/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.formplugin.imports;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.service.ServiceFactory;
import kd.bos.service.TimeService;
import kd.bos.url.UrlService;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.swc.hsbp.business.log.SWCOpLogServiceHelper;
import kd.swc.hsbp.formplugin.imports.EntryProgressHandler;
import org.apache.commons.lang.StringUtils;

public class ImportProcessNewPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static Log log = LogFactory.getLog(ImportProcessNewPlugin.class);
    private static final String IMPORT_PROGRESS_ID = "IMPORT_PROGRESS_ID";
    private static final String BTN_OK = "btnok";
    private static final String PROGRESSBARAP = "progressbarap";
    private static final String SUCCESSPANEL = "successpanel";
    private static final String BTNSUSPEND = "btnsuspend";
    private static final String FAILPANEL = "failpanel";
    private static final String BTNCLOSE = "buttonap";
    private static final String BOS_IMPORTLOG = "bos_importlog";
    private static final String SUSPENDPANEL = "suspendpanel";
    private static final String BILLFORMID = "BillFormId";
    private static final String BOS_FORM_BUSINESS = "swc-hsbp-formplugin";
    public static final String IMPORT_PROCESS_CALLBACK = "ImportProcessCallBack";

    public void initialize() {
        this.addClickListeners(new String[]{BTN_OK, "btndetails", "btnresult", BTNSUSPEND});
        ProgressBar progressbar = (ProgressBar)this.getControl(PROGRESSBARAP);
        progressbar.addProgressListener((ProgresssListener)this);
    }

    public void afterCreateNewData(EventObject eventObject) {
        IFormView view = this.getView();
        view.setVisible(Boolean.FALSE, new String[]{FAILPANEL, SUCCESSPANEL, BTNCLOSE, BTN_OK, SUSPENDPANEL});
        FormShowParameter params = this.getView().getFormShowParameter();
        String listName = (String)params.getCustomParam("entityname");
        Label title = (Label)this.getControl("title");
        title.setText(listName);
        Object logId = this.createImportLog(listName);
        this.getPageCache().put(IMPORT_PROGRESS_ID, logId.toString());
        EntryProgressHandler handler = this.getProgressCachedData();
        String total = handler == null ? "0" : String.valueOf(handler.getTotal());
        Label progressTotal = (Label)this.getControl("rowcount");
        progressTotal.setText(total);
        ProgressBar progress = (ProgressBar)this.getControl(PROGRESSBARAP);
        if (handler != null && handler.getProgress() == 100) {
            ProgressEvent progressEvent = new ProgressEvent((Object)progress);
            this.onProgress(progressEvent);
        } else {
            progress.start();
        }
    }

    public void onProgress(ProgressEvent evt) {
        int importProgress = 0;
        EntryProgressHandler handler = this.getProgressCachedData();
        IFormView view = this.getView();
        if (handler != null) {
            Label currRow = (Label)this.getControl("currentrow");
            Label rowCount = (Label)this.getControl("rowcount");
            Label handlecount = (Label)this.getControl("handlecount");
            currRow.setText(handler.getHandled() + "");
            handlecount.setText(handler.getHandled() + "");
            importProgress = handler.getProgress();
            int total = handler.getTotal();
            rowCount.setText("" + total);
            if (importProgress >= 100) {
                view.hideLoading();
                view.setVisible(Boolean.FALSE, new String[]{"importpanel", "btncancel", BTNSUSPEND, SUSPENDPANEL});
                view.setVisible(Boolean.TRUE, new String[]{BTNCLOSE});
                int failed = handler.getFailedRow();
                if (failed > 0) {
                    Label success = (Label)this.getControl("success");
                    Label fail = (Label)this.getControl("failed");
                    success.setText("" + (total - failed));
                    fail.setText("" + failed);
                    view.setVisible(Boolean.TRUE, new String[]{FAILPANEL});
                    if (StringUtils.isNotBlank((String)((String)view.getFormShowParameter().getCustomParam("OperateKey")))) {
                        view.setVisible(Boolean.TRUE, new String[]{BTN_OK});
                    }
                    HashMap<String, Integer> notHidden = new HashMap<String, Integer>(16);
                    notHidden.put("gr", 1);
                    view.updateControlMetadata(FAILPANEL, notHidden);
                    MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u5bfc\u5165\u5931\u8d25", "ImportProcessPlugin_6", BOS_FORM_BUSINESS);
                    MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u5bfc\u5165\u6210\u529f\u7684\u6570\u636e0\u6761\uff0c\u5bfc\u5165\u5931\u8d25\u7684\u6570\u636e{0}\u6761", "ImportProcessPlugin_7", BOS_FORM_BUSINESS);
                    SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)"upload", (MultiLangEnumBridge)opNameBridge, (String)"", (MultiLangEnumBridge)opDescBridge, (String[])new String[]{String.valueOf(total)});
                } else {
                    Label success = (Label)this.getControl("successall");
                    success.setText("" + total);
                    view.setVisible(Boolean.TRUE, new String[]{SUCCESSPANEL});
                    HashMap<String, Integer> notHidden = new HashMap<String, Integer>(16);
                    notHidden.put("gr", 1);
                    view.updateControlMetadata(SUCCESSPANEL, notHidden);
                    MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u5bfc\u5165\u6210\u529f", "ImportProcessPlugin_4", BOS_FORM_BUSINESS);
                    MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u6210\u529f\u5bfc\u5165{0}\u6761\u6570\u636e", "ImportProcessPlugin_5", BOS_FORM_BUSINESS);
                    SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)"upload", (MultiLangEnumBridge)opNameBridge, (String)"", (MultiLangEnumBridge)opDescBridge, (String[])new String[]{String.valueOf(total)});
                }
                view.getPageCache().remove("");
            }
        }
        evt.setProgress(importProgress);
    }

    private EntryProgressHandler getProgressCachedData() {
        String taskid = (String)this.getView().getFormShowParameter().getCustomParam("taskId");
        return EntryProgressHandler.fromTask(taskid);
    }

    public void click(EventObject evt) {
        String controlKey = ((Control)evt.getSource()).getKey();
        if ("btndetails".equals(controlKey)) {
            EntryProgressHandler handler = this.getProgressCachedData();
            if (handler == null || StringUtils.isBlank((String)handler.getErrorLogFile())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e5\u5fd7\u6570\u636e\u6b63\u5728\u751f\u6210\u4e2d", (String)"ImportProcessNewPlugin_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                return;
            }
            this.getView().download(UrlService.getAttachmentFullUrl((String)handler.getErrorLogFile()));
            this.getView().sendFormAction(this.getView());
        } else if (BTN_OK.equals(controlKey)) {
            IFormView view = this.getView();
            FormShowParameter parameter = view.getFormShowParameter();
            IFormView parentView = view.getViewNoPlugin(parameter.getParentPageId());
            parentView.invokeOperation((String)parameter.getCustomParam("OperateKey"));
            view.close();
            view.sendFormAction(parentView);
        } else if ("btnresult".equals(controlKey)) {
            IFormView view = this.getView();
            IFormView parentView = view.getParentView();
            String pkId = this.getPageCache().get(IMPORT_PROGRESS_ID);
            BillShowParameter parameter = new BillShowParameter();
            parameter.setFormId(BOS_IMPORTLOG);
            parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
            parameter.setParentPageId(view.getFormShowParameter().getParentPageId());
            parameter.setPkId((Object)pkId);
            parameter.setStatus(OperationStatus.VIEW);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parentView.showForm((FormShowParameter)parameter);
            view.close();
        } else if (BTNSUSPEND.equals(controlKey)) {
            IFormView view = this.getView();
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u4e2d\u6b62\u5bfc\u5165\u6570\u636e\uff0c\u8bf7\u7a0d\u7b49\u3002", (String)"ImportProcessNewPlugin_8", (String)BOS_FORM_BUSINESS, (Object[])new Object[0])));
            Label fullOrPartialSuccessText = (Label)this.getControl("labelap10");
            view.setVisible(Boolean.FALSE, new String[]{"importpanel"});
            view.setVisible(Boolean.TRUE, new String[]{SUSPENDPANEL});
            HashMap<String, Integer> notHidden = new HashMap<String, Integer>(16);
            notHidden.put("gr", 1);
            view.updateControlMetadata(SUSPENDPANEL, notHidden);
            fullOrPartialSuccessText.setText(ResManager.loadKDString((String)"\u4e2d\u6b62\u5b8c\u6210\uff0c\u5bfc\u5165\u6210\u529f", (String)"ImportProcessNewPlugin_7", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        }
    }

    private Object createImportLog(String name) {
        MainEntityType objType = EntityMetadataCache.getDataEntityType((String)BOS_IMPORTLOG);
        DynamicObject dyn = (DynamicObject)objType.createInstance();
        dyn.set("name", (Object)name);
        dyn.set("billstatus", (Object)"C");
        dyn.set("importstatus", (Object)"0");
        dyn.set("createtime", (Object)new TimeService().now());
        ICodeRuleService coderule = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        String billno = coderule.getNumber(BOS_IMPORTLOG, dyn, null);
        dyn.set("billno", (Object)billno);
        dyn = (DynamicObject)BusinessDataWriter.save((IDataEntityType)objType, (Object[])new Object[]{dyn})[0];
        return dyn.getPkValue();
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        boolean isEnd;
        super.beforeClosed(evt);
        String taskId = (String)this.getView().getFormShowParameter().getCustomParam("taskId");
        HRBackgroundTaskHelper taskHelper = HRBackgroundTaskHelper.getInstance();
        TaskInfo taskInfo = taskHelper.getTaskInfo(taskId);
        boolean bl = isEnd = taskInfo == null || taskInfo.isTaskEnd();
        if (isEnd) {
            String entryPageId = (String)this.getView().getFormShowParameter().getCustomParam("entryview");
            String entryKey = (String)this.getView().getFormShowParameter().getCustomParam("entrykey");
            IFormView entryView = this.getView().getView(entryPageId);
            if (entryView != null) {
                entryView.updateView();
                this.getView().sendFormAction(entryView);
            }
            if (taskInfo != null) {
                taskHelper.confirmEndTask(taskId, taskInfo.getStatus());
            }
        } else {
            taskHelper.showBaskgroundTask(taskId);
        }
        IFormView mainView = this.getView().getMainView();
        if (mainView != null) {
            taskHelper.removeProgressPageId(mainView, taskId);
        }
    }
}

