/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.formplugin.imports;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.common.util.SWCJSONUtils;
import org.apache.commons.lang3.StringUtils;

public class ProgressHandler
implements Serializable {
    private static final long serialVersionUID = 5700387454613322008L;
    public static final String cacheKey = "progressDataCache";
    protected int total;
    protected int handled;
    protected int successRow;
    protected int failedRow;
    protected String errorLogFile;
    private static Log log = LogFactory.getLog(ProgressHandler.class);
    @JsonIgnore
    private IFormView processView;
    @JsonIgnore
    private Map<Integer, List<String>> logCache = new HashMap<Integer, List<String>>(16);

    public ProgressHandler(int total, IFormView processView) {
        this.total = total;
        this.processView = processView;
    }

    public ProgressHandler() {
    }

    public void incrByProgress(int success, int failed) {
        this.successRow += success;
        this.failedRow += failed;
        this.handled += success + failed;
        String processContent = null;
        try {
            processContent = SWCJSONUtils.toString((Object)this);
        }
        catch (IOException e) {
            log.error("json\u89e3\u6790\u62a5\u9519", (Throwable)e);
        }
        this.processView.getPageCache().put(cacheKey, processContent);
    }

    public void updateProgress(int success, int failed) {
        this.successRow = success;
        this.failedRow = failed;
        this.handled = success + failed;
        this.cacheData();
    }

    protected void cacheData() {
        String processContent = null;
        try {
            processContent = SWCJSONUtils.toString((Object)this);
        }
        catch (IOException e) {
            log.error("json\u89e3\u6790\u62a5\u9519", (Throwable)e);
        }
        this.processView.getPageCache().put(cacheKey, processContent);
    }

    public ProgressHandler putRowError(Integer rowIndex, String msg) {
        List errors = this.logCache.get(rowIndex);
        if (errors == null && this.logCache.size() == 5000) {
            msg = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u884c\u6570\u636e", (String)"ProgressHandler_1", (String)"swc-hsbp-formplugin", (Object[])new Object[0]);
        }
        if (errors == null && this.logCache.size() <= 5000) {
            errors = this.logCache.computeIfAbsent(rowIndex, Lists::newArrayListWithCapacity);
        }
        if (errors == null) {
            this.logCache.put(rowIndex, null);
        }
        if (errors != null) {
            errors.add((String)msg);
        }
        return this;
    }

    @JsonIgnore
    public int getProgress() {
        if (this.total == 0) {
            return 100;
        }
        return this.handled / this.total * 100;
    }

    public int getTotal() {
        return this.total;
    }

    public int getHandled() {
        return this.handled;
    }

    public int getSuccessRow() {
        return this.successRow;
    }

    public int getFailedRow() {
        return this.failedRow;
    }

    public IFormView getProcessView() {
        return this.processView;
    }

    public Map<Integer, List<String>> getLogCache() {
        return this.logCache;
    }

    public String getErrorLogFile() {
        return this.errorLogFile;
    }

    public void setAndCacheErrorLogFile(String errorLogFile) {
        this.errorLogFile = errorLogFile;
        if (StringUtils.isNotEmpty((CharSequence)errorLogFile)) {
            this.cacheData();
        }
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public void setHandled(int handled) {
        this.handled = handled;
    }

    public void setSuccessRow(int successRow) {
        this.successRow = successRow;
    }

    public void setFailedRow(int failedRow) {
        this.failedRow = failedRow;
    }
}

