/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.formplugin.report;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.base.BaseView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.swc.hsbp.business.report.ReportTplHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.constants.RptDisplayConstants;
import kd.swc.hsbp.common.entity.RptDisplayColumnEntity;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;
import org.apache.commons.collections.MapUtils;

public abstract class AbstractRptDisplayPlugin
extends SWCDataBaseEdit
implements TreeNodeClickListener,
TreeNodeCheckListener,
SearchEnterListener,
RptDisplayConstants {
    private static Log logger = LogFactory.getLog(AbstractRptDisplayPlugin.class);
    private static final String BOS_LISTF7 = "bos_listf7";
    private static final String CACHE_IS_ADDNEW = "CACHE_IS_ADDNEW";
    private static final Set<String> noSelectNodes = Sets.newHashSet((Object[])new String[]{"text_type_hsbs_salaryitem", "text_type_hsbs_bizitem", "text_type_hsbs_fetchitem", "text_type_hsbs_supportitem", "hsbs_salaryitem", "hsbs_bizitem", "hsbs_fetchitem", "hsbs_supportitem", "hsbs_statisticstag"});
    private static final String option_donothing_delete = "donothing_delete";
    private static final String option_donothing_update = "donothing_update";
    private static final String option_donothing_copy = "donothing_copy";
    private static final String option_donothing_importscheme = "donothing_importscheme";

    protected abstract List<RptDisplayColumnEntity> getLeftTreeDataList();

    protected Map<String, Object> getExtendFieldValue(RptDisplayColumnEntity rowData) {
        return null;
    }

    protected boolean beforeRemoveColumns() {
        return true;
    }

    protected boolean beforeAddColumns(List<RptDisplayColumnEntity> entities) {
        return true;
    }

    protected boolean beforeDoSaveOperation() {
        return true;
    }

    protected int getMaxSortFieldCount() {
        return 5;
    }

    protected List<RptDisplayColumnEntity> getDefaultColumns() {
        return new ArrayList<RptDisplayColumnEntity>();
    }

    protected void afterDeleteDisplaySchema(String schemaId) {
    }

    protected String getReportFormId() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object customParam = formShowParameter.getCustomParam("reportformid");
        if (null == customParam || SWCStringUtils.isEmpty((String)customParam.toString())) {
            return formShowParameter.getParentFormId();
        }
        return String.valueOf(customParam);
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        TreeView schmTreeView = (TreeView)this.getView().getControl("schmtreeview");
        schmTreeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        treeView.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        Search treeColumnSearch = (Search)this.getView().getControl("treesearchap");
        treeColumnSearch.addEnterListener((SearchEnterListener)this);
        Search listColumnSearch = (Search)this.getView().getControl("columnsearchap");
        listColumnSearch.addEnterListener((SearchEnterListener)this);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.addClickListeners(new String[]{"btnedit", "btndelete", "btncopy", "btnimportscheme"});
        this.addClickListeners(new String[]{"btncancel", "btnsave"});
        this.addClickListeners(new String[]{"btn_addcolumn", "btn_removecolumn"});
        this.addClickListeners(new String[]{"flexadd", "flexaddleft", "vectoradd", "flexaddright", "labeladd"});
    }

    public void beforeBindData(EventObject eventObject) {
        this.buildLeftTree();
        this.buildSchmTree();
    }

    private void buildSchmTree() {
        DynamicObject[] userSchms = ReportTplHelper.queryPersonalScheme((String)this.getCurrentRptDisplayFormId(), (String)this.getReportFormId());
        TreeView schmTreeView = (TreeView)this.getView().getControl("schmtreeview");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        BaseShowParameter showParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        Object pkId = showParameter.getPkId();
        if (!(OperationStatus.VIEW.equals((Object)status) || userSchms != null && userSchms.length != 0)) {
            this.clearPageData();
            this.openConfirmPage();
            return;
        }
        String waitSelectNodeId = this.getPageCache().get("CACHE_SELECTED_NODE");
        ArrayList<TreeNode> schmNodes = new ArrayList<TreeNode>(userSchms.length);
        for (DynamicObject schm : userSchms) {
            Long id = schm.getLong("id");
            String name = schm.getString("name");
            TreeNode rootNode = new TreeNode("", String.valueOf(id), name);
            schmNodes.add(rootNode);
            if (waitSelectNodeId != null || pkId != null) continue;
            waitSelectNodeId = rootNode.getId();
        }
        schmTreeView.deleteAllNodes();
        schmTreeView.addNodes(schmNodes);
        this.getPageCache().put("schmNodes", SerializationUtils.serializeToBase64(schmNodes));
        if (waitSelectNodeId != null && !waitSelectNodeId.equals(pkId)) {
            this.refreshDisplaySchm(waitSelectNodeId);
        }
    }

    private void openConfirmPage() {
        String confirmTip = ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u53ef\u7528\u65b9\u6848\uff0c\u8bf7\u65b0\u5efa\u65b9\u6848\u6216\u8005\u5bfc\u5165\u65b9\u6848\u3002", (String)"AbstractRptDisplayPlugin_29", (String)"swc-hsbp-formplugin", (Object[])new Object[0]);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsbp_rptconfirm");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("message", (Object)confirmTip);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "CALLBACK_ADD_OR_IMPORT");
        showParameter.setCloseCallBack(callBack);
        this.getView().showForm(showParameter);
    }

    private void tipAddOrImport(Map<String, Object> returnData) {
        String result;
        if (returnData == null) {
            return;
        }
        switch (result = MapUtils.getString(returnData, (Object)"option")) {
            case "add": {
                this.addDisplayScheme();
                break;
            }
            case "import": {
                this.importSchemeF7();
                break;
            }
        }
    }

    private void clearPageData() {
        TreeView schmTreeView = (TreeView)this.getView().getControl("schmtreeview");
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        schmTreeView.deleteAllNodes();
        treeView.deleteAllNodes();
        treeView.uncheckNodes(treeView.getTreeState().getCheckedNodeIds());
        this.getModel().deleteEntryData("entryentity");
        this.clearSearchKey();
        this.getPageCache().remove("schmNodes");
    }

    public void afterBindData(EventObject eventObject) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String parentFormId = formShowParameter.getParentFormId();
        if (BOS_LISTF7.equals(parentFormId)) {
            SplitContainer splitContainer = (SplitContainer)this.getView().getControl("splitcontainerap");
            splitContainer.hidePanel(SplitDirection.left, true);
        }
        TreeView treeView = (TreeView)this.getView().getControl("schmtreeview");
        BaseShowParameter showParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        Object pkId = showParameter.getPkId();
        if (pkId != null) {
            TreeNode focusNode = new TreeNode("", String.valueOf(pkId), null);
            treeView.focusNode(focusNode);
            this.checkSpecialColumn();
        }
        ReportTplHelper.refreshSecondaryHeaderByFreeze((IFormView)this.getView());
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        int[] rows = entryGrid.getSelectRows();
        List<String> entryOps = Arrays.asList("lbldelete", "lblmoveup", "lblmovedown", "lblmoveto");
        if (entryOps.contains(key) && rows.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"AbstractRptDisplayPlugin_1", (String)"swc-hsbp-formplugin", (Object[])new Object[0]));
            return;
        }
        switch (key) {
            case "lblmoveup": {
                this.moveUp(rows);
                break;
            }
            case "lblmoveto": {
                this.moveTo(rows);
                break;
            }
            case "lblmovedown": {
                this.moveDown(rows);
                break;
            }
            case "lblsort": {
                this.sort(rows);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null) {
            return;
        }
        if (operationResult.isSuccess()) {
            switch (args.getOperateKey()) {
                case "save": {
                    Long id = (Long)this.getModel().getValue("id");
                    Boolean isDefaultScheme = (Boolean)this.getModel().getValue("defaultscheme");
                    if (Boolean.TRUE.equals(isDefaultScheme)) {
                        ReportTplHelper.cancelOtherDefaultScheme((String)this.getCurrentRptDisplayFormId(), (String)this.getReportFormId(), (Long)id);
                    }
                    this.getPageCache().remove(CACHE_IS_ADDNEW);
                    break;
                }
                case "do_addcolumn": {
                    if (!this.checkBeforeAddColumns() || !this.checkSelectedSchm(this.getView())) break;
                    this.addColumn(this.getView());
                    break;
                }
                case "do_removecolumn": {
                    if (!this.beforeRemoveColumns()) break;
                    ReportTplHelper.removeColumn((IFormView)this.getView());
                    break;
                }
            }
        }
    }

    private boolean checkBeforeAddColumns() {
        TreeView treeView = (TreeView)this.getControl("treeviewap");
        List checkedNodeIds = treeView.getTreeState().getCheckedNodeIds();
        return this.beforeAddColumns(this.getTreeDataByIds(checkedNodeIds));
    }

    public void addColumn(IFormView formView) {
        TreeView treeView = (TreeView)formView.getControl("treeviewap");
        List selectNodeIds = treeView.getTreeState().getCheckedNodeIds();
        if (CollectionUtils.isEmpty((Collection)selectNodeIds)) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u6570\u636e\u3002", (String)"AbstractRptDisplayPlugin_2", (String)"swc-hsbp-formplugin", (Object[])new Object[0]));
            return;
        }
        SWCPageCache pageCache = new SWCPageCache(formView);
        String cacheTreeNodeStr = (String)pageCache.get("CACHE_TREE_DATA", String.class);
        Map nodeMap = (Map)SerializationUtils.deSerializeFromBase64((String)cacheTreeNodeStr);
        Map treeNodeTableRowMap = ReportTplHelper.geTreeNodeBindTableRowMap((IFormView)formView);
        IDataModel model = formView.getModel();
        String disableItemIdsStr = formView.getPageCache().get("DISABLEITEMIDS");
        Set disableItemIds = new HashSet(0);
        if (!StringUtils.isEmpty((CharSequence)disableItemIdsStr)) {
            disableItemIds = (Set)SerializationUtils.deSerializeFromBase64((String)disableItemIdsStr);
        }
        String disableStr = ResManager.loadKDString((String)"\uff08\u5df2\u7981\u7528\uff09", (String)"AbstractRptDisplayPlugin_27", (String)"swc-hsbp-formplugin", (Object[])new Object[0]);
        for (String selectNodeId : selectNodeIds) {
            TreeNode selectNode = (TreeNode)nodeMap.get(selectNodeId);
            if (selectNode == null || treeNodeTableRowMap.containsKey(selectNodeId) || !selectNode.isLeaf() && !selectNodeId.startsWith("itemtag_")) continue;
            RptDisplayColumnEntity rowData = (RptDisplayColumnEntity)selectNode.getData();
            if (noSelectNodes.contains(selectNodeId) && (CollectionUtils.isEmpty((Collection)rowData.getChildren()) || selectNodeId.startsWith("itemtag_"))) continue;
            int detailIndex = model.createNewEntryRow("entryentity");
            String fieldValue = rowData.getFieldValue();
            String fieldName = rowData.getFieldName();
            if (disableItemIds.contains(fieldValue)) {
                fieldName = fieldName.substring(0, fieldName.lastIndexOf(disableStr));
            }
            model.setValue("displayname", (Object)rowData.getDisplayName(), detailIndex);
            model.setValue("fieldname", (Object)fieldName, detailIndex);
            model.setValue("fieldvalue", (Object)fieldValue, detailIndex);
            model.setValue("columnwidth", (Object)rowData.getColumnWidth(), detailIndex);
            model.setValue("alignment", (Object)rowData.getAlignment(), detailIndex);
            model.setValue("fieldalias", (Object)rowData.getFieldAlias(), detailIndex);
            model.setValue("fieldtype", (Object)rowData.getFieldType(), detailIndex);
            model.setValue("secondaryheader", (Object)rowData.getSecondaryHeader(), detailIndex);
            model.setValue("isdefault", (Object)(rowData.getIsDefault() ? "1" : "0"), detailIndex);
            this.setExetendFieldValue(model, rowData, detailIndex);
            treeNodeTableRowMap.put(selectNodeId, detailIndex);
        }
    }

    private void setExetendFieldValue(IDataModel model, RptDisplayColumnEntity rowData, int detailIndex) {
        boolean condition;
        Map<String, Object> extendFieldValue = this.getExtendFieldValue(rowData);
        boolean bl = condition = extendFieldValue != null && !extendFieldValue.isEmpty() && model != null;
        if (condition) {
            extendFieldValue.forEach((key, value) -> model.setValue(key, value, detailIndex));
        }
    }

    private boolean checkSelectedSchm(IFormView formView) {
        BaseShowParameter showParameter = (BaseShowParameter)formView.getFormShowParameter();
        Object pkId = showParameter.getPkId();
        if (pkId == null) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65b9\u6848\u6216\u8005\u65b0\u589e\u65b9\u6848\u540e\u518d\u64cd\u4f5c\u3002", (String)"AbstractRptDisplayPlugin_3", (String)"swc-hsbp-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        String searchText = searchEnterEvent.getText();
        Search search = (Search)searchEnterEvent.getSource();
        String key = search.getKey();
        if ("treesearchap".equals(key)) {
            ReportTplHelper.dimSearchTreeNode((String)searchText, (IFormView)this.getView());
        } else if ("columnsearchap".equals(key)) {
            ReportTplHelper.searchFieldName((String)searchText, (IFormView)this.getView());
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey;
        switch (fieldKey = args.getProperty().getName()) {
            case "freeze": {
                this.columnFreeze(args);
                break;
            }
        }
    }

    private void columnFreeze(PropertyChangedArgs args) {
        DynamicObjectCollection entryEntities = this.getModel().getEntryEntity("entryentity");
        ChangeData changeData = args.getChangeSet()[0];
        boolean isFreeze = (Boolean)changeData.getNewValue();
        int rowIndex = changeData.getRowIndex();
        if (isFreeze) {
            ReportTplHelper.freeze((DynamicObjectCollection)entryEntities, (int)rowIndex, (IFormView)this.getView());
        } else {
            ReportTplHelper.unFreeze((DynamicObjectCollection)entryEntities, (int)rowIndex, (IFormView)this.getView());
        }
    }

    private void buildLeftTree() {
        BaseShowParameter showParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        if (showParameter.getPkId() == null) {
            return;
        }
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        this.buildBillTreeNodes(treeView);
        this.getModel().setDataChanged(false);
    }

    private void buildBillTreeNodes(TreeView treeView) {
        List<RptDisplayColumnEntity> treeData = this.getLeftTreeDataList();
        if (!this.validTreeDataList(treeData)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7531\u4e8e\u5b58\u5728\u540c\u540d\u8282\u70b9\uff0c\u4e0d\u80fd\u6b63\u5e38\u5c55\u793a\u5de6\u6811\u8282\u70b9\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\u3002", (String)"AbstractRptDisplayPlugin_28", (String)"swc-hsbp-formplugin", (Object[])new Object[0]));
            return;
        }
        List<TreeNode> rootNodes = this.convertToTreeNode(treeData, null);
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        Map<String, TreeNode> treeNodeMap = this.getTreeNodeMap(rootNodes);
        pageCache.put("CACHE_TREE_DATA", (Object)SerializationUtils.serializeToBase64(treeNodeMap));
        pageCache.put("CACHE_ROOT_NODE", (Object)SerializationUtils.serializeToBase64(rootNodes));
        treeView.addNodes(rootNodes);
    }

    private boolean validTreeDataList(List<RptDisplayColumnEntity> treeData) {
        HashSet<String> validSet = new HashSet<String>();
        return this.doCheckTreeDataList(treeData, validSet);
    }

    private boolean doCheckTreeDataList(List<RptDisplayColumnEntity> treeData, Set<String> validSet) {
        if (CollectionUtils.isEmpty(treeData)) {
            return true;
        }
        for (RptDisplayColumnEntity data : treeData) {
            if (!validSet.add(data.getFieldValue())) {
                logger.info("AbstractRptDisplayPlugin doCheckTreeDataList fieldValue repeat:{}", (Object)data);
                return false;
            }
            if (this.doCheckTreeDataList(data.getChildren(), validSet)) continue;
            logger.info("AbstractRptDisplayPlugin doCheckTreeDataList fieldValue repeat:{}", (Object)data);
            return false;
        }
        return true;
    }

    private List<TreeNode> convertToTreeNode(List<RptDisplayColumnEntity> treeData, String parentId) {
        if (CollectionUtils.isEmpty(treeData)) {
            return null;
        }
        ArrayList<TreeNode> treeNodeList = new ArrayList<TreeNode>(10);
        for (RptDisplayColumnEntity entity : treeData) {
            TreeNode treeNode = new TreeNode();
            treeNode.setData((Object)entity);
            treeNode.setId(entity.getFieldValue());
            treeNode.setText(entity.getFieldName());
            treeNode.setLeaf(!entity.hasChild());
            treeNode.setChildren(this.convertToTreeNode(entity.getChildren(), entity.getFieldValue()));
            if (!SWCStringUtils.isEmpty((String)parentId)) {
                treeNode.setParentid(parentId);
            }
            treeNodeList.add(treeNode);
        }
        return treeNodeList;
    }

    private Map<String, TreeNode> getTreeNodeMap(List<TreeNode> rootNodes) {
        HashMap<String, TreeNode> result = new HashMap<String, TreeNode>(16);
        if (CollectionUtils.isEmpty(rootNodes)) {
            return result;
        }
        for (TreeNode treeNode : rootNodes) {
            result.put(treeNode.getId(), treeNode);
            List children = treeNode.getChildren();
            if (CollectionUtils.isEmpty((Collection)children)) continue;
            result.putAll(this.getTreeNodeMap(treeNode.getChildren()));
        }
        return result;
    }

    public void treeNodeCheck(TreeNodeCheckEvent evt) {
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        BaseView view = (BaseView)this.getView();
        BaseShowParameter showParameter = (BaseShowParameter)view.getFormShowParameter();
        String nodeId = (String)evt.getNodeId();
        TreeView treeView = (TreeView)evt.getSource();
        if (SWCStringUtils.equals((String)treeView.getKey(), (String)"schmtreeview")) {
            if (StringUtils.isEmpty((CharSequence)nodeId) || nodeId.equals(showParameter.getPkId())) {
                return;
            }
            this.getPageCache().remove("CACHE_SELECTED_NODE");
            this.getPageCache().put("waitNodeId", nodeId);
            if (!this.checkDataChange("CALLBACK_CHECK_DATA_CHANGE_TREE")) {
                this.refreshDisplaySchm(nodeId);
            }
        }
    }

    private void refreshDisplaySchm(String schmId) {
        BaseView view = (BaseView)this.getView();
        BaseShowParameter showParameter = (BaseShowParameter)view.getFormShowParameter();
        showParameter.setPkId((Object)schmId);
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setBillStatus(BillOperationStatus.EDIT);
        view.cacheFormShowParameter();
        view.load((Object)schmId);
        this.clearSearchKey();
    }

    private void clearSearchKey() {
        Search treeSearch = (Search)this.getView().getControl("treesearchap");
        treeSearch.setSearchKey("");
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        String rootNode = (String)pageCache.get("CACHE_ROOT_NODE", String.class);
        if (rootNode != null) {
            List rootNodes = (List)SerializationUtils.deSerializeFromBase64((String)rootNode);
            TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
            treeView.deleteAllNodes();
            treeView.addNodes(rootNodes);
        }
        Search columnSearch = (Search)this.getView().getControl("columnsearchap");
        columnSearch.setSearchKey("");
        pageCache.remove(this.getView().getPageId() + "_matchNodes");
        pageCache.remove(this.getView().getPageId() + "_oldSearchText");
    }

    private void checkSpecialColumn() {
        DynamicObjectCollection entryEntities = this.getModel().getEntryEntity("entryentity");
        HashSet<String> entityDataSet = new HashSet<String>();
        for (DynamicObject entity : entryEntities) {
            entityDataSet.add(entity.getString("fieldvalue"));
        }
        List<RptDisplayColumnEntity> specailList = this.getAllDefaultColumns();
        if (CollectionUtils.isEmpty(specailList)) {
            return;
        }
        IDataModel model = this.getModel();
        for (RptDisplayColumnEntity rowData : specailList) {
            if (entityDataSet.contains(rowData.getFieldValue())) continue;
            int detailIndex = model.createNewEntryRow("entryentity");
            model.setValue("displayname", (Object)rowData.getDisplayName(), detailIndex);
            model.setValue("fieldname", (Object)rowData.getFieldName(), detailIndex);
            model.setValue("fieldvalue", (Object)rowData.getFieldValue(), detailIndex);
            model.setValue("columnwidth", (Object)rowData.getColumnWidth(), detailIndex);
            model.setValue("alignment", (Object)rowData.getAlignment(), detailIndex);
            model.setValue("fieldalias", (Object)rowData.getFieldAlias(), detailIndex);
            model.setValue("fieldtype", (Object)rowData.getFieldType(), detailIndex);
            model.setValue("secondaryheader", (Object)rowData.getSecondaryHeader(), detailIndex);
            model.setValue("isdefault", (Object)"1", detailIndex);
            this.setExetendFieldValue(model, rowData, detailIndex);
        }
        if (OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.getModel().setDataChanged(false);
        }
        this.getView().updateView("entryentity");
    }

    private List<RptDisplayColumnEntity> getAllDefaultColumns() {
        List<TreeNode> rootNodes = this.getTreeRootNodeList();
        if (rootNodes == null || rootNodes.isEmpty()) {
            return null;
        }
        List<RptDisplayColumnEntity> collect = rootNodes.stream().map(node -> (RptDisplayColumnEntity)node.getData()).collect(Collectors.toList());
        List<RptDisplayColumnEntity> specailList = this.getSpecialDataList(collect);
        specailList.addAll(this.getDefaultColumns());
        return specailList;
    }

    private List<TreeNode> getTreeRootNodeList() {
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        String rootNodeStr = (String)swcPageCache.get("CACHE_ROOT_NODE", String.class);
        if (SWCStringUtils.isEmpty((String)rootNodeStr)) {
            return null;
        }
        List rootNodes = (List)SerializationUtils.deSerializeFromBase64((String)rootNodeStr);
        return rootNodes;
    }

    private Map<String, RptDisplayColumnEntity> getTreeMap() {
        List<TreeNode> treeRootNodeList = this.getTreeRootNodeList();
        if (CollectionUtils.isEmpty(treeRootNodeList)) {
            return null;
        }
        return this.flatTreeListToMap(treeRootNodeList);
    }

    private Map<String, RptDisplayColumnEntity> flatTreeListToMap(List<TreeNode> treeRootNodeList) {
        HashMap<String, RptDisplayColumnEntity> treeNodeMap = new HashMap<String, RptDisplayColumnEntity>(16);
        for (TreeNode treeNode : treeRootNodeList) {
            List children = treeNode.getChildren();
            treeNodeMap.put(treeNode.getId(), (RptDisplayColumnEntity)treeNode.getData());
            if (CollectionUtils.isEmpty((Collection)children)) continue;
            treeNodeMap.putAll(this.flatTreeListToMap(children));
        }
        return treeNodeMap;
    }

    private List<RptDisplayColumnEntity> getTreeDataByIds(List<String> ids) {
        boolean isEmpty;
        Map<String, RptDisplayColumnEntity> treeMap = this.getTreeMap();
        boolean bl = isEmpty = treeMap == null || treeMap.isEmpty();
        if (CollectionUtils.isEmpty(ids) || isEmpty) {
            return null;
        }
        ArrayList<RptDisplayColumnEntity> resultList = new ArrayList<RptDisplayColumnEntity>();
        for (String id : ids) {
            RptDisplayColumnEntity rptDisplayColumnEntity = treeMap.get(id);
            if (null == rptDisplayColumnEntity) continue;
            resultList.add(rptDisplayColumnEntity);
        }
        return resultList;
    }

    private List<RptDisplayColumnEntity> getSpecialDataList(List<RptDisplayColumnEntity> collect) {
        if (CollectionUtils.isEmpty(collect)) {
            return new ArrayList<RptDisplayColumnEntity>();
        }
        ArrayList<RptDisplayColumnEntity> result = new ArrayList<RptDisplayColumnEntity>();
        for (RptDisplayColumnEntity rptDisplayColumnEntity : collect) {
            if (rptDisplayColumnEntity.getIsDefault()) {
                result.add(rptDisplayColumnEntity);
            }
            result.addAll(this.getSpecialDataList(rptDisplayColumnEntity.getChildren()));
        }
        return result;
    }

    private boolean moveUp(int[] rows) {
        if (rows[0] == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5230\u8fbe\u9876\u90e8\u3002", (String)"AbstractRptDisplayPlugin_4", (String)"swc-hsbp-formplugin", (Object[])new Object[0]));
            return false;
        }
        this.getModel().moveEntryRowsUp("entryentity", rows);
        DynamicObjectCollection entryEntities = this.getModel().getEntryEntity("entryentity");
        DynamicObject lastFreezedCol = entryEntities.stream().filter(entryEntity -> Boolean.TRUE.equals(entryEntity.getBoolean("freeze"))).sorted(Comparator.comparingInt(entity -> entity.getInt("seq")).reversed()).findFirst().orElse(null);
        if (lastFreezedCol == null) {
            return true;
        }
        int index = lastFreezedCol.getInt("seq") - 1;
        this.getModel().beginInit();
        for (int i = 0; i <= index; ++i) {
            ((DynamicObject)entryEntities.get(i)).set("freeze", (Object)Boolean.TRUE);
            ((DynamicObject)entryEntities.get(i)).set("secondaryheader", null);
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"secondaryheader"});
            this.getView().updateView("freeze", i);
            this.getView().updateView("secondaryheader", i);
        }
        this.getModel().endInit();
        return true;
    }

    private boolean moveDown(int[] rows) {
        int size = this.getModel().getEntryRowCount("entryentity");
        if (rows[rows.length - 1] == size - 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5230\u8fbe\u5e95\u90e8\u3002", (String)"AbstractRptDisplayPlugin_5", (String)"swc-hsbp-formplugin", (Object[])new Object[0]));
            return false;
        }
        this.getModel().moveEntryRowsDown("entryentity", rows);
        DynamicObjectCollection movedEntryEntities = this.getModel().getEntryEntity("entryentity");
        DynamicObject firstUnFreezedCol = movedEntryEntities.stream().filter(entryEntity -> Boolean.FALSE.equals(entryEntity.getBoolean("freeze"))).sorted(Comparator.comparingInt(entity -> entity.getInt("seq"))).findFirst().orElse(null);
        if (firstUnFreezedCol == null) {
            return true;
        }
        int index = firstUnFreezedCol.getInt("seq") - 1;
        this.getModel().beginInit();
        for (int i = index; i < size; ++i) {
            DynamicObject entryObj = (DynamicObject)movedEntryEntities.get(i);
            if (!entryObj.getBoolean("freeze")) continue;
            entryObj.set("freeze", (Object)Boolean.FALSE);
            this.getView().setEnable(Boolean.TRUE, i, new String[]{"secondaryheader"});
            this.getView().updateView("freeze", i);
        }
        this.getModel().endInit();
        return true;
    }

    private boolean isSelectedData(int[] rowIndexs) {
        if (rowIndexs.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u64cd\u4f5c\u7684\u6570\u636e\u3002", (String)"AbstractRptDisplayPlugin_6", (String)"swc-hsbp-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean moveTo(int[] rows) {
        boolean isSelected = this.isSelectedData(rows);
        if (!isSelected) {
            return false;
        }
        if (rows.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"AbstractRptDisplayPlugin_7", (String)"swc-hsbp-formplugin", (Object[])new Object[0]));
            return false;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsbp_rptdisplaymove");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u62a5\u8868\u663e\u793a\u65b9\u6848\u79fb\u52a8\u5f39\u6846", (String)"AbstractRptDisplayPlugin_8", (String)"swc-hsbp-formplugin", (Object[])new Object[0]));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "handleMoveToCallback");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
        return true;
    }

    private boolean sort(int[] rows) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u6570\u636e\u3002", (String)"AbstractRptDisplayPlugin_9", (String)"swc-hsbp-formplugin", (Object[])new Object[0]));
            return false;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCustomParam("MAX_SORT_FIELD_COUNT", (Object)this.getMaxSortFieldCount());
        showParameter.setFormId("hsbp_rptdisplaysort");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "handleSortCallback");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
        return true;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        switch (actionId = evt.getActionId()) {
            case "handleMoveToCallback": {
                IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                int[] rows = proxy.getEntryState("entryentity").getSelectedRows();
                Map returnData = (Map)evt.getReturnData();
                if (CollectionUtils.isEmpty((Map)returnData)) {
                    return;
                }
                Object rowNumber = returnData.get("rownumber");
                if (null == rowNumber) {
                    return;
                }
                Integer row = Integer.parseInt(rowNumber.toString());
                this.moveToSpecLocation(rows[0], row - 1);
                break;
            }
            case "handleSortCallback": {
                Map returnData2 = (Map)evt.getReturnData();
                ReportTplHelper.setSortColumn((Map)returnData2, (IFormView)this.getView());
                break;
            }
            case "CALLBACK_IMPORT_RPT_DISPLAY_SCHEMA": {
                ListSelectedRowCollection returnData3 = (ListSelectedRowCollection)evt.getReturnData();
                this.setShareSchemeAfterSelectedOne(returnData3);
                break;
            }
            case "addSchemeNameAndDesc": {
                Map returnDataAdd = (Map)evt.getReturnData();
                this.setDisplaySchemeBaseInfoAfterAdd(returnDataAdd);
                break;
            }
            case "editDisplayScheme": {
                Map returnData4 = (Map)evt.getReturnData();
                this.setDisplaySchemeBaseInfoAfterEdit(returnData4);
                break;
            }
            case "copyDisplayScheme": {
                Map returnData5 = (Map)evt.getReturnData();
                this.copyDisplayScheme(returnData5);
                break;
            }
            case "importDisplayScheme": {
                Map returnData6 = (Map)evt.getReturnData();
                this.importShareSchemeAfterSetName(returnData6);
                break;
            }
            case "CALLBACK_ADD_OR_IMPORT": {
                Map returnData7 = (Map)evt.getReturnData();
                this.tipAddOrImport(returnData7);
                break;
            }
        }
        this.afterClosedCallBack(evt);
    }

    protected void afterClosedCallBack(ClosedCallBackEvent evt) {
    }

    private void moveToSpecLocation(Integer from, Integer to) {
        if (from == null || to == null || from < 0 || to < 0 || from.equals(to)) {
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        Integer toIndex = to;
        if (to >= entryEntity.size()) {
            toIndex = entryEntity.size() - 1;
        }
        IDataModel model = this.getModel();
        model.beginInit();
        DynamicObject fromObject = this.getModel().getEntryRowEntity("entryentity", from.intValue());
        model.deleteEntryRow("entryentity", from.intValue());
        DataEntityPropertyCollection properties = fromObject.getDataEntityType().getProperties();
        model.insertEntryRow("entryentity", toIndex.intValue());
        for (IDataEntityProperty property : properties) {
            if (property.getName().equals("seq") || property.getName().equals("id")) continue;
            model.setValue(property.getName(), fromObject.get(property), toIndex.intValue());
        }
        model.endInit();
        this.getView().updateView("entryentity");
        this.refreshSecondaryHeaderByFreezeData(to);
        this.getModel().setDataChanged(false);
        EntryGrid control = (EntryGrid)this.getControl("entryentity");
        control.selectRows(toIndex.intValue());
    }

    private void refreshSecondaryHeaderByFreezeData(Integer movedIndex) {
        boolean condition;
        if (movedIndex == null) {
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        Integer index = movedIndex;
        if (movedIndex >= entryEntity.size()) {
            index = entryEntity.size() - 1;
        }
        IDataModel model = this.getModel();
        model.beginInit();
        String lastValue = ((DynamicObject)entryEntity.get(index.intValue())).getString("freeze");
        ((DynamicObject)entryEntity.get(index.intValue())).set("freeze", (Object)"0");
        boolean isFreeze = false;
        Integer freezeNo = null;
        for (int i = entryEntity.size() - 1; i >= 0; --i) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            if (dynamicObject.getBoolean("freeze")) {
                isFreeze = true;
                if (null == freezeNo) {
                    freezeNo = i;
                }
            }
            if (!isFreeze) continue;
            dynamicObject.set("secondaryheader", null);
            dynamicObject.set("freeze", (Object)isFreeze);
        }
        boolean bl = condition = isFreeze && (index - freezeNo == 1 || index - freezeNo == 0);
        if (condition) {
            ((DynamicObject)entryEntity.get(index.intValue())).set("freeze", (Object)lastValue);
        }
        model.endInit();
        this.getView().updateView("entryentity");
        ReportTplHelper.refreshSecondaryHeaderByFreeze((IFormView)this.getView());
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "flexadd": 
            case "flexaddleft": 
            case "vectoradd": 
            case "flexaddright": 
            case "labeladd": {
                if (this.checkDataChange("CALLBACK_CHECK_DATA_CHANGE_ADD")) break;
                this.addDisplayScheme();
                break;
            }
            case "btnedit": {
                this.editDisplayScheme();
                break;
            }
            case "btndelete": {
                this.deleteDisplayScheme();
                break;
            }
            case "btncopy": {
                this.copyDisplaySchemeShowForm();
                break;
            }
            case "btnimportscheme": {
                if (this.checkDataChange("CALLBACK_CHECK_DATA_CHANGE_IMPORT")) break;
                this.importSchemeF7();
                break;
            }
        }
    }

    private void deleteDisplayScheme() {
        boolean condition;
        if (!this.checkSelectedSchm()) {
            return;
        }
        BaseShowParameter showParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        String pkId = String.valueOf(showParameter.getPkId());
        DynamicObject dyObj = ReportTplHelper.queryRptDisplayScheme((String)this.getCurrentRptDisplayFormId(), (Long)Long.parseLong(pkId));
        boolean bl = condition = dyObj != null && (dyObj.getBoolean("defaultscheme") || dyObj.getBoolean("sharescheme"));
        if (condition) {
            String warnTip = ResManager.loadKDString((String)"\u8be5\u663e\u793a\u65b9\u6848\u4e3a\u9ed8\u8ba4\u65b9\u6848\u6216\u5171\u4eab\u65b9\u6848\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"AbstractRptDisplayPlugin_10", (String)"swc-hsbp-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(warnTip);
            return;
        }
        this.getPageCache().put("CACHE_DELETE_DISPLAY_SCHEMA_ID", pkId);
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("CALLBACK_DELETE", (IFormPlugin)this);
        String confirmTip = ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u540e\u76841\u6761\u65b9\u6848\u540e\u5c06\u65e0\u6cd5\u6062\u590d \u786e\u5b9a\u8981\u5220\u9664\u8be5\u65b9\u6848\u5417\uff1f", (String)"AbstractRptDisplayPlugin_11", (String)"swc-hsbp-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
    }

    private boolean checkSelectedSchm() {
        BaseShowParameter showParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        Object pkId = showParameter.getPkId();
        if (pkId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65b9\u6848\u6216\u8005\u65b0\u589e\u65b9\u6848\u540e\u518d\u64cd\u4f5c\u3002", (String)"AbstractRptDisplayPlugin_3", (String)"swc-hsbp-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void copyDisplaySchemeShowForm() {
        if (!this.checkSelectedSchm()) {
            return;
        }
        if (this.getModel().getDataChanged()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u590d\u5236\u5e76\u5207\u6362\u65b9\u6848\uff1f\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"AbstractRptDisplayPlugin_12", (String)"swc-hsbp-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("copyDisplaySchemeDataChanged"));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsbp_rptdisplayinfo");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "copyDisplayScheme"));
        IBillModel dataModel = (IBillModel)this.getModel();
        long pkId = Long.parseLong(String.valueOf(dataModel.getPKValue()));
        DynamicObject schmObj = this.queryRptDisplaySchemeObj(pkId);
        if (schmObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u539f\u65b9\u6848\u4e0d\u5b58\u5728\uff0c\u8bf7\u9009\u62e9\u65b9\u6848\u6216\u8005\u65b0\u589e\u65b9\u6848\u540e\u518d\u64cd\u4f5c\u3002", (String)"AbstractRptDisplayPlugin_13", (String)"swc-hsbp-formplugin", (Object[])new Object[0]));
            this.buildSchmTree();
            return;
        }
        String schmName = schmObj.getLocaleString("name").getLocaleValue();
        showParameter.setCustomParam("name", (Object)ResManager.loadKDString((String)"{0}(\u590d\u5236)", (String)"AbstractRptDisplayPlugin_26", (String)"swc-hsbp-formplugin", (Object[])new Object[]{schmName}));
        showParameter.setCustomParam("schemedesc", schmObj.get("schemedesc"));
        showParameter.setCaption(ResManager.loadKDString((String)"\u590d\u5236\u663e\u793a\u65b9\u6848", (String)"AbstractRptDisplayPlugin_14", (String)"swc-hsbp-formplugin", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
        this.setCacheForDisplayInfo(showParameter);
    }

    private void importDisplaySchemeShowForm() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsbp_rptdisplayinfo");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "importDisplayScheme"));
        showParameter.setCaption(ResManager.loadKDString((String)"\u5bfc\u5165\u663e\u793a\u65b9\u6848", (String)"AbstractRptDisplayPlugin_30", (String)"swc-hsbp-formplugin", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
    }

    private void copyDisplayScheme(Map<String, Object> returnData) {
        if (returnData == null) {
            return;
        }
        BaseShowParameter showParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        String pkId = String.valueOf(showParameter.getPkId());
        DynamicObject result = ReportTplHelper.copyDisplayScheme((String)this.getCurrentRptDisplayFormId(), (String)pkId, returnData);
        if (result != null) {
            new OperationServiceImpl().localInvokeOperation(option_donothing_copy, new DynamicObject[]{this.getModel().getDataEntity()}, OperateOption.create());
            this.getPageCache().put("CACHE_SELECTED_NODE", result.getString("id"));
            this.getPageCache().put(CACHE_IS_ADDNEW, String.valueOf(Boolean.TRUE));
            this.buildSchmTree();
        }
    }

    private void setShareSchemeAfterSelectedOne(ListSelectedRowCollection returnData) {
        DynamicObject result = ReportTplHelper.setShareSchemeAfterSelectedOne((String)this.getCurrentRptDisplayFormId(), (ListSelectedRowCollection)returnData, (IFormView)this.getView());
        if (result != null) {
            new OperationServiceImpl().localInvokeOperation(option_donothing_importscheme, new DynamicObject[]{this.getModel().getDataEntity()}, OperateOption.create());
            this.getPageCache().put("CACHE_SELECTED_NODE", result.getString("id"));
            this.buildSchmTree();
        }
    }

    private void importShareSchemeAfterSetName(Map<String, Object> returnData) {
        if (returnData == null) {
            return;
        }
        String pkId = this.getView().getPageCache().get("waitImportSchmId");
        DynamicObject result = ReportTplHelper.copyDisplayScheme((String)this.getCurrentRptDisplayFormId(), (String)pkId, returnData);
        if (result != null) {
            this.getPageCache().put("CACHE_SELECTED_NODE", result.getString("id"));
            this.getPageCache().put(CACHE_IS_ADDNEW, String.valueOf(Boolean.TRUE));
            this.buildSchmTree();
        }
    }

    private void setDisplaySchemeBaseInfoAfterAdd(Map<String, Object> returnData) {
        if (returnData == null) {
            return;
        }
        String repDisplayName = this.getCurrentRptDisplayFormId();
        DynamicObject result = ReportTplHelper.addDisplayScheme((String)repDisplayName, (String)this.getReportFormId(), returnData);
        this.getPageCache().put("CACHE_SELECTED_NODE", result.getString("id"));
        this.getPageCache().put(CACHE_IS_ADDNEW, String.valueOf(Boolean.TRUE));
        this.buildSchmTree();
    }

    private String getCurrentRptDisplayFormId() {
        return this.getModel().getDataEntityType().getName();
    }

    private void setDisplaySchemeBaseInfoAfterEdit(Map<String, Object> returnData) {
        if (returnData == null) {
            return;
        }
        BaseShowParameter showParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        String pkId = String.valueOf(showParameter.getPkId());
        DynamicObject schmObj = ReportTplHelper.updateDisplayScheme((String)this.getCurrentRptDisplayFormId(), (String)pkId, returnData);
        new OperationServiceImpl().localInvokeOperation(option_donothing_update, new DynamicObject[]{this.getModel().getDataEntity()}, OperateOption.create());
        TreeView schmTreeView = (TreeView)this.getView().getControl("schmtreeview");
        OrmLocaleValue name = (OrmLocaleValue)schmObj.get("name");
        TreeNode currNode = new TreeNode("", String.valueOf(showParameter.getPkId()), name.getLocaleValue());
        schmTreeView.updateNode(currNode);
        schmTreeView.focusNode(currNode);
    }

    private void importSchemeF7() {
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        pageCache.put("importShareScheme", (Object)"importing");
        ListShowParameter form = ShowFormHelper.createShowListForm((String)this.getCurrentRptDisplayFormId(), (boolean)false);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter qFilter = new QFilter("sharescheme", "=", (Object)"1");
        filters.add(qFilter);
        String reportFormId = this.getReportFormId();
        if (SWCStringUtils.isNotEmpty((String)reportFormId)) {
            filters.add(new QFilter("reportformid", "=", (Object)reportFormId));
        }
        form.getListFilterParameter().setQFilters(filters);
        form.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CALLBACK_IMPORT_RPT_DISPLAY_SCHEMA"));
        form.setFormId(BOS_LISTF7);
        this.getView().showForm((FormShowParameter)form);
    }

    private void addDisplayScheme() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsbp_rptdisplayinfo");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addSchemeNameAndDesc"));
        showParameter.setCustomParam("type", (Object)"new");
        showParameter.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u663e\u793a\u65b9\u6848", (String)"AbstractRptDisplayPlugin_16", (String)"swc-hsbp-formplugin", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
        this.setCacheForDisplayInfo(showParameter);
    }

    private void setCacheForDisplayInfo(FormShowParameter showParameter) {
        ISWCAppCache cache = SWCAppCache.get((String)"hsbp");
        cache.put(showParameter.getPageId() + "_schmNodes", (Object)this.getView().getPageCache().get("schmNodes"));
    }

    private void editDisplayScheme() {
        if (!this.checkSelectedSchm()) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsbp_rptdisplayinfo");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "editDisplayScheme"));
        IBillModel dataModel = (IBillModel)this.getModel();
        long pkId = Long.parseLong(String.valueOf(dataModel.getPKValue()));
        DynamicObject schmObj = this.queryRptDisplaySchemeObj(pkId);
        showParameter.setCustomParam("name", (Object)schmObj.getLocaleString("name").getLocaleValue());
        showParameter.setCustomParam("id", schmObj.get("id"));
        showParameter.setCustomParam("schemedesc", schmObj.get("schemedesc"));
        showParameter.setCaption(ResManager.loadKDString((String)"\u663e\u793a\u65b9\u6848", (String)"AbstractRptDisplayPlugin_17", (String)"swc-hsbp-formplugin", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
        this.setCacheForDisplayInfo(showParameter);
    }

    private boolean validSecondaryHeaderContinuous() {
        DynamicObjectCollection entryEntities = this.getModel().getEntryEntity("entryentity");
        HashSet<String> secondaryHeaderSets = new HashSet<String>(entryEntities.size());
        DynamicObject preEntryObj = entryEntities.stream().filter(entryObj -> !entryObj.getBoolean("freeze")).findFirst().orElse(null);
        if (preEntryObj == null) {
            return true;
        }
        for (DynamicObject entryObj2 : entryEntities) {
            if (entryObj2.getBoolean("freeze")) continue;
            String preSecondaryHeader = preEntryObj.getString("secondaryheader");
            String secondaryHeader = entryObj2.getString("secondaryheader");
            if (secondaryHeaderSets.contains(secondaryHeader) && !preSecondaryHeader.equals(secondaryHeader)) {
                String tipMsg = ResManager.loadKDString((String)"\u76f8\u540c\u4e8c\u7ea7\u8868\u5934\u6570\u636e\u6392\u5217\u4e0d\u8fde\u7eed\u3002", (String)"AbstractRptDisplayPlugin_18", (String)"swc-hsbp-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(tipMsg);
                return false;
            }
            if (SWCStringUtils.isNotEmpty((String)secondaryHeader)) {
                secondaryHeaderSets.add(secondaryHeader);
            }
            preEntryObj = entryObj2;
        }
        return true;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (opKey = formOperate.getOperateKey()) {
            case "save": {
                String afterConfirm = formOperate.getOption().getVariableValue("SAVE_AFTERCONFIRM", "0");
                if ("0".equals(afterConfirm) && !this.doValidBeforSave()) {
                    args.setCancel(true);
                    return;
                }
                this.confirmResetDefaultScheme(args, formOperate);
                break;
            }
        }
    }

    private boolean doValidBeforSave() {
        return this.checkSelectedSchm(this.getView()) && this.validSecondaryHeaderContinuous() && this.validDisplayName() && this.beforeDoSaveOperation();
    }

    private boolean validDisplayName() {
        DynamicObjectCollection entryEntities = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntities)) {
            return true;
        }
        HashSet<String> displayNameSet = new HashSet<String>();
        HashSet<String> repeatDisplayNameSet = new HashSet<String>();
        for (DynamicObject dynamicObject : entryEntities) {
            String displayName = dynamicObject.getString("displayname");
            if (SWCStringUtils.isEmpty((String)displayName) || displayNameSet.add(displayName)) continue;
            repeatDisplayNameSet.add(displayName);
        }
        if (!CollectionUtils.isEmpty(repeatDisplayNameSet)) {
            String repeatNameTip = ResManager.loadKDString((String)"\u663e\u793a\u540d\u79f0%s\u91cd\u590d\u3002", (String)"AbstractRptDisplayPlugin_19", (String)"swc-hsbp-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(String.format(Locale.ROOT, repeatNameTip, repeatDisplayNameSet));
            return false;
        }
        return true;
    }

    private void confirmResetDefaultScheme(BeforeDoOperationEventArgs args, FormOperate formOperate) {
        DynamicObject dataEntity;
        boolean isDefaultScheme;
        boolean confirm = formOperate.getOption().tryGetVariableValue("confirm", new RefObject());
        DynamicObject defaultSchemeObj = ReportTplHelper.queryDefaultScheme((String)this.getCurrentRptDisplayFormId(), (String)this.getReportFormId());
        if (defaultSchemeObj != null && !confirm && (isDefaultScheme = (dataEntity = this.getModel().getDataEntity()).getBoolean("defaultscheme")) && dataEntity.getLong("id") != defaultSchemeObj.getLong("id")) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u5df2\u6709\u9ed8\u8ba4\u65b9\u6848\uff0c\u662f\u5426\u8981\u53d6\u6d88\u4e4b\u524d\u7684\u9ed8\u8ba4\u65b9\u6848\uff1f", (String)"AbstractRptDisplayPlugin_20", (String)"swc-hsbp-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("resetDefaultScheme"));
            args.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId = evt.getCallBackId();
        if (MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            switch (callBackId) {
                case "resetDefaultScheme": {
                    OperateOption operateOption = OperateOption.create();
                    operateOption.setVariableValue("confirm", "true");
                    this.getView().invokeOperation("save", operateOption);
                    break;
                }
                case "CALLBACK_DELETE": {
                    new OperationServiceImpl().localInvokeOperation(option_donothing_delete, new DynamicObject[]{this.getModel().getDataEntity()}, OperateOption.create());
                    String pkId = this.getPageCache().get("CACHE_DELETE_DISPLAY_SCHEMA_ID");
                    ReportTplHelper.deleteRptDisplaySchemeById((String)this.getCurrentRptDisplayFormId(), (Long)Long.valueOf(pkId));
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"AbstractRptDisplayPlugin_21", (String)"swc-hsbp-formplugin", (Object[])new Object[0]));
                    BaseShowParameter showParameter = (BaseShowParameter)this.getView().getFormShowParameter();
                    showParameter.setPkId(null);
                    this.getView().cacheFormShowParameter();
                    this.getPageCache().remove("CACHE_SELECTED_NODE");
                    this.buildSchmTree();
                    this.afterDeleteDisplaySchema(pkId);
                    break;
                }
                case "copyDisplaySchemeDataChanged": {
                    this.checkNewDisplaySchm();
                    this.getView().getModel().setDataChanged(false);
                    this.copyDisplaySchemeShowForm();
                    break;
                }
                case "CALLBACK_CHECK_DATA_CHANGE_TREE": {
                    this.checkNewDisplaySchm();
                    this.refreshDisplaySchm(this.getPageCache().get("waitNodeId"));
                    break;
                }
                case "CALLBACK_CHECK_DATA_CHANGE_CLOSE": {
                    this.checkNewDisplaySchm();
                    this.getView().getModel().setDataChanged(false);
                    this.getView().invokeOperation("close");
                    break;
                }
                case "CALLBACK_CHECK_DATA_CHANGE_ADD": {
                    this.checkNewDisplaySchm();
                    this.addDisplayScheme();
                    break;
                }
                case "CALLBACK_CHECK_DATA_CHANGE_IMPORT": {
                    this.importSchemeF7();
                    break;
                }
                case "importShareSchemeCheckNameExists": {
                    this.importDisplaySchemeShowForm();
                    break;
                }
            }
        } else {
            switch (callBackId) {
                case "CALLBACK_CHECK_DATA_CHANGE_TREE": {
                    TreeView treeView = (TreeView)this.getView().getControl("schmtreeview");
                    BaseShowParameter showParameter = (BaseShowParameter)this.getView().getFormShowParameter();
                    Object pkId = showParameter.getPkId();
                    TreeNode focusNode = new TreeNode("", String.valueOf(pkId), null);
                    treeView.focusNode(focusNode);
                    break;
                }
            }
        }
    }

    private void checkNewDisplaySchm() {
        BaseShowParameter showParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        long pkId = 0L;
        if (showParameter.getPkId() != null) {
            pkId = Long.parseLong(String.valueOf(showParameter.getPkId()));
        }
        if (pkId == 0L) {
            return;
        }
        String isAddNew = this.getPageCache().get(CACHE_IS_ADDNEW);
        if (Boolean.TRUE.toString().equals(isAddNew)) {
            ReportTplHelper.deleteRptDisplaySchemeById((String)this.getCurrentRptDisplayFormId(), (Long)pkId);
            this.getPageCache().remove(CACHE_IS_ADDNEW);
        }
    }

    private boolean checkDataChange(String callBackId) {
        String dataChangeContinue;
        String isAddNew = this.getPageCache().get(CACHE_IS_ADDNEW);
        IDataModel model = this.getModel();
        model.getDataChanged();
        DynamicObject dataEntity = model.getDataEntity(true);
        String changeDesc = model.getChangeDesc();
        boolean isChange = false;
        if (!StringUtils.isEmpty((CharSequence)changeDesc) && dataEntity != null && dataEntity.getDynamicObjectCollection("entryentity").size() != 0) {
            isChange = true;
        }
        if (String.valueOf(Boolean.TRUE).equals(isAddNew) && StringUtils.isEmpty((CharSequence)changeDesc)) {
            isChange = true;
        }
        if ((dataChangeContinue = (String)this.getView().getFormShowParameter().getCustomParam("dataChangeContinue")) != null) {
            isChange = false;
        }
        if (isChange) {
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"AbstractRptDisplayPlugin_22", (String)"swc-hsbp-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"AbstractRptDisplayPlugin_23", (String)"swc-hsbp-formplugin", (Object[])new Object[0]));
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"AbstractRptDisplayPlugin_24", (String)"swc-hsbp-formplugin", (Object[])new Object[0]);
            msg = msg.replaceAll("\\\\r\\\\n", "\r\n");
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(callBackId, (IFormPlugin)this);
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            this.getView().showConfirm(msg, changeDesc, options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        }
        return isChange;
    }

    public void beforeClosed(BeforeClosedEvent event) {
        BaseShowParameter showParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        long pkId = 0L;
        if (showParameter.getPkId() != null) {
            pkId = Long.parseLong(String.valueOf(showParameter.getPkId()));
        }
        if (pkId == 0L) {
            this.getView().getModel().setDataChanged(false);
        }
        if (this.checkDataChange("CALLBACK_CHECK_DATA_CHANGE_CLOSE")) {
            event.setCancel(true);
        }
    }

    private DynamicObject queryRptDisplaySchemeObj(Long pkId) {
        String name = this.getModel().getDataEntityType().getName();
        String selectProperties = SWCHisBaseDataHelper.getSelectProperties((String)name);
        selectProperties = selectProperties + ", entryentity.seq";
        QFilter qFilter = new QFilter("id", "=", (Object)pkId);
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(this.getCurrentRptDisplayFormId());
        return serviceHelper.queryOne(selectProperties, new QFilter[]{qFilter});
    }
}

