/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.formplugin.web;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.control.Html;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.swc.hsbp.common.enums.RuleOperatorEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.vo.ConditionExpressInfo;
import kd.swc.hsbp.common.vo.ConditionInfo;
import kd.swc.hsbp.common.vo.RuleConditionInfo;

public class ExpressViewPlugin
extends AbstractFormPlugin {
    public void afterBindData(EventObject eventObject) {
        Html html = (Html)this.getView().getControl("htmlap");
        html.setConent(this.getParamValues());
    }

    private String getParamValues() {
        String conditions = (String)this.getView().getFormShowParameter().getCustomParam("data");
        RuleConditionInfo conditionInfo = (RuleConditionInfo)SerializationUtils.fromJsonString((String)conditions, RuleConditionInfo.class);
        List conditionList = conditionInfo.getConditionList();
        Map<String, ConditionInfo> conditionMap = conditionList.stream().collect(Collectors.toMap(ConditionInfo::getName, conditionInfo1 -> conditionInfo1, (o1, o2) -> o1));
        List conditionExpressList = conditionInfo.getConditionExpressList();
        StringBuilder sb = new StringBuilder("<div>");
        for (ConditionExpressInfo conditionExpressInfo : conditionExpressList) {
            this.appendConditionHtml(conditionMap, sb, conditionExpressInfo);
            String logic = null;
            if (!SWCStringUtils.isEmpty((String)conditionExpressInfo.getLogical())) {
                logic = "and".equals(conditionExpressInfo.getLogical().trim()) ? ResManager.loadKDString((String)"\u5e76\u4e14", (String)"ExpressViewPlugin_0", (String)"swc-hsbp-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6216\u8005", (String)"ExpressViewPlugin_1", (String)"swc-hsbp-formplugin", (Object[])new Object[0]);
            }
            sb.append("<span class='logic'>").append(this.tranNullToEmpty(logic)).append("</span>");
            sb.append("</br>");
        }
        sb.append("</div>");
        return sb.toString();
    }

    private void appendConditionHtml(Map<String, ConditionInfo> conditionMap, StringBuilder sb, ConditionExpressInfo conditionExpressInfo) {
        String name = conditionExpressInfo.getName();
        ConditionInfo condition = conditionMap.get(name);
        sb.append("<span class='leftBracket'>").append(this.tranNullToEmpty(conditionExpressInfo.getLeftBracket())).append("</span>");
        sb.append("<span>\u3010<span class='param'>").append(this.tranNullToEmpty(condition.getDisplayParam())).append("</span>\u3011</span>");
        sb.append("<span class='comparisonOpt'>").append(this.tranNullToEmpty(RuleOperatorEnum.getEnum((String)condition.getOperators()).getName())).append("</span>");
        sb.append("<span>");
        if (SWCStringUtils.isNotEmpty((String)condition.getDisplayValue())) {
            sb.append(" \"<span class='value'>");
            sb.append(condition.getDisplayValue());
            sb.append("</span>\" ");
        }
        sb.append("</span>");
        sb.append("<span class='rightBracket'>").append(this.tranNullToEmpty(conditionExpressInfo.getRightBracket())).append("</span>");
        sb.append("</br>");
    }

    private String tranNullToEmpty(String str) {
        if (SWCStringUtils.isEmpty((String)str)) {
            str = "";
        }
        return str;
    }
}

