/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.formplugin.web;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Html;
import kd.bos.form.control.Image;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.swc.hsbp.business.servicehelper.SWCBaseDataSummaryHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCBaseUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.vo.SummaryObject;
import kd.swc.hsbp.common.vo.SummaryObjectList;

public class SWCBaseDataSummaryPlugin
extends AbstractFormPlugin {
    private static final String KEY_SUBMIT = "submit";
    private static final String KEY_AUDIT = "audit";
    private static final String KEY_LOSEEFFECT = "loseeffect";
    private static final String KEY_ABANDONED = "abandoned";
    private static final String KEY_DISABLE = "disable";
    private static final String KEY_UNUSING = "unusing";

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.setAllVisible(false);
        SummaryObjectList fixSummaryObjectList = this.getFixSummaryObjectList();
        SummaryObjectList liveSummaryObjectList = this.getLiveSummaryObjectList();
        if (null != fixSummaryObjectList) {
            this.setFixSummaryValue(fixSummaryObjectList);
        }
        if (null != liveSummaryObjectList) {
            this.setLiveSummaryValue(liveSummaryObjectList);
        }
        this.sendPageIdToPageCache();
    }

    protected void sendPageIdToPageCache() {
        String pageId;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter != null && SWCStringUtils.isNotEmpty((String)(pageId = formShowParameter.getParentPageId()))) {
            SWCPageCache cache = new SWCPageCache(pageId);
            cache.put("SummaryPageId", (Object)this.getView().getPageId());
        }
    }

    protected void setLiveSummaryValue(SummaryObjectList floatSummaryObjectList) {
        if (null != floatSummaryObjectList) {
            List list = floatSummaryObjectList.getSummaryList();
            String result = "";
            for (SummaryObject summaryObject : list) {
                if (!SWCBaseDataSummaryHelper.isNotEmptySummary((SummaryObject)summaryObject)) continue;
                result = this.drawLiveLabel(result, summaryObject.getName() + "\uff1a" + summaryObject.getValue(), 12);
            }
            result = "<p>" + result + "</p>";
            Html html = (Html)this.getView().getControl("livemsg");
            html.setConent(result);
            this.getView().setVisible(Boolean.TRUE, new String[]{"livemsg"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"livesumap"});
        }
    }

    protected String drawLiveLabel(String leftValue, String rightValue, int blankNum) {
        if (blankNum <= 0) {
            return "";
        }
        String result = leftValue;
        if (null == result) {
            return "";
        }
        StringBuilder sb = new StringBuilder(result);
        if (SWCStringUtils.isNotEmpty((String)result)) {
            for (int i = 0; i < blankNum; ++i) {
                sb.append("&nbsp;");
            }
        }
        sb.append(rightValue);
        return sb.toString();
    }

    protected SummaryObjectList getLiveSummaryObjectList() {
        String summaryObjectListString = (String)this.getView().getFormShowParameter().getCustomParams().get("liveSummaryObjectList");
        SummaryObjectList summaryObjectList = null;
        if (SWCStringUtils.isNotEmpty((String)summaryObjectListString)) {
            summaryObjectList = (SummaryObjectList)SWCBaseUtils.json2Pojo(SummaryObjectList.class, (String)summaryObjectListString);
        }
        return summaryObjectList;
    }

    protected void setFixSummaryValue(SummaryObjectList summaryObjectList) {
        if (null != summaryObjectList && summaryObjectList.getSummaryList().size() > 0) {
            List summaryList = summaryObjectList.getSummaryList();
            this.setSpacing(summaryList);
            block20: for (SummaryObject summaryObject : summaryList) {
                if (SWCBaseDataSummaryHelper.isEmptySummary((SummaryObject)summaryObject)) continue;
                String key = summaryObject.getKey();
                String value = summaryObject.getValue();
                switch (key) {
                    case "status": {
                        this.getView().setVisible(Boolean.TRUE, new String[]{key});
                        this.showStatusLabel(value);
                        continue block20;
                    }
                    case "enable": {
                        this.getView().setVisible(Boolean.TRUE, new String[]{key});
                        this.showEnableLabel(value);
                        continue block20;
                    }
                    case "bsed": {
                        this.getModel().setValue(key, (Object)value);
                        this.getView().setVisible(Boolean.TRUE, new String[]{"bredap"});
                        continue block20;
                    }
                    case "createtime": {
                        this.getModel().setValue(key, (Object)value);
                        this.getView().setVisible(Boolean.TRUE, new String[]{"createtimeap"});
                        continue block20;
                    }
                    case "createorg": {
                        this.getModel().setValue(key, (Object)value);
                        this.getView().setVisible(Boolean.TRUE, new String[]{"createorgap"});
                        continue block20;
                    }
                    case "creator": {
                        this.getModel().setValue(key, (Object)value);
                        this.getView().setVisible(Boolean.TRUE, new String[]{"creatorap"});
                        continue block20;
                    }
                    case "countryimg": {
                        this.getView().setVisible(Boolean.TRUE, new String[]{"countryimg"});
                        Image img = (Image)this.getView().getControl("countryimg");
                        img.setUrl(value);
                        this.getView().updateView("countryimg");
                        continue block20;
                    }
                    case "ismodify": {
                        this.getView().setVisible(Boolean.TRUE, new String[]{key});
                        continue block20;
                    }
                }
                this.getModel().setValue(key, (Object)value);
                this.getView().setVisible(Boolean.TRUE, new String[]{key});
            }
        }
    }

    private void setSpacing(List<SummaryObject> summaryList) {
        String countryLogo = null;
        String country = null;
        String currency = null;
        String sharable = null;
        block12: for (int count = 0; count < summaryList.size(); ++count) {
            String key;
            SummaryObject summaryObj = summaryList.get(count);
            if (!SWCBaseDataSummaryHelper.isNotEmptySummary((SummaryObject)summaryObj)) continue;
            switch (key = summaryObj.getKey()) {
                case "countryimg": {
                    countryLogo = "countryimg";
                    continue block12;
                }
                case "country": {
                    country = "country";
                    continue block12;
                }
                case "currency": {
                    currency = "currency";
                    continue block12;
                }
                case "issharescheme": {
                    sharable = "issharescheme";
                    continue block12;
                }
            }
        }
        if (SWCStringUtils.isEmpty(countryLogo) && SWCStringUtils.isNotEmpty(country)) {
            this.setMargin("24px", "country");
        } else if (SWCStringUtils.isNotEmpty(countryLogo) && SWCStringUtils.isNotEmpty(country)) {
            this.setMargin("6px", "country");
        }
        if (SWCStringUtils.isEmpty(currency) && SWCStringUtils.isNotEmpty(sharable)) {
            this.setMargin("12px", "issharescheme");
        } else if (SWCStringUtils.isNotEmpty(currency) && SWCStringUtils.isNotEmpty(sharable)) {
            this.setMargin("8px", "issharescheme");
        }
    }

    private void setMargin(String leftMargin, String controlKey) {
        HashMap<String, String> marginMap = new HashMap<String, String>(2);
        marginMap.put("l", leftMargin);
        HashMap<String, HashMap<String, String>> styleMap = new HashMap<String, HashMap<String, String>>(2);
        styleMap.put("m", marginMap);
        HashMap<String, HashMap<String, HashMap<String, String>>> fieldMap = new HashMap<String, HashMap<String, HashMap<String, String>>>(2);
        fieldMap.put("s", styleMap);
        this.getView().updateControlMetadata(controlKey, fieldMap);
    }

    protected SummaryObjectList getFixSummaryObjectList() {
        String summaryObjectListString = (String)this.getView().getFormShowParameter().getCustomParams().get("fixSummaryObjectList");
        SummaryObjectList summaryObjectList = null;
        if (SWCStringUtils.isNotEmpty((String)summaryObjectListString)) {
            summaryObjectList = (SummaryObjectList)SWCBaseUtils.json2Pojo(SummaryObjectList.class, (String)summaryObjectListString);
        }
        return summaryObjectList;
    }

    protected void setAllVisible(boolean visible) {
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"name"});
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"number"});
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"currency"});
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"started"});
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"countryimg"});
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"country"});
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"bredap"});
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"status"});
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{KEY_SUBMIT});
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{KEY_AUDIT});
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{KEY_LOSEEFFECT});
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{KEY_ABANDONED});
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"enable"});
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{KEY_DISABLE});
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{KEY_UNUSING});
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"ismodify"});
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"livemsg"});
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"livesumap"});
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"sublabel"});
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"createtimeap"});
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"createorgap"});
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"creatorap"});
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"issharescheme"});
    }

    private void showStatusLabel(String status) {
        switch (status) {
            case "A": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"status"});
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_SUBMIT, KEY_AUDIT, KEY_LOSEEFFECT, KEY_ABANDONED});
                break;
            }
            case "B": {
                this.getView().setVisible(Boolean.TRUE, new String[]{KEY_SUBMIT});
                this.getView().setVisible(Boolean.FALSE, new String[]{"status", KEY_AUDIT, KEY_LOSEEFFECT, KEY_ABANDONED});
                break;
            }
            case "C": {
                this.getView().setVisible(Boolean.TRUE, new String[]{KEY_AUDIT});
                this.getView().setVisible(Boolean.FALSE, new String[]{"status", KEY_SUBMIT, KEY_LOSEEFFECT, KEY_ABANDONED});
                break;
            }
            case "D": {
                this.getView().setVisible(Boolean.TRUE, new String[]{KEY_LOSEEFFECT});
                this.getView().setVisible(Boolean.FALSE, new String[]{"status", KEY_SUBMIT, KEY_AUDIT, KEY_ABANDONED});
                break;
            }
            case "E": {
                this.getView().setVisible(Boolean.TRUE, new String[]{KEY_ABANDONED});
                this.getView().setVisible(Boolean.FALSE, new String[]{"status", KEY_SUBMIT, KEY_AUDIT, KEY_LOSEEFFECT});
                break;
            }
        }
    }

    private void showEnableLabel(String status) {
        switch (status) {
            case "1": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"enable"});
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_DISABLE, KEY_UNUSING});
                break;
            }
            case "0": {
                this.getView().setVisible(Boolean.TRUE, new String[]{KEY_DISABLE});
                this.getView().setVisible(Boolean.FALSE, new String[]{"enable", KEY_UNUSING});
                break;
            }
            case "10": {
                this.getView().setVisible(Boolean.TRUE, new String[]{KEY_UNUSING});
                this.getView().setVisible(Boolean.FALSE, new String[]{"enable", KEY_DISABLE});
                break;
            }
        }
    }
}

