/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.formplugin.web;

import java.text.ParseException;
import java.util.EventObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.Tips;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.Html;
import kd.bos.form.control.Label;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.control.LabelAp;
import kd.swc.hsbp.common.control.SWCLabelAp;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SWCBrledConfirmPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(SWCBrledConfirmPlugin.class);

    public void registerListener(EventObject eventObject) {
        this.addClickListeners(new String[]{"btnok"});
        this.addClickListeners(new String[]{"btncanel"});
    }

    public void beforeBindData(EventObject eventObject) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String content = (String)parameter.getCustomParam("content");
        Boolean mustInput = (Boolean)parameter.getCustomParam("mustInput");
        String tipsContent = (String)parameter.getCustomParam("tipsContent");
        String tipsTitle = (String)parameter.getCustomParam("tipsTitle");
        String title = (String)parameter.getCustomParam("title");
        String dateCaption = (String)parameter.getCustomParam("dateCaption");
        String minDate = (String)parameter.getCustomParam("minDate");
        if (StringUtils.isNotBlank((CharSequence)title)) {
            LabelAp imgLabel = new SWCLabelAp.Builder("title").setFontSize(16).build();
            imgLabel.setName(new LocaleString(title));
            this.getView().updateControlMetadata(imgLabel.getKey(), imgLabel.createControl());
        }
        DateEdit dateEdit = (DateEdit)this.getView().getControl("bsled");
        if (StringUtils.isNotBlank((CharSequence)dateCaption)) {
            dateEdit.setCaption(new LocaleString(dateCaption));
        }
        if (StringUtils.isNotBlank((CharSequence)minDate)) {
            String mask = dateEdit.getMask();
            try {
                dateEdit.setMinDate(SWCDateTimeUtils.parseDate((String)minDate, (String)mask));
            }
            catch (ParseException e1) {
                logger.error("\u65e5\u671f\u63a7\u4ef6MinDate\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38:{}", (Object)e1.getMessage());
            }
        }
        if (SWCStringUtils.isNotEmpty((String)content)) {
            Html html = (Html)this.getView().getControl("fcontent");
            html.setConent(content);
        }
        if (null != mustInput) {
            FieldEdit field = (FieldEdit)this.getView().getControl("bsled");
            field.setMustInput(mustInput.booleanValue());
        }
        if (SWCStringUtils.isNotEmpty((String)tipsContent)) {
            Label label = (Label)this.getView().getControl("title");
            Tips tips = new Tips();
            tips.setType("text");
            tips.setContent(new LocaleString(tipsContent));
            if (SWCStringUtils.isNotEmpty((String)tipsTitle)) {
                tips.setTitle(new LocaleString(tipsTitle));
            }
            label.addTips(tips);
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        Object bsled = this.getModel().getValue("bsled");
        switch (key) {
            case "btnok": {
                this.getView().setReturnData(bsled);
                this.getView().returnDataToParent(bsled);
                this.getView().close();
                break;
            }
        }
    }
}

