/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.formplugin.web;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCBaseDataSummaryHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCBaseUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.vo.SummaryObjectList;

public class SWCHisBaseDataSummaryEdit
extends AbstractBasePlugIn {
    private static final Log logger = LogFactory.getLog(SWCHisBaseDataSummaryEdit.class);

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.changeAboutSummary();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        switch (args.getOperateKey()) {
            case "save": 
            case "submit": 
            case "unsubmit": 
            case "audit": 
            case "unaudit": 
            case "disable": 
            case "enable": 
            case "confirmchange": {
                if (!args.getOperationResult().isSuccess()) break;
                this.changeAboutSummary();
                break;
            }
        }
    }

    protected void changeAboutSummary() {
        boolean isShowSummary;
        if (SWCBaseDataSummaryHelper.isNew((DynamicObject)this.getModel().getDataEntity())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"summaryap"});
            return;
        }
        BillOperationStatus billStatus = ((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus();
        logger.info("SWCHisBaseDataSummaryEdit.changeAboutSummary:billStatus=", (Object)billStatus);
        boolean isHistoryPage = BaseDataHisHelper.isHisPage((IFormView)this.getView());
        boolean bl = isShowSummary = !this.isShowIfRevisionHistory() && isHistoryPage || isHistoryPage && !this.isShowIfPageToChange() && BillOperationStatus.ADDNEW.equals((Object)billStatus);
        if (isShowSummary) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"summaryap"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"summaryap"});
        String summaryPageId = this.getSummaryPageId();
        if (SWCStringUtils.isNotEmpty((String)summaryPageId)) {
            this.updateSummary(summaryPageId);
        } else {
            this.loadSummary();
        }
    }

    private String getSummaryPageId() {
        SWCPageCache cache = new SWCPageCache(this.getView());
        String summaryPageId = (String)cache.get("SummaryPageId", String.class);
        if (SWCStringUtils.isEmpty((String)summaryPageId)) {
            return null;
        }
        return summaryPageId;
    }

    protected void updateSummary(String summaryPageId) {
        IFormView formView = this.getView();
        if (SWCStringUtils.isNotEmpty((String)summaryPageId)) {
            IFormView summaryView = formView.getView(summaryPageId);
            if (summaryView == null) {
                return;
            }
            FormShowParameter formShowParameter = summaryView.getFormShowParameter();
            List<String> fixSummarykeyList = this.getFixSummarykeyList();
            SummaryObjectList fixSummaryObjectList = SWCBaseDataSummaryHelper.getBaseDataSummaryObjectList(fixSummarykeyList, (IFormView)formView);
            formShowParameter.setCustomParam("fixSummaryObjectList", (Object)SWCBaseUtils.pojo2Json((Object)fixSummaryObjectList));
            SummaryObjectList liveSummaryObjectList = this.getLiveSummaryObjectList();
            if (liveSummaryObjectList != null) {
                formShowParameter.setCustomParam("liveSummaryObjectList", (Object)SWCBaseUtils.pojo2Json((Object)liveSummaryObjectList));
            }
            summaryView.updateView();
            formView.sendFormAction(summaryView);
        }
    }

    protected void loadSummary() {
        List<String> fixSummarykeyList = this.getFixSummarykeyList();
        SummaryObjectList liveSummaryObjectList = this.getLiveSummaryObjectList();
        FormShowParameter formShowParameter = liveSummaryObjectList == null ? SWCBaseDataSummaryHelper.getBaseDataSummaryFormShowParameter((String)"summaryap", (boolean)this.isShowDelimiter(), fixSummarykeyList, (IFormView)this.getView()) : SWCBaseDataSummaryHelper.getBaseDataSummaryFormShowParameter((String)"summaryap", (boolean)this.isShowDelimiter(), fixSummarykeyList, (SummaryObjectList)liveSummaryObjectList, (IFormView)this.getView());
        this.getView().showForm(formShowParameter);
        this.getView().updateView("summaryap");
    }

    protected List<String> getFixSummarykeyList() {
        ArrayList<String> fixSummarykeyList = new ArrayList<String>();
        fixSummarykeyList.add("name");
        fixSummarykeyList.add("number");
        fixSummarykeyList.add("createorg");
        fixSummarykeyList.add("creator");
        fixSummarykeyList.add("createtime");
        fixSummarykeyList.add("bsed");
        fixSummarykeyList.add("status");
        fixSummarykeyList.add("enable");
        fixSummarykeyList.add("ismodify");
        return fixSummarykeyList;
    }

    protected SummaryObjectList getLiveSummaryObjectList() {
        return null;
    }

    protected boolean isShowDelimiter() {
        return true;
    }

    protected boolean isShowIfRevisionHistory() {
        return true;
    }

    protected boolean isShowIfPageToChange() {
        return false;
    }
}

