/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.formplugin.web.verify;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbp.business.cloudcolla.verify.VerifyBillDataService;
import kd.swc.hsbp.business.cloudcolla.verify.dynamic.DynamicPropCreatorFactory;
import kd.swc.hsbp.business.cloudcolla.verify.dynamic.IDynamicPropHandler;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.control.SWCFlexPanelAp;
import kd.swc.hsbp.common.control.SWCLabelAp;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCCoreBaseBillEdit;

public abstract class AbstractVerifyBillLoadSubCardEdit
extends SWCCoreBaseBillEdit {
    private static final Log LOGGER = LogFactory.getLog(AbstractVerifyBillLoadSubCardEdit.class);
    public static final String OBJECT_NAME = "objectName";
    public static final String OBJECT_NUMBER = "objectNumber";
    public static final String FLEX_ROOT_CONTAINER = "rootcontainer";
    public static final String OBJECT_LIST = "objectList";
    public static final String CACHE_SUB_CARD_PAGE_ID = "CACHE_SUB_CARD_PAGE_ID";
    public static final String CACHE_CLOSE_CONFIRM_FLAG = "CACHE_CLOSE_CONFIRM_FLAG";

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        List<DynamicObject> verifyDataList = this.getSubCardData();
        if (CollectionUtils.isEmpty(verifyDataList)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_ROOT_CONTAINER});
            this.getView().getPageCache().remove(CACHE_SUB_CARD_PAGE_ID);
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_ROOT_CONTAINER});
        ArrayList<DynamicObject> objectFiledEntry = new ArrayList<DynamicObject>();
        Map<String, Map<String, Object>> pageFlexDataMap = this.getPageFlexDataInfoMap(verifyDataList, objectFiledEntry);
        this.createBizAppFlex(pageFlexDataMap);
        List<Long> triggerIds = verifyDataList.stream().map(item -> {
            Object triggercolla = item.get("triggercolla");
            if (triggercolla instanceof Long) {
                return (Long)triggercolla;
            }
            if (triggercolla == null) {
                LOGGER.info("[colla] triggercolla is null item ={}", item);
                return 0L;
            }
            return ((DynamicObject)triggercolla).getLong("id");
        }).collect(Collectors.toList());
        Map<Long, DynamicObject> triggerCollas = this.getAllTriggerColla(triggerIds);
        this.createObjectFlex(objectFiledEntry, triggerCollas);
    }

    private void createObjectFlex(List<DynamicObject> objectFiledEntry, Map<Long, DynamicObject> cardFormMap) {
        HashMap<String, List> pageIdCache = new HashMap<String, List>(16);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long depEmpId = dataEntity.getLong("depemp.id");
        long depEmpBoId = dataEntity.getLong("depemp.boid");
        Date changeTime = dataEntity.getDate("changetime");
        String flowType = dataEntity.getString("flowtype");
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        for (DynamicObject dynamicObject : objectFiledEntry) {
            Long triggerId = null;
            Object triggerColla = dynamicObject.get("triggercolla");
            triggerId = triggerColla instanceof Long ? (Long)triggerColla : Long.valueOf(((DynamicObject)triggerColla).getLong("id"));
            DynamicObject trigger = cardFormMap.get(triggerId);
            if (trigger == null) continue;
            String appId = dynamicObject.getString("bizapp.id");
            String appNumber = dynamicObject.getString("bizapp.number");
            String bizObjectId = dynamicObject.getString("bizobject.id");
            String cardFrom = trigger.getString("cardform");
            if (SWCStringUtils.isEmpty((String)cardFrom)) {
                cardFrom = "hsbp_defverifycard";
            }
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId(cardFrom);
            formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            formShowParameter.getOpenStyle().setTargetKey("container-" + bizObjectId);
            if (OperationStatus.VIEW.equals((Object)status)) {
                formShowParameter.setStatus(OperationStatus.VIEW);
            } else {
                String auditStatus = this.getModel().getDataEntity().getString("auditstatus");
                formShowParameter.setStatus("A".equalsIgnoreCase(auditStatus) ? OperationStatus.EDIT : OperationStatus.VIEW);
            }
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            paramMap.put("entryData", SerializationUtils.serializeToBase64(this.getEntryData(dynamicObject, trigger)));
            paramMap.put(OBJECT_NUMBER, bizObjectId);
            paramMap.put("appNumber", appNumber);
            paramMap.put("appId", appId);
            paramMap.put("depEmpId", depEmpId);
            paramMap.put("depEmpBoId", depEmpBoId);
            paramMap.put("flowType", flowType);
            paramMap.put("changeTime", SWCDateTimeUtils.format((Date)changeTime, (String)"yyyy-MM-dd HH:mm:ss"));
            formShowParameter.setCustomParams(paramMap);
            this.getView().showForm(formShowParameter);
            HashMap<String, String> cacheMap = new HashMap<String, String>(16);
            cacheMap.put("bizObjectId", bizObjectId);
            cacheMap.put("pageId", formShowParameter.getPageId());
            cacheMap.put("appNumber", appNumber);
            cacheMap.put("cardType", dynamicObject.getString("cardtype"));
            cacheMap.put("triggerCollaId", dynamicObject.getString("triggercolla.id"));
            List cacheMapList = pageIdCache.computeIfAbsent(appNumber, val -> new ArrayList(10));
            cacheMapList.add(cacheMap);
        }
        new SWCPageCache(this.getView()).put(CACHE_SUB_CARD_PAGE_ID, pageIdCache);
    }

    private Map<String, Object> getEntryData(DynamicObject data, DynamicObject trigger) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("triggerColla", data.getDynamicObject("triggercolla"));
        result.put("bizApp", data.getDynamicObject("bizapp"));
        result.put("cardType", data.getString("cardtype"));
        result.put("bizObjectId", data.getString("bizobject.id"));
        result.put("summaryVerifyBill", this.getModel().getDataEntity());
        ArrayList fields = new ArrayList(10);
        result.put("fields", fields);
        DynamicObjectCollection entryEntity = data.getDynamicObjectCollection("subentryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return result;
        }
        String entityObject = trigger.getString("entityobject.number");
        String bizObjectId = data.getString("bizobject.id");
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)bizObjectId);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        HashMap temp = new HashMap(16);
        for (DynamicObject object : entryEntity) {
            String fieldValue;
            Integer groupIndex;
            Map fieldData;
            String fieldNumber = object.getString("fieldnumber");
            IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)fieldNumber);
            if (property == null && (property = this.generateProp(fieldNumber = VerifyBillDataService.getInstance().formatFieldNumber(fieldNumber, entityObject), trigger)) == null) {
                LOGGER.info("[colla] init page [{}], ext property [{}] is null ", (Object)bizObjectId, (Object)fieldNumber);
            }
            if ((fieldData = (Map)temp.get(fieldNumber)) != null) {
                List values = (List)temp.get("fieldValues");
                groupIndex = Integer.valueOf(object.getString("groupindex"));
                fieldValue = object.getString("fieldvalue");
                values.add(groupIndex, fieldValue);
                continue;
            }
            HashMap<String, Object> tmp = new HashMap<String, Object>(16);
            tmp.put("fieldNumber", fieldNumber);
            groupIndex = Integer.valueOf(object.getString("groupindex"));
            fieldValue = object.getString("fieldvalue");
            tmp.put("groupIndex", groupIndex);
            tmp.put("fieldValues", Lists.newArrayList((Object[])new String[]{fieldValue}));
            if (property != null) {
                tmp.put("fieldType", property.getPropertyType().getTypeName());
            }
            tmp.put("prop", property);
            fields.add(tmp);
            temp.put(fieldNumber, tmp);
        }
        return result;
    }

    private IDataEntityProperty generateProp(String fieldNumber, DynamicObject trigger) {
        DynamicObjectCollection exeParamEntryEntity = trigger.getDynamicObjectCollection("exeparamentryentity");
        if (CollectionUtils.isEmpty((Collection)exeParamEntryEntity)) {
            return null;
        }
        for (DynamicObject object : exeParamEntryEntity) {
            String pfieldkey = object.getString("pfieldkey");
            if (!fieldNumber.equalsIgnoreCase(pfieldkey)) continue;
            ILocaleString pfieldname = object.getLocaleString("pfieldname");
            String pfieldtype = object.getString("pfieldtype");
            IDynamicPropHandler handler = DynamicPropCreatorFactory.create((String)pfieldtype);
            return handler.createDynamicProp(fieldNumber, new LocaleString(pfieldname.getLocaleValue()), null, null);
        }
        return null;
    }

    private void createBizAppFlex(Map<String, Map<String, Object>> pageFlexDataMap) {
        Container rootContainer = (Container)this.getView().getControl(FLEX_ROOT_CONTAINER);
        FlexPanelAp rootAp = new SWCFlexPanelAp.Builder(FLEX_ROOT_CONTAINER).setId(FLEX_ROOT_CONTAINER).setAlignContent("flex-start").setAlignItems("stretch").setDirection("column").setGrow(0).setShrink(0).build();
        pageFlexDataMap.forEach((appNumber, appData) -> {
            String key = "container-" + appNumber;
            String flexName = ResManager.loadKDString((String)"{0}\u53d8\u52a8\u6838\u5b9a", (String)"AbstractVerifyBillLoadSubCardEdit_3", (String)"swc-hsbp-formplugin", (Object[])new Object[]{appData.get("appName")});
            FlexPanelAp tempAp = ((SWCFlexPanelAp.Builder)new SWCFlexPanelAp.Builder(key).setAlignContent("flex-start").setAlignItems("stretch").setDirection("column").setCollapsible(true).setGrow(0).setShrink(0).setMarginTop("10px")).setWidth("100%").setName(flexName).setBackColor("#fff").build();
            List objectList = (List)appData.get(OBJECT_LIST);
            if (CollectionUtils.isEmpty((Collection)objectList)) {
                return;
            }
            for (Map paraMap : objectList) {
                String objectName = (String)paraMap.get(OBJECT_NAME);
                String objectNumber = (String)paraMap.get(OBJECT_NUMBER);
                String objectKey = "container-" + objectNumber;
                String labelKey = "label_" + objectNumber;
                LabelAp labelAp = ((SWCLabelAp.Builder)((SWCLabelAp.Builder)new SWCLabelAp.Builder(labelKey).setId(labelKey).setFontSize(14).setName(objectName).setBackColor("#F2F2F2").setGrow(0).setShrink(0).setPaddingBottom("3.5px")).setPaddingTop("3.5px")).setFontWeight("400").build();
                FlexPanelAp tempLabelPanelAp = new SWCFlexPanelAp.Builder("flex_" + labelKey).setGrow(0).setShrink(0).setWidth("100%").setCollapsible(false).build();
                tempLabelPanelAp.getItems().add(labelAp);
                tempAp.getItems().add(tempLabelPanelAp);
                FlexPanelAp tempFlexPanelAp = new SWCFlexPanelAp.Builder(objectKey).setGrow(0).setShrink(0).setWidth("100%").setCollapsible(false).build();
                tempAp.getItems().add(tempFlexPanelAp);
            }
            rootAp.getItems().add(tempAp);
        });
        rootContainer.getItems().addAll(((Container)rootAp.buildRuntimeControl()).getItems());
        this.getView().createControlIndex(rootContainer.getItems());
        this.getView().updateControlMetadata(FLEX_ROOT_CONTAINER, rootAp.createControl());
    }

    private Map<String, Map<String, Object>> getPageFlexDataInfoMap(List<DynamicObject> verifyDataList, List<DynamicObject> objectFiledEntry) {
        LinkedHashMap<String, Map<String, Object>> pageFlexDataMap = new LinkedHashMap<String, Map<String, Object>>();
        if (CollectionUtils.isEmpty(verifyDataList)) {
            return pageFlexDataMap;
        }
        for (DynamicObject object : verifyDataList) {
            String bizAppId = object.getString("bizapp.number");
            String bizName = object.getString("bizapp.name");
            String bizObjectId = object.getString("bizobject.id");
            Map bizAppDataMap = pageFlexDataMap.getOrDefault(bizAppId, new HashMap(2));
            if (CollectionUtils.isEmpty((Map)bizAppDataMap)) {
                pageFlexDataMap.put(bizAppId, bizAppDataMap);
            }
            bizAppDataMap.put("appName", bizName);
            List objectList = bizAppDataMap.getOrDefault(OBJECT_LIST, new ArrayList(10));
            if (CollectionUtils.isEmpty((Collection)objectList)) {
                bizAppDataMap.put(OBJECT_LIST, objectList);
            }
            HashMap<String, String> objectDataMap = new HashMap<String, String>(16);
            objectDataMap.put(OBJECT_NUMBER, bizObjectId);
            objectDataMap.put(OBJECT_NAME, object.getString("bizobject.name"));
            objectList.add(objectDataMap);
            objectFiledEntry.add(object);
        }
        return pageFlexDataMap;
    }

    private Map<Long, DynamicObject> getAllTriggerColla(List<Long> triggerIds) {
        String entityName = "hsbs_triggercolla";
        SWCDataServiceHelper triggerOrm = new SWCDataServiceHelper(entityName);
        DynamicObject[] data = triggerOrm.query(SWCHisBaseDataHelper.getSelectProperties((String)entityName), new QFilter[]{new QFilter("id", "in", triggerIds)});
        if (data == null || data.length == 0) {
            return Collections.emptyMap();
        }
        return Arrays.stream(data).collect(Collectors.toMap(item -> item.getLong("id"), Function.identity(), (key, val) -> val));
    }

    protected abstract List<DynamicObject> getSubCardData();

    public boolean existConfirm() {
        Map pageIdMap;
        ArrayList<String> changDescList = new ArrayList<String>(10);
        this.getModel().getDataChanged();
        String mainDesc = this.getModel().getChangeDesc();
        if (SWCStringUtils.isNotEmpty((String)mainDesc)) {
            changDescList.add(mainDesc);
        }
        if (!CollectionUtils.isEmpty((Map)(pageIdMap = (Map)new SWCPageCache(this.getView()).get(CACHE_SUB_CARD_PAGE_ID, Map.class)))) {
            pageIdMap.forEach((appNumber, data) -> {
                for (Map pageIds : (List)data) {
                    IDataModel model;
                    IFormView view;
                    String pageId;
                    if (CollectionUtils.isEmpty((Map)pageIds) || SWCStringUtils.isEmpty((String)(pageId = (String)pageIds.get("pageId"))) || (view = this.getView().getView(pageId)) == null || !(model = view.getModel()).isDataLoaded() || !view.getModel().getDataChanged()) continue;
                    String bizObjectName = EntityMetadataCache.getDataEntityType((String)((String)pageIds.get("bizObjectId"))).getDisplayName().getLocaleValue();
                    String changeDesc = view.getModel().getChangeDesc();
                    if (SWCStringUtils.isEmpty((String)changeDesc)) continue;
                    changDescList.add("[" + bizObjectName + "] " + changeDesc);
                }
            });
        }
        if (CollectionUtils.isEmpty(changDescList)) {
            return false;
        }
        HashMap<Integer, String> objectObjectHashMap = new HashMap<Integer, String>();
        objectObjectHashMap.put(6, ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"AbstractVerifyBillLoadSubCardEdit_0", (String)"swc-hsbp-formplugin", (Object[])new Object[0]));
        objectObjectHashMap.put(7, ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"AbstractVerifyBillLoadSubCardEdit_1", (String)"swc-hsbp-formplugin", (Object[])new Object[0]));
        this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u5185\u5bb9\u3002", (String)"AbstractVerifyBillLoadSubCardEdit_2", (String)"swc-hsbp-formplugin", (Object[])new Object[0]), changDescList.stream().collect(Collectors.joining(System.lineSeparator())), MessageBoxOptions.YesNo, ConfirmTypes.Save, new ConfirmCallBackListener("CALLBACK_EXIT_CONFIRM"), objectObjectHashMap);
        return true;
    }

    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
        event.setCheckDataChange(false);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String billStatus = dataEntity.getString("billstatus");
        if (!"A".equalsIgnoreCase(billStatus) && !"G".equalsIgnoreCase(billStatus)) {
            return;
        }
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        Boolean cacheCloseConfirmFlag = (Boolean)swcPageCache.get(CACHE_CLOSE_CONFIRM_FLAG, Boolean.class);
        if (cacheCloseConfirmFlag != null) {
            swcPageCache.remove(CACHE_CLOSE_CONFIRM_FLAG);
            return;
        }
        DataEntityState dataEntityState = dataEntity.getDataEntityState();
        List<String> unChangedField = this.getIgnoreCheckFiled();
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        for (String field : unChangedField) {
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get((Object)field);
            if (iDataEntityProperty == null) continue;
            dataEntityState.setBizChanged(iDataEntityProperty.getOrdinal(), false);
            if (!(iDataEntityProperty instanceof MulBasedataProp)) continue;
            DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection(iDataEntityProperty);
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                DataEntityState subState = dynamicObject.getDataEntityState();
                subState.setBizChanged(false);
            }
        }
        event.setCancel(this.existConfirm());
    }

    protected List<String> getIgnoreCheckFiled() {
        return Collections.emptyList();
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId;
        super.confirmCallBack(event);
        switch (callBackId = event.getCallBackId()) {
            case "CALLBACK_EXIT_CONFIRM": {
                this.closeConfirmCallBack(event);
                break;
            }
        }
    }

    private void closeConfirmCallBack(MessageBoxClosedEvent event) {
        MessageBoxResult result = event.getResult();
        if (MessageBoxResult.Yes.equals((Object)result)) {
            SWCPageCache swcPageCache = new SWCPageCache(this.getView());
            swcPageCache.put(CACHE_CLOSE_CONFIRM_FLAG, (Object)Boolean.TRUE);
            this.getView().close();
        }
    }

    public void onGetControl(OnGetControlArgs event) {
        super.onGetControl(event);
        String key = event.getKey();
        if (key.startsWith("container-") && this.isAppOrObjectFlex(key)) {
            event.setControl((Control)this.bindAppOrObjectFlex(key));
        }
    }

    private Set<String> parseSubPageContainer() {
        Map pageIdMap = (Map)new SWCPageCache(this.getView()).get(CACHE_SUB_CARD_PAGE_ID, Map.class);
        if (CollectionUtils.isEmpty((Map)pageIdMap)) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>(16);
        pageIdMap.forEach((appNumber, objectList) -> {
            result.add((String)appNumber);
            if (CollectionUtils.isEmpty((Collection)objectList)) {
                for (Map objectMap : objectList) {
                    String bizObjectId = (String)objectMap.get("bizObjectId");
                    if (!SWCStringUtils.isNotEmpty((String)bizObjectId)) continue;
                    result.add(bizObjectId);
                }
            }
        });
        return result;
    }

    private boolean isAppOrObjectFlex(String key) {
        Set<String> keySet = this.parseSubPageContainer();
        if (CollectionUtils.isEmpty(keySet)) {
            return false;
        }
        return keySet.contains(key);
    }

    private Container bindAppOrObjectFlex(String key) {
        Container container = new Container();
        container.setKey(key);
        container.setView(this.getView());
        return container;
    }
}

