/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.addperson.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.proration.HandleProrationHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.history.model.SWCHisBaseConstants;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.vo.CalPayRollTaskVO;
import kd.swc.hsbp.common.vo.MatchedSalaryFileVO;

public class FilterSalaryFileService {
    private static final Log logger = LogFactory.getLog(FilterSalaryFileService.class);
    private List<Long> salaryFileIdList;
    private CalPayRollTaskVO calPayRollTaskVO;
    private Map<Long, List<Long>> salaryStyleWithBizItemMap;
    private Set<Long> salaryStyleWithoutBizItemSet;
    private List<QFilter> authorizedFilterList;
    private RequestContext requestContext;

    public FilterSalaryFileService(CalPayRollTaskVO calPayRollTaskVO, List<Long> salaryFileIdList, Map<Long, List<Long>> salaryStyleMap, Set<Long> salaryStyleWithoutBizItemList, List<QFilter> authorizedFilterList, RequestContext requestContext) {
        this.calPayRollTaskVO = calPayRollTaskVO;
        this.salaryFileIdList = salaryFileIdList;
        this.salaryStyleWithBizItemMap = salaryStyleMap;
        this.salaryStyleWithoutBizItemSet = salaryStyleWithoutBizItemList;
        this.authorizedFilterList = authorizedFilterList;
        this.requestContext = requestContext;
    }

    public List<Long> filterSalaryFileVIdList() {
        return this.filterSalaryFileVoList().stream().map(MatchedSalaryFileVO::getFileVId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    public List<MatchedSalaryFileVO> filterSalaryFileVoList() {
        long startTime = System.currentTimeMillis();
        String threadName = Thread.currentThread().getName();
        logger.info("FilterSalaryFileService.filterSalaryFileVoList begin: taskId = {}, thread name = {}", (Object)this.calPayRollTaskVO.getId(), (Object)threadName);
        RequestContext.copyAndSet((RequestContext)this.requestContext);
        ArrayList<Long> sumSalaryStyleIdList = new ArrayList<Long>(this.salaryStyleWithBizItemMap.keySet());
        sumSalaryStyleIdList.addAll(this.salaryStyleWithoutBizItemSet);
        List<DynamicObject> salaryFileHisDyList = this.querySalaryFileHis(this.calPayRollTaskVO, this.salaryFileIdList, sumSalaryStyleIdList);
        HashMap<Long, Date> salaryHisFileBsedMap = new HashMap<Long, Date>(10000);
        HashMap<Long, MatchedSalaryFileVO> lastSalaryFileMap = new HashMap<Long, MatchedSalaryFileVO>(10000);
        HashMap<Long, Map<Long, Long>> salaryFileHisInfoGroupByStyleMap = new HashMap<Long, Map<Long, Long>>(this.salaryStyleWithBizItemMap.size());
        this.separateSalaryFileHisWithBizData(salaryFileHisDyList, salaryHisFileBsedMap, lastSalaryFileMap, salaryFileHisInfoGroupByStyleMap);
        this.filterLastSalaryFileMap(salaryHisFileBsedMap, lastSalaryFileMap, salaryFileHisInfoGroupByStyleMap);
        long costTime = System.currentTimeMillis() - startTime;
        logger.info("FilterSalaryFileService.filterSalaryFileVoList end: taskId = {}, thread name = {}, cost time = {}, sub size is {}", new Object[]{this.calPayRollTaskVO.getId(), threadName, costTime, lastSalaryFileMap.size()});
        return new ArrayList<MatchedSalaryFileVO>(lastSalaryFileMap.values());
    }

    private void filterLastSalaryFileMap(Map<Long, Date> salaryHisFileBsedMap, Map<Long, MatchedSalaryFileVO> lastSalaryFileMap, Map<Long, Map<Long, Long>> salaryFileHisInfoGroupByStyleMap) {
        String threadName = Thread.currentThread().getName();
        logger.info("FilterSalaryFileService.filterLastSalaryFileMap begin: taskId = {}, thread name = {}", (Object)this.calPayRollTaskVO.getId(), (Object)threadName);
        long startTime = System.currentTimeMillis();
        for (Map.Entry<Long, Map<Long, Long>> salaryFileHisInfo : salaryFileHisInfoGroupByStyleMap.entrySet()) {
            Long calStyleId = salaryFileHisInfo.getKey();
            List<Long> bizDataItemList = this.salaryStyleWithBizItemMap.get(calStyleId);
            if (bizDataItemList == null || bizDataItemList.isEmpty()) continue;
            Map<Long, Long> salaryFileHisMap = salaryFileHisInfo.getValue();
            Set<Long> enableSalaryFileIdSet = this.filterSalaryFileSeparateByStyleIdSet(this.calPayRollTaskVO, bizDataItemList, salaryFileHisMap.keySet());
            for (Long enableSalaryFileId : enableSalaryFileIdSet) {
                Date oldDate;
                Long currSalaryFileVid = salaryFileHisMap.get(enableSalaryFileId);
                Date currDate = salaryHisFileBsedMap.get(currSalaryFileVid);
                if (currDate == null) continue;
                MatchedSalaryFileVO matchedSalaryFileVO = lastSalaryFileMap.get(enableSalaryFileId);
                if (matchedSalaryFileVO != null && matchedSalaryFileVO.getDataSrcEnum() == MatchedSalaryFileVO.DataSrcEnum.ONLY_FROM_SALARY_TYPE) {
                    matchedSalaryFileVO.setDataSrcEnum(MatchedSalaryFileVO.DataSrcEnum.MATCH_BOTH);
                }
                if (matchedSalaryFileVO != null && (oldDate = salaryHisFileBsedMap.get(matchedSalaryFileVO.getFileVId())) != null && !currDate.after(oldDate)) continue;
                if (matchedSalaryFileVO == null) {
                    matchedSalaryFileVO = new MatchedSalaryFileVO(enableSalaryFileId, currSalaryFileVid, MatchedSalaryFileVO.DataSrcEnum.FROM_BIZ_DATA);
                    lastSalaryFileMap.put(enableSalaryFileId, matchedSalaryFileVO);
                    continue;
                }
                if (matchedSalaryFileVO.getDataSrcEnum() != MatchedSalaryFileVO.DataSrcEnum.FROM_BIZ_DATA) {
                    matchedSalaryFileVO.setDataSrcEnum(MatchedSalaryFileVO.DataSrcEnum.MATCH_BOTH);
                } else {
                    matchedSalaryFileVO.setDataSrcEnum(MatchedSalaryFileVO.DataSrcEnum.FROM_BIZ_DATA);
                }
                matchedSalaryFileVO.setFileVId(currSalaryFileVid);
            }
        }
        long costTime = System.currentTimeMillis() - startTime;
        logger.info("FilterSalaryFileService.filterLastSalaryFileMap end: taskId = {}, thread name = {}, cost time = {}", new Object[]{this.calPayRollTaskVO.getId(), threadName, costTime});
    }

    private void separateSalaryFileHisWithBizData(List<DynamicObject> salaryFileHisDyList, Map<Long, Date> salaryHisFileBsedMap, Map<Long, MatchedSalaryFileVO> salaryFileWithoutBizItemMap, Map<Long, Map<Long, Long>> salaryFileHisInfoGroupByStyleMap) {
        long startTime = System.currentTimeMillis();
        String threadName = Thread.currentThread().getName();
        logger.info("FilterSalaryFileService.separateSalaryFileHisWithBizData begin: taskId = {}, thread name = {}", (Object)this.calPayRollTaskVO.getId(), (Object)threadName);
        for (DynamicObject salaryFileHisDyObj : salaryFileHisDyList) {
            Long salaryFileVId = salaryFileHisDyObj.getLong("id");
            Long salaryFileId = salaryFileHisDyObj.getLong("boid");
            salaryHisFileBsedMap.put(salaryFileVId, salaryFileHisDyObj.getDate("bsed"));
            Long salaryStyleId = salaryFileHisDyObj.getLong("salarycalcstyle.id");
            if (this.salaryStyleWithoutBizItemSet.contains(salaryStyleId)) {
                Date oldVidBsed;
                MatchedSalaryFileVO matchedSalaryFileVO;
                boolean isValid;
                Date newVidBsed = salaryHisFileBsedMap.get(salaryFileVId);
                if (newVidBsed == null || !(isValid = (matchedSalaryFileVO = salaryFileWithoutBizItemMap.get(salaryFileId)) == null || (oldVidBsed = salaryHisFileBsedMap.get(matchedSalaryFileVO.getFileVId())) == null || oldVidBsed.before(newVidBsed))) continue;
                if (matchedSalaryFileVO != null) {
                    matchedSalaryFileVO.setFileVId(salaryFileVId);
                    continue;
                }
                matchedSalaryFileVO = new MatchedSalaryFileVO(salaryFileId, salaryFileVId, MatchedSalaryFileVO.DataSrcEnum.ONLY_FROM_SALARY_TYPE);
                salaryFileWithoutBizItemMap.put(salaryFileId, matchedSalaryFileVO);
                continue;
            }
            Map salaryFileInfoMap = salaryFileHisInfoGroupByStyleMap.computeIfAbsent(salaryStyleId, key -> new HashMap(16));
            salaryFileInfoMap.put(salaryFileId, salaryFileVId);
        }
        long costTime = System.currentTimeMillis() - startTime;
        logger.info("FilterSalaryFileService.separateSalaryFileHisWithBizData end: taskId = {}, thread name = {}, cost time = {}", new Object[]{this.calPayRollTaskVO.getId(), threadName, costTime});
    }

    public List<DynamicObject> querySalaryFileHis(CalPayRollTaskVO calPayRollTask, List<Long> salaryFileBoIdList, List<Long> sumSalaryStyleIdList) {
        SWCDataServiceHelper salaryFileHisHelper;
        Object[] salaryFileHisDyArr;
        String threadName = Thread.currentThread().getName();
        logger.info("FilterSalaryFileService.querySalaryFileHis begin: taskId = {}, thread name = {}", (Object)this.calPayRollTaskVO.getId(), (Object)threadName);
        long startTime = System.currentTimeMillis();
        Date calPeriodEndTime = calPayRollTask.getEnddate();
        Date calPeriodStartTime = calPayRollTask.getStartdate();
        QFilter qFilter = new QFilter("boid", "in", salaryFileBoIdList);
        BaseDataHisHelper.addHisVerFilter(qFilter);
        QFilter payStatusFilter = new QFilter("paystatus", "=", (Object)"1");
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus());
        QFilter bsedFilter = new QFilter("bsed", "<=", (Object)calPeriodEndTime);
        QFilter bsledFilter = new QFilter("bsled", ">=", (Object)calPeriodStartTime);
        QFilter salaryCalStyleFilter = new QFilter("salarycalcstyle.id", "in", sumSalaryStyleIdList);
        qFilter.and(payStatusFilter);
        qFilter.and(dataStatusFilter);
        qFilter.and(bsedFilter);
        qFilter.and(bsledFilter);
        qFilter.and(salaryCalStyleFilter);
        if (!this.authorizedFilterList.isEmpty()) {
            qFilter.and(this.authorizedFilterList.get(0));
        }
        if (SWCArrayUtils.isEmpty((Object[])(salaryFileHisDyArr = (salaryFileHisHelper = new SWCDataServiceHelper("hsas_salaryfile")).queryOriginalArray("id,boid,salarycalcstyle.id,bsed", qFilter.toArray())))) {
            return new ArrayList<DynamicObject>(0);
        }
        long costTime = System.currentTimeMillis() - startTime;
        logger.info("FilterSalaryFileService.querySalaryFileHis end: taskId = {}, thread name = {}, cost time = {}", new Object[]{this.calPayRollTaskVO.getId(), threadName, costTime});
        return Arrays.asList(salaryFileHisDyArr);
    }

    private Set<Long> filterSalaryFileSeparateByStyleIdSet(CalPayRollTaskVO calPayRollTaskVO, List<Long> bizDataItemList, Set<Long> salaryFileIdSet) {
        long startTime = System.currentTimeMillis();
        String threadName = Thread.currentThread().getName();
        logger.info("FilterSalaryFileService.filterSalaryFileForDetailStyle begin: taskId = {}, thread name = {}", (Object)calPayRollTaskVO.getId(), (Object)threadName);
        if (salaryFileIdSet.isEmpty() || bizDataItemList.isEmpty()) {
            return new HashSet<Long>(0);
        }
        Date taskStartDate = HandleProrationHelper.replaceDateTime(calPayRollTaskVO.getStartdate(), "00:00:00");
        Date taskEndDate = HandleProrationHelper.replaceDateTime(calPayRollTaskVO.getEnddate(), "23:59:59");
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_nonrecurbizdata");
        QFilter filter = new QFilter("salaryfile.id", "in", salaryFileIdSet);
        filter.and("bizitem.id", "in", bizDataItemList);
        filter.and("usagecount", "=", (Object)0);
        filter.and("bsed", ">=", (Object)taskStartDate);
        filter.and("bsed", "<=", (Object)taskEndDate);
        filter.and("auditstatus", "=", (Object)"C");
        DynamicObjectCollection nonRecurBizDataColl = helper.queryOriginalCollection("salaryfile.id", filter.toArray());
        Set<Object> enableSalaryFileIdSet = !CollectionUtils.isEmpty((Collection)nonRecurBizDataColl) ? nonRecurBizDataColl.stream().map(nonRecurBizDataDy -> nonRecurBizDataDy.getLong("salaryfile.id")).collect(Collectors.toSet()) : new HashSet(0);
        long costTime = System.currentTimeMillis() - startTime;
        logger.info("FilterSalaryFileService.filterSalaryFileSeparateByStyleIdSet end: taskId = {}, thread name = {}, cost time = {}", new Object[]{calPayRollTaskVO.getId(), threadName, costTime});
        return enableSalaryFileIdSet;
    }
}

