/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.cal.calitemtree;

import com.google.common.collect.HashBasedTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbp.business.cal.calitemtree.BaseItemTreeService;
import kd.swc.hsbp.business.cal.helper.CalItemHelper;
import kd.swc.hsbp.business.servicehelper.SWCSalaryParameterServiceHelper;
import kd.swc.hsbp.common.constants.WtcInteCfgConstants;
import kd.swc.hsbp.common.enums.AttBizItemtypeEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.MapUtils;

public class BizItemTreeServiceImpl
extends BaseItemTreeService {
    @Override
    public List<Map<String, Object>> getItemDataList(String entityName, String selectFields, QFilter filter, String orderBys) {
        List<Map<String, Object>> itemMapList = CalItemHelper.getItemMapList(entityName, selectFields, filter, orderBys);
        itemMapList.forEach(data -> data.put("itemcategory", "BS"));
        return itemMapList;
    }

    @Override
    public List<TreeNode> getTreeNodeList(boolean isExpend, String searchText, List<Map<String, Object>> dataList) {
        List<Map<String, Object>> dataBySearch = this.findDataBySearch(searchText, dataList);
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(10);
        if (CollectionUtils.isEmpty(dataBySearch)) {
            return nodeList;
        }
        TreeNode node = new TreeNode("", "ALL_@_BS", ResManager.loadKDString((String)"\u4e1a\u52a1\u9879\u76ee-BS", (String)"BizItemTreeServiceImpl_0", (String)"swc-hsbp-business", (Object[])new Object[0]));
        node.setExpend(isExpend);
        node.setIsOpened(isExpend);
        HashBasedTable bsNodeTable = HashBasedTable.create();
        LinkedHashMap<String, Map> bsClassNodeMap = new LinkedHashMap<String, Map>(16);
        for (Map<String, Object> bsItem : dataBySearch) {
            String bizTypNumber2 = MapUtils.getString(bsItem, (Object)"bizitemcategory.number");
            String bizTypName = MapUtils.getString(bsItem, (Object)"bizitemcategory.name");
            String classification = MapUtils.getString(bsItem, (Object)"classification");
            if ("1".equals(classification)) {
                bizTypNumber2 = MapUtils.getString(bsItem, (Object)"attitemtype");
                bizTypName = AttBizItemtypeEnum.getDesc((String)bizTypNumber2);
            }
            if (SWCStringUtils.isEmpty((String)bizTypNumber2) || SWCStringUtils.isEmpty((String)classification)) continue;
            TreeNode bsNode = new TreeNode(classification + "_@_" + bizTypNumber2 + "_@_" + "BS", String.valueOf(bsItem.get("uniquecode")), MapUtils.getString(bsItem, (Object)"name"), bsItem);
            bsNode.setLeaf(true);
            ArrayList<TreeNode> treeNodes = (ArrayList<TreeNode>)bsNodeTable.get((Object)classification, (Object)bizTypNumber2);
            if (treeNodes == null) {
                treeNodes = new ArrayList<TreeNode>(10);
                bsNodeTable.put((Object)classification, (Object)bizTypNumber2, treeNodes);
            }
            treeNodes.add(bsNode);
            Map bsTypeNodeMap = bsClassNodeMap.computeIfAbsent(classification, key -> new LinkedHashMap(16));
            if (bsTypeNodeMap.containsKey(bizTypNumber2)) continue;
            bsTypeNodeMap.put(bizTypNumber2, new TreeNode("ALL_@_BS", classification + "_@_" + bizTypNumber2 + "_@_" + "BS", bizTypName, bsItem));
        }
        if (this.isEnableWtcInte()) {
            Map attBsTypeNodeMap;
            ArrayList<TreeNode> childrenList = new ArrayList<TreeNode>(10);
            Map bizBsTypeNodeMap = (Map)bsClassNodeMap.get("0");
            if (bizBsTypeNodeMap != null) {
                TreeNode bizItemNode = new TreeNode("ALL_@_BS", "_@_BS", ResManager.loadKDString((String)"\u4e1a\u52a1\u9879\u76ee", (String)"BizItemTreeServiceImpl_1", (String)"swc-hsbp-business", (Object[])new Object[0]));
                bizItemNode.setExpend(isExpend);
                bizItemNode.setIsOpened(isExpend);
                childrenList.add(bizItemNode);
                bizBsTypeNodeMap.forEach((bizTypNumber, treeNode) -> {
                    List treeNodeList = (List)bsNodeTable.get((Object)"0", bizTypNumber);
                    treeNode.setParentid("_@_BS");
                    treeNode.setExpend(isExpend);
                    treeNode.setIsOpened(isExpend);
                    treeNode.setChildren(treeNodeList);
                });
                bizItemNode.setChildren(new ArrayList(bizBsTypeNodeMap.values()));
            }
            if ((attBsTypeNodeMap = (Map)bsClassNodeMap.get("1")) != null) {
                TreeNode attItemNode = new TreeNode("ALL_@_BS", "ATT_@_BS", ResManager.loadKDString((String)"\u8003\u52e4\u4e1a\u52a1\u9879\u76ee", (String)"BizItemTreeServiceImpl_2", (String)"swc-hsbp-business", (Object[])new Object[0]));
                attItemNode.setExpend(isExpend);
                attItemNode.setIsOpened(isExpend);
                childrenList.add(attItemNode);
                attBsTypeNodeMap.forEach((bizTypNumber, treeNode) -> {
                    List treeNodeList = (List)bsNodeTable.get((Object)"1", bizTypNumber);
                    treeNode.setParentid("ATT_@_BS");
                    treeNode.setExpend(isExpend);
                    treeNode.setIsOpened(isExpend);
                    treeNode.setChildren(treeNodeList);
                });
                attItemNode.setChildren(new ArrayList(attBsTypeNodeMap.values()));
            }
            node.setChildren(childrenList);
        } else {
            Map bizBsTypeNodeMap = (Map)bsClassNodeMap.get("0");
            bizBsTypeNodeMap.forEach((bizTypNumber, treeNode) -> {
                List treeNodeList = (List)bsNodeTable.get((Object)"0", bizTypNumber);
                treeNode.setExpend(isExpend);
                treeNode.setIsOpened(isExpend);
                treeNode.setChildren(treeNodeList);
            });
            node.setChildren(new ArrayList(bizBsTypeNodeMap.values()));
        }
        if (!CollectionUtils.isEmpty((Collection)node.getChildren())) {
            nodeList.add(node);
        }
        return nodeList;
    }

    private boolean isEnableWtcInte() {
        Map<String, Object> paramMap = SWCSalaryParameterServiceHelper.getSalaryParam("wtcinte");
        boolean enableWtcInte = Boolean.FALSE;
        if (paramMap != null) {
            Boolean wtcinte = MapUtils.getBoolean(paramMap, (Object)"enableWtcInte");
            Integer scheme = (Integer)paramMap.getOrDefault("scheme", WtcInteCfgConstants.FIELD_SCHEME_THREE);
            if (wtcinte.booleanValue() && (WtcInteCfgConstants.FIELD_SCHEME_ONE.equals(scheme) || WtcInteCfgConstants.FIELD_SCHEME_TWO.equals(scheme))) {
                enableWtcInte = Boolean.TRUE;
            }
        }
        return enableWtcInte;
    }
}

