/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.cal.calitemtree.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.swc.hsbp.business.cal.calitemtree.service.CalItemTreeService;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;

public class CalItemTreeAndEntryService
extends CalItemTreeService {
    private String entryEntityName;

    public CalItemTreeAndEntryService(TreeView treeView, IFormView view, List<String> itemKeyList, String entryEntityName) {
        super(treeView, view, itemKeyList);
        this.entryEntityName = entryEntityName;
    }

    public void batchCreateNewEntryRow(List<Map<String, Object>> fieldMapList) {
        if (CollectionUtils.isEmpty(fieldMapList)) {
            return;
        }
        ArrayList<String> fieldKeyList = new ArrayList<String>(fieldMapList.get(0).keySet());
        TableValueSetter tableSetter = new TableValueSetter(new String[0]);
        fieldKeyList.forEach(fieldKey -> tableSetter.addField(fieldKey, new Object[0]));
        AbstractFormDataModel model = (AbstractFormDataModel)this.view.getModel();
        model.beginInit();
        fieldMapList.forEach(data -> {
            Object[] rowData = new Object[fieldKeyList.size()];
            for (int index = 0; index < fieldKeyList.size(); ++index) {
                rowData[index] = data.get(fieldKeyList.get(index));
            }
            tableSetter.addRow(rowData);
        });
        model.batchCreateNewEntryRow(this.entryEntityName, tableSetter);
        model.endInit();
        this.view.updateView(this.entryEntityName);
    }

    public void searchEntry(String searchText, List<String> searchFields) {
        Integer matchLine;
        if (SWCStringUtils.isEmpty((String)searchText) || CollectionUtils.isEmpty(searchFields)) {
            return;
        }
        DynamicObjectCollection entryDatas = this.view.getModel().getEntryEntity(this.entryEntityName);
        if (SWCObjectUtils.isEmpty((Object)entryDatas)) {
            return;
        }
        EntryGrid grid = (EntryGrid)this.view.getControl(this.entryEntityName);
        int[] selectRows = grid.getSelectRows();
        Integer selectRow = null;
        if (selectRows.length == 1) {
            selectRow = selectRows[0];
        }
        if ((matchLine = this.getMatchColumn(selectRow, entryDatas, searchText, searchFields)) == null) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22,\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"CalItemTreeAndEntryService_0", (String)"swc-hsbp-business", (Object[])new Object[0]));
            return;
        }
        grid.selectRows(matchLine.intValue(), true);
    }

    public List<Map<String, Object>> addColumn(String treeNodeKey) {
        List selectedNodes = this.treeView.getTreeState().getSelectedNodes();
        if (CollectionUtils.isEmpty((Collection)selectedNodes)) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u6570\u636e\u3002", (String)"CalItemTreeAndEntryService_2", (String)"swc-hsbp-business", (Object[])new Object[0]));
            return new ArrayList<Map<String, Object>>(10);
        }
        String cacheTreeNodeStr = (String)this.pageCache.get("cacheTree", String.class);
        Map nodeMap = (Map)JSON.parseObject((String)cacheTreeNodeStr, (TypeReference)new TypeReference<Map<String, TreeNode>>(){}, (Feature[])new Feature[0]);
        Set treeNodeIdSet = this.view.getModel().getEntryEntity(this.entryEntityName).stream().map(entry -> entry.getString(treeNodeKey)).collect(Collectors.toSet());
        ArrayList<Map<String, Object>> addItemList = new ArrayList<Map<String, Object>>(10);
        ArrayList<TreeNode> checkNodeList = new ArrayList<TreeNode>(selectedNodes.size());
        for (Map selectNode : selectedNodes) {
            TreeNode treeNode;
            String parentId = MapUtils.getString((Map)selectNode, (Object)"parentid");
            String treeId = MapUtils.getString((Map)selectNode, (Object)"id");
            if (treeNodeIdSet.contains(treeId) || (treeNode = this.getTreeNodeByTreeId(nodeMap, treeId, parentId)) == null || SWCStringUtils.isEmpty((String)treeNode.getId()) || !treeNode.isLeaf()) continue;
            Map dataMap = (Map)treeNode.getData();
            dataMap.put("treenodeid", treeId);
            addItemList.add(dataMap);
            checkNodeList.add(treeNode);
        }
        if (CollectionUtils.isNotEmpty(checkNodeList)) {
            this.treeView.checkNodes(checkNodeList);
        }
        return addItemList;
    }

    public void removeColumn(String treeNodeKey) {
        EntryGrid entryGrid = (EntryGrid)this.view.getControl(this.entryEntityName);
        int[] rows = entryGrid.getSelectRows();
        if (rows == null || rows.length == 0) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"CalItemTreeAndEntryService_1", (String)"swc-hsbp-business", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection selectDatas = this.view.getModel().getEntryEntity(this.entryEntityName);
        ArrayList<String> removeCheckNodeList = new ArrayList<String>(selectDatas.size());
        String cacheTreeNodeStr = (String)this.pageCache.get("cacheTree", String.class);
        Map nodeMap = (Map)JSON.parseObject((String)cacheTreeNodeStr, (TypeReference)new TypeReference<Map<String, TreeNode>>(){}, (Feature[])new Feature[0]);
        for (int index : rows) {
            DynamicObject selectData = (DynamicObject)selectDatas.get(index);
            TreeNode treeNode = this.getTreeNodeByTreeId(nodeMap, selectData.getString(treeNodeKey), null);
            if (treeNode == null) continue;
            removeCheckNodeList.add(treeNode.getId());
        }
        this.treeView.uncheckNodes(removeCheckNodeList);
        this.view.getModel().deleteEntryRows(this.entryEntityName, rows);
    }

    public void returnData() {
        DynamicObjectCollection entryDatas = this.view.getModel().getEntryEntity(this.entryEntityName);
        if (entryDatas == null || entryDatas.size() == 0) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u9879\u76ee\u518d\u786e\u5b9a\u3002", (String)"CalItemTreeAndEntryService_3", (String)"swc-hsbp-business", (Object[])new Object[0]));
            return;
        }
        this.view.returnDataToParent((Object)entryDatas);
        this.view.close();
    }

    private Integer getMatchColumn(Integer selectRow, DynamicObjectCollection entryDataCol, String searchText, List<String> searchFields) {
        boolean isNeed = false;
        Integer isFirstMatch = null;
        for (int index = 0; index < entryDataCol.size(); ++index) {
            DynamicObject dataObj = (DynamicObject)entryDataCol.get(index);
            if (!searchFields.stream().anyMatch(data -> dataObj.getString(data).contains(searchText))) continue;
            if (selectRow == null) {
                return index;
            }
            if (isNeed) {
                return index;
            }
            isNeed = selectRow.equals(index);
            if (isFirstMatch != null) continue;
            isFirstMatch = index;
        }
        return isFirstMatch;
    }

    private TreeNode getTreeNodeByTreeId(Map<String, TreeNode> nodeMap, String treeId, String parentId) {
        for (Map.Entry<String, TreeNode> entry : nodeMap.entrySet()) {
            TreeNode value = entry.getValue();
            TreeNode treeNode = this.getTreeNode(treeId, value, parentId);
            if (treeNode == null) continue;
            return treeNode;
        }
        return null;
    }

    private TreeNode getTreeNode(String treeId, TreeNode treeNode, String parentId) {
        List childTrees;
        if (!(parentId != null && SWCStringUtils.equals((String)parentId, (String)treeNode.getParentid()) || (childTrees = treeNode.getChildren()) == null || childTrees.size() <= 0)) {
            for (TreeNode childTree : childTrees) {
                TreeNode node = this.getTreeNode(treeId, childTree, parentId);
                if (node == null) continue;
                return node;
            }
        }
        if (SWCStringUtils.equals((String)treeId, (String)treeNode.getId())) {
            return treeNode;
        }
        return null;
    }
}

