/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.cal.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.CollectionUtils;

public class FormulaHelper {
    public static final String ITEM_TYPE_SL = "SL";
    public static final String ITEM_TYPE_BS = "BS";
    public static final String ITEM_TYPE_AC = "AC";
    public static final String ITEM_TYPE_SP = "SP";
    public static final String ITEM_TYPE_FT = "FT";
    public static final String ITEM_TYPE_BSP = "BSP";
    public static final String replaceKey = "replace[%d]";
    private static final Log log = LogFactory.getLog(FormulaHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateCalElementName(Map<String, String> changeMap, Map<String, String> uniqueCodeRelMap, String itemType) {
        if (changeMap == null || changeMap.size() == 0) {
            return;
        }
        String lockKey = "_updateFormula";
        DLock lock = DLock.create((String)lockKey);
        try {
            if (lock.tryLock(300000L)) {
                FormulaHelper.doUpdateCalElementName(changeMap, uniqueCodeRelMap, itemType);
            } else {
                log.error("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u8d85\u65f6");
            }
        }
        catch (Exception e) {
            log.error("update formula error", (Throwable)e);
        }
        finally {
            lock.unlock();
            lock.close();
        }
    }

    private static void doUpdateCalElementName(Map<String, String> changeMap, Map<String, String> uniqueCodeRelMap, String itemType) {
        String oldName;
        HashMap<String, String> replaceMap = new HashMap<String, String>(changeMap.size());
        Set<String> oldNameSet = changeMap.keySet();
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_formula");
        ArrayList<DynamicObject> allFormulaList = new ArrayList<DynamicObject>(10);
        Map<String, List<DynamicObject>> formulaListMap = FormulaHelper.searchFormulaByElementName(oldNameSet, allFormulaList, uniqueCodeRelMap, itemType);
        if (CollectionUtils.isEmpty(allFormulaList)) {
            return;
        }
        int index = 1;
        for (Map.Entry<String, String> entry : changeMap.entrySet()) {
            oldName = entry.getKey();
            String tempExp = String.format(Locale.ROOT, replaceKey, index++);
            replaceMap.put(oldName, tempExp);
            List<DynamicObject> formulaList = formulaListMap.get(oldName);
            for (DynamicObject formula : formulaList) {
                String originalExp = formula.getString("originalexp");
                originalExp = originalExp.replace(oldName, tempExp);
                formula.set("originalexp", (Object)originalExp);
            }
        }
        for (Map.Entry<String, String> entry : changeMap.entrySet()) {
            oldName = entry.getKey();
            String newName = entry.getValue();
            String tempExp = (String)replaceMap.get(oldName);
            List<DynamicObject> formulaList = formulaListMap.get(oldName);
            for (DynamicObject formula : formulaList) {
                String originalExp = formula.getString("originalexp");
                originalExp = originalExp.replace(tempExp, newName);
                formula.set("originalexp", (Object)originalExp);
            }
        }
        DynamicObject[] formulas = new DynamicObject[allFormulaList.size()];
        allFormulaList.toArray(formulas);
        helper.update(formulas);
    }

    public static Map<String, String> getChangeMap(Map<Long, String> dataMap, String itemType, Map<String, String> uniqueCodeRelMap) {
        if (dataMap == null || dataMap.isEmpty()) {
            return new HashMap<String, String>(0);
        }
        String itemMeta = null;
        switch (itemType) {
            case "SL": {
                itemMeta = "hsbs_salaryitem";
                break;
            }
            case "BS": {
                itemMeta = "hsbs_bizitem";
                break;
            }
            case "AC": {
                itemMeta = "hsas_accumulator";
                break;
            }
            case "SP": {
                itemMeta = "hsbs_supportitem";
                break;
            }
            case "FT": {
                itemMeta = "hsbs_fetchitem";
                break;
            }
            default: {
                return new HashMap<String, String>(0);
            }
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper(itemMeta);
        DynamicObject[] oldDatas = helper.query("id,name,uniquecode", new QFilter[]{new QFilter("id", "in", dataMap.keySet())});
        if (oldDatas == null || oldDatas.length <= 0) {
            return new HashMap<String, String>(0);
        }
        HashMap<String, String> changeMap = new HashMap<String, String>(16);
        String keyFormat = itemType + "[%s]";
        for (DynamicObject oldData : oldDatas) {
            String newName;
            String oldName = oldData.getString("name");
            if (SWCStringUtils.equals((String)oldName, (String)(newName = dataMap.get(oldData.getLong("id"))))) continue;
            changeMap.put(String.format(Locale.ROOT, keyFormat, oldName), String.format(Locale.ROOT, keyFormat, newName));
            uniqueCodeRelMap.put(String.format(Locale.ROOT, keyFormat, oldName), oldData.getString("uniquecode"));
        }
        return changeMap;
    }

    private static Map<String, List<DynamicObject>> searchFormulaByElementName(Set<String> elementNameSet, List<DynamicObject> allFormulaList, Map<String, String> uniqueCodeRelMap, String itemType) {
        HashMap<Long, DynamicObject> formulaMap = new HashMap<Long, DynamicObject>(16);
        HashMap<String, List<DynamicObject>> formulaListMap = new HashMap<String, List<DynamicObject>>(16);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_formula");
        for (String elementName : elementNameSet) {
            DynamicObject[] formulas;
            ArrayList<Object> formulaList = new ArrayList<Object>(10);
            QFilter filter = FormulaHelper.getQfilter(uniqueCodeRelMap.get(elementName), itemType);
            for (DynamicObject formula : formulas = helper.query("id,originalexp", new QFilter[]{filter})) {
                Long formulaId = formula.getLong("id");
                if (!formulaMap.containsKey(formulaId)) {
                    formulaMap.put(formulaId, formula);
                    formulaList.add(formula);
                    allFormulaList.add(formula);
                    continue;
                }
                formulaList.add(formulaMap.get(formulaId));
            }
            formulaListMap.put(elementName, formulaList);
        }
        return formulaListMap;
    }

    private static QFilter getQfilter(String uniqueCode, String itemType) {
        QFilter filter = null;
        String value = "%" + uniqueCode + "%";
        switch (itemType) {
            case "SL": {
                filter = new QFilter("dependonsitem", "like", (Object)value);
                break;
            }
            case "BS": {
                filter = new QFilter("dependonbsitem", "like", (Object)value);
                break;
            }
            case "AC": {
                filter = new QFilter("dependonacc", "like", (Object)value);
                break;
            }
            case "SP": {
                filter = new QFilter("dependonspitem", "like", (Object)value);
                break;
            }
            case "FT": {
                filter = new QFilter("dependonftitem", "like", (Object)value);
                break;
            }
            case "BSP": {
                filter = new QFilter("bsitemprop", "like", (Object)value);
                break;
            }
            default: {
                filter = new QFilter("1", "!=", (Object)1);
            }
        }
        return filter;
    }
}

