/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.cal.helper;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.operate.MutexHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.CalPayrollTaskStateEnum;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.vo.CalPayRollTaskMutex;

public class PayrollTaskHelper {
    private static final Log logger = LogFactory.getLog(PayrollTaskHelper.class);

    public static void updateCalPayRollTaskStatus(Long calTaskId) {
        if (calTaskId == null || calTaskId == 0L) {
            logger.error("updateCalPayRollTaskStatus error cause taskId is null or zero");
            return;
        }
        PayrollTaskHelper.updateCalPayRollTaskStatus(calTaskId, PayrollTaskHelper.getPayRollTaskState(calTaskId));
    }

    public static void updateCalPayRollTaskStatus(Long calTaskId, String status) {
        if (calTaskId == null || calTaskId == 0L) {
            logger.error("updateCalPayRollTaskStatus error cause taskId is null or zero");
            return;
        }
        SWCDataServiceHelper calTaskHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        QFilter filter = new QFilter("id", "=", (Object)calTaskId);
        DynamicObject obj = calTaskHelper.queryOne("taskstatus,taxitemschemev", new QFilter[]{filter});
        if (obj != null) {
            obj.set("taskstatus", (Object)status);
            if (SWCStringUtils.equals((String)status, (String)CalPayrollTaskStateEnum.UNCAL.getCode())) {
                obj.set("taxitemschemev", (Object)0L);
            }
            calTaskHelper.updateOne(obj);
        }
    }

    public static void delTaskAndAccRef(Long calTaskId) {
        if (calTaskId == null || calTaskId == 0L) {
            logger.error("delTaskAndAccRef error cause taskId is null or zero");
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        QFilter filter = new QFilter("id", "=", (Object)calTaskId);
        DynamicObject calTask = helper.queryOne("taskstatus", new QFilter[]{filter});
        if (!SWCObjectUtils.isEmpty((Object)calTask) && CalPayrollTaskStateEnum.UNCAL.getCode().equals(calTask.getString("taskstatus"))) {
            helper.setEntityName("hsas_caltaskaccrel");
            filter = new QFilter("caltask", "=", (Object)calTaskId);
            helper.deleteByFilter(filter.toArray());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getPayRollTaskState(Long taskId) {
        if (taskId == null || taskId == 0L) {
            logger.error("get payRollTaskStatus error cause taskId is null or zero");
            return "";
        }
        SWCDataServiceHelper calTableHelper = new SWCDataServiceHelper("hsas_calperson");
        try (DataSet dataSet = calTableHelper.queryDataSet("groupByCalTableState", "calstatus", new QFilter[]{new QFilter("caltask.id", "=", (Object)taskId), new QFilter("calmainid", "=", (Object)0L)});
             DataSet queryDataSet = dataSet.groupBy(new String[]{"calstatus"}).count().finish();){
            Object row;
            if (queryDataSet == null) return CalPayrollTaskStateEnum.CREATE.getCode();
            HashMap<String, Integer> groupCalState = new HashMap<String, Integer>(16);
            while (queryDataSet.hasNext()) {
                row = queryDataSet.next();
                groupCalState.put(row.getString("calstatus"), row.getInteger("count"));
            }
            queryDataSet.close();
            if (groupCalState.size() == 0) {
                row = CalPayrollTaskStateEnum.CREATE.getCode();
                return row;
            }
            Integer personCount = 0;
            for (Object value : groupCalState.values()) {
                personCount = personCount + (Integer)value;
            }
            if (personCount.equals(groupCalState.get(CalStateEnum.UNCAL.getCode()))) {
                String string = CalPayrollTaskStateEnum.UNCAL.getCode();
                return string;
            }
            Integer audit = (Integer)groupCalState.get(CalStateEnum.AUDIT.getCode());
            if (audit != null && personCount.equals(groupCalState.get(CalStateEnum.AUDIT.getCode()))) {
                Object value;
                value = CalPayrollTaskStateEnum.AUDIT.getCode();
                return value;
            }
            Integer approvaling = (Integer)groupCalState.get(CalStateEnum.APPROVALING.getCode());
            if (approvaling != null && personCount.equals(approvaling)) {
                String string = CalPayrollTaskStateEnum.APPROVALEDING.getCode();
                return string;
            }
            Integer waitApprovaled = (Integer)groupCalState.get(CalStateEnum.WAIT_APPROVALED.getCode());
            if (waitApprovaled != null && personCount.equals(waitApprovaled)) {
                String string = CalPayrollTaskStateEnum.APPROVALEDING.getCode();
                return string;
            }
            if (waitApprovaled != null && approvaling != null && personCount.equals(waitApprovaled + approvaling)) {
                String string = CalPayrollTaskStateEnum.APPROVALEDING.getCode();
                return string;
            }
            Integer approval = (Integer)groupCalState.get(CalStateEnum.APPROVAL.getCode());
            if (approval != null && personCount.equals(approval)) {
                String string = CalPayrollTaskStateEnum.APPROVALED.getCode();
                return string;
            }
            Integer approvaled = (Integer)groupCalState.get(CalStateEnum.APPROVALED.getCode());
            if (approvaled != null && personCount.equals(approvaled)) {
                String string = CalPayrollTaskStateEnum.APPROVALED.getCode();
                return string;
            }
            if (approvaled != null && approval != null && personCount.equals(approval + approvaled)) {
                String string = CalPayrollTaskStateEnum.APPROVALED.getCode();
                return string;
            }
            if (personCount.equals(groupCalState.get(CalStateEnum.APPROVALED_NOT_PASS.getCode()))) {
                String string = CalPayrollTaskStateEnum.APPROVALED_NOT_PASS.getCode();
                return string;
            }
            if (groupCalState.containsKey(CalStateEnum.UNCAL.getCode()) || groupCalState.containsKey(CalStateEnum.CALING.getCode()) || groupCalState.containsKey(CalStateEnum.PARTIAL_CALED.getCode()) || groupCalState.containsKey(CalStateEnum.ALL_CALED.getCode()) || groupCalState.containsKey(CalStateEnum.PRECAL_ERROR.getCode()) || groupCalState.containsKey(CalStateEnum.PRECAL_CALED.getCode()) || groupCalState.containsKey(CalStateEnum.PUSHTAX_ERROR.getCode()) || groupCalState.containsKey(CalStateEnum.TAXCAL_ERROR.getCode()) || groupCalState.containsKey(CalStateEnum.PULLTAX_ERROR.getCode()) || groupCalState.containsKey(CalStateEnum.TAX_CALED.getCode()) || groupCalState.containsKey(CalStateEnum.AFTERCAL_ERROR.getCode())) {
                String string = CalPayrollTaskStateEnum.CALPROCESSING.getCode();
                return string;
            }
            if (groupCalState.containsKey(CalStateEnum.AUDIT.getCode())) {
                String string = CalPayrollTaskStateEnum.AUDIT.getCode();
                return string;
            }
            if (groupCalState.containsKey(CalStateEnum.APPROVAL.getCode()) || groupCalState.containsKey(CalStateEnum.WAIT_APPROVALED.getCode()) || groupCalState.containsKey(CalStateEnum.APPROVALING.getCode()) || groupCalState.containsKey(CalStateEnum.APPROVALED_NOT_PASS.getCode())) {
                String string = CalPayrollTaskStateEnum.APPROVALEDING.getCode();
                return string;
            }
            String string = CalPayrollTaskStateEnum.CALPROCESSING.getCode();
            return string;
        }
    }

    public static void updateCalpayrollTaskPersonCount(Long caltaskId) {
        logger.info("updateCalpayrollTaskPersonCount begin,time= {} ", (Object)System.currentTimeMillis());
        SWCDataServiceHelper calTaskHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        QFilter filter = new QFilter("id", "=", (Object)caltaskId);
        String selectProperties = "calpersoncount,taskstatus";
        DynamicObject obj = calTaskHelper.queryOne(selectProperties, new QFilter[]{filter});
        SWCDataServiceHelper calTableHelper = new SWCDataServiceHelper("hsas_calperson");
        QFilter calTableFilter = new QFilter("caltask", "=", (Object)caltaskId);
        calTableFilter.and(new QFilter("calmainid", "=", (Object)0L));
        int count = calTableHelper.count(calTableFilter.toArray());
        obj.set("calpersoncount", (Object)count);
        obj.set("taskstatus", (Object)PayrollTaskHelper.getPayRollTaskState(caltaskId));
        calTaskHelper.updateOne(obj);
        logger.info("updateCalpayrollTaskPersonCount end,time= {}", (Object)System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CalPayRollTaskMutex tryLock(String entityName, String pkId, String opKey) {
        boolean require = MutexHelper.require((String)entityName, (Object)pkId, (String)opKey, (boolean)true, (StringBuilder)new StringBuilder());
        if (require) {
            return null;
        }
        String groupId = MutexHelper.getMutexGroupId((String)entityName, (String)opKey);
        DataMutex dataMutex = null;
        try {
            dataMutex = DataMutex.create();
            Map mutex = dataMutex.getLockInfo(pkId, groupId, entityName);
            CalPayRollTaskMutex calPayRollTaskMutex = new CalPayRollTaskMutex().initByMap(mutex);
            return calPayRollTaskMutex;
        }
        finally {
            if (dataMutex != null) {
                try {
                    dataMutex.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean release(String entityName, String pkId, String opKey) {
        String groupId = MutexHelper.getMutexGroupId((String)entityName, (String)opKey);
        logger.info("releaseDistributedLock:{}", (Object)opKey);
        DataMutex dataMutex = null;
        dataMutex = DataMutex.create();
        Map mutex = dataMutex.getLockInfo(pkId, groupId, entityName);
        if (null == mutex || mutex.isEmpty()) {
            boolean bl = true;
            return bl;
        }
        boolean bl = MutexHelper.release((String)entityName, (String)opKey, (String)pkId);
        return bl;
        finally {
            if (dataMutex != null) {
                try {
                    dataMutex.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean releaseForce(String entityName, String pkId, String opKey) {
        String groupId = MutexHelper.getMutexGroupId((String)entityName, (String)opKey);
        DataMutex dataMutex = null;
        dataMutex = DataMutex.create();
        Map mutex = dataMutex.getLockInfo(pkId, groupId, entityName);
        if (null == mutex || mutex.isEmpty()) {
            boolean bl = true;
            return bl;
        }
        boolean bl = MutexHelper.release((String)entityName, (String)opKey, (String)pkId);
        return bl;
        finally {
            if (dataMutex != null) {
                try {
                    dataMutex.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean isPublishPaySlip(DynamicObject taskDy) {
        return !Boolean.FALSE.equals(PayrollTaskHelper.isPublishPaySlip(Collections.singletonList(taskDy)).get(taskDy.getLong("id")));
    }

    public static Map<Long, Boolean> isPublishPaySlip(Collection<DynamicObject> taskDys) {
        if (taskDys == null || taskDys.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<Long, Boolean> taskNeededPublishOrNot = new HashMap<Long, Boolean>(taskDys.size());
        HashBasedTable payrollGrpVIdAndScenesInTask = HashBasedTable.create();
        HashMap<String, List> groupKeyAndTaskIdsMap = new HashMap<String, List>(taskDys.size());
        for (DynamicObject taskDy : taskDys) {
            boolean couldPublish;
            long payrollGrpVId = taskDy.getLong("payrollgroupv.id");
            long payrollSceneId = taskDy.getLong("payrollscene.id");
            long payrollSceneVId = taskDy.getLong("payrollscenev.id");
            boolean bl = couldPublish = "2".equals(taskDy.getString("tasktype")) && (payrollGrpVId == 0L || payrollSceneId == 0L || payrollSceneVId == 0L);
            if (couldPublish) {
                taskNeededPublishOrNot.put(taskDy.getLong("id"), Boolean.TRUE);
                continue;
            }
            HashSet<Long> sceneVIds = (HashSet<Long>)payrollGrpVIdAndScenesInTask.get((Object)payrollGrpVId, (Object)payrollSceneId);
            if (sceneVIds == null) {
                sceneVIds = new HashSet<Long>(taskDys.size());
            }
            sceneVIds.add(payrollSceneVId);
            payrollGrpVIdAndScenesInTask.put((Object)payrollGrpVId, (Object)payrollSceneId, sceneVIds);
            String groupKey = new StringJoiner(",").add(String.valueOf(payrollGrpVId)).add(String.valueOf(payrollSceneId)).add(String.valueOf(payrollSceneVId)).toString();
            groupKeyAndTaskIdsMap.computeIfAbsent(groupKey, key -> new ArrayList(10)).add(taskDy.getLong("id"));
        }
        Map<String, Boolean> publishedGroup = PayrollTaskHelper.markPublishedGroup((Table<Long, Long, Set<Long>>)payrollGrpVIdAndScenesInTask);
        for (Map.Entry entry : groupKeyAndTaskIdsMap.entrySet()) {
            Boolean cloudPublish = !Boolean.FALSE.equals(publishedGroup.get(entry.getKey()));
            ((List)entry.getValue()).forEach(taskId -> taskNeededPublishOrNot.put((Long)taskId, cloudPublish));
        }
        return taskNeededPublishOrNot;
    }

    public static Map<String, Boolean> markPublishedGroup(Table<Long, Long, Set<Long>> payrollGrpVIdAndSceneInTask) {
        if (payrollGrpVIdAndSceneInTask == null || payrollGrpVIdAndSceneInTask.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>(payrollGrpVIdAndSceneInTask.size());
        HashSet<Long> sumSceneVIds = new HashSet<Long>(16);
        for (Table.Cell payrollGrpVIdAndSceneInTaskCell : payrollGrpVIdAndSceneInTask.cellSet()) {
            Set sceneVIds = (Set)payrollGrpVIdAndSceneInTaskCell.getValue();
            if (sceneVIds == null) continue;
            for (Long sceneVId : sceneVIds) {
                String groupKey = new StringJoiner(",").add(String.valueOf(payrollGrpVIdAndSceneInTaskCell.getRowKey())).add(String.valueOf(payrollGrpVIdAndSceneInTaskCell.getColumnKey())).add(String.valueOf(sceneVId)).toString();
                sumSceneVIds.add(sceneVId);
                resultMap.put(groupKey, Boolean.TRUE);
            }
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hsas_payrollgrpschis");
        QFilter filter = new QFilter("payrollgroupv.id", "in", (Object)payrollGrpVIdAndSceneInTask.rowKeySet());
        filter.and("payrollscene.id", "in", (Object)payrollGrpVIdAndSceneInTask.columnKeySet());
        DynamicObjectCollection payrollGrpEntrys = helper.queryOriginalCollection("payrollgroupv.id,payrollscene.id,lssuepayslip", filter.toArray());
        if (payrollGrpEntrys == null || payrollGrpEntrys.isEmpty()) {
            return resultMap;
        }
        helper.setEntityName("hsas_payrollscene");
        filter = new QFilter("id", "in", sumSceneVIds);
        filter.and("lssuepayslip", "=", (Object)"0");
        DynamicObjectCollection sceneDys = helper.queryOriginalCollection("id", filter.toArray());
        Set notPublishSceneIds = sceneDys != null ? sceneDys.stream().map(sceneDy -> sceneDy.getLong("id")).collect(Collectors.toSet()) : Collections.emptySet();
        for (DynamicObject payrollGrpEntry : payrollGrpEntrys) {
            String publishPaySlip = payrollGrpEntry.getString("lssuepayslip");
            long payrollGrpVId = payrollGrpEntry.getLong("payrollgroupv.id");
            long payrollSceneId = payrollGrpEntry.getLong("payrollscene.id");
            Set sceneVIds = (Set)payrollGrpVIdAndSceneInTask.get((Object)payrollGrpVId, (Object)payrollSceneId);
            if (sceneVIds == null) continue;
            for (Long payrollSceneVId : sceneVIds) {
                boolean sceneCanNotPublish;
                String groupKey = new StringJoiner(",").add(String.valueOf(payrollGrpVId)).add(String.valueOf(payrollSceneId)).add(String.valueOf(payrollSceneVId)).toString();
                boolean payGrpCanNotPublish = "0".equals(publishPaySlip);
                boolean bl = sceneCanNotPublish = (publishPaySlip == null || publishPaySlip.trim().length() == 0) && notPublishSceneIds.contains(payrollSceneVId);
                if (!payGrpCanNotPublish && !sceneCanNotPublish) continue;
                resultMap.put(groupKey, Boolean.FALSE);
            }
        }
        return resultMap;
    }

    public static String getPermItemName(String permItemId) {
        String permItemName = "";
        if (SWCStringUtils.isNotEmpty((String)permItemId)) {
            DynamicObject permItemDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)permItemId, (String)"perm_permitem");
            permItemName = null == permItemDyn ? permItemId : permItemDyn.getString("name");
        }
        return permItemName;
    }
}

