/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.calrequest;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.coderule.CodeRuleHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.CalRequestStatusEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.vo.CalRequestVO;

public class CalRequestHelper {
    private static Log logger = LogFactory.getLog(CalRequestHelper.class);

    public static void saveCalRequest(Long calTaskId, int totalCount, String type, String runStatus, Long calRecordId, String batchnum) {
        SWCDataServiceHelper calRequestHelper = new SWCDataServiceHelper("hsas_calrequest");
        DynamicObject calRequest = calRequestHelper.generateEmptyDynamicObject();
        SWCDataServiceHelper taskhelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        DynamicObject task = taskhelper.queryOne("id,org.id", calTaskId);
        calRequest.set("caltask", (Object)calTaskId);
        calRequest.set("org", (Object)task.getLong("org.id"));
        calRequest.set("type", (Object)type);
        calRequest.set("runstatus", (Object)runStatus);
        if (SWCStringUtils.isEmpty((String)batchnum)) {
            batchnum = CalRequestHelper.getBatchNum();
        }
        calRequest.set("batchnum", (Object)batchnum);
        calRequest.set("count", (Object)totalCount);
        calRequest.set("creator", (Object)RequestContext.get().getCurrUserId());
        calRequest.set("createtime", (Object)new Date());
        calRequest.set("modifier", (Object)RequestContext.get().getCurrUserId());
        calRequest.set("modifytime", (Object)new Date());
        String number = CodeRuleHelper.getNumber(calRequest, String.valueOf(RequestContext.get().getOrgId()));
        calRequest.set("number", (Object)number);
        calRequest.set("calrecord", (Object)calRecordId);
        calRequestHelper.saveOne(calRequest);
    }

    public static String getBatchNum() {
        String preBatchnum = SWCDateTimeUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss");
        SecureRandom secureRandom = new SecureRandom();
        int random = secureRandom.nextInt(1000);
        String batchnum = preBatchnum + random;
        return batchnum;
    }

    public static void updateCalRequest(Long calRecordId, String runStatus) {
        SWCDataServiceHelper calRequestHelper = new SWCDataServiceHelper("hsas_calrequest");
        DynamicObject calRequest = calRequestHelper.queryOne("id,runstatus", new QFilter("calrecord", "=", (Object)calRecordId).toArray());
        if (calRequest == null) {
            return;
        }
        String oldRunStatus = calRequest.getString("runstatus");
        if (SWCStringUtils.equals((String)oldRunStatus, (String)runStatus) || SWCStringUtils.equals((String)oldRunStatus, (String)CalRequestStatusEnum.STOPPED.getCode()) || SWCStringUtils.equals((String)oldRunStatus, (String)CalRequestStatusEnum.FINISHED.getCode())) {
            return;
        }
        calRequest.set("runstatus", (Object)runStatus);
        calRequestHelper.updateOne(calRequest);
    }

    public static List<CalRequestVO> loadAllRequestWithOrder() {
        List<CalRequestVO> requestVOS = CalRequestHelper.loadRequestFormDb();
        int index = 1;
        Collections.sort(requestVOS, Comparator.comparing(CalRequestVO::getCreateTime));
        for (CalRequestVO requestVO : requestVOS) {
            if (SWCStringUtils.equals((String)CalRequestStatusEnum.DOING.getCode(), (String)requestVO.getRunStatus())) continue;
            requestVO.setOrder(index++);
        }
        return requestVOS;
    }

    public static List<CalRequestVO> loadAllRequest() {
        ArrayList<CalRequestVO> requestVOs = new ArrayList<CalRequestVO>(10);
        RequestContext ctx = RequestContext.copy((RequestContext)RequestContext.get());
        List accountList = AccountUtils.getAllAccountsOfCurrentEnv();
        for (Account account : accountList) {
            if (SWCStringUtils.equals((String)ctx.getTenantId(), (String)account.getTenantId()) && ctx.getAccountId().equals(account.getAccountId())) continue;
            requestVOs.addAll(CalRequestHelper.loadRequest(account.getTenantId(), account.getAccountId()));
        }
        if (SWCStringUtils.isNotEmpty((String)ctx.getTenantId())) {
            requestVOs.addAll(CalRequestHelper.loadRequest(ctx.getTenantId(), ctx.getAccountId()));
            RequestContext.set((RequestContext)ctx);
        }
        return requestVOs;
    }

    private static List<CalRequestVO> loadRequest(String tenantId, String accountId) {
        try {
            RequestContextCreator.createForPreheat((String)tenantId, (String)accountId);
            List<CalRequestVO> requestVOS = CalRequestHelper.loadRequestFormDb();
            return requestVOS;
        }
        catch (Exception e) {
            logger.error("\u5207\u6362\u6570\u636e\u4e2d\u5fc3\uff0c\u83b7\u53d6\u8ba1\u7b97\u8bf7\u6c42\u62a5\u9519", (Throwable)e);
            throw e;
        }
    }

    private static List<CalRequestVO> loadRequestFormDb() {
        ArrayList<CalRequestVO> requestVOs = new ArrayList<CalRequestVO>(10);
        SWCDataServiceHelper requestHelper = new SWCDataServiceHelper("hsas_calrequest");
        DynamicObjectCollection requests = requestHelper.queryOriginalCollection("id,createtime,runstatus", new QFilter("runstatus", "in", Arrays.asList(CalRequestStatusEnum.QUEUING.getCode(), CalRequestStatusEnum.DOING.getCode())).toArray());
        for (DynamicObject request : requests) {
            CalRequestVO calRequestVO = new CalRequestVO();
            calRequestVO.setFid(Long.valueOf(request.getLong("id")));
            calRequestVO.setCreateTime(request.getDate("createtime"));
            calRequestVO.setRunStatus(request.getString("runstatus"));
            requestVOs.add(calRequestVO);
        }
        return requestVOs;
    }

    public static Set<Long> getCalingTask() {
        SWCDataServiceHelper requestHelper = new SWCDataServiceHelper("hsas_calrequest");
        DynamicObject[] requests = requestHelper.query("id,runstatus,caltask.id,", new QFilter("runstatus", "in", Arrays.asList(CalRequestStatusEnum.QUEUING.getCode(), CalRequestStatusEnum.DOING.getCode())).toArray());
        if (requests != null) {
            return Arrays.stream(requests).map(dynamicObject -> dynamicObject.getLong("caltask.id")).collect(Collectors.toSet());
        }
        return new HashSet<Long>(16);
    }

    public static ListShowParameter getCalRequestListForm() {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("hsas_calrequest");
        listShowParameter.setFormId("hsas_calrequestlist");
        OpenStyle style = new OpenStyle();
        style.setShowType(ShowType.MainNewTabPage);
        listShowParameter.setOpenStyle(style);
        return listShowParameter;
    }

    public static int getCalRequestCountByBatchNum(String batchnum) {
        SWCDataServiceHelper requestHelper = new SWCDataServiceHelper("hsas_calrequest");
        QFilter filter = new QFilter("batchnum", "=", (Object)batchnum);
        return requestHelper.count(new QFilter[]{filter});
    }
}

