/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.cloudcolla;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.LongProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.util.SWCJSONUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections4.MapUtils;

public class CloudCollaContextHelper {
    private static final Log LOGGER = LogFactory.getLog(CloudCollaContextHelper.class);

    private CloudCollaContextHelper() {
    }

    public static CloudCollaContextHelper getInstance() {
        return Load.INSTANCE;
    }

    public Map<String, String> parseCustomiseResult(Map<String, Object> context, Long currentActionId, String entityNumber) {
        if (context == null || currentActionId == null) {
            return Collections.emptyMap();
        }
        List collaActContext = (List)MapUtils.getObject(context, (Object)"collaActContext");
        if (CollectionUtils.isEmpty((Collection)collaActContext)) {
            return Collections.emptyMap();
        }
        for (Map actContext : collaActContext) {
            Long payRollActId = MapUtils.getLong((Map)actContext, (Object)"payRollActId");
            if (!Objects.equals(currentActionId, payRollActId)) continue;
            return MapUtils.getMap((Map)MapUtils.getMap((Map)actContext, (Object)"ruleEngineCustomizedResult"), (Object)entityNumber, Collections.emptyMap());
        }
        return Collections.emptyMap();
    }

    public DynamicObject parseAndSetCustomizeResultOnlyFlowOutData(DynamicObject currentObject, Map<String, Object> commonParams) {
        return this.parseAndSetCustomizeResult(currentObject, commonParams, null, true);
    }

    public DynamicObject parseAndSetCustomizeResultOnlyExistData(DynamicObject currentObject, Map<String, Object> commonParams, DynamicObject existObject) {
        return this.parseAndSetCustomizeResult(currentObject, commonParams, existObject, false);
    }

    public Set<String> parseCurrentCollaFields(Map<String, Object> commonParams, String entityNumber) {
        if (SWCStringUtils.isEmpty((String)entityNumber)) {
            return Collections.emptySet();
        }
        Map executeInfo = (Map)MapUtils.getObject(commonParams, (Object)"executeInfoMap");
        if (executeInfo == null) {
            return Collections.emptySet();
        }
        List collaActContext = (List)MapUtils.getObject((Map)executeInfo, (Object)"collaActContext", Collections.emptyList());
        for (Map actContext : collaActContext) {
            List triggers = (List)MapUtils.getObject((Map)actContext, (Object)"triggers", Collections.emptyList());
            for (Map trigger : triggers) {
                if (!entityNumber.equals(MapUtils.getString((Map)trigger, (Object)"objectName"))) continue;
                return new HashSet<String>((Collection)MapUtils.getObject((Map)trigger, (Object)"fields", Collections.emptyList()));
            }
        }
        return Collections.emptySet();
    }

    public void copyPropValue(DynamicObject source, DynamicObject target, Set<String> fields) {
        if (CollectionUtils.isEmpty(fields) || source == null || target == null) {
            return;
        }
        for (String field : fields) {
            target.set(field, source.get(field));
        }
    }

    public DynamicObject parseAndSetCustomizeResultOnlyAllData(DynamicObject currentObject, Map<String, Object> commonParams, DynamicObject existObject) {
        return this.parseAndSetCustomizeResult(currentObject, commonParams, existObject, true);
    }

    private DynamicObject parseAndSetCustomizeResult(DynamicObject currentObject, Map<String, Object> commonParams, DynamicObject existObject, boolean isHandleFlowOut) {
        if (currentObject == null || CollectionUtils.isEmpty(commonParams)) {
            return currentObject;
        }
        String entityNumber = currentObject.getDynamicObjectType().getName();
        Map context = (Map)MapUtils.getObject(commonParams, (Object)"executeInfoMap");
        Long actionId = MapUtils.getLong(commonParams, (Object)"currentPayRollActId");
        CloudCollaContextHelper contextHelper = CloudCollaContextHelper.getInstance();
        Map<String, String> customiseResult = contextHelper.parseCustomiseResult(context, actionId, entityNumber);
        HashSet tempChangeType = Sets.newHashSet((Object[])new String[]{"NEW", "CHANGE", "DO_NOTHING"});
        List<Object> flowOutObjectList = Collections.emptyList();
        if (isHandleFlowOut) {
            flowOutObjectList = contextHelper.parseFlowOutData(context, entityNumber, tempChangeType);
        }
        LOGGER.info("[colla] find multi flowOutObject, ids={}", flowOutObjectList.stream().map(item -> item.getLong("id")).collect(Collectors.toList()));
        contextHelper.parseAndSetCustomizeResult(currentObject, customiseResult, existObject, flowOutObjectList.size() >= 1 ? (DynamicObject)flowOutObjectList.get(0) : null);
        return currentObject;
    }

    public DynamicObject parseAndSetCustomizeResult(DynamicObject currentObject, Map<String, String> customizeResult, DynamicObject existObject, DynamicObject flowOutObject) {
        LOGGER.info("[colla] parseSetCustomizeResult, customizeResult = {} ,currentObject.isnull={}, existObject.id ={}, flowOutObject.id={}", new Object[]{JSON.toJSONString(customizeResult), currentObject == null, Optional.ofNullable(existObject).map(item -> item.get("id")).orElse(null), Optional.ofNullable(flowOutObject).map(item -> item.get("id")).orElse(null)});
        if (currentObject == null || CollectionUtils.isEmpty(customizeResult)) {
            return currentObject;
        }
        customizeResult.forEach((field, type) -> {
            switch (type) {
                case "0": {
                    currentObject.set(field, null);
                    break;
                }
                case "1": {
                    Optional.ofNullable(existObject).ifPresent(item -> currentObject.set(field, item.get(field)));
                    break;
                }
                case "2": {
                    Optional.ofNullable(flowOutObject).ifPresent(item -> currentObject.set(field, item.get(field)));
                    break;
                }
            }
        });
        return currentObject;
    }

    private List<DynamicObject> parseFlowOutData(Map<String, Object> executeContext, String entityNumber, Set<String> typeSet) {
        Map batchTaskCenterData = (Map)MapUtils.getObject(executeContext, (Object)"batchTaskCenterData");
        if (CollectionUtils.isEmpty((Map)batchTaskCenterData)) {
            return Collections.emptyList();
        }
        List flowOutTaskCenterList = (List)MapUtils.getObject((Map)batchTaskCenterData, (Object)"2", Collections.emptyList());
        if (CollectionUtils.isEmpty((Collection)flowOutTaskCenterList)) {
            return Collections.emptyList();
        }
        ArrayList<String> resultIdList = new ArrayList<String>(10);
        for (Map taskCenterMap : flowOutTaskCenterList) {
            List entryEntity = (List)MapUtils.getObject((Map)taskCenterMap, (Object)"entryEntity");
            if (CollectionUtils.isEmpty((Collection)entryEntity)) continue;
            for (Map entryRow : entryEntity) {
                String rowResult = MapUtils.getString((Map)entryRow, (Object)"result");
                if (SWCStringUtils.isEmpty((String)rowResult)) continue;
                resultIdList.addAll(this.parseResult(rowResult, typeSet, entityNumber));
            }
        }
        if (CollectionUtils.isEmpty(resultIdList)) {
            return Collections.emptyList();
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper(entityNumber);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        ISimpleProperty primaryKey = dataEntityType.getPrimaryKey();
        DynamicObject[] query = primaryKey instanceof LongProp ? helper.query(SWCHisBaseDataHelper.getSelectProperties(entityNumber), new QFilter[]{new QFilter("id", "in", resultIdList.stream().map(Long::valueOf).collect(Collectors.toList()))}) : helper.query(SWCHisBaseDataHelper.getSelectProperties(entityNumber), new QFilter[]{new QFilter("id", "in", resultIdList)});
        if (query == null || query.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.stream(query).collect(Collectors.toList());
    }

    private List<String> parseResult(String rowResult, Set<String> typeSet, String entityNumber) {
        if (SWCStringUtils.isEmpty((String)rowResult)) {
            return Collections.emptyList();
        }
        Map parseMap = SWCJSONUtils.jsonToMap((Object)rowResult);
        List entityDataMapList = (List)MapUtils.getObject((Map)parseMap, (Object)entityNumber);
        if (CollectionUtils.isEmpty((Collection)entityDataMapList)) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(10);
        ImmutableList typeList = ImmutableList.of((Object)"NEW", (Object)"CHANGE", (Object)"DO_NOTHING", (Object)"ENABLE", (Object)"DISABLE");
        Map<String, List<Map>> groupResult = entityDataMapList.stream().collect(Collectors.groupingBy(item -> MapUtils.getString((Map)item, (Object)"type")));
        for (String type : typeList) {
            List tempResult = (List)MapUtils.getObject(groupResult, (Object)type);
            if (CollectionUtils.isEmpty((Collection)tempResult)) continue;
            result.addAll(tempResult.stream().map(item -> MapUtils.getString((Map)item, (Object)"dataId")).collect(Collectors.toList()));
            return result;
        }
        for (Map entityDataMap : entityDataMapList) {
            String type = MapUtils.getString((Map)entityDataMap, (Object)"type");
            if (!typeSet.contains(type)) continue;
            result.add(MapUtils.getString((Map)entityDataMap, (Object)"dataId"));
        }
        return result;
    }

    private static interface Load {
        public static final CloudCollaContextHelper INSTANCE = new CloudCollaContextHelper();
    }
}

