/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.cloudcolla.verify.event.object;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.swc.hsbp.business.cloudcolla.verify.event.IVerifyBillListener;

public abstract class AbstractVerifyBillEvent
extends EventObject {
    private static final long serialVersionUID = 6653770667184290647L;
    private boolean success = true;
    private Map<String, Map<String, Object>> outputData = new ConcurrentHashMap<String, Map<String, Object>>(16);

    public AbstractVerifyBillEvent(Map<String, Object> source) {
        super(source);
    }

    public synchronized void success(IVerifyBillListener listener, Map<String, Object> value) {
        Map<String, Object> objectMap;
        String billFormId = listener.getBillFormId();
        if (billFormId == null) {
            return;
        }
        Map<String, Object> data = this.outputData.get(billFormId);
        if (data == null && (objectMap = this.outputData.putIfAbsent(billFormId, data = new ConcurrentHashMap<String, Object>(16))) != null) {
            data = objectMap;
        }
        for (Map.Entry<String, Object> entry : value.entrySet()) {
            String key = entry.getKey();
            Object dataValue = entry.getValue();
            if (key == null || dataValue == null) continue;
            data.put(entry.getKey(), entry.getValue());
        }
    }

    public synchronized void success(IVerifyBillListener listener, String key, Object value) {
        Map<String, Object> objectMap;
        String billFormId = listener.getBillFormId();
        if (billFormId == null) {
            return;
        }
        Map<String, Object> data = this.outputData.get(billFormId);
        if (data == null && (objectMap = this.outputData.putIfAbsent(billFormId, data = new ConcurrentHashMap<String, Object>(16))) != null) {
            data = objectMap;
        }
        data.putIfAbsent(key, value);
    }

    public synchronized void error(IVerifyBillListener listener, String msg) {
        this.success = false;
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        data.put("success", Boolean.FALSE);
        data.put("msg", msg);
        this.outputData.putIfAbsent(listener.getBillFormId(), data);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public Map<String, Map<String, Object>> getOutputData() {
        return this.outputData;
    }

    @Override
    public Map<String, Object> getSource() {
        return (Map)super.getSource();
    }
}

