/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.cloudcolla.verify.handler;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.swc.hsbp.business.cloudcolla.verify.VerifyBillDataService;
import kd.swc.hsbp.business.cloudcolla.verify.handler.IVerifyBillDataHandler;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.MapUtils;

public class SubVerifyBillSaveHandler
implements IVerifyBillDataHandler,
Serializable {
    private static final long serialVersionUID = -8668155937385710885L;

    @Override
    public Map<String, Object> accept(Map<String, Object> param) {
        String appNumber = this.getAppNumber(param);
        String formId = this.getFormId(param);
        Map<String, Object> data = this.getData(param);
        return this.saveVerifyBill(appNumber, formId, data);
    }

    private Map<String, Object> saveVerifyBill(String appNumber, String formId, Map<String, Object> data) {
        Set<String> ignoredFormIds = this.getIgnoredFormIds(data);
        if (ignoredFormIds.contains(formId)) {
            return this.success(null);
        }
        DynamicObject[] summaryVerifyBill = (DynamicObject[])data.get("summaryVerifyBill");
        SWCDataServiceHelper formHelper = new SWCDataServiceHelper(formId);
        ArrayList<DynamicObject> saveDataObject = new ArrayList<DynamicObject>(summaryVerifyBill.length);
        Set billIds = Arrays.stream(summaryVerifyBill).map(item -> item.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] relbillids = formHelper.query(SWCHisBaseDataHelper.getSelectProperties(formId), new QFilter[]{new QFilter("relbillid", "in", billIds)});
        Map<Object, Object> idRels = new HashMap(16);
        if (relbillids != null && relbillids.length > 0) {
            idRels = Arrays.stream(relbillids).collect(Collectors.toMap(item -> item.getLong("relbillid"), Function.identity(), (first, second) -> first));
        }
        Map billFieldValues = (Map)data.get("billFieldValues");
        AppInfo appInfoByNumber = AppMetadataCache.getAppInfoByNumber((String)appNumber);
        String appId = appInfoByNumber.getId();
        for (DynamicObject entity : summaryVerifyBill) {
            Map finalData;
            if (!this.parseFormIdSet(entity).contains(appNumber)) continue;
            long billId = entity.getLong("id");
            DynamicObject targetObject = this.generateDynamicObject(formHelper, (DynamicObject)idRels.get(billId), entity);
            SubVerifyBillSaveHandler.setCommonFieldValue(entity, billId, targetObject);
            saveDataObject.add(targetObject);
            DynamicObjectCollection entryEntity = formHelper.generateEmptyEntryCollection(targetObject, "entryentity");
            if (CollectionUtils.isEmpty((Map)billFieldValues) || CollectionUtils.isEmpty((Map)(finalData = (Map)billFieldValues.get(billId)))) continue;
            finalData.forEach((triggerId, collaValue) -> {
                String dataAppNumber = MapUtils.getString((Map)collaValue, (Object)"appNumber");
                String objectNumber = MapUtils.getString((Map)collaValue, (Object)"objectNumber");
                if (!appNumber.equalsIgnoreCase(dataAppNumber) || SWCStringUtils.isEmpty((String)objectNumber)) {
                    return;
                }
                DynamicObject rowEntry = formHelper.generateEmptyEntryDynamicObject(targetObject, "entryentity");
                entryEntity.add((Object)rowEntry);
                rowEntry.set("bizapp", (Object)appId);
                rowEntry.set("cardtype", collaValue.get("cardType"));
                rowEntry.set("bizobject", (Object)objectNumber);
                rowEntry.set("triggercolla", triggerId);
                DynamicObjectCollection subEntryEntity = formHelper.generateEmptySubEntryCollection(targetObject, rowEntry, "subentryentity");
                List objectValues = (List)collaValue.get("objectValues");
                List exeParams = (List)collaValue.get("exeParams");
                if (!CollectionUtils.isEmpty((Collection)objectValues)) {
                    for (int i = 0; i < objectValues.size(); ++i) {
                        Map objectValue = (Map)objectValues.get(i);
                        DynamicObject dynamicObject = formHelper.generateEmptyEntryDynamicObject(targetObject, "subentryentity");
                        subEntryEntity.add((Object)dynamicObject);
                        dynamicObject.set("fieldnumber", objectValue.get("fieldNumber"));
                        dynamicObject.set("fieldvalue", this.getFieldValue(objectValue.get("fieldValue")));
                        dynamicObject.set("seq", (Object)(i + 1));
                        dynamicObject.set("groupindex", (Object)0);
                    }
                }
                if (!CollectionUtils.isEmpty((Collection)exeParams)) {
                    int index = subEntryEntity.size();
                    for (Map objectValue : exeParams) {
                        DynamicObject dynamicObject = formHelper.generateEmptyEntryDynamicObject(targetObject, "subentryentity");
                        subEntryEntity.add((Object)dynamicObject);
                        dynamicObject.set("fieldnumber", (Object)VerifyBillDataService.getInstance().formatFieldNumber((String)objectValue.get("fieldNumber"), (String)collaValue.get("objectNumber")));
                        dynamicObject.set("fieldValue", this.getFieldValue(objectValue.get("fieldValue")));
                        dynamicObject.set("seq", (Object)(++index));
                        dynamicObject.set("groupindex", (Object)0);
                    }
                }
            });
            targetObject.set("entryentity", (Object)entryEntity);
        }
        formHelper.save(saveDataObject.toArray(new DynamicObject[0]));
        return this.success(null);
    }

    private Set<String> parseFormIdSet(DynamicObject verifyBill) {
        if (verifyBill == null) {
            return Collections.emptySet();
        }
        DynamicObjectCollection verifyApps = verifyBill.getDynamicObjectCollection("verifyapp");
        return verifyApps.stream().map(item -> item.getString("fbasedataid.number")).collect(Collectors.toSet());
    }

    private Set<String> getIgnoredFormIds(Map<String, Object> data) {
        if (CollectionUtils.isEmpty(data)) {
            return Collections.emptySet();
        }
        String notSaveBillFromIds = (String)data.get("notSaveBillFromIds");
        if (SWCStringUtils.isEmpty((String)notSaveBillFromIds)) {
            return Collections.emptySet();
        }
        String[] split = notSaveBillFromIds.split(",");
        HashSet<String> ignoredFormIds = new HashSet<String>(split.length);
        for (String formId : split) {
            if (SWCStringUtils.isEmpty((String)formId)) continue;
            ignoredFormIds.add(formId.trim());
        }
        return ignoredFormIds;
    }

    private static void setCommonFieldValue(DynamicObject entity, long billId, DynamicObject targetObject) {
        targetObject.set("relbillid", (Object)billId);
        targetObject.set("auditstatus", (Object)entity.getString("auditstatus"));
        targetObject.set("billstatus", (Object)entity.getString("billstatus"));
        targetObject.set("auditdate", (Object)entity.getDate("auditdate"));
        targetObject.set("createtime", (Object)entity.getDate("createtime"));
        targetObject.set("modifytime", (Object)entity.getDate("modifytime"));
        targetObject.set("changetime", (Object)entity.getDate("changetime"));
        targetObject.set("creator", entity.get("creator"));
        targetObject.set("auditor", entity.get("auditor"));
    }

    public DynamicObject generateDynamicObject(SWCDataServiceHelper formHelper, DynamicObject existObject, DynamicObject entity) {
        if (existObject != null) {
            return existObject;
        }
        DynamicObject dynamicObject = formHelper.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)entity, (DynamicObject)dynamicObject);
        return dynamicObject;
    }

    private Object getFieldValue(Object fieldValue) {
        if (fieldValue == null) {
            return null;
        }
        if (fieldValue instanceof DynamicObject) {
            return ((DynamicObject)fieldValue).getPkValue();
        }
        if (fieldValue instanceof Date) {
            return SWCDateTimeUtils.format((Date)((Date)fieldValue));
        }
        return fieldValue;
    }
}

