/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.datachanged;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.util.CollectionUtils;

public class BizChangedHelper {
    public static void operateBizChangedSet(DynamicObject dataEntity, Collection<String> needOptFields, OperateEnum operateEnum) {
        if (CollectionUtils.isEmpty(needOptFields)) {
            return;
        }
        if (!(needOptFields instanceof Set)) {
            needOptFields = new HashSet<String>(needOptFields);
        }
        DataEntityState dataEntityState = dataEntity.getDataEntityState();
        if (OperateEnum.RETAIN == operateEnum) {
            for (IDataEntityProperty bizChangedProperty : dataEntityState.getBizChangedProperties()) {
                String bizChangedPropertyName = bizChangedProperty.getName();
                if (bizChangedPropertyName.endsWith("_id")) {
                    bizChangedPropertyName = bizChangedPropertyName.substring(0, bizChangedPropertyName.lastIndexOf("_id"));
                }
                dataEntityState.setBizChanged(bizChangedProperty.getOrdinal(), needOptFields.contains(bizChangedPropertyName));
            }
        } else {
            Map<String, Integer> changedFieldAndOrdinalMap = null;
            DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
            for (String needOptField : needOptFields) {
                Map<String, Integer> bizOrdinalMap = BizChangedHelper.getBizOrdinalMap(properties, needOptField);
                if (OperateEnum.ADD == operateEnum) {
                    if (changedFieldAndOrdinalMap == null) {
                        changedFieldAndOrdinalMap = BizChangedHelper.getChangedFieldAndOrdinalMap(dataEntityState);
                    }
                    if (bizOrdinalMap.size() <= 0 || bizOrdinalMap.keySet().removeAll(changedFieldAndOrdinalMap.keySet())) continue;
                    Integer ordinal2 = bizOrdinalMap.values().iterator().next();
                    dataEntityState.setBizChanged(bizOrdinalMap.values().iterator().next().intValue(), true);
                    continue;
                }
                if (OperateEnum.DELETE != operateEnum) continue;
                bizOrdinalMap.values().forEach(ordinal -> dataEntityState.setBizChanged(ordinal.intValue(), false));
            }
        }
    }

    private static Map<String, Integer> getBizOrdinalMap(DataEntityPropertyCollection properties, String needOptField) {
        List<String> needOptFields = Arrays.asList(needOptField, needOptField + "_id");
        HashMap<String, Integer> bizOrdinalMap = new HashMap<String, Integer>(2);
        for (String optField : needOptFields) {
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get((Object)optField);
            if (iDataEntityProperty == null) continue;
            bizOrdinalMap.put(needOptField, iDataEntityProperty.getOrdinal());
        }
        return bizOrdinalMap;
    }

    public static Map<String, Integer> getChangedFieldAndOrdinalMap(DataEntityState dataEntityState) {
        HashMap<String, Integer> changedFieldAndOrdinalMap = new HashMap<String, Integer>(16);
        for (IDataEntityProperty dataEntityProperty : dataEntityState.getBizChangedProperties()) {
            changedFieldAndOrdinalMap.put(dataEntityProperty.getName(), dataEntityProperty.getOrdinal());
        }
        return changedFieldAndOrdinalMap;
    }

    public static enum OperateEnum {
        ADD,
        DELETE,
        RETAIN;

    }
}

