/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.dynamicentry;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.operate.GridConfigurationRow;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.entity.userconfig.UserConfig;
import kd.bos.filter.ListColumnCompareHelper;
import kd.bos.form.BindingContext;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormUserConfig;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.userconfig.GridConfigDAO;
import kd.swc.hsbp.business.export.SWCExportEntryHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang.StringUtils;

public class SWCDynamicEntryGrid
extends EntryGrid {
    private Log LOGGER = LogFactory.getLog(SWCDynamicEntryGrid.class);

    public void bindData(BindingContext bctx) {
        Map<String, Object> map;
        Map<String, Object> entryMeta;
        this.LOGGER.info("SWCDynamicEntryGrid...bindData...");
        List gridConfigurationRows = null;
        IFormUserConfig service = (IFormUserConfig)this.view.getService(IFormUserConfig.class);
        if (service == null) {
            GridConfigDAO gridConfigDAO = new GridConfigDAO();
            gridConfigurationRows = gridConfigDAO.getGridConfig(this.view.getFormShowParameter().getFormId(), this.getEntryKey());
        } else {
            String key = GridConfigDAO.buildUserConfigKey((String)this.view.getFormShowParameter().getFormId(), (String)this.getEntryKey());
            UserConfig userConfig = service.loadUserConfig(key);
            if (userConfig == null || StringUtils.isBlank((String)userConfig.getSetting())) {
                gridConfigurationRows = new ArrayList();
            } else {
                this.LOGGER.info("SWCDynamicEntryGrid...bindData...getSetting...");
                gridConfigurationRows = SerializationUtils.fromJsonStringToList((String)userConfig.getSetting(), GridConfigurationRow.class);
            }
        }
        if (gridConfigurationRows != null && !gridConfigurationRows.isEmpty() && (entryMeta = SWCExportEntryHelper.getEntryMeta((Map)(map = SWCExportEntryHelper.invokeLoadCustomControlMetas(this.getView())).get("metas"), this.getEntryKey())) != null) {
            HashMap<String, GridConfigurationRow> gridConfigMap = new HashMap<String, GridConfigurationRow>(16);
            for (GridConfigurationRow row : gridConfigurationRows) {
                if (gridConfigMap.containsKey(row.getFieldKey())) {
                    this.LOGGER.info("SWCDynamicEntryGrid...bindData...containsKey= {}", (Object)row.getFieldKey());
                    continue;
                }
                gridConfigMap.put(row.getFieldKey(), row);
            }
            this.LOGGER.info("SWCDynamicEntryGrid...bindData...gridConfigMap.keySet= {}", gridConfigMap.keySet());
            List<Map<String, Object>> colMeta = (List<Map<String, Object>>)entryMeta.get("columns");
            SWCDynamicEntryGrid.setColumnCompareOperators(this.view, colMeta);
            SWCDynamicEntryGrid.mergeConfigAndMeta(colMeta, gridConfigMap);
            colMeta = this.moveFixedField(colMeta);
            entryMeta.put("columns", colMeta);
            IClientViewProxy proxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
            proxy.invokeControlMethod(this.getEntryKey(), "createGridColumns", new Object[]{entryMeta});
        }
        try {
            Method bindPageData = EntryGrid.class.getDeclaredMethod("bindPageData", BindingContext.class);
            ReflectionUtils.makeAccessible((Method)bindPageData);
            bindPageData.invoke((Object)this, bctx);
        }
        catch (Exception e) {
            this.LOGGER.error("SWCDynamicEntryGrid bindData is: ", (Throwable)e);
            throw new RuntimeException(e);
        }
        this.setEntryGridPageConfig();
    }

    private List<Map<String, Object>> moveFixedField(List<Map<String, Object>> columnMeta) {
        List<Map<String, Object>> fixedColumnMeta = this.doMoveFixedField(columnMeta);
        if (fixedColumnMeta.isEmpty()) {
            return columnMeta;
        }
        int sysFieldEndIndex = 0;
        for (int i = 0; i < columnMeta.size(); ++i) {
            String dataIndex = (String)columnMeta.get(i).getOrDefault("dataIndex", "");
            if (StringUtils.equals((String)dataIndex, (String)"rk") || StringUtils.equals((String)dataIndex, (String)"seq")) continue;
            sysFieldEndIndex = i;
            break;
        }
        columnMeta.addAll(sysFieldEndIndex, fixedColumnMeta);
        return columnMeta;
    }

    private List<Map<String, Object>> doMoveFixedField(List<Map<String, Object>> columnMeta) {
        List<Map<String, Object>> columnMetaCopy = this.copyColumnWithRename(columnMeta);
        this.recursionRemoveWithCondition(columnMeta, objectMap -> {
            Boolean fixed = objectMap.getOrDefault("isFixed", Boolean.FALSE);
            if (objectMap.get("children") == null && fixed.booleanValue()) {
                return true;
            }
            return Boolean.FALSE;
        });
        this.recursionRemoveWithCondition(columnMetaCopy, objectMap -> {
            Boolean fixed = objectMap.getOrDefault("isFixed", Boolean.FALSE);
            if (objectMap.get("children") == null && !fixed.booleanValue()) {
                return true;
            }
            return Boolean.FALSE;
        });
        return columnMetaCopy;
    }

    private List<Map<String, Object>> copyColumnWithRename(List<Map<String, Object>> columnMeta) {
        return this.doCopyColumnWithRename(columnMeta);
    }

    private List<Map<String, Object>> doCopyColumnWithRename(List<Map<String, Object>> columnMeta) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)columnMeta.size());
        for (Map<String, Object> colMeta : columnMeta) {
            Object Children = colMeta.get("children");
            String dataIndex = (String)colMeta.get("dataIndex");
            if (Children != null) {
                HashMap<String, Object> colMetaCopy = new HashMap<String, Object>(colMeta);
                colMetaCopy.put("dataIndex", dataIndex + "#C");
                List<Map<String, Object>> childrenListCopy = this.doCopyColumnWithRename((List)Children);
                colMetaCopy.put("children", childrenListCopy);
                result.add(colMetaCopy);
                continue;
            }
            result.add(colMeta);
        }
        return result;
    }

    private void recursionRemoveWithCondition(List<Map<String, Object>> columnMeta, Function<Map<String, Object>, Boolean> mapBooleanFunction) {
        Iterator<Map<String, Object>> iterator = columnMeta.iterator();
        while (iterator.hasNext()) {
            Map<String, Object> colMeta = iterator.next();
            Object Children = colMeta.get("children");
            if (Children != null) {
                List childrenList = (List)Children;
                this.recursionRemoveWithCondition(childrenList, mapBooleanFunction);
                if (!childrenList.isEmpty()) continue;
                iterator.remove();
                continue;
            }
            if (!mapBooleanFunction.apply(colMeta).booleanValue()) continue;
            iterator.remove();
        }
    }

    private void setEntryGridPageConfig() {
        if (this.isServerFilterModle()) {
            HashMap<String, Boolean> returnData = new HashMap<String, Boolean>(1);
            returnData.put("isServerFilterModle", true);
            HashMap<String, Object> map = new HashMap<String, Object>(1);
            map.put("grid", returnData);
            this.setPageConfigAction(map);
        }
    }

    private void setPageConfigAction(Map<String, Object> configData) {
        IClientViewProxy proxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
        proxy.removeAction("setPageConfig");
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put("config", configData);
        paraMap.put("pageId", this.view.getPageId());
        proxy.addAction("setPageConfig", paraMap);
    }

    public void listFieldsControl(List<Map<String, Object>> columnsWidthInFrontEnd) {
        String entryId = this.getEntryKey();
        String formId = this.getView().getFormShowParameter().getFormId();
        GridConfigDAO gridConfigDAO = new GridConfigDAO();
        List<GridConfigurationRow> configurationRows = this.getRuntimeColInfo(entryId);
        this.setCustomInitConfig(configurationRows);
        List gridConfigByDB = gridConfigDAO.getGridConfig(formId, entryId);
        Iterator it = gridConfigByDB.iterator();
        while (it.hasNext()) {
            GridConfigurationRow gridConfigurationRowByDB = (GridConfigurationRow)it.next();
            if (!configurationRows.contains(gridConfigurationRowByDB)) {
                it.remove();
            }
            for (GridConfigurationRow gridConfigurationRowByMeta : configurationRows) {
                if (!StringUtils.equals((String)gridConfigurationRowByDB.getFieldKey(), (String)gridConfigurationRowByMeta.getFieldKey())) continue;
                gridConfigurationRowByDB.setFieldName(gridConfigurationRowByMeta.getFieldName());
            }
        }
        gridConfigByDB.addAll(configurationRows.stream().filter(row -> !gridConfigByDB.contains(row)).collect(Collectors.toList()));
        CloseCallBack closeCallBack = new CloseCallBack(((Object)((Object)this)).getClass().getName(), "listFieldsControl");
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ide_gridconfig");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(closeCallBack);
        parameter.setCustomParam("gridConfig", (Object)SerializationUtils.toJsonString((Object)gridConfigByDB));
        parameter.setCustomParam("gridConfigKey", (Object)entryId);
        parameter.setCustomParam("entityNum", (Object)formId);
        parameter.setCustomParam("sourceType", (Object)"listFieldsControl");
        parameter.setCustomParam("resetGridConfig", (Object)SerializationUtils.toJsonString(configurationRows));
        this.getView().showForm(parameter);
    }

    private void setCustomInitConfig(List<GridConfigurationRow> configurationRows) {
        List initConfigRows = SerializationUtils.fromJsonStringToList((String)this.getView().getPageCache().get("customGridInitConf"), GridConfigurationRow.class);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)initConfigRows)) {
            Map fieldConfMap = configurationRows.stream().collect(Collectors.toMap(GridConfigurationRow::getFieldKey, Function.identity()));
            for (GridConfigurationRow configurationRow : initConfigRows) {
                GridConfigurationRow gridConfigurationRow = (GridConfigurationRow)fieldConfMap.get(configurationRow.getFieldKey());
                if (gridConfigurationRow == null) continue;
                gridConfigurationRow.setHide(configurationRow.isHide());
                gridConfigurationRow.setFreeze(configurationRow.isFreeze());
            }
        }
    }

    public void initGridConfig(Map<String, GridConfigurationRow> initConf) {
        this.getView().getPageCache().put("customGridInitConf", SerializationUtils.toJsonString(initConf.values()));
        String entryId = this.getEntryKey();
        String formId = this.getView().getFormShowParameter().getFormId();
        GridConfigDAO gridConfigDAO = new GridConfigDAO();
        List gridConfigByDB = gridConfigDAO.getGridConfig(formId, entryId);
        if (gridConfigByDB.isEmpty()) {
            List<GridConfigurationRow> configurationRows = this.getRuntimeColInfo(entryId);
            for (GridConfigurationRow configurationRow : configurationRows) {
                String fieldKey = configurationRow.getFieldKey();
                GridConfigurationRow initConfRow = initConf.get(fieldKey);
                if (initConfRow == null) continue;
                configurationRow.setHide(initConfRow.isHide());
                configurationRow.setFreeze(initConfRow.isFreeze());
            }
            gridConfigDAO.saveGridConfig(formId, entryId, configurationRows);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if ("listFieldsControl".equalsIgnoreCase(evt.getActionId())) {
            IFormView view = evt.getView();
            Map result = (Map)evt.getReturnData();
            if (result != null) {
                String action = (String)result.get("action");
                GridConfigDAO gridConfigDAO = new GridConfigDAO();
                String entryKey = (String)result.get("gridConfigKey");
                if ("setConfig".equals(action)) {
                    String gridConfigStr = (String)result.get("gridConfig");
                    List configRows = SerializationUtils.fromJsonStringToList((String)gridConfigStr, GridConfigurationRow.class);
                    gridConfigDAO.saveGridConfig(view.getFormShowParameter().getFormId(), entryKey, configRows);
                }
                view.updateView(entryKey);
            }
        }
    }

    private List<GridConfigurationRow> getRuntimeColInfo(String entryId) {
        Map<String, Object> map = SWCExportEntryHelper.invokeLoadCustomControlMetas(this.getView());
        List<Map<String, Object>> columnsFromMeta = SWCExportEntryHelper.getEntryColumnsFromMeta((Map)map.get("metas"), entryId);
        ArrayList gridConfigRows = Lists.newArrayListWithCapacity((int)columnsFromMeta.size());
        columnsFromMeta.remove(0);
        columnsFromMeta.remove(0);
        this.createConfigRowWithColumnInfo(gridConfigRows, columnsFromMeta, null);
        return gridConfigRows;
    }

    private void createConfigRowWithColumnInfo(List<GridConfigurationRow> gridConfigRows, List<Map<String, Object>> colMetas, Map<String, Object> parent) {
        for (Map<String, Object> colMeta : colMetas) {
            Object isFixedObj;
            BillOperationStatus billOperationStatus;
            OperationStatus operationStatus;
            Object obj;
            LocaleString header = (LocaleString)colMeta.get("header");
            if (parent != null) {
                LocaleString parentHeader = (LocaleString)parent.get("header");
                header = SWCStringUtils.joinLocaleString((String)"-", (LocaleString[])new LocaleString[]{parentHeader, header});
                colMeta.put("header", header);
            }
            if ((obj = colMeta.get("children")) != null) {
                this.createConfigRowWithColumnInfo(gridConfigRows, (List)obj, colMeta);
                continue;
            }
            int visible = Integer.parseInt(colMeta.get("vi").toString());
            if ((visible & 8) != 8) {
                return;
            }
            if (!(this.view instanceof IBillView) ? (operationStatus = this.view.getFormShowParameter().getStatus()) == OperationStatus.ADDNEW && (visible & 1) != 1 || operationStatus == OperationStatus.EDIT && (visible & 2) != 2 || operationStatus == OperationStatus.VIEW && (visible & 4) != 4 : (billOperationStatus = ((BillShowParameter)this.view.getFormShowParameter()).getBillStatus()) == BillOperationStatus.ADDNEW && (visible & 1) != 1 || billOperationStatus == BillOperationStatus.EDIT && (visible & 2) != 2 || billOperationStatus == BillOperationStatus.VIEW && (visible & 4) != 4 || billOperationStatus == BillOperationStatus.SUBMIT && (visible & 0x10) != 16 || billOperationStatus == BillOperationStatus.AUDIT && (visible & 0x20) != 32) continue;
            Object align = colMeta.get("text-align");
            String textAlign = align instanceof String ? (String)align : "default";
            Object dataIndex = colMeta.get("dataIndex");
            String key = dataIndex instanceof String ? (String)dataIndex : null;
            int width = 0;
            if (colMeta.get("w") != null) {
                for (Map.Entry entry : ((Map)colMeta.get("w")).entrySet()) {
                    if (!StringUtils.isNotBlank((String)((String)entry.getValue())) || ((String)entry.getValue()).contains("%")) continue;
                    width = Integer.parseInt(((String)entry.getValue()).replace("px", "").split("\\.")[0]);
                    break;
                }
            }
            boolean isFixed = (isFixedObj = colMeta.get("isFixed")) != null && (Boolean)isFixedObj != false;
            GridConfigurationRow bean = new GridConfigurationRow(header, width, textAlign, key);
            bean.setFreeze(isFixed);
            gridConfigRows.add(bean);
        }
    }

    private static void mergeConfigAndMeta(List<Map<String, Object>> columnMeta, Map<String, GridConfigurationRow> setting) {
        for (int i = 0; i < columnMeta.size(); ++i) {
            Map<String, Object> colMeta = columnMeta.get(i);
            Object Children = colMeta.get("children");
            if (Children != null) {
                SWCDynamicEntryGrid.mergeConfigAndMeta((List)Children, setting);
                continue;
            }
            String dataIndex = (String)colMeta.get("dataIndex");
            GridConfigurationRow bean = setting.get(dataIndex);
            if (bean == null) continue;
            if (bean.isHide()) {
                colMeta.put("vi", 0);
            } else {
                colMeta.put("vi", 63);
            }
            colMeta.put("isFixed", bean.isFreeze());
            if (bean.getTextAlign() == null) continue;
            colMeta.put("text-align", bean.getTextAlign());
        }
    }

    private static void setColumnCompareOperators(IFormView view, List<Map<String, Object>> columnMeta) {
        try (EntityTraceSpan span = EntityTracer.create((String)"GridConfigUitls", (String)"setColumnCompareOperators");){
            for (Map<String, Object> column : columnMeta) {
                IDataEntityProperty property;
                ArrayList children;
                String fieldName = (String)column.get("dataIndex");
                ArrayList arrayList = children = column.get("children") == null ? null : (ArrayList)column.get("children");
                if (!CollectionUtils.isEmpty((Collection)children)) {
                    SWCDynamicEntryGrid.setColumnCompareOperators(view, children);
                }
                if (!((property = view.getModel().getProperty(fieldName)) instanceof MulBasedataProp || property instanceof ItemClassProp || property instanceof FlexProp)) {
                    if (property instanceof TimeProp) {
                        column.put("sort", true);
                        column.put("filter", false);
                        continue;
                    }
                    String type = null;
                    String[] displayProps = EntityTypeUtil.getBasedataDisplayProps((IDataEntityProperty)property);
                    if (displayProps != null && displayProps.length > 0) {
                        fieldName = fieldName + "." + displayProps[0];
                        type = "text";
                    }
                    FilterField filterField = FilterField.create((MainEntityType)view.getModel().getDataEntityType(), (String)fieldName);
                    if (span.isRealtime()) {
                        span.addTag("fieldname", fieldName);
                        span.addLocaleTag("compareTypes", (Object)(filterField == null ? "null" : SerializationUtils.toJsonString((Object)filterField.getCompareTypes())));
                    }
                    ListColumnCompareHelper.setColumnCompareOperators((FilterField)filterField, column, new HashMap(0), (String)null, (String)type, (Function)null, (Function)null, new ArrayList(), (boolean)false);
                    continue;
                }
                column.put("sort", false);
                column.put("filter", false);
            }
        }
    }
}

