/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.encrypt;

import com.alibaba.fastjson.JSONObject;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.List;
import kd.bos.crypto.MultiEncrypters;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.model.EncryptionScheme;
import kd.bos.permission.util.SchemeUtil;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.swc.hsbp.business.encrypt.util.SecretTableUtil;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.EncryptLevelEnum;
import kd.swc.hsbp.common.enums.EncryptTypeEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.codec.binary.Hex;

public class MultiEncryptNewService {
    private static final Log log = LogFactory.getLog(MultiEncryptNewService.class);
    private Long encryptId;
    private Long secretKeyId;
    private String secretKey;
    private EncryptTypeEnum encryptType;
    private EncryptLevelEnum encryptLevel;

    public MultiEncryptNewService(EncryptTypeEnum encryptType, EncryptLevelEnum encryptLevel) {
        this.encryptType = encryptType;
        this.encryptLevel = encryptLevel;
        this.encryptId = 0L;
        this.secretKeyId = 0L;
        this.initEncryptId();
        this.initSecretKeyData();
    }

    public Long getEncryptId() {
        return this.encryptId;
    }

    public Long getSecretKeyId() {
        return this.secretKeyId;
    }

    public String getSecretKey(String leaderKey) {
        String key1 = this.getHashcode(leaderKey);
        key1 = key1.substring(0, 32);
        key1 = key1.replaceAll("\u0000", "");
        String key2 = SecretTableUtil.getEncryptKey(key1);
        return key2;
    }

    public String getEncryKey(List<String> secretKeyList) {
        String result = "";
        StringBuilder sb = new StringBuilder();
        secretKeyList.forEach(sb::append);
        try {
            result = this.getHashcode(sb.toString());
        }
        catch (Exception e) {
            log.error("encrypt error : {}", (Object)e.getMessage());
        }
        return result;
    }

    public String encode(List<String> secretKeyList, String content) {
        String encodeStr = this.encode(content);
        if (SWCStringUtils.isEmpty((String)encodeStr)) {
            return encodeStr;
        }
        if (EncryptLevelEnum.ENCRYPT_LEVEL_HIGH == this.encryptLevel) {
            encodeStr = this.leaderEncode(encodeStr);
            encodeStr = this.personEncode(secretKeyList, encodeStr);
        }
        return encodeStr;
    }

    public String encode(String content) {
        JSONObject result = PermissionServiceHelper.encryptData((long)this.encryptId, (String)content);
        if (!result.getBoolean("success").booleanValue()) {
            log.info("PermissionServiceHelper encryptData error :{}", (Object)result.getString("description"));
            return "";
        }
        return result.getString("data");
    }

    public String decode(List<String> secretKeyList, String content) {
        try {
            if (EncryptLevelEnum.ENCRYPT_LEVEL_HIGH == this.encryptLevel) {
                content = this.personDecode(secretKeyList, content);
                content = this.leaderDecode(content);
            }
            content = this.decode(content);
            return content;
        }
        catch (Exception e) {
            log.error("decode error\uff1a{} msg \uff1a", (Object)e.getMessage());
            return null;
        }
    }

    public String decode(String content) {
        JSONObject result = PermissionServiceHelper.decryptData((long)this.encryptId, (String)content);
        if (!result.getBoolean("success").booleanValue()) {
            log.info("PermissionServiceHelper decryptData error :{}", (Object)result.getString("description"));
        }
        return result.getString("data");
    }

    private String getHashcode(String key) {
        String result = "";
        try {
            if (!"0".equals(this.encryptType.getCode())) {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
                byte[] hash = messageDigest.digest(key.getBytes(StandardCharsets.UTF_8));
                result = Hex.encodeHexString((byte[])hash);
            }
        }
        catch (Exception e) {
            log.info("getHashcode error : {}", (Object)e.getMessage());
        }
        return result;
    }

    private String leaderEncode(String content) {
        return this.encrypt(content, this.secretKey);
    }

    public String encrypt(String originalStr, String aesKey) {
        if (originalStr == null) {
            return null;
        }
        try {
            String encrypt = MultiEncrypters.encrypt((String)"AES/GCM/NoPadding", (String)aesKey, (int)256, (String)originalStr);
            return encrypt;
        }
        catch (Exception ex) {
            log.info("encrypt error : {}", (Object)ex.getMessage());
            return "";
        }
    }

    public String decrypt(String encryptStr, String aesKey) {
        if (encryptStr == null) {
            return null;
        }
        return MultiEncrypters.decrypt((String)"AES/GCM/NoPadding", (String)aesKey, (int)256, (String)encryptStr);
    }

    private String leaderDecode(String content) {
        return this.decrypt(content, this.secretKey);
    }

    private String personEncode(List<String> secretKeyList, String content) {
        String key = this.getPersonSecretKey(secretKeyList);
        return this.encrypt(content, key);
    }

    private String personDecode(List<String> secretKeyList, String content) {
        String key = this.getPersonSecretKey(secretKeyList);
        return this.decrypt(content, key);
    }

    private String getPersonSecretKey(List<String> secretKeyList) {
        if (secretKeyList == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        secretKeyList.forEach(sb::append);
        String result = this.getHashcode(sb.toString());
        return result.substring(0, 32);
    }

    private void initEncryptId() {
        EncryptionScheme scheme;
        if ((this.encryptId == null || this.encryptId == 0L) && (scheme = SchemeUtil.getEncryptionScheme((String)"STANDARD-AES-256")) != null) {
            this.encryptId = scheme.getPkId();
        }
    }

    private void initSecretKeyData() {
        if (EncryptLevelEnum.ENCRYPT_LEVEL_HIGH == this.encryptLevel) {
            SWCDataServiceHelper helper;
            DynamicObject dynamicObject;
            if (SWCStringUtils.isEmpty((String)this.secretKey) && (dynamicObject = (helper = new SWCDataServiceHelper("hsas_secretkey")).queryOne("id,secretkey", new QFilter[0])) != null) {
                String dataSrcretKey = dynamicObject.getString("secretkey");
                this.secretKey = SecretTableUtil.getDecryptKey(this.encryptType.getCode(), dataSrcretKey);
                this.secretKeyId = dynamicObject.getLong("id");
            }
            if (EncryptTypeEnum.ENCRYPT_TYPE_INTERNATIONAL == this.encryptType && SWCStringUtils.isNotEmpty((String)this.secretKey)) {
                this.secretKey = this.secretKey.substring(0, 32);
            }
        }
    }
}

