/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.export;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.KeyValue;
import kd.bos.mvc.export.ExcelWriter;
import kd.bos.web.actions.export.ExportSheetStyle;
import kd.swc.hsbp.business.export.SWCExportEntryHelper;
import kd.swc.hsbp.business.export.entity.ImportConfig;
import kd.swc.hsbp.common.entity.EntryColumnContainer;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ListExporter
extends ExcelWriter {
    protected SXSSFSheet sheet;
    protected ExportSheetStyle styles;
    protected List<KeyValue> fieldCaptions;
    protected EntityType entryType;
    protected int rowCount = 0;
    protected ImportConfig importConfig;

    public ListExporter(String sheetName, List<EntryColumnContainer> containers) {
        this.sheet = this.wb.createSheet(sheetName);
        this.styles = new ExportSheetStyle(this.wb);
        Map<String, KeyValue> captions = SWCExportEntryHelper.getEntryFieldCaptions(containers);
        this.fieldCaptions = new ArrayList<KeyValue>(captions.values());
        String[][] headArray = new String[SWCExportEntryHelper.calcSheetHeadHeight(containers)][captions.size()];
        SWCExportEntryHelper.fillSheetHeadArray(containers, headArray, 0, 0);
        SWCExportEntryHelper.setAndMergeHeadCell(this.sheet, headArray, this.styles, 0, containers);
        int[] colLenArray = this.getMaxColWidth(headArray, 0);
        this.setColumnWidth(colLenArray, containers);
        this.setBorderStyle(this.styles.getTitleStyle());
    }

    public ListExporter() {
    }

    public void write(List<List<Object>> dataRows) {
        for (List<Object> row : dataRows) {
            this.writeLine(row, ++this.rowCount);
        }
    }

    protected final void setColumnWidth(int[] colLenArray, List<EntryColumnContainer> containers) {
        int isHasRk = 0;
        if (containers != null && containers.size() >= 1 && "rk".equals(containers.get(0).getKey())) {
            isHasRk = 1;
        }
        for (int col = 0; col < colLenArray.length; ++col) {
            Integer widthContain;
            int width = (colLenArray[col] + 1) * 2 * 256;
            if (containers != null && containers.size() - 1 >= col + isHasRk && (widthContain = containers.get(col + isHasRk).getWidth()) != null && widthContain * 20 > width) {
                width = widthContain * 20;
            }
            this.sheet.setColumnWidth(col, width);
        }
    }

    protected final int[] getMaxColWidth(String[][] headArray, int rowIndex) {
        int[] result = new int[headArray[0].length];
        for (int i = rowIndex; i < headArray.length; ++i) {
            for (int j = 0; j < headArray[i].length; ++j) {
                int colLength = headArray[i][j] == null ? 0 : headArray[i][j].length();
                result[j] = result[j] > colLength ? result[j] : colLength;
            }
        }
        return result;
    }

    public void writeLine(List<Object> row, int rownum) {
        int col = 0;
        for (int i = 0; i < this.fieldCaptions.size(); ++i) {
            Object value = row.get(i);
            if (StringUtils.isBlank((Object)value)) {
                ++col;
                continue;
            }
            String align = "default";
            ListExporter.createCell((SXSSFWorkbook)this.wb, (SXSSFRow)ListExporter.getRow((SXSSFSheet)this.sheet, (int)rownum), (int)col++, (CellStyle)this.styles.getTextStyle(align)).setCellValue(value instanceof BigDecimal ? ((BigDecimal)value).toPlainString() : (value == null ? "" : value.toString()));
        }
    }

    protected final void setBorderStyle(CellStyle style) {
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
    }

    public EntityType getEntryType() {
        return this.entryType;
    }

    public void setEntryType(EntityType entryType) {
        this.entryType = entryType;
    }

    public ImportConfig getImportConfig() {
        return this.importConfig;
    }

    public void setImportConfig(ImportConfig importConfig) {
        this.importConfig = importConfig;
    }
}

