/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.formula.utils;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;

public class EnumConfigCacheUtils {
    public static Map<String, String> getEnumValue(Long enumId) {
        String key;
        ISWCAppCache appCache = SWCAppCache.get((String)"swc_enumconfig");
        Map<String, String> enumMap = (Map<String, String>)appCache.get(key = String.format(Locale.ROOT, "cal_enumconfig_cachekey_%s", enumId), Map.class);
        if (enumMap == null || enumMap.size() == 0) {
            enumMap = EnumConfigCacheUtils.getEnumMap(enumId);
            appCache.put(key, enumMap);
        }
        return (Map)appCache.get(key, Map.class);
    }

    private static Map<String, String> getEnumMap(Long enumId) {
        DynamicObject[] dyObjs;
        HashMap<String, String> enumMap = new HashMap<String, String>(16);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_enumconfig");
        String selectFields = "id,entryentity.enumvalue,entryentity.enumname";
        QFilter filter = new QFilter("id", "=", (Object)enumId);
        for (DynamicObject obj : dyObjs = helper.queryOriginalArray(selectFields, new QFilter[]{filter})) {
            String enumValue = obj.getString("entryentity.enumvalue");
            String enumName = obj.getString("entryentity.enumname");
            enumMap.put(enumValue, enumName);
        }
        return enumMap;
    }

    public static void putEnumValueToCache(Long enumId) {
        ISWCAppCache appCache = SWCAppCache.get((String)"swc_enumconfig");
        String enumCacheKey = String.format(Locale.ROOT, "cal_enumconfig_cachekey_%s", enumId);
        appCache.remove(enumCacheKey);
    }
}

