/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.formula.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.util.SWCDbUtil;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class FormulaCacheUtils {
    private static final Log logger = LogFactory.getLog(FormulaCacheUtils.class);

    public static Map<String, Set<String>> checkItemIsUsedForFormula(List<String> itemUniqueCodeList, String itemType) {
        logger.info("checkItemIsUsedForFormula begin,itemType = {}", (Object)itemType);
        String field = FormulaCacheUtils.getFieldByType(itemType);
        if (SWCStringUtils.isEmpty((String)field) || SWCListUtils.isEmpty(itemUniqueCodeList)) {
            return new HashMap<String, Set<String>>(0);
        }
        QFilter filter = new QFilter("datastatus", "in", (Object)new String[]{"0", "1", "2", "-3"});
        QFilter uniqueCodeFilter = null;
        for (String uniqueCode : itemUniqueCodeList) {
            if (uniqueCodeFilter == null) {
                uniqueCodeFilter = new QFilter(field, "like", (Object)("%" + uniqueCode + "%"));
                continue;
            }
            uniqueCodeFilter.or(field, "like", (Object)("%" + uniqueCode + "%"));
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_formula");
        String fields = field + ",id,name";
        DynamicObjectCollection formulaData = helper.queryOriginalCollection(fields, new QFilter[]{filter, uniqueCodeFilter});
        if (formulaData.size() == 0) {
            return new HashMap<String, Set<String>>(0);
        }
        HashMap<String, Set<String>> itemRelMap = new HashMap<String, Set<String>>(itemUniqueCodeList.size());
        for (DynamicObject formula : formulaData) {
            FormulaCacheUtils.dealItemData(formula, itemRelMap, itemUniqueCodeList, field);
        }
        logger.info("checkItemIsUsedForFormula end,itemType = {}", (Object)itemType);
        return itemRelMap;
    }

    private static void dealItemData(DynamicObject formula, Map<String, Set<String>> itemRelMap, List<String> itemUniqueCodeList, String field) {
        String itemStr = formula.getString(field);
        if (SWCStringUtils.isEmpty((String)itemStr)) {
            return;
        }
        String[] itemArray = itemStr.split(",");
        Set<String> tempSet = null;
        for (String itemUniqueCode : itemArray) {
            if (!itemUniqueCodeList.contains(itemUniqueCode)) continue;
            tempSet = itemRelMap.get(itemUniqueCode);
            if (tempSet == null) {
                tempSet = new HashSet<String>(16);
                itemRelMap.put(itemUniqueCode, tempSet);
            }
            tempSet.add(formula.getString("name"));
        }
    }

    private static String getFieldByType(String itemType) {
        String field = null;
        switch (itemType) {
            case "SL": {
                field = "dependonsitem";
                break;
            }
            case "BS": {
                field = "dependonbsitem";
                break;
            }
            case "FC": {
                field = "dependonfunc";
                break;
            }
            case "FT": {
                field = "dependonftitem";
                break;
            }
            case "AC": {
                field = "dependonacc";
                break;
            }
            case "BR": {
                field = "dependondatagrade";
                break;
            }
            case "SP": {
                field = "dependonspitem";
                break;
            }
        }
        return field;
    }

    public static Map<String, Integer> updateProgress(ISWCAppCache appCache, int successCount, int failCount, int onlyPreCalCount, String cacheKey) {
        Integer existSuccessCount;
        HashMap<String, Integer> calProgressMap = (HashMap<String, Integer>)appCache.get(cacheKey, Map.class);
        if (calProgressMap == null || calProgressMap.size() == 0) {
            calProgressMap = new HashMap<String, Integer>(3);
        }
        if ((existSuccessCount = (Integer)calProgressMap.get("sucesscount")) == null) {
            existSuccessCount = 0;
        }
        existSuccessCount = existSuccessCount + successCount;
        Integer existOnlyPreCalCount = (Integer)calProgressMap.get("onlyPreCalCount");
        if (existOnlyPreCalCount == null) {
            existOnlyPreCalCount = 0;
        }
        existOnlyPreCalCount = existOnlyPreCalCount + onlyPreCalCount;
        Integer existFailCount = (Integer)calProgressMap.get("failcount");
        if (existFailCount == null) {
            existFailCount = 0;
        }
        existFailCount = existFailCount + failCount;
        calProgressMap.put("sucesscount", existSuccessCount);
        calProgressMap.put("failcount", existFailCount);
        calProgressMap.put("onlyPreCalCount", existOnlyPreCalCount);
        logger.info("updateProgress,success:{},fail:{},cacheKey:{}", new Object[]{existSuccessCount, existFailCount, cacheKey});
        appCache.put(cacheKey, calProgressMap);
        return calProgressMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Integer> getCalProgerssFromPage(long calRecordId, String cacheKey) {
        ISWCAppCache calProgressAppCache = SWCAppCache.get((String)String.format(Locale.ROOT, "CACHE_SWC_CAL_PROGRESS_KEY_%s", calRecordId));
        String lockKey = "_swcCalUpdateSaveProcess_" + calRecordId;
        DLock lock = DLock.create((String)lockKey);
        try {
            if (lock.tryLock(30000L)) {
                Map calProgressMap = (Map)calProgressAppCache.get(cacheKey, Map.class);
                if (calProgressMap != null) {
                    Map map = calProgressMap;
                    return map;
                }
                FormulaCacheUtils.updateCalProgressFromDB(calRecordId);
                Map map = calProgressMap = (Map)calProgressAppCache.get(cacheKey, Map.class);
                return map;
            }
        }
        catch (Exception ex) {
            logger.error("getCalProgerssFromPage error.", (Throwable)ex);
        }
        finally {
            lock.unlock();
            lock.close();
        }
        return new HashMap<String, Integer>(0);
    }

    public static void updateCalProgressFromDB(long calRecordId) {
        logger.info("updateCalProgressFromDB start,recordId = {}", (Object)calRecordId);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_caldetail");
        QFilter filter = new QFilter("record", "=", (Object)calRecordId);
        DynamicObjectCollection calDetailData = helper.queryOriginalCollection("calpersonid", new QFilter[]{filter});
        if (calDetailData.size() == 0) {
            return;
        }
        List<Long> calPersonIdList = calDetailData.stream().map(obj -> obj.getLong("calpersonid")).collect(Collectors.toList());
        String querySql = "SELECT FCALSTATUS ,COUNT(FID) NUM FROM T_HSAS_CALPERSON_S WHERE FID IN (" + FormulaCacheUtils.getParamsByData(calPersonIdList) + ") GROUP BY FCALSTATUS";
        Object[] params = new Object[calPersonIdList.size()];
        calPersonIdList.toArray(params);
        HashMap<String, Integer> calStatusCountMap = new HashMap<String, Integer>(16);
        try (DataSet dateSet = SWCDbUtil.queryDataSet((String)"queryCalStatusCountService", (DBRoute)SWCConstants.SWC_ROUETE, (String)querySql, (Object[])params);){
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                calStatusCountMap.put(row.getString("FCALSTATUS"), row.getInteger("NUM"));
            }
        }
        int preSucCount = 0;
        int preFailCount = 0;
        int taxSucCount = 0;
        int taxFailCount = 0;
        int afterSucCount = 0;
        int afterFailCount = 0;
        int onlyPreCalCount = 0;
        for (Map.Entry entry : calStatusCountMap.entrySet()) {
            if (CalStateEnum.PRECAL_ERROR.getCode().equals(entry.getKey())) {
                preFailCount += ((Integer)entry.getValue()).intValue();
                taxFailCount += ((Integer)entry.getValue()).intValue();
                afterFailCount += ((Integer)entry.getValue()).intValue();
                continue;
            }
            if (CalStateEnum.PUSHTAX_ERROR.getCode().equals(entry.getKey()) || CalStateEnum.TAXCAL_ERROR.getCode().equals(entry.getKey()) || CalStateEnum.PULLTAX_ERROR.getCode().equals(entry.getKey())) {
                taxFailCount += ((Integer)entry.getValue()).intValue();
                afterFailCount += ((Integer)entry.getValue()).intValue();
                preSucCount += ((Integer)entry.getValue()).intValue();
                continue;
            }
            if (CalStateEnum.AFTERCAL_ERROR.getCode().equals(entry.getKey())) {
                afterFailCount += ((Integer)entry.getValue()).intValue();
                taxSucCount += ((Integer)entry.getValue()).intValue();
                preSucCount += ((Integer)entry.getValue()).intValue();
                continue;
            }
            if (CalStateEnum.ALL_CALED.getCode().equals(entry.getKey())) {
                taxSucCount += ((Integer)entry.getValue()).intValue();
                preSucCount += ((Integer)entry.getValue()).intValue();
                afterSucCount += ((Integer)entry.getValue()).intValue();
                continue;
            }
            if (CalStateEnum.TAX_CALED.getCode().equals(entry.getKey())) {
                taxSucCount += ((Integer)entry.getValue()).intValue();
                preSucCount += ((Integer)entry.getValue()).intValue();
                continue;
            }
            if (CalStateEnum.PRECAL_CALED.getCode().equals(entry.getKey())) {
                preSucCount += ((Integer)entry.getValue()).intValue();
                continue;
            }
            if (!CalStateEnum.PARTIAL_CALED.getCode().equals(entry.getKey())) continue;
            preSucCount += ((Integer)entry.getValue()).intValue();
            onlyPreCalCount += ((Integer)entry.getValue()).intValue();
        }
        HashMap<String, Integer> preCalProgressMap = new HashMap<String, Integer>(3);
        preCalProgressMap.put("sucesscount", preSucCount);
        preCalProgressMap.put("failcount", preFailCount);
        preCalProgressMap.put("onlyPreCalCount", onlyPreCalCount);
        HashMap<String, Integer> taxCalProgressMap = new HashMap<String, Integer>(3);
        taxCalProgressMap.put("sucesscount", taxSucCount);
        taxCalProgressMap.put("failcount", taxFailCount);
        taxCalProgressMap.put("onlyPreCalCount", onlyPreCalCount);
        HashMap<String, Integer> afterCalProgressMap = new HashMap<String, Integer>(3);
        afterCalProgressMap.put("sucesscount", afterSucCount);
        afterCalProgressMap.put("failcount", afterFailCount);
        afterCalProgressMap.put("onlyPreCalCount", onlyPreCalCount);
        ISWCAppCache calProgressAppCache = SWCAppCache.get((String)String.format(Locale.ROOT, "CACHE_SWC_CAL_PROGRESS_KEY_%s", calRecordId));
        calProgressAppCache.put(String.format(Locale.ROOT, "pretax_cal_progress_%s", calRecordId), preCalProgressMap);
        calProgressAppCache.put(String.format(Locale.ROOT, "tax_cal_progress_%s", calRecordId), taxCalProgressMap);
        calProgressAppCache.put(String.format(Locale.ROOT, "calrecord_progress_%s", calRecordId), afterCalProgressMap);
        logger.info("preSucCount:{},preFailCount:{},taxSucCount:{},taxFailCount:{},afterSucCount:{},afterFailCount:{}", new Object[]{preSucCount, preFailCount, taxSucCount, taxFailCount, afterSucCount, afterFailCount});
        logger.info("updateCalProgressFromDB end,recordId = {}", (Object)calRecordId);
    }

    private static String getParamsByData(List<Long> paramList) {
        StringBuilder param = new StringBuilder();
        if (SWCListUtils.isEmpty(paramList)) {
            return param.append(' ').toString();
        }
        paramList.forEach(key -> param.append('?').append(','));
        return param.substring(0, param.length() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updatePushDataToTaxCount(ISWCAppCache appCache, int totalCount, int pushedCount, long calRecordId) {
        String lockKey = "_updatePushedToTaxCount_" + calRecordId;
        boolean isFinish = false;
        DLock lock = DLock.create((String)lockKey);
        try {
            if (lock.tryLock(8000L)) {
                String cacheKey = String.format(Locale.ROOT, "updatePushToTaxCount_%s", calRecordId);
                HashMap<String, Integer> pushedMap = (HashMap<String, Integer>)appCache.get(cacheKey, Map.class);
                if (pushedMap == null) {
                    pushedMap = new HashMap<String, Integer>(2);
                }
                Integer existTotalCount = (Integer)pushedMap.get("totalCount");
                Integer existPushedCount = (Integer)pushedMap.get("pushedCount");
                if (existTotalCount == null) {
                    existTotalCount = 0;
                }
                if (existPushedCount == null) {
                    existPushedCount = 0;
                }
                existTotalCount = existTotalCount + totalCount;
                existPushedCount = existPushedCount + pushedCount;
                pushedMap.put("totalCount", existTotalCount);
                pushedMap.put("pushedCount", existPushedCount);
                appCache.put(cacheKey, pushedMap);
                if (existTotalCount.equals(existPushedCount)) {
                    isFinish = true;
                    appCache.remove(cacheKey);
                }
            }
        }
        finally {
            lock.unlock();
            lock.close();
        }
        return isFinish;
    }
}

