/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.historynew;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.operate.MutexHelper;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisVersionChangeService;
import kd.hr.hbp.common.constants.newhismodel.EnumHisOperateType;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class BaseDataHisHelper {
    private static final Log logger = LogFactory.getLog(BaseDataHisHelper.class);

    public static QFilter getHisCurrFilter() {
        return new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE);
    }

    public static void addHisCurrFilter(QFilter filter) {
        if (filter == null) {
            return;
        }
        filter.and(BaseDataHisHelper.getHisCurrFilter());
    }

    public static QFilter getHisVerFilter() {
        return new QFilter("iscurrentversion", "=", (Object)Boolean.FALSE);
    }

    public static void addHisVerFilter(QFilter filter) {
        if (filter == null) {
            return;
        }
        filter.and(BaseDataHisHelper.getHisVerFilter());
    }

    public static boolean isCurrPage(IFormView view) {
        return !BaseDataHisHelper.isHisPage(view);
    }

    public static boolean isHisPage(IFormView view) {
        Map params = view.getFormShowParameter().getCustomParams();
        Object fromPage = params.get("fromPage");
        return fromPage != null && "fromHisAction".equals(fromPage);
    }

    public static boolean isCurrList(IFormView view) {
        return !BaseDataHisHelper.isHisList(view);
    }

    public static boolean isHisList(IFormView view) {
        Map params = view.getFormShowParameter().getCustomParams();
        return "hisinfolist".equals(params.get("hisinfolist")) || "showhisversion".equals(params.get("option"));
    }

    public static void saveTempVersion(DynamicObject[] dataCol) {
        HisVersionParamBo hisVersionParamBo = new HisVersionParamBo();
        hisVersionParamBo.setEntityNumber(dataCol[0].getDataEntityType().getName());
        hisVersionParamBo.setHisDyns(dataCol);
        hisVersionParamBo.setNeedValidateDate(false);
        hisVersionParamBo.setAtomicTrans(false);
        HisVersionChangeService.getInstance().saveTempVersion(hisVersionParamBo);
    }

    public static HisResponse<VersionChangeRespData> saveTimeVersion(DynamicObject[] hisDyns, boolean effImmediately) {
        if (hisDyns == null || hisDyns.length == 0) {
            return null;
        }
        HisModelController hisModelController = new HisModelController();
        HisVersionParamBo hisVersionParamBo = new HisVersionParamBo();
        hisVersionParamBo.setEffImmediately(effImmediately);
        hisVersionParamBo.setOperateType(EnumHisOperateType.SAVE_VERSION.getType());
        hisVersionParamBo.setHisDyns(hisDyns);
        hisVersionParamBo.setEntityNumber(hisDyns[0].getDataEntityType().getName());
        hisVersionParamBo.setCancel_notSupported(true);
        hisVersionParamBo.setAtomicTrans(false);
        HisResponse res = hisModelController.hisVersionChange(hisVersionParamBo);
        return res;
    }

    public static HisResponse<VersionChangeRespData> saveTimeVersion(DynamicObject[] hisDyns, boolean effImmediately, Long eventId) {
        if (hisDyns == null || hisDyns.length == 0) {
            return null;
        }
        long start1 = System.currentTimeMillis();
        HisModelController hisModelController = new HisModelController();
        HisVersionParamBo hisVersionParamBo = new HisVersionParamBo();
        hisVersionParamBo.setEffImmediately(effImmediately);
        hisVersionParamBo.setOperateType(EnumHisOperateType.SAVE_VERSION.getType());
        hisVersionParamBo.setHisDyns(hisDyns);
        hisVersionParamBo.setEntityNumber(hisDyns[0].getDataEntityType().getName());
        hisVersionParamBo.setCancel_notSupported(true);
        hisVersionParamBo.setAtomicTrans(false);
        hisVersionParamBo.setEventId(eventId);
        HisResponse res = hisModelController.hisVersionChange(hisVersionParamBo);
        long end1 = System.currentTimeMillis();
        logger.info("HisModelController#hisVersionChange params size is {}, spend time is\uff1a{}", (Object)hisDyns.length, (Object)(end1 - start1));
        return res;
    }

    public static HisResponse<VersionChangeRespData> saveNoTimeVersion(DynamicObject[] hisDyns, boolean effImmediately) {
        if (hisDyns == null || hisDyns.length == 0) {
            return null;
        }
        HisModelController hisModelController = new HisModelController();
        HisVersionParamBo hisVersionParamBo = new HisVersionParamBo();
        hisVersionParamBo.setEffImmediately(effImmediately);
        hisVersionParamBo.setOperateType(EnumHisOperateType.NO_TIME_SAVE_VERSION.getType());
        hisVersionParamBo.setHisDyns(hisDyns);
        hisVersionParamBo.setEntityNumber(hisDyns[0].getDataEntityType().getName());
        hisVersionParamBo.setCancel_notSupported(true);
        hisVersionParamBo.setAtomicTrans(false);
        HisResponse res = hisModelController.noLineTimeHisVersionChange(hisVersionParamBo);
        return res;
    }

    public static void openHisListPage(IFormView view, String formId, Long boId, boolean isLeftTree, String caption) {
        ListShowParameter showParam = BaseDataHisHelper.getOpenHisListPageParam(view, formId, boId, isLeftTree, caption);
        view.showForm((FormShowParameter)showParam);
    }

    public static ListShowParameter getOpenHisListPageParam(IFormView view, String formId, Long boId, boolean isLeftTree, String caption) {
        ListShowParameter showParam = new ListShowParameter();
        showParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParam.setParentPageId(view.getPageId());
        showParam.setBillFormId(formId);
        if (isLeftTree) {
            showParam.setFormId("hsbp_adminorgtreelist");
        } else {
            showParam.setFormId("bos_list");
        }
        showParam.setCustomParam("option", (Object)"showhisversion");
        showParam.setCustomParam("hisinfolist", (Object)"hisinfolist");
        showParam.setCustomParam("notOpenDefaultHyperLink", (Object)"number");
        if (boId != null) {
            showParam.setCustomParam("boid", (Object)boId);
            QFilter qFilter1 = new QFilter("boid", "=", (Object)boId);
            showParam.getListFilterParameter().getQFilters().add(qFilter1);
        }
        QFilter qFilter2 = new QFilter("iscurrentversion", "=", (Object)Boolean.FALSE);
        showParam.getListFilterParameter().getQFilters().add(qFilter2);
        if (caption != null) {
            showParam.setCaption(caption);
        }
        return showParam;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkMutexLock(IFormView formView, String entityId, String pkId) {
        String groupId = MutexHelper.getMutexGroupId((String)entityId, (String)"modify");
        DataMutex dataMutex = DataMutex.create();
        try {
            Map<String, String> lockInfo = BaseDataHisHelper.getMutexLockInfo(entityId, pkId, groupId, dataMutex);
            if (null != lockInfo && !lockInfo.isEmpty()) {
                BaseDataHisHelper.showMutexNotification(lockInfo, formView);
                boolean bl = true;
                return bl;
            }
            dataMutex.close();
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (dataMutex != null) {
                    dataMutex.close();
                }
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    private static Map<String, String> getMutexLockInfo(String entityId, String pkId, String groupId, DataMutex dataMutex) {
        return dataMutex.getLockInfo(pkId, groupId, entityId);
    }

    private static void showMutexNotification(Map<String, String> lockInfo, IFormView formView) {
        Map userInfo;
        String userId = lockInfo.get("userid");
        String operateKey = lockInfo.get("opkey");
        if (!SWCStringUtils.isEmpty((String)userId) && SWCStringUtils.equals((String)operateKey, (String)"modify") && null != (userInfo = UserServiceHelper.getUserInfoByID((long)Long.parseLong(userId)))) {
            String userName = (String)userInfo.get("name");
            if (!SWCStringUtils.isEmpty((String)userName)) {
                formView.showTipNotification(ResManager.loadKDString((String)"{0}\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u5f53\u524d\u65e0\u6cd5\u8fdb\u884c\u4fee\u6539\u3002", (String)"BaseDataHisHelper_0", (String)"swc-hsbp-formplugin", (Object[])new Object[]{userName}));
            } else {
                formView.showTipNotification(ResManager.loadKDString((String)"\u7f51\u7edc\u4e92\u65a5\u68c0\u6d4b\u51fa\u6709\u4eba\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u5f53\u524d\u65e0\u6cd5\u8fdb\u884c\u4fee\u6539\u3002", (String)"SWCHisBlockBaseDataEdit_1", (String)"swc-hsbp-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public static Set<Long> getUsableId(String entityNumber, Collection<Long> pkIds) {
        DynamicObject[] objArr = new SWCDataServiceHelper(entityNumber).query("id,enable,status", new QFilter[]{new QFilter("id", "in", pkIds), new QFilter("enable", "=", (Object)"1"), new QFilter("status", "=", (Object)"C")});
        return Arrays.stream(objArr).map(obj -> obj.getLong("id")).collect(Collectors.toSet());
    }

    public static Map<Long, Long> getVersionOfCurrent(String entityNumber, Collection<Long> pkIds) {
        DynamicObject[] currObjArr = new SWCDataServiceHelper(entityNumber).query("id,sourcevid", new QFilter[]{new QFilter("id", "in", pkIds)});
        return Arrays.stream(currObjArr).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("sourcevid"), (o1, o2) -> o2));
    }

    public static Map<Long, Long> getCurrentOfVersion(String entityNumber, Collection<Long> vids) {
        DynamicObject[] currObjArr = new SWCDataServiceHelper(entityNumber).query("id,boid", new QFilter[]{new QFilter("id", "in", vids)});
        return Arrays.stream(currObjArr).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("boid"), (o1, o2) -> o2));
    }

    public static DynamicObject[] getAllVersionByBoId(String entityNumber, Collection<Long> boIds) {
        return new SWCDataServiceHelper(entityNumber).query("bsled,bsed,id,boid", new QFilter[]{new QFilter("boid", "in", boIds), new QFilter("enable", "=", (Object)"1"), new QFilter("status", "=", (Object)"C"), new QFilter("id", "not in", boIds), new QFilter("datastatus", "in", (Object)new String[]{"1", "2", "0"})});
    }

    public static void removeDefaultHRQFilter(IFormView formView, List<QFilter> qFilters) {
        if (BaseDataHisHelper.isHisList(formView) && formView.getFormShowParameter().getCustomParam("removeHrDatastatusFilter") != null) {
            Iterator<QFilter> it = qFilters.iterator();
            while (it.hasNext()) {
                Set valSet;
                QFilter filter = it.next();
                if (filter == null) continue;
                Object valObj = filter.getValue();
                if (!"datastatus".equals(filter.getProperty()) || !"in".equals(filter.getCP()) || !(valObj instanceof Set) || (valSet = (Set)valObj).size() != 4 || !valSet.contains("0") || !valSet.contains("1") || !valSet.contains("2") || !valSet.contains("-3")) continue;
                it.remove();
            }
        }
    }
}

