/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.log;

import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.operate.FormOperate;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.service.ServiceFactory;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SWCOpLogServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(SWCOpLogServiceHelper.class);

    public static void addOpLog(IFormView formView, String opKey, String keyWord, MultiLangEnumBridge opDescBridge, String ... opDescArgs) {
        OpLogAppInfo opLogAppInfo = new OpLogAppInfo();
        SWCOpLogServiceHelper.setOpLogAppInfo(formView, opLogAppInfo);
        if (SWCStringUtils.isNotEmpty((String)keyWord)) {
            opLogAppInfo.setKeyWord(keyWord);
        }
        String opName = SWCOpLogServiceHelper.getOpNameByEntityAndOpKey(opLogAppInfo.getBizObjID(), opKey);
        opLogAppInfo.setOpName(opKey, opName);
        opLogAppInfo.setOpDesc(opDescBridge, opDescArgs);
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        logService.addLog((AppLogInfo)opLogAppInfo);
    }

    public static void addOpLog(String appNumber, String billFormId, String opKey, String keyWord, MultiLangEnumBridge opDescBridge, String ... opDescArgs) {
        OpLogAppInfo opLogAppInfo = new OpLogAppInfo();
        String appId = SWCOpLogServiceHelper.getAppIdByAppNumber(appNumber);
        opLogAppInfo.setBizAppID(appId);
        opLogAppInfo.setBizObjID(billFormId);
        SWCOpLogServiceHelper.getOpNameByEntityAndOpKey(billFormId, opKey);
        if (SWCStringUtils.isNotEmpty((String)keyWord)) {
            opLogAppInfo.setKeyWord(keyWord);
        }
        String opName = SWCOpLogServiceHelper.getOpNameByEntityAndOpKey(opLogAppInfo.getBizObjID(), opKey);
        opLogAppInfo.setOpName(opKey, opName);
        opLogAppInfo.setOpDesc(opDescBridge, opDescArgs);
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        logService.addLog((AppLogInfo)opLogAppInfo);
    }

    private static String getOpNameByEntityAndOpKey(String billFormId, String opKey) {
        String opName = null;
        try {
            FormOperate formOperation = (FormOperate)FormMetadataCache.getFormOperation((String)billFormId, (String)opKey);
            opName = "";
            if (formOperation != null) {
                opName = formOperation.getOperateName().getLocaleValue_zh_CN();
            }
        }
        catch (Exception e) {
            LOGGER.error("getOpNameByEntityAndOpKey error {} ... billFormId {}", (Object)e, (Object)billFormId);
        }
        return opName;
    }

    public static void addOpLog(IFormView formView, String opKey, MultiLangEnumBridge opNameBridge, String keyWord, MultiLangEnumBridge opDescBridge, String ... opDescArgs) {
        OpLogAppInfo opLogAppInfo = new OpLogAppInfo();
        SWCOpLogServiceHelper.setOpLogAppInfo(formView, opLogAppInfo);
        if (SWCStringUtils.isNotEmpty((String)keyWord)) {
            opLogAppInfo.setKeyWord(keyWord);
        }
        opLogAppInfo.setOpName(opKey, opNameBridge);
        opLogAppInfo.setOpDesc(opDescBridge, opDescArgs);
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        logService.addLog((AppLogInfo)opLogAppInfo);
    }

    public static void addOpLog(String appNumber, String billFormId, String opKey, MultiLangEnumBridge opNameBridge, String keyWord, MultiLangEnumBridge opDescBridge, String ... opDescArgs) {
        OpLogAppInfo opLogAppInfo = new OpLogAppInfo();
        String appId = SWCOpLogServiceHelper.getAppIdByAppNumber(appNumber);
        opLogAppInfo.setBizAppID(appId);
        opLogAppInfo.setBizObjID(billFormId);
        if (SWCStringUtils.isNotEmpty((String)keyWord)) {
            opLogAppInfo.setKeyWord(keyWord);
        }
        opLogAppInfo.setOpName(opKey, opNameBridge);
        opLogAppInfo.setOpDesc(opDescBridge, opDescArgs);
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        logService.addLog((AppLogInfo)opLogAppInfo);
    }

    private static String getAppIdByAppNumber(String appNumber) {
        AppInfo appInfo;
        String appId = " ";
        if (StringUtils.isNotEmpty((CharSequence)appNumber) && null != (appInfo = AppMetadataCache.getAppInfo((String)appNumber))) {
            appId = appInfo.getId();
        }
        return appId;
    }

    private static void setOpLogAppInfo(IFormView formView, OpLogAppInfo opLogAppInfo) {
        AppInfo appInfo;
        String billFormId = formView instanceof ListView ? ((ListView)formView).getBillFormId() : formView.getEntityId();
        opLogAppInfo.setBizObjID(billFormId);
        String appNumber = formView.getFormShowParameter().getAppId();
        String appId = " ";
        if (StringUtils.isNotEmpty((CharSequence)appNumber) && null != (appInfo = AppMetadataCache.getAppInfo((String)appNumber))) {
            appId = appInfo.getId();
        }
        opLogAppInfo.setBizAppID(appId);
    }
}

