/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.perbankcard;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dlock.DLock;
import kd.swc.hsbp.business.servicehelper.SWCSalaryParameterServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;

public class PerBankcardServiceHelper {
    private static final String HSBS_BANKCARD_PARAM = "hsbs_bankcardparam";
    private static final String PERBANKCARD = "perbankcard";

    public static void setBankCardCacheMap() {
        Map<String, Object> paramMap = SWCSalaryParameterServiceHelper.getSalaryParam(PERBANKCARD);
        ISWCAppCache appCache = SWCAppCache.get((String)HSBS_BANKCARD_PARAM);
        appCache.put(HSBS_BANKCARD_PARAM, paramMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getBankCardParam() {
        ISWCAppCache appCache = SWCAppCache.get((String)HSBS_BANKCARD_PARAM);
        Map paramMap = (Map)appCache.get(HSBS_BANKCARD_PARAM, Map.class);
        if (paramMap == null) {
            DLock lock = DLock.create((String)HSBS_BANKCARD_PARAM);
            try {
                if (lock.tryLock(5000L)) {
                    paramMap = (Map)appCache.get(HSBS_BANKCARD_PARAM, Map.class);
                    if (paramMap == null && (paramMap = SWCSalaryParameterServiceHelper.getSalaryParam(PERBANKCARD)) != null) {
                        appCache.put(HSBS_BANKCARD_PARAM, paramMap);
                        Map map = paramMap;
                        return map;
                    }
                    paramMap = new HashMap<String, Object>(16);
                    appCache.put(HSBS_BANKCARD_PARAM, paramMap);
                    Map map = paramMap;
                    return map;
                }
            }
            catch (Exception e) {
                Map map = Collections.emptyMap();
                return map;
            }
            finally {
                lock.unlock();
                lock.close();
            }
        }
        return paramMap;
    }

    private static Boolean getParamKeyStatus(String paramKey) {
        Map bankCardParam = PerBankcardServiceHelper.getBankCardParam();
        if (bankCardParam == null) {
            return Boolean.FALSE;
        }
        return bankCardParam.getOrDefault(paramKey, Boolean.FALSE);
    }

    public static Boolean getAuditStatus() {
        return PerBankcardServiceHelper.getParamKeyStatus("needaudit");
    }

    public static Boolean getUpdateSettingStatus() {
        return PerBankcardServiceHelper.getParamKeyStatus("needupdateset");
    }
}

