/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.proration;

import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;

public class HandleProrationHelper {
    private static final Log logger = LogFactory.getLog(HandleProrationHelper.class);

    public static QFilter getDateFilter(Date startDate, Date endDate) {
        QFilter filter = new QFilter("bsed", "<=", (Object)endDate);
        QFilter brledFilter = new QFilter("bsled", ">", (Object)startDate);
        brledFilter.or(QFilter.isNull((String)"bsled"));
        filter.and(brledFilter);
        return filter;
    }

    public static Date replaceDateTime(Date date, String hhmmss) {
        if (StringUtils.isEmpty((CharSequence)hhmmss)) {
            return date;
        }
        String dateStr = SWCDateTimeUtils.format((Date)date, (String)"yyyy-MM-dd");
        try {
            return SWCDateTimeUtils.parseDate((String)(dateStr + " " + hhmmss), (String)"yyyy-MM-dd HH:mm:ss");
        }
        catch (ParseException e) {
            logger.error((Throwable)e);
            return null;
        }
    }

    public static Map<Long, List<DynamicObject>> getCaltableProrationData(List<Long> calTableIdList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        String selectProperties = "id, calstatus, paystatus, onholdstatus,calmainid,taxstatus";
        QFilter qFilter = new QFilter("id", "in", calTableIdList).or("calmainid", "in", calTableIdList);
        DynamicObject[] calTables = helper.query(selectProperties, new QFilter[]{qFilter});
        if (calTables == null || calTables.length == 0) {
            return null;
        }
        Map<Long, List<DynamicObject>> calTableListMap = Arrays.stream(calTables).collect(Collectors.groupingBy(calTable -> calTable.getLong("calmainid")));
        return calTableListMap;
    }

    public static DynamicObject[] getProrationChildDataList(List<Long> calTableIdList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_caltable");
        QFilter qFilter = new QFilter("calmainid", "in", calTableIdList);
        DynamicObject[] calTables = helper.query("calmainid,calstate, paystate, onholdstatus, allotstatus", new QFilter[]{qFilter});
        return calTables;
    }

    public static String getDataRange(Date startDate, Date endDate) {
        String startDateStr = SWCDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd");
        String endDateStr = SWCDateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd");
        return startDateStr + "@" + endDateStr;
    }
}

