/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.record;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.BackgroundTaskSubscriber;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCJSONUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class TaskRecordHelper {
    private static final Log LOGGER = LogFactory.getLog(TaskRecordHelper.class);
    private static final String HSBS_TASKRECORD = "hsbs_taskrecord";
    public static final String TASK_STATUS_FINISH = "1";
    public static final String TASK_STATUS_IN_PROGRESS = "2";
    public static final String TASK_STATUS_CANCEL = "3";
    public static final String TASK_TYPE_CAL = "1";
    public static final String TASK_TYPE_IMPORT = "2";
    public static final String TASK_TYPE_EXPORT = "3";
    public static final String TASK_TYPE_ADDPER = "4";
    public static final String TASK_TYPE_PRORATION = "5";
    public static final String TASK_TYPE_COSTALLOCATION = "6";
    public static final String TASK_TYPE_BANKOFFER = "7";
    public static final String TASK_TYPE_CALTABLE = "8";
    public static final String TASK_TYPE_PAYSETTINGUPDATE = "9";
    public static final String PARENT_PAGE_KEY = "parent_page_{0}";

    public static Long saveTaskRecordData(String userId, Long businessTaskId, JobFormInfo jobFormInfo, String taskType) {
        SWCDataServiceHelper taskRecordHelper = new SWCDataServiceHelper(HSBS_TASKRECORD);
        Date nowDate = new Date();
        DynamicObject taskRecord = taskRecordHelper.generateEmptyDynamicObject();
        taskRecord.set("businesstaskid", (Object)businessTaskId);
        taskRecord.set("starttime", (Object)nowDate);
        try {
            taskRecord.set("platforminfo", (Object)SWCJSONUtils.toString((Object)jobFormInfo));
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e);
            return null;
        }
        taskRecord.set("taskstatus", (Object)"2");
        taskRecord.set("tasktype", (Object)taskType);
        taskRecord.set("description", (Object)jobFormInfo.getJobInfo().getName());
        taskRecord.set("platformtaskid", (Object)jobFormInfo.getJobInfo().getTaskId());
        taskRecord.set("createtime", (Object)nowDate);
        taskRecord.set("modifytime", (Object)nowDate);
        taskRecord.set("creator", (Object)Long.valueOf(userId));
        taskRecord.set("modifier", (Object)Long.valueOf(userId));
        taskRecordHelper.saveOne(taskRecord);
        return taskRecord.getLong("id");
    }

    public static void updateTaskRecordStatus(String userId, Long id, String taskStatus) {
        if (id == null || StringUtils.isEmpty((CharSequence)taskStatus)) {
            return;
        }
        SWCDataServiceHelper taskRecordHelper = new SWCDataServiceHelper(HSBS_TASKRECORD);
        DynamicObject taskRecord = taskRecordHelper.queryOne(id);
        if (taskRecord == null) {
            return;
        }
        if (!"2".equals(taskRecord.get("taskstatus"))) {
            return;
        }
        taskRecord.set("taskstatus", (Object)taskStatus);
        taskRecord.set("modifytime", (Object)new Date());
        if (!StringUtils.isEmpty((CharSequence)userId)) {
            taskRecord.set("modifier", (Object)userId);
        }
        taskRecordHelper.updateOne(taskRecord);
    }

    public static void batchUpdateTaskRecordStatus(Long userId, Long[] ids, String taskStatus) {
        if (ids == null || ids.length <= 0 || StringUtils.isEmpty((CharSequence)taskStatus)) {
            return;
        }
        SWCDataServiceHelper taskRecordHelper = new SWCDataServiceHelper(HSBS_TASKRECORD);
        DynamicObject[] taskRecords = taskRecordHelper.query(ids);
        if (taskRecords == null || taskRecords.length <= 0) {
            return;
        }
        ArrayList<DynamicObject> updatedList = new ArrayList<DynamicObject>(taskRecords.length);
        for (DynamicObject taskRecord : taskRecords) {
            if (!"2".equals(taskRecord.get("taskstatus"))) continue;
            taskRecord.set("taskstatus", (Object)taskStatus);
            taskRecord.set("modifytime", (Object)new Date());
            if (userId != null) {
                taskRecord.set("modifier", (Object)userId);
            }
            updatedList.add(taskRecord);
        }
        if (CollectionUtils.isEmpty(updatedList)) {
            return;
        }
        DynamicObject[] updatedArray = new DynamicObject[updatedList.size()];
        taskRecordHelper.update(updatedList.toArray(updatedArray));
    }

    public static DynamicObjectCollection queryTaskRecords(Long userId, String taskStatus, String taskType) {
        SWCDataServiceHelper taskRecordHelper = new SWCDataServiceHelper(HSBS_TASKRECORD);
        QFilter filter = new QFilter("1", "=", (Object)1);
        if (!SWCObjectUtils.isEmpty((Object)userId)) {
            filter.and(new QFilter("creator", "=", (Object)userId));
        }
        if (!SWCStringUtils.isEmpty((String)taskStatus)) {
            filter.and(new QFilter("taskstatus", "=", (Object)taskStatus));
        }
        if (!SWCStringUtils.isEmpty((String)taskType)) {
            filter.and(new QFilter("tasktype", "=", (Object)taskType));
        }
        String selectProperties = "id,businesstaskid,platformtaskid,platforminfo";
        QFilter[] filters = new QFilter[]{filter};
        return taskRecordHelper.queryOriginalCollection(selectProperties, filters, "createtime asc");
    }

    public static boolean showTask(IFormView view, JobFormInfo jobFormInfo, String taskId, String rootPageId) {
        if (jobFormInfo == null || SWCStringUtils.isEmpty((String)taskId)) {
            return false;
        }
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (taskInfo == null || taskInfo.isTaskEnd()) {
            return false;
        }
        if (TaskClientProxy.isExistTask((String)taskId)) {
            String openPageId = jobFormInfo.getRootPageId();
            jobFormInfo.setRootPageId(rootPageId);
            TaskClientProxy.delTask((JobFormInfo)jobFormInfo, (String)taskId, null);
            jobFormInfo.setRootPageId(openPageId);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            LOGGER.error((Throwable)e);
        }
        if (SWCStringUtils.isEmpty((String)taskInfo.getId())) {
            return false;
        }
        TaskClientProxy.addTask((IFormView)view, (JobFormInfo)jobFormInfo, (TaskInfo)taskInfo);
        BackgroundTaskSubscriber subscriber = new BackgroundTaskSubscriber(RequestContext.get(), jobFormInfo, taskId);
        ThreadPools.executeOnce((String)"task-background-monitor", (Runnable)subscriber);
        return true;
    }

    public static void delTask(String taskId, JobFormInfo jobFormInfo, String rootPageId) {
        jobFormInfo.setRootPageId(rootPageId);
        TaskClientProxy.delTask((JobFormInfo)jobFormInfo, (String)taskId, null);
    }

    public static void delTaskRecord(String userId, Long businessTaskId, String type) {
        SWCDataServiceHelper taskRecordHelper = new SWCDataServiceHelper(HSBS_TASKRECORD);
        QFilter userFilter = new QFilter("creator", "=", (Object)Long.valueOf(userId));
        QFilter businessFilter = new QFilter("businesstaskid", "=", (Object)businessTaskId);
        QFilter typeFileter = new QFilter("tasktype", "=", (Object)type);
        taskRecordHelper.deleteByFilter(new QFilter[]{userFilter, businessFilter, typeFileter});
    }
}

