/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.relatepanel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.swc.hsbp.business.relatepanel.RelatePageInfo;
import kd.swc.hsbp.business.taxservice.TaxCalServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SWCRelatePanelSetFactory {
    private static final Log logger = LogFactory.getLog(SWCRelatePanelSetFactory.class);
    private static String APPID_HSBP = "hsbp";
    private static String RELATEPAGE_PRE = "relatePage_";

    public static List<RelatePageInfo> getRelatePageInfoList(String relateEntityTypeId, Long regionId) {
        String lang = RequestContext.get().getLang().getLocale().toString();
        String cacheKey = RELATEPAGE_PRE + relateEntityTypeId + lang;
        String jsonString = "";
        List<RelatePageInfo> relatePageList = new ArrayList<RelatePageInfo>();
        if (SWCStringUtils.isEmpty((String)jsonString)) {
            SWCRelatePanelSetFactory.initPageSetMapByEntityType(relateEntityTypeId);
            jsonString = (String)SWCAppCache.get((String)APPID_HSBP).get(cacheKey, String.class);
        }
        if (SWCStringUtils.isEmpty((String)jsonString)) {
            return relatePageList;
        }
        relatePageList = SerializationUtils.fromJsonStringToList((String)jsonString, RelatePageInfo.class);
        if (CollectionUtils.isEmpty(relatePageList)) {
            SWCRelatePanelSetFactory.initPageSetMapByEntityType(relateEntityTypeId);
            jsonString = (String)SWCAppCache.get((String)APPID_HSBP).get(cacheKey, String.class);
        }
        if (SWCStringUtils.isEmpty((String)jsonString)) {
            return relatePageList;
        }
        relatePageList = SerializationUtils.fromJsonStringToList((String)jsonString, RelatePageInfo.class);
        if (regionId == null || !TaxCalServiceHelper.getTaxCalEnableStatusByCountryId(regionId).booleanValue()) {
            Iterator<RelatePageInfo> it = relatePageList.iterator();
            while (it.hasNext()) {
                RelatePageInfo pageInfo = it.next();
                if (!"hsas_salarytaxfilerel".equals(pageInfo.getPageNumber())) continue;
                it.remove();
                break;
            }
        }
        return relatePageList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initPageSetMapByEntityType(String relateEntityTypeId) {
        Class<SWCRelatePanelSetFactory> clazz = SWCRelatePanelSetFactory.class;
        synchronized (SWCRelatePanelSetFactory.class) {
            Map<String, List<RelatePageInfo>> pageMap = SWCRelatePanelSetFactory.queryRelatePageInfoList(relateEntityTypeId);
            String lang = RequestContext.get().getLang().getLocale().toString();
            pageMap.entrySet().stream().forEach(entry -> {
                if (((String)entry.getKey()).contains(lang)) {
                    SWCAppCache.get((String)APPID_HSBP).put((String)entry.getKey(), (Object)SerializationUtils.toJsonString(entry.getValue()));
                }
            });
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void clearHRRelatePanelSetMap(String relateEntityTypeId) {
        ISWCAppCache appCache = SWCAppCache.get((String)APPID_HSBP);
        Lang[] langs = Lang.values();
        String cachePre = RELATEPAGE_PRE + relateEntityTypeId;
        for (int i = 0; i < langs.length; ++i) {
            Lang tempLang = langs[i];
            String cacheKey = cachePre + tempLang;
            String relatePageJson = (String)appCache.get(cacheKey, String.class);
            if (!SWCStringUtils.isNotEmpty((String)relatePageJson)) continue;
            appCache.remove(cacheKey);
        }
    }

    private static Map<String, List<RelatePageInfo>> queryRelatePageInfoList(String relateEntityTypeId) {
        String selectFields = "number,entitytype.id,pageinfo,name,pagetype,mainPropName,filterCondition,enable,status,url";
        Long relateEntityTypeLongId = Long.valueOf(relateEntityTypeId);
        QFilter typeFilter = new QFilter("entitytype.id", "=", (Object)relateEntityTypeLongId);
        typeFilter.and("enable", "=", (Object)"1");
        typeFilter.and("status", "=", (Object)"C");
        QFilter[] filterArray = new QFilter[]{typeFilter};
        String order = "index,number";
        DynamicObject[] pageSetColl = BusinessDataServiceHelper.load((String)"hsbs_relatepanelset", (String)selectFields, (QFilter[])filterArray, (String)order);
        Lang[] langs = Lang.values();
        HashMap<String, List<RelatePageInfo>> pageMap = new HashMap<String, List<RelatePageInfo>>(16);
        String cachePre = RELATEPAGE_PRE + relateEntityTypeId;
        for (int i = 0; i < langs.length; ++i) {
            ArrayList<RelatePageInfo> pageList = new ArrayList<RelatePageInfo>();
            String tempLang = langs[i].toString();
            String cacheKey = cachePre + tempLang;
            for (int j = 0; j < pageSetColl.length; ++j) {
                DynamicObject pageDynObj = pageSetColl[j];
                LocaleDynamicObjectCollection localeColl = (LocaleDynamicObjectCollection)pageDynObj.get("multilanguagetext");
                SWCRelatePanelSetFactory.addPageList(pageList, tempLang, pageDynObj, localeColl);
            }
            pageMap.put(cacheKey, pageList);
        }
        return pageMap;
    }

    private static void addPageList(List<RelatePageInfo> pageList, String tempLang, DynamicObject pageDynObj, LocaleDynamicObjectCollection localeColl) {
        for (DynamicObject dynamicObject : localeColl) {
            if (!SWCStringUtils.equals((String)tempLang, (String)dynamicObject.getString("localeid"))) continue;
            if (!SWCStringUtils.isEmpty((String)pageDynObj.getString("url"))) {
                RelatePageInfo relatePageInfo = new RelatePageInfo(pageDynObj.getString("number").toUpperCase(), pageDynObj.getString("pageinfo_id"), dynamicObject.getString("name"), pageDynObj.getString("pagetype"), pageDynObj.getString("mainPropName"), pageDynObj.getString("filterCondition"), pageDynObj.getString("url"));
                pageList.add(relatePageInfo);
                break;
            }
            RelatePageInfo relatePageInfo = new RelatePageInfo(pageDynObj.getString("number").toUpperCase(), pageDynObj.getString("pageinfo_id"), dynamicObject.getString("name"), pageDynObj.getString("pagetype"), pageDynObj.getString("mainPropName"), pageDynObj.getString("filterCondition"));
            pageList.add(relatePageInfo);
            break;
        }
    }

    public static RelatePageInfo getRelatePageInfo(String relateEntityTypeId, String pageNumber, Long regionId) {
        RelatePageInfo relatePageInfo = null;
        List<RelatePageInfo> pageList = SWCRelatePanelSetFactory.getRelatePageInfoList(relateEntityTypeId, regionId);
        int size = pageList.size();
        for (int i = 0; i < size; ++i) {
            if (!pageNumber.equals(pageList.get(i).getPageNumber())) continue;
            relatePageInfo = pageList.get(i);
            break;
        }
        return relatePageInfo;
    }
}

