/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.report;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.constants.RptDisplayConstants;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class ReportTplHelper
implements RptDisplayConstants {
    public static void dimSearchTreeNode(String searchText, IFormView iFormView) {
        SWCPageCache pageCache = new SWCPageCache(iFormView);
        String rootNode = (String)pageCache.get("CACHE_ROOT_NODE", String.class);
        if (rootNode == null) {
            return;
        }
        String oldMatchNodesKey = iFormView.getPageId() + "_matchNodes";
        String oldSearchTextKey = iFormView.getPageId() + "_oldSearchText";
        String oldSearchText = (String)pageCache.get(oldSearchTextKey, String.class);
        pageCache.put(oldSearchTextKey, (Object)searchText);
        if (StringUtils.isEmpty((String)oldSearchText) && StringUtils.isEmpty((String)searchText)) {
            return;
        }
        List<TreeNode> rootNodes = (List<TreeNode>)SerializationUtils.deSerializeFromBase64((String)rootNode);
        List<TreeNode> searchNodes = null;
        if (StringUtils.isEmpty((String)searchText)) {
            searchNodes = rootNodes;
        } else {
            if (org.apache.commons.lang3.StringUtils.equals((CharSequence)oldSearchText, (CharSequence)searchText)) {
                rootNode = (String)pageCache.get(oldMatchNodesKey, String.class);
                if (rootNode != null) {
                    return;
                }
            } else {
                searchNodes = ReportTplHelper.searchByText(rootNodes, searchText, Boolean.TRUE);
                pageCache.put(oldMatchNodesKey, (Object)SerializationUtils.serializeToBase64(searchNodes));
            }
            if (CollectionUtils.isEmpty(searchNodes)) {
                iFormView.showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\uff0c\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"ReportTplHelper_0", (String)"swc-hsbp-business", (Object[])new Object[0]));
                return;
            }
        }
        TreeView treeView = (TreeView)iFormView.getControl("treeviewap");
        treeView.deleteAllNodes();
        treeView.addNodes(searchNodes);
    }

    private static List<TreeNode> searchByText(List<TreeNode> rootNodes, String searchText, Boolean isExpend) {
        ArrayList resultNodes = Lists.newArrayListWithCapacity((int)rootNodes.size());
        for (TreeNode rootNode : rootNodes) {
            if (!ReportTplHelper.searchTextExist(rootNode, searchText, isExpend)) continue;
            resultNodes.add(rootNode);
            rootNode.setExpend(isExpend.booleanValue());
            rootNode.setIsOpened(isExpend.booleanValue());
        }
        return resultNodes;
    }

    private static boolean searchTextExist(TreeNode rootNode, String searchText, Boolean isExpend) {
        List children = rootNode.getChildren();
        if (CollectionUtils.isEmpty((Collection)children) && rootNode.getText().contains(searchText)) {
            return true;
        }
        boolean isExist = false;
        if (!CollectionUtils.isEmpty((Collection)children)) {
            Iterator iterator = children.iterator();
            while (iterator.hasNext()) {
                TreeNode next = (TreeNode)iterator.next();
                if (ReportTplHelper.searchTextExist(next, searchText, isExpend)) {
                    isExist = true;
                    next.setExpend(isExpend.booleanValue());
                    next.setIsOpened(isExpend.booleanValue());
                    continue;
                }
                iterator.remove();
            }
        }
        return isExist;
    }

    public static void searchTreeNode(String searchText, IFormView iFormView, boolean isSelected) {
        List<Object> treeNodes;
        boolean flag;
        SWCPageCache swcPageCache = new SWCPageCache(iFormView);
        String rootNode = (String)swcPageCache.get("CACHE_ROOT_NODE", String.class);
        if (rootNode == null) {
            return;
        }
        List rootNodes = (List)SerializationUtils.deSerializeFromBase64((String)rootNode);
        IPageCache pageCache = (IPageCache)iFormView.getService(IPageCache.class);
        String searchNodesCacheKey = iFormView.getPageId() + "_searchNodes";
        String matchNodesCacheKey = iFormView.getPageId() + "_matchNodes";
        String oldSearchTextCacheKey = iFormView.getPageId() + "_oldSearchText";
        String searchIndexCacheKey = iFormView.getPageId() + "_searchIndex";
        String oldSearchText = pageCache.get(oldSearchTextCacheKey);
        pageCache.put(oldSearchTextCacheKey, searchText);
        String matchNodesCache = pageCache.get(matchNodesCacheKey);
        boolean bl = flag = (oldSearchText == null || oldSearchText.equals(searchText)) && !SWCStringUtils.isEmpty((String)matchNodesCache);
        if (flag) {
            String treeViewNode = pageCache.get(searchNodesCacheKey);
            treeNodes = SWCStringUtils.isEmpty((String)treeViewNode) ? SerializationUtils.fromJsonStringToList((String)matchNodesCache, TreeNode.class) : SerializationUtils.fromJsonStringToList((String)treeViewNode, TreeNode.class);
        } else {
            treeNodes = ReportTplHelper.getNodes(rootNodes, searchText);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
        }
        TreeView treeView = (TreeView)iFormView.getControl("treeviewap");
        if (treeNodes.isEmpty()) {
            treeNodes = ReportTplHelper.getNodes(rootNodes, searchText);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
            iFormView.showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\uff0c\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"ReportTplHelper_0", (String)"swc-hsbp-business", (Object[])new Object[0]));
        } else {
            if (SWCStringUtils.isNotEmpty((String)pageCache.get(searchIndexCacheKey))) {
                int indexCache = Integer.parseInt(pageCache.get(searchIndexCacheKey));
                if (indexCache < treeNodes.size()) {
                    TreeNode treeNode = treeNodes.get(indexCache);
                    if (isSelected) {
                        ReportTplHelper.keyWordSearchSelected(treeView, iFormView, pageCache, searchIndexCacheKey, indexCache, treeNode);
                    }
                } else {
                    iFormView.showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\u3002", (String)"ReportTplHelper_2", (String)"swc-hsbp-business", (Object[])new Object[0]));
                    pageCache.put(searchIndexCacheKey, String.valueOf(0));
                }
            } else {
                treeView.showNode(treeNodes.get(0).getParentid());
                treeView.focusNode(treeNodes.get(0));
                pageCache.put(searchIndexCacheKey, String.valueOf(0));
            }
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
        }
    }

    private static List<TreeNode> getNodes(List<TreeNode> rootNodes, String searchText) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(10);
        for (TreeNode rootNode : rootNodes) {
            nodes.addAll(rootNode.getTreeNodeListByText(new LinkedList(), searchText, 16));
        }
        return nodes;
    }

    private static void keyWordSearchSelected(TreeView treeView, IFormView iFormView, IPageCache pageCache, String searchIndexCacheKey, int indexCache, TreeNode treeNode) {
        treeView.showNode(treeNode.getParentid());
        treeView.focusNode(treeNode);
        TreeView tree = (TreeView)iFormView.getControl("treeviewap");
        List checkedNodeIds = tree.getTreeState().getCheckedNodeIds();
        treeView.uncheckNodes(checkedNodeIds);
        treeView.checkNode(treeNode);
        treeView.treeNodeClick(treeNode.getParentid(), treeNode.getId());
        pageCache.put(searchIndexCacheKey, String.valueOf(++indexCache));
    }

    public static void searchFieldName(String searchText, IFormView iFormView) {
        if (searchText.isEmpty()) {
            return;
        }
        int minSequenceNo = 0;
        int maxSequenceNo = 0;
        DynamicObjectCollection entryColl = iFormView.getModel().getEntryEntity("entryentity");
        LinkedHashMap fieldNameSeqMap = Maps.newLinkedHashMapWithExpectedSize((int)entryColl.size());
        for (DynamicObject entryObj : entryColl) {
            String fieldName = entryObj.getString("fieldname");
            if (!fieldName.contains(searchText)) continue;
            int sequenceNo = entryObj.getInt("seq");
            fieldNameSeqMap.put(fieldName, sequenceNo);
            if (fieldNameSeqMap.size() == 1) {
                minSequenceNo = sequenceNo;
                continue;
            }
            maxSequenceNo = sequenceNo;
        }
        if (fieldNameSeqMap.isEmpty()) {
            iFormView.showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\uff0c\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"ReportTplHelper_0", (String)"swc-hsbp-business", (Object[])new Object[0]));
            return;
        }
        IClientViewProxy proxy = (IClientViewProxy)iFormView.getService(IClientViewProxy.class);
        int[] rows = proxy.getEntryState("entryentity").getSelectedRows();
        int len = rows.length;
        boolean isSelected = true;
        if (0 == len) {
            isSelected = false;
        }
        EntryGrid grid = (EntryGrid)iFormView.getControl("entryentity");
        for (Map.Entry entry : fieldNameSeqMap.entrySet()) {
            int sequenceNo = (Integer)entry.getValue();
            if (!isSelected || sequenceNo - 1 > rows[rows.length - 1]) {
                grid.selectRows(sequenceNo - 1, true);
                return;
            }
            if (sequenceNo != maxSequenceNo) continue;
            grid.selectRows(minSequenceNo - 1, true);
            return;
        }
    }

    public static void setSortColumn(Map<String, Object> returnData, IFormView formView) {
        if (returnData == null) {
            return;
        }
        DynamicObjectCollection columnSortEntryEntities = returnData.getOrDefault("sortColumnEntryEntity", null);
        HashMap sortFieldValMap = Maps.newHashMapWithExpectedSize((int)columnSortEntryEntities.size());
        columnSortEntryEntities.forEach(entryDyObj -> sortFieldValMap.put(entryDyObj.getString("fieldvalue"), entryDyObj));
        DynamicObjectCollection entryEntities = formView.getModel().getEntryEntity("entryentity");
        entryEntities.forEach(entryObj -> {
            int sort;
            String fieldVal = entryObj.getString("fieldvalue");
            DynamicObject sortedDyObj = (DynamicObject)sortFieldValMap.get(fieldVal);
            if (sortedDyObj != null) {
                entryObj.set("sort", sortedDyObj.get("sort"));
                entryObj.set("sorttype", sortedDyObj.get("sorttype"));
            }
            if ((sort = entryObj.getInt("sort")) != 0 && !sortFieldValMap.containsKey(fieldVal)) {
                entryObj.set("sort", (Object)0);
                entryObj.set("sorttype", (Object)0);
            }
        });
        formView.updateView("entryentity");
        ReportTplHelper.refreshSecondaryHeaderByFreeze(formView);
    }

    public static DynamicObject copyDisplayScheme(String displayFormId, String pkId, Map<String, Object> returnData) {
        if (pkId == null || returnData == null) {
            return null;
        }
        DynamicObject shareSchemeObj = ReportTplHelper.queryRptDisplaySchemeObj(displayFormId, Long.parseLong(pkId));
        DynamicObject newCopyDyObj = ReportTplHelper.copyDynamicObj(shareSchemeObj);
        Object schemeName = returnData.get("name");
        Object schemeDesc = returnData.get("schemedesc");
        newCopyDyObj.set("name", schemeName);
        newCopyDyObj.set("schemedesc", schemeDesc);
        newCopyDyObj.set("createtime", (Object)new Date());
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(displayFormId);
        DynamicObject result = (DynamicObject)serviceHelper.saveOne(newCopyDyObj);
        return result;
    }

    public static DynamicObject copyDisplayScheme(String displayFormId, Long sourceSchmId, String reportFormId) {
        if (sourceSchmId == null) {
            return null;
        }
        DynamicObject shareSchemeObj = ReportTplHelper.queryRptDisplaySchemeObj(displayFormId, sourceSchmId);
        DynamicObject newCopyDyObj = ReportTplHelper.copyDynamicObj(shareSchemeObj);
        Date currTime = new Date();
        newCopyDyObj.set("createtime", (Object)currTime);
        newCopyDyObj.set("modifytime", (Object)currTime);
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(displayFormId);
        DynamicObject result = (DynamicObject)serviceHelper.saveOne(newCopyDyObj);
        return result;
    }

    public static DynamicObject setShareSchemeAfterSelectedOne(String displayFormId, ListSelectedRowCollection returnData, IFormView view) {
        if (returnData == null || returnData.isEmpty() || view == null) {
            return null;
        }
        ListSelectedRow selectedRow = returnData.get(0);
        Long pkId = (Long)selectedRow.getPrimaryKeyValue();
        DynamicObject schemeObj = ReportTplHelper.queryRptDisplaySchemeObj(displayFormId, pkId);
        if (Long.valueOf(RequestContext.get().getCurrUserId()).equals(schemeObj.getDynamicObject("creator").getLong("id"))) {
            return schemeObj;
        }
        if (ReportTplHelper.checkNameExists(view, schemeObj)) {
            DynamicObject newCopyDyObj = ReportTplHelper.copyDynamicObj(schemeObj);
            SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(displayFormId);
            DynamicObject result = (DynamicObject)serviceHelper.saveOne(newCopyDyObj);
            return result;
        }
        return null;
    }

    private static boolean checkNameExists(IFormView view, DynamicObject schemeObj) {
        String currName = schemeObj.getLocaleString("name").getLocaleValue();
        String schmNodeStr = view.getPageCache().get("schmNodes");
        if (schmNodeStr == null) {
            return true;
        }
        List schmNodes = (List)SerializationUtils.deSerializeFromBase64((String)schmNodeStr);
        TreeNode schmNode = null;
        for (int i = 0; i < schmNodes.size(); ++i) {
            schmNode = (TreeNode)schmNodes.get(i);
            if (!schmNode.getText().equals(currName)) continue;
            view.getPageCache().put("waitImportSchmId", schemeObj.getString("id"));
            view.showConfirm(ResManager.loadKDString((String)"\u4e2a\u4eba\u65b9\u6848\u5217\u8868\u4e2d\u5b58\u5728\u540d\u79f0\u76f8\u540c\u7684\u663e\u793a\u65b9\u6848\uff0c\u662f\u5426\u5c06\u672c\u65b9\u6848\u91cd\u547d\u540d\u540e\u5bfc\u5165\uff1f", (String)"ReportTplHelper_7", (String)"swc-hsbp-business", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("importShareSchemeCheckNameExists"));
            return false;
        }
        return true;
    }

    public static DynamicObject queryRptDisplaySchemeObj(String displayName, Long pkId) {
        String selectProperties = SWCHisBaseDataHelper.getSelectProperties(displayName);
        selectProperties = selectProperties + ", entryentity.seq";
        QFilter qFilter = new QFilter("id", "=", (Object)pkId);
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(displayName);
        return serviceHelper.queryOne(selectProperties, new QFilter[]{qFilter});
    }

    public static DynamicObject copyDynamicObj(DynamicObject shareSchemeObj) {
        String entityNumber = shareSchemeObj.getDataEntityType().getName();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        List<String> entryEntities = SWCHisBaseDataHelper.getEntryEntitys(mainEntityType);
        Map<String, List<String>> fieldMaps = SWCHisBaseDataHelper.getEntityFieldsMap(mainEntityType);
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(entityNumber);
        DynamicObject emptyDynamicObject = serviceHelper.generateEmptyDynamicObject();
        Long pkId = ORM.create().genLongId((IDataEntityType)mainEntityType);
        for (String fieldName : fieldMaps.get(entityNumber)) {
            if (fieldName.equals("id")) {
                emptyDynamicObject.set("id", (Object)pkId);
                continue;
            }
            if (fieldName.equals("creator") || fieldName.equals("modifier")) {
                emptyDynamicObject.set(fieldName, (Object)RequestContext.get().getCurrUserId());
                continue;
            }
            if (fieldName.equals("sharescheme") || fieldName.equals("defaultscheme")) {
                emptyDynamicObject.set(fieldName, (Object)"0");
                continue;
            }
            emptyDynamicObject.set(fieldName, shareSchemeObj.get(fieldName));
        }
        for (String entryEntity : entryEntities) {
            DynamicObjectCollection coll = shareSchemeObj.getDynamicObjectCollection(entryEntity);
            if (coll == null || coll.isEmpty()) continue;
            List<String> entryFields = fieldMaps.get(entryEntity);
            ReportTplHelper.copyEntryEntities(serviceHelper, emptyDynamicObject, entryEntity, entryFields, coll);
        }
        return emptyDynamicObject;
    }

    private static void copyEntryEntities(SWCDataServiceHelper serviceHelper, DynamicObject dynamicObject, String entryEntity, List<String> entryFields, DynamicObjectCollection coll) {
        DynamicObjectCollection newColl = dynamicObject.getDynamicObjectCollection(entryEntity);
        int index = 1;
        for (DynamicObject entryDyObj : coll) {
            DynamicObject newEntryDy = serviceHelper.generateEmptyEntryDynamicObject(entryEntity);
            for (String entryField : entryFields) {
                newEntryDy.set(entryField, entryDyObj.get(entryField));
            }
            newEntryDy.set("seq", (Object)index);
            newColl.add((Object)newEntryDy);
            ++index;
        }
    }

    public static void unFreeze(DynamicObjectCollection entryEntity, int rowIndex, IFormView formView) {
        for (int i = rowIndex; i < entryEntity.size(); ++i) {
            formView.setEnable(Boolean.TRUE, i, new String[]{"secondaryheader"});
            formView.getModel().setValue("freeze", (Object)Boolean.FALSE, i);
        }
        formView.updateView("entryentity");
        ReportTplHelper.refreshSecondaryHeaderByFreeze(formView);
    }

    public static void refreshSecondaryHeaderByFreeze(IFormView formView) {
        DynamicObjectCollection entryEntities = formView.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entryEntities.size(); ++i) {
            DynamicObject entryObj = (DynamicObject)entryEntities.get(i);
            if (entryObj.getBoolean("freeze")) {
                formView.setEnable(Boolean.FALSE, i, new String[]{"secondaryheader"});
                continue;
            }
            formView.setEnable(Boolean.TRUE, i, new String[]{"secondaryheader"});
        }
    }

    public static void freeze(DynamicObjectCollection entryEntity, int rowIndex, IFormView formView) {
        int i;
        boolean isChanged = false;
        for (i = 0; i <= rowIndex; ++i) {
            DynamicObject entryObj = (DynamicObject)entryEntity.get(i);
            String secondaryHeader = entryObj.getString("secondaryheader");
            if (!SWCStringUtils.isNotEmpty((String)secondaryHeader)) continue;
            isChanged = true;
            formView.showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7b2c%d\u884c\u7684\u4e8c\u7ea7\u8868\u5934\u5217\u8bbe\u7f6e\u4e86\u503c\uff0c\u65e0\u6cd5\u51bb\u7ed3\u3002", (String)"ReportTplHelper_3", (String)"swc-hsbp-business", (Object[])new Object[0]), i + 1));
            break;
        }
        if (!isChanged) {
            for (i = 0; i < rowIndex; ++i) {
                formView.getModel().setValue("freeze", (Object)Boolean.TRUE, i);
            }
            formView.setEnable(Boolean.FALSE, rowIndex, new String[]{"secondaryheader"});
        } else {
            formView.getModel().setValue("freeze", (Object)Boolean.FALSE, rowIndex);
        }
    }

    public static DynamicObject[] queryPersonalScheme(String rptDisplayFormId, String reportFormId) {
        QFilter filter = new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId());
        QFilter reportFormIdFilter = null;
        if (SWCStringUtils.isNotEmpty((String)reportFormId)) {
            reportFormIdFilter = new QFilter("reportformid", "=", (Object)reportFormId);
        }
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(rptDisplayFormId);
        DynamicObject[] personalSchemeObj = serviceHelper.query("id, name, defaultscheme", new QFilter[]{filter, reportFormIdFilter}, "defaultscheme desc, createtime desc");
        return personalSchemeObj;
    }

    public static DynamicObject queryDefaultScheme(String reportDisplayFormId, String reportFormId) {
        QFilter filter = new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId());
        QFilter defaultFilter = new QFilter("defaultscheme", "=", (Object)Boolean.TRUE);
        QFilter reportFormIdFilter = null;
        if (SWCStringUtils.isNotEmpty((String)reportFormId)) {
            reportFormIdFilter = new QFilter("reportformid", "=", (Object)reportFormId);
        }
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(reportDisplayFormId);
        return serviceHelper.queryOne("defaultscheme", new QFilter[]{filter, defaultFilter, reportFormIdFilter});
    }

    public static DynamicObject queryRptDisplayScheme(String currentDisplayFormId, Long pkId) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(currentDisplayFormId);
        return serviceHelper.queryOne("id,defaultscheme,sharescheme", pkId);
    }

    public static void deleteRptDisplaySchemeById(String currentDisplayFormId, Long pkId) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(currentDisplayFormId);
        serviceHelper.deleteOne(pkId);
    }

    public static void cancelOtherDefaultScheme(String reportDisplayFormId, String reportFormId, Long pkId) {
        DynamicObject[] dynamicObjects;
        QFilter qFilter = new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId());
        qFilter.and(new QFilter("defaultscheme", "=", (Object)"1"));
        qFilter.and(new QFilter("id", "!=", (Object)pkId));
        qFilter.and(new QFilter("reportformid", "=", (Object)reportFormId));
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(reportDisplayFormId);
        for (DynamicObject dyObj : dynamicObjects = serviceHelper.query("id, defaultscheme", new QFilter[]{qFilter})) {
            dyObj.set("defaultscheme", (Object)0);
        }
        serviceHelper.update(dynamicObjects);
    }

    public static <T> void forEach(Iterable<? extends T> elements, BiConsumer<Integer, ? super T> action) {
        Objects.requireNonNull(elements);
        Objects.requireNonNull(action);
        int index = 0;
        for (T element : elements) {
            action.accept(index, (Integer)element);
            ++index;
        }
    }

    public static Map<String, Integer> geTreeNodeBindTableRowMap(IFormView formView) {
        HashMap treeNodeTableRowMap = Maps.newHashMapWithExpectedSize((int)16);
        treeNodeTableRowMap.clear();
        DynamicObjectCollection entity = formView.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entity.size(); ++i) {
            DynamicObject obj = (DynamicObject)entity.get(i);
            String nodeid = obj.getString("fieldvalue");
            treeNodeTableRowMap.put(nodeid, i);
        }
        return treeNodeTableRowMap;
    }

    public static void removeColumn(IFormView formView) {
        EntryGrid entryGrid = (EntryGrid)formView.getControl("entryentity");
        int[] rows = entryGrid.getSelectRows();
        if (rows == null || rows.length == 0) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ReportTplHelper_4", (String)"swc-hsbp-business", (Object[])new Object[0]));
            return;
        }
        String removeTip = ResManager.loadKDString((String)"%s\u884c\u4e0d\u80fd\u79fb\u9664\u3002", (String)"ReportTplHelper_5", (String)"swc-hsbp-business", (Object[])new Object[0]);
        ArrayList<String> unRemoveNameList = new ArrayList<String>();
        for (int i = 0; i < rows.length; ++i) {
            int isDefault;
            DynamicObject rowEntity = formView.getModel().getEntryRowEntity("entryentity", rows[i]);
            if (rowEntity == null || (isDefault = rowEntity.getInt("isdefault")) != 1) continue;
            unRemoveNameList.add(rowEntity.getString("fieldname"));
        }
        if (unRemoveNameList.size() > 0) {
            formView.showTipNotification(String.format(Locale.ROOT, removeTip, unRemoveNameList.stream().collect(Collectors.joining("\u3001"))));
            return;
        }
        formView.getModel().deleteEntryRows("entryentity", rows);
        ReportTplHelper.refreshColumnSort(formView);
    }

    private static void refreshColumnSort(IFormView formView) {
        AtomicInteger index = new AtomicInteger();
        IDataModel dataModel = formView.getModel();
        DynamicObjectCollection entryEntities = dataModel.getEntryEntity("entryentity");
        dataModel.beginInit();
        entryEntities.stream().filter(entryObj -> entryObj.getInt("sort") > 0).sorted(Comparator.comparing(entryObj -> entryObj.getInt("sort"))).forEach(entryObj -> entryObj.set("sort", (Object)index.incrementAndGet()));
        dataModel.endInit();
        formView.updateView("entryentity");
        ReportTplHelper.refreshSecondaryHeaderByFreeze(formView);
    }

    public static DynamicObject addDisplayScheme(String rptDisplayFormId, String reportFormId, Map<String, Object> returnData) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(rptDisplayFormId);
        DynamicObject schmObj = serviceHelper.generateEmptyDynamicObject();
        if (SWCStringUtils.isNotEmpty((String)reportFormId)) {
            schmObj.set("reportformid", (Object)reportFormId);
        }
        schmObj.set("name", returnData.get("name"));
        schmObj.set("schemedesc", returnData.get("schemedesc"));
        schmObj.set("defaultscheme", (Object)Boolean.FALSE);
        schmObj.set("sharescheme", (Object)Boolean.FALSE);
        schmObj.set("status", (Object)"A");
        schmObj.set("creator", (Object)RequestContext.get().getCurrUserId());
        Date currDate = new Date();
        schmObj.set("createtime", (Object)currDate);
        schmObj.set("modifier", (Object)RequestContext.get().getCurrUserId());
        schmObj.set("modifytime", (Object)currDate);
        schmObj.set("enable", (Object)"1");
        DynamicObject result = (DynamicObject)serviceHelper.saveOne(schmObj);
        return result;
    }

    public static DynamicObject updateDisplayScheme(String displayName, String pkId, Map<String, Object> returnData) {
        DynamicObject shareSchemeObj = ReportTplHelper.queryRptDisplaySchemeObj(displayName, Long.parseLong(pkId));
        Object schemeName = returnData.get("name");
        Object schemeDesc = returnData.get("schemedesc");
        shareSchemeObj.set("name", schemeName);
        shareSchemeObj.set("schemedesc", schemeDesc);
        shareSchemeObj.set("modifytime", (Object)new Date());
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(displayName);
        return (DynamicObject)serviceHelper.updateOne(shareSchemeObj);
    }
}

