/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.schedule;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.swc.hsbp.business.schedule.SwcBizSchConfigConstants;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public abstract class SwcBizAbstractTask
extends AbstractTask
implements SwcBizSchConfigConstants {
    private static Log logger = LogFactory.getLog(SwcBizAbstractTask.class);
    private static final String HSBS_SCHPLANCFG = "hsbs_schplancfg";
    public static final String IS_SWC_JOB_REALTIME = "IS_SWC_JOB_REALTIME";
    public static final String SWC_BIZ_OBJ_ID = "swcBizObjId";
    private String useEntityCode;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        long startTime = System.currentTimeMillis();
        logger.info("SwcBizAbstractTask execute start...");
        if (map != null && !map.isEmpty() && "true".equals(map.get(IS_SWC_JOB_REALTIME))) {
            this.executeBiz(requestContext, map, map.get(SWC_BIZ_OBJ_ID));
            logger.info("SwcBizAbstractTask execute end...cost time = {} ms", (Object)(System.currentTimeMillis() - startTime));
            return;
        }
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        String scheduleId = taskInfo.getScheduleId();
        if (StringUtils.isEmpty((CharSequence)scheduleId)) {
            logger.info("scheduleId is empty, task run over.");
            throw new KDException(new ErrorCode("SCHEDULE_ID_EMPTY", "scheduleId is empty."), new Object[0]);
        }
        SWCDataServiceHelper schCfgHelper = new SWCDataServiceHelper(HSBS_SCHPLANCFG);
        QFilter qfilter = new QFilter("schedule", "=", (Object)scheduleId);
        DynamicObject schCfgDyn = schCfgHelper.queryOriginalOne("id,useobj.entity, useobj.fieldkey", qfilter.toArray());
        if (schCfgDyn == null) {
            logger.info("schCfgDyn is empty, task run over.");
            throw new KDException(new ErrorCode("SCHEDULE_CONFIG_EMPTY", "scheduleId config is empty."), new Object[0]);
        }
        long schCfgId = schCfgDyn.getLong("id");
        String applicableObj = schCfgDyn.getString("useobj.entity");
        this.setUseEntityCode(applicableObj);
        String fieldKey = schCfgDyn.getString("useobj.fieldkey");
        SWCDataServiceHelper bizHelper = new SWCDataServiceHelper(applicableObj);
        QFilter qFilter = this.buildBizQFilter(requestContext, map, schCfgId);
        if (qFilter == null) {
            qFilter = new QFilter(fieldKey, "=", (Object)schCfgId);
        }
        DynamicObjectCollection bizDynColl = bizHelper.queryOriginalCollection("id", qFilter.toArray());
        ArrayList<Object> allBizIds = new ArrayList<Object>(10);
        ArrayList<Object> errorBizIds = new ArrayList<Object>(10);
        for (DynamicObject dynamicObject : bizDynColl) {
            Object bizId = dynamicObject.get("id");
            try {
                allBizIds.add(bizId);
                this.executeBiz(requestContext, map, bizId);
            }
            catch (Exception exc) {
                errorBizIds.add(bizId);
                logger.error("SwcBizAbstractTask executed error: ", (Throwable)exc);
            }
        }
        logger.info("SwcBizAbstractTask allBizIds.size() = {}, allBizIds = {}, errorBizIds.size() = {}, errorBizIds = {}.", new Object[]{allBizIds.size(), SerializationUtils.toJsonString(allBizIds), errorBizIds.size(), SerializationUtils.toJsonString(errorBizIds)});
        if (errorBizIds.size() == 0) {
            logger.info("SwcBizAbstractTask allBizIds execute success!");
        }
        logger.info("SwcBizAbstractTask execute end...cost time = {} ms", (Object)(System.currentTimeMillis() - startTime));
        if (allBizIds.size() > 0 && allBizIds.size() == errorBizIds.size()) {
            throw new RuntimeException("allBizIds executeBiz error.");
        }
    }

    protected abstract QFilter buildBizQFilter(RequestContext var1, Map<String, Object> var2, long var3);

    protected abstract void executeBiz(RequestContext var1, Map<String, Object> var2, Object var3);

    public String getUseEntityCode() {
        return this.useEntityCode;
    }

    public void setUseEntityCode(String useEntityCode) {
        this.useEntityCode = useEntityCode;
    }
}

