/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.servicehelper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.swc.hsbp.common.util.SWCBaseUtils;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.vo.SummaryObject;
import kd.swc.hsbp.common.vo.SummaryObjectList;

public class SWCBaseDataSummaryHelper {
    public static final FormShowParameter getBaseDataSummaryFormShowParameter(String targetKey, boolean isShowDelimiter, SummaryObjectList fixSummaryObjectList, SummaryObjectList liveSummaryObjectList) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey(targetKey);
        formShowParameter.setFormId("hsbp_summary");
        if (null != fixSummaryObjectList) {
            formShowParameter.setCustomParam("fixSummaryObjectList", (Object)SWCBaseUtils.pojo2Json((Object)fixSummaryObjectList));
        }
        if (null != liveSummaryObjectList) {
            formShowParameter.setCustomParam("liveSummaryObjectList", (Object)SWCBaseUtils.pojo2Json((Object)liveSummaryObjectList));
        }
        formShowParameter.setCustomParam("isShowDelimiter", (Object)isShowDelimiter);
        return formShowParameter;
    }

    public static final FormShowParameter getBaseDataSummaryFormShowParameter(String targetKey, boolean isShowDelimiter, List<String> fixSummarykeyList, IFormView iFormView) {
        SummaryObjectList fixSummaryObjectList = SWCBaseDataSummaryHelper.getBaseDataSummaryObjectList(fixSummarykeyList, iFormView);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey(targetKey);
        formShowParameter.setFormId("hsbp_summary");
        formShowParameter.setCustomParam("fixSummaryObjectList", (Object)SWCBaseUtils.pojo2Json((Object)fixSummaryObjectList));
        formShowParameter.setCustomParam("isShowDelimiter", (Object)isShowDelimiter);
        return formShowParameter;
    }

    public static final SummaryObjectList getBaseDataSummaryObjectList(List<String> fixSummarykeyList, IFormView iFormView) {
        SummaryObjectList fixSummaryObjectList = new SummaryObjectList();
        ArrayList summaryObjectList = Lists.newArrayListWithExpectedSize((int)10);
        for (String key : fixSummarykeyList) {
            SummaryObject sObject;
            IDataEntityProperty ismodifyProperty = iFormView.getModel().getProperty(key);
            if (null == ismodifyProperty && key.indexOf("img") < 0 || null == (sObject = SWCBaseDataSummaryHelper.getFixSummaryObject(key, iFormView))) continue;
            summaryObjectList.add(sObject);
        }
        fixSummaryObjectList.setSummaryList((List)summaryObjectList);
        return fixSummaryObjectList;
    }

    public static final FormShowParameter getBaseDataSummaryFormShowParameter(String targetKey, boolean isShowDelimiter, List<String> fixSummarykeyList, SummaryObjectList liveSummaryObjectList, IFormView iFormView) {
        FormShowParameter formShowParameter = SWCBaseDataSummaryHelper.getBaseDataSummaryFormShowParameter(targetKey, isShowDelimiter, fixSummarykeyList, iFormView);
        if (null != liveSummaryObjectList) {
            formShowParameter.setCustomParam("liveSummaryObjectList", (Object)SWCBaseUtils.pojo2Json((Object)liveSummaryObjectList));
        }
        return formShowParameter;
    }

    private static SummaryObject getFixSummaryObject(String key, IFormView iFormView) {
        SummaryObject summaryObj = new SummaryObject();
        summaryObj.setKey(key);
        DynamicObject dataEntity = iFormView.getModel().getDataEntity();
        switch (key) {
            case "name": {
                String valueString = dataEntity.getString("name");
                if (!SWCStringUtils.isNotEmpty((String)valueString)) break;
                summaryObj.setValue(valueString);
                return summaryObj;
            }
            case "number": {
                String valueString = dataEntity.getString("number");
                if (!SWCStringUtils.isNotEmpty((String)valueString)) break;
                summaryObj.setValue(valueString);
                return summaryObj;
            }
            case "bsed": {
                String valueString;
                Date date = dataEntity.getDate("bsed");
                if (null == date || !SWCStringUtils.isNotEmpty((String)(valueString = SWCDateTimeUtils.format((Date)date, (String)"yyyy-MM-dd")))) break;
                summaryObj.setValue(valueString);
                return summaryObj;
            }
            case "status": {
                String valueString = dataEntity.getString("status");
                if (!SWCStringUtils.isNotEmpty((String)valueString)) break;
                summaryObj.setName(SWCBaseDataSummaryHelper.getDataStatus(iFormView.getEntityId(), valueString));
                summaryObj.setValue(valueString);
                return summaryObj;
            }
            case "enable": {
                summaryObj = new SummaryObject();
                summaryObj.setKey("enable");
                String valueString = dataEntity.getString("enable");
                if (!SWCStringUtils.isNotEmpty((String)valueString)) break;
                summaryObj.setName(SWCBaseDataSummaryHelper.getUseStatus(valueString));
                summaryObj.setValue(valueString);
                return summaryObj;
            }
            case "ismodify": {
                IDataEntityProperty ismodifyProperty = iFormView.getModel().getProperty("ismodify");
                if (null == ismodifyProperty) break;
                summaryObj = new SummaryObject();
                summaryObj.setKey("ismodify");
                boolean isModify = dataEntity.getBoolean("ismodify");
                String valueString = SWCBaseDataSummaryHelper.getModifyStatus(isModify);
                if (!SWCStringUtils.isNotEmpty((String)valueString)) break;
                summaryObj.setValue(valueString);
                return summaryObj;
            }
            case "currency": {
                String valueString;
                summaryObj = new SummaryObject();
                summaryObj.setKey("currency");
                DynamicObject currency = dataEntity.getDynamicObject("currency");
                if (null == currency || !SWCStringUtils.isNotEmpty((String)(valueString = currency.getString("name") + currency.getString("sign")))) break;
                summaryObj.setValue(valueString);
                return summaryObj;
            }
            case "country": {
                summaryObj = new SummaryObject();
                summaryObj.setKey("country");
                String valueString = dataEntity.getString("country.name");
                if (!SWCStringUtils.isNotEmpty((String)valueString)) break;
                summaryObj.setValue(valueString);
                return summaryObj;
            }
            case "countryimg": {
                summaryObj = new SummaryObject();
                summaryObj.setKey("countryimg");
                String valueString = dataEntity.getString("country.logo");
                if (!SWCStringUtils.isNotEmpty((String)valueString)) break;
                summaryObj.setValue(valueString);
                return summaryObj;
            }
            case "createtime": {
                String valueString;
                Date date = dataEntity.getDate("createtime");
                if (null == date || !SWCStringUtils.isNotEmpty((String)(valueString = SWCDateTimeUtils.format((Date)date)))) break;
                summaryObj.setValue(valueString);
                return summaryObj;
            }
            case "createorg": {
                summaryObj = new SummaryObject();
                summaryObj.setKey("createorg");
                String value = dataEntity.getString("createorg.name");
                if (!SWCStringUtils.isNotEmpty((String)value)) break;
                summaryObj.setValue(value);
                return summaryObj;
            }
            case "creator": {
                summaryObj = new SummaryObject();
                summaryObj.setKey("creator");
                String value = dataEntity.getString("creator.name");
                if (!SWCStringUtils.isNotEmpty((String)value)) break;
                summaryObj.setValue(value);
                return summaryObj;
            }
            case "issharescheme": {
                IDataEntityProperty isShareSchemeProp = iFormView.getModel().getProperty("issharescheme");
                if (isShareSchemeProp == null) break;
                summaryObj = new SummaryObject();
                summaryObj.setKey("issharescheme");
                boolean isShare = dataEntity.getBoolean("issharescheme");
                String value = SWCBaseDataSummaryHelper.getSharable(isShare);
                if (!SWCStringUtils.isNotEmpty((String)value)) break;
                summaryObj.setValue(value);
                return summaryObj;
            }
        }
        return null;
    }

    public static boolean isEmptySummary(SummaryObject obj) {
        return SWCStringUtils.isEmpty((String)obj.getKey()) || SWCStringUtils.isEmpty((String)obj.getValue());
    }

    public static boolean isNotEmptySummary(SummaryObject obj) {
        return !SWCBaseDataSummaryHelper.isEmptySummary(obj);
    }

    public static String getPaymethod(String key) {
        if (SWCStringUtils.isEmpty((String)key)) {
            return "";
        }
        HashMap<String, String> PAYMETHOD = new HashMap<String, String>(16);
        PAYMETHOD.put("1", ResManager.loadKDString((String)"\u94f6\u884c\u8f6c\u8d26", (String)"SWCBaseDataSummaryHelper_0", (String)"swc-hsbp-business", (Object[])new Object[0]));
        PAYMETHOD.put("2", ResManager.loadKDString((String)"\u73b0\u91d1\u53d1\u653e", (String)"SWCBaseDataSummaryHelper_1", (String)"swc-hsbp-business", (Object[])new Object[0]));
        PAYMETHOD.put("3", ResManager.loadKDString((String)"\u94f6\u884c\u8f6c\u8d26\u548c\u73b0\u91d1\u53d1\u653e", (String)"SWCBaseDataSummaryHelper_2", (String)"swc-hsbp-business", (Object[])new Object[0]));
        return (String)PAYMETHOD.get(key);
    }

    public static String getDataStatus(String key) {
        if (SWCStringUtils.isEmpty((String)key)) {
            return "";
        }
        HashMap<String, String> DATASTATUS = new HashMap<String, String>(16);
        DATASTATUS.put("A", ResManager.loadKDString((String)"\u6682\u5b58", (String)"SWCBaseDataSummaryHelper_3", (String)"swc-hsbp-business", (Object[])new Object[0]));
        DATASTATUS.put("B", ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4", (String)"SWCBaseDataSummaryHelper_4", (String)"swc-hsbp-business", (Object[])new Object[0]));
        DATASTATUS.put("C", ResManager.loadKDString((String)"\u5df2\u5ba1\u6838", (String)"SWCBaseDataSummaryHelper_5", (String)"swc-hsbp-business", (Object[])new Object[0]));
        return (String)DATASTATUS.get(key);
    }

    public static String getDataStatus(String formId, String key) {
        return SWCBaseDataSummaryHelper.getDataStatus(key);
    }

    public static String getUseStatus(String key) {
        if (SWCStringUtils.isEmpty((String)key)) {
            return "";
        }
        HashMap<String, String> USESTATUS = new HashMap<String, String>(16);
        USESTATUS.put("1", ResManager.loadKDString((String)"\u53ef\u7528", (String)"SWCBaseDataSummaryHelper_6", (String)"swc-hsbp-business", (Object[])new Object[0]));
        USESTATUS.put("0", ResManager.loadKDString((String)"\u7981\u7528", (String)"SWCBaseDataSummaryHelper_7", (String)"swc-hsbp-business", (Object[])new Object[0]));
        USESTATUS.put("10", ResManager.loadKDString((String)"\u5f85\u542f\u7528", (String)"SWCBaseDataSummaryHelper_16", (String)"swc-hsbp-business", (Object[])new Object[0]));
        return (String)USESTATUS.get(key);
    }

    public static String getModifyStatus(boolean key) {
        if (key) {
            return ResManager.loadKDString((String)"\u53d8\u66f4\u4e2d", (String)"SWCBaseDataSummaryHelper_8", (String)"swc-hsbp-business", (Object[])new Object[0]);
        }
        return "";
    }

    public static String getPayHZ(String key) {
        if (SWCStringUtils.isEmpty((String)key)) {
            return "";
        }
        HashMap<String, String> PAYHZ = new HashMap<String, String>(16);
        PAYHZ.put("1", ResManager.loadKDString((String)"\u5468", (String)"SWCBaseDataSummaryHelper_9", (String)"swc-hsbp-business", (Object[])new Object[0]));
        PAYHZ.put("2", ResManager.loadKDString((String)"\u53cc\u5468", (String)"SWCBaseDataSummaryHelper_10", (String)"swc-hsbp-business", (Object[])new Object[0]));
        PAYHZ.put("3", ResManager.loadKDString((String)"\u534a\u6708", (String)"SWCBaseDataSummaryHelper_11", (String)"swc-hsbp-business", (Object[])new Object[0]));
        PAYHZ.put("4", ResManager.loadKDString((String)"\u6708", (String)"SWCBaseDataSummaryHelper_12", (String)"swc-hsbp-business", (Object[])new Object[0]));
        PAYHZ.put("5", ResManager.loadKDString((String)"\u5b63\u5ea6", (String)"SWCBaseDataSummaryHelper_13", (String)"swc-hsbp-business", (Object[])new Object[0]));
        PAYHZ.put("6", ResManager.loadKDString((String)"\u534a\u5e74", (String)"SWCBaseDataSummaryHelper_14", (String)"swc-hsbp-business", (Object[])new Object[0]));
        PAYHZ.put("7", ResManager.loadKDString((String)"\u5e74", (String)"SWCBaseDataSummaryHelper_15", (String)"swc-hsbp-business", (Object[])new Object[0]));
        return (String)PAYHZ.get(key);
    }

    public static boolean isNew(DynamicObject obj) {
        return SWCStringUtils.isEmpty((String)obj.getString("number"));
    }

    public static String getSharable(boolean isShare) {
        if (isShare) {
            return ResManager.loadKDString((String)"\u5171\u4eab", (String)"SWCBaseDataSummaryHelper_18", (String)"swc-hsbp-business", (Object[])new Object[0]);
        }
        return "";
    }
}

