/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.servicehelper;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.task.MultithreadedQueryTask;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import org.apache.commons.lang.ArrayUtils;

public class SWCMultithreadedQueryService {
    protected static final Log logger = LogFactory.getLog(SWCMultithreadedQueryService.class);

    public static SWCMultithreadedQueryService getInstance() {
        return SWCMultithreadedQueryServiceHolder.service;
    }

    public DynamicObject[] getData(String entityName, String selectProperties, QFilter[] filters, String orderBy, int pageIndex, int pagesize) throws InterruptedException {
        Object[] coll = null;
        int batchSize = 100;
        int num = 1;
        if (pagesize > batchSize) {
            num = pagesize / batchSize;
        }
        CountDownLatch latch = new CountDownLatch(num);
        ArrayList<Future> futureList = new ArrayList<Future>(num);
        for (int index = 0; index < num; ++index) {
            int currPageSize;
            int currPageIndex;
            if (pagesize > batchSize) {
                currPageIndex = pageIndex * num + index;
                currPageSize = batchSize;
            } else {
                currPageIndex = pageIndex;
                currPageSize = pagesize;
            }
            MultithreadedQueryTask task = new MultithreadedQueryTask(entityName, selectProperties, filters, orderBy, currPageIndex, currPageSize, latch);
            Future future = SWCThreadPoolFactory.getMultithreadedQueryThreadpool().submit((Callable)task);
            futureList.add(future);
        }
        try {
            boolean flag = latch.await(10L, TimeUnit.MINUTES);
            if (!flag) {
                return new DynamicObject[0];
            }
            for (Future future : futureList) {
                if (coll == null) {
                    coll = (DynamicObject[])future.get();
                    continue;
                }
                coll = (DynamicObject[])ArrayUtils.addAll((Object[])coll, (Object[])((Object[])future.get()));
            }
        }
        catch (ExecutionException e) {
            logger.error((Throwable)e);
        }
        return coll;
    }

    public DynamicObject[] getData(String entityName, String selectProperties, QFilter[] filters, String orderBy, int batchSize) throws InterruptedException {
        int total = new SWCDataServiceHelper(entityName).count(filters);
        Object[] coll = null;
        int num = 1;
        if (total > batchSize) {
            num = total / batchSize;
            if (total % batchSize > 0) {
                ++num;
            }
        }
        CountDownLatch latch = new CountDownLatch(num);
        ArrayList<Future> futureList = new ArrayList<Future>(num);
        int index = 0;
        while (index < num) {
            int currPageIndex = index++;
            int currPageSize = batchSize;
            MultithreadedQueryTask task = new MultithreadedQueryTask(entityName, selectProperties, filters, orderBy, currPageIndex, currPageSize, latch);
            Future future = SWCThreadPoolFactory.getMultithreadedQueryThreadpool().submit((Callable)task);
            futureList.add(future);
        }
        try {
            boolean flag = latch.await(10L, TimeUnit.MINUTES);
            if (!flag) {
                return new DynamicObject[0];
            }
            for (Future future : futureList) {
                if (coll == null) {
                    coll = (DynamicObject[])future.get();
                    continue;
                }
                coll = (DynamicObject[])ArrayUtils.addAll((Object[])coll, (Object[])((Object[])future.get()));
            }
        }
        catch (ExecutionException e) {
            logger.error((Throwable)e);
        }
        return coll;
    }

    private static class SWCMultithreadedQueryServiceHolder {
        private static final SWCMultithreadedQueryService service = new SWCMultithreadedQueryService();

        private SWCMultithreadedQueryServiceHolder() {
        }
    }
}

