/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.servicehelper;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.api.PermissionService;
import kd.bos.permission.cache.SuperUserCache;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.utils.DbTypeConverter;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.model.DimValueResult;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.SWCErrorInfoEnum;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.MapUtils;

public class SWCPermissionServiceHelper {
    private static Log logger = LogFactory.getLog(SWCPermissionServiceHelper.class);

    public static boolean isSuperUser() {
        long currUserId = RequestContext.get().getCurrUserId();
        return SuperUserCache.isSuperUser((long)currUserId);
    }

    public static boolean hasPermission(Long userId, Long orgId, String appId, String entityNum, String permItemId) {
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"11", (String)appId, (String)entityNum, (String)permItemId);
        if (result.hasAllOrgPerm()) {
            return true;
        }
        List orgIds = result.getHasPermOrgs();
        return orgIds.contains(orgId);
    }

    public static HasPermOrgResult getPermOrgs(String appId, String entityNum, String permItemId) {
        return SWCPermissionServiceHelper.getPermOrgs("11", appId, entityNum, permItemId);
    }

    public static HasPermOrgResult getPermOrgs(String orgViewType, String appId, String entityNum, String permItemId) {
        long userId = RequestContext.get().getCurrUserId();
        return PermissionServiceHelper.getAllPermOrgs((long)userId, (String)orgViewType, (String)appId, (String)entityNum, (String)permItemId);
    }

    public static HasPermOrgResult getPermOrgs(String appId, String entityNum) {
        long userId = RequestContext.get().getCurrUserId();
        return PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"11", (String)appId, (String)entityNum, (String)"47150e89000000ac");
    }

    public static HasPermOrgResult getPermOrgs(Long userId, String appId, String entityNum) {
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"11", (String)appId, (String)entityNum, (String)"47150e89000000ac");
        return result;
    }

    public static List<Long> getUserHasPermOrgs(Long userId) {
        HasPermOrgResult result = PermissionServiceHelper.getUserHasPermOrgs((long)userId);
        if (result.hasAllOrgPerm()) {
            return null;
        }
        return result.getHasPermOrgs();
    }

    public static boolean hasPermByPermItemNum(long userId, String entityName, String permItemNum) {
        String bizAppId = "";
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)entityName)};
        DynamicObject formDy = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (String)"id,bizappid", (QFilter[])filters);
        if (formDy == null) {
            throw new KDBizException(ResManager.loadKDString((String)"{0}\u9875\u9762\u4e0d\u5b58\u5728\u3002", (String)"SWCPermissionServiceHelper_0", (String)"swc-hsbp-business", (Object[])new Object[]{entityName}));
        }
        String formId = formDy.getString("id");
        bizAppId = formDy.getString("bizappid");
        if (SWCStringUtils.isEmpty((String)bizAppId)) {
            bizAppId = SWCPermissionServiceHelper.getAppIdByFormId(formId);
        }
        String permItemId = "";
        QFilter[] permItemFilters = new QFilter[]{new QFilter("number", "=", (Object)permItemNum)};
        DynamicObject permItemDy = BusinessDataServiceHelper.loadSingleFromCache((String)"perm_permitem", (String)"id", (QFilter[])permItemFilters);
        if (permItemDy == null) {
            throw new KDBizException(ResManager.loadKDString((String)"{0}\u6743\u9650\u9879\u4e0d\u5b58\u5728\u3002", (String)"SWCPermissionServiceHelper_1", (String)"swc-hsbp-business", (Object[])new Object[]{permItemNum}));
        }
        permItemId = permItemDy.getString("id");
        return SWCPermissionServiceHelper.hasPerm(userId, bizAppId, entityName, permItemId);
    }

    public static boolean hasPerm(long userId, String entityName, String permItemId) {
        String bizAppId = "";
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)entityName)};
        DynamicObject formDy = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (String)"id,bizappid", (QFilter[])filters);
        if (formDy == null) {
            throw new KDBizException(ResManager.loadKDString((String)"{0}\u9875\u9762\u4e0d\u5b58\u5728\u3002", (String)"SWCPermissionServiceHelper_0", (String)"swc-hsbp-business", (Object[])new Object[]{entityName}));
        }
        String formId = formDy.getString("id");
        bizAppId = formDy.getString("bizappid");
        if (SWCStringUtils.isEmpty((String)bizAppId)) {
            bizAppId = SWCPermissionServiceHelper.getAppIdByFormId(formId);
        }
        return SWCPermissionServiceHelper.hasPerm(userId, bizAppId, entityName, permItemId);
    }

    private static String getAppIdByFormId(String formId) {
        QFilter[] filters = new QFilter[]{new QFilter("form", "=", (Object)formId)};
        DynamicObject unitRelForm = QueryServiceHelper.queryOne((String)"bos_devportal_unitrelform", (String)"bizapp", (QFilter[])filters);
        String bizAppId = unitRelForm.getString("bizapp");
        return bizAppId;
    }

    public static boolean hasPermByPermItemNum(long userId, String appId, String entityName, String permItemNum) {
        String permItemId = "";
        QFilter[] permItemFilters = new QFilter[]{new QFilter("number", "=", (Object)permItemNum)};
        DynamicObject permItemDy = BusinessDataServiceHelper.loadSingleFromCache((String)"perm_permitem", (String)"id", (QFilter[])permItemFilters);
        if (permItemDy == null) {
            throw new KDBizException(ResManager.loadKDString((String)"{0}\u6743\u9650\u9879\u4e0d\u5b58\u5728\u3002", (String)"SWCPermissionServiceHelper_1", (String)"swc-hsbp-business", (Object[])new Object[]{permItemNum}));
        }
        permItemId = permItemDy.getString("id");
        return SWCPermissionServiceHelper.hasPerm(userId, appId, entityName, permItemId);
    }

    public static boolean hasPerm(long userId, String appId, String entityName, String permItemId) {
        return PermissionServiceHelper.hasSpecificPerm((long)userId, (String)appId, (String)entityName, (String)permItemId);
    }

    public static boolean hasPerm(String appId, String entityName, String permItemId) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        return PermissionServiceHelper.hasSpecificPerm((long)userId, (String)appId, (String)entityName, (String)permItemId);
    }

    @Deprecated
    public static String getNoPermTips(String opName) {
        if (SWCStringUtils.isEmpty((String)opName)) {
            return ResManager.loadKDString((String)"\u65e0\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SWCPermissionServiceHelper_2", (String)"swc-hsbp-business", (Object[])new Object[0]);
        }
        return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SWCPermissionServiceHelper_3", (String)"swc-hsbp-business", (Object[])new Object[0]), opName);
    }

    public static String getNoPermTips(String entityName, String opName) {
        if (SWCStringUtils.isEmpty((String)entityName) || SWCStringUtils.isEmpty((String)opName)) {
            return ResManager.loadKDString((String)"\u65e0\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SWCPermissionServiceHelper_2", (String)"swc-hsbp-business", (Object[])new Object[0]);
        }
        return MessageFormat.format(ResManager.loadKDString((String)"\u65e0\u201c{0}\u201d\u7684\u201c{1}\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SWCPermissionServiceHelper_4", (String)"swc-hsbp-business", (Object[])new Object[0]), entityName, opName);
    }

    public static boolean hasViewPermission(String appId, String entityNum) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        return PermissionServiceHelper.hasViewPermission((long)userId, (String)appId, (String)entityNum);
    }

    public static Set<Long> getAdminOrgSetByPermItem(String appId, String entityNumber, String permItemId, String propKey) {
        Long userId = RequestContext.get().getCurrUserId();
        return SWCPermissionServiceHelper.getAdminOrgSetByPermItem(userId, appId, entityNumber, permItemId, propKey);
    }

    public static Set<Long> getAdminOrgSetByPermItem(Long userId, String appId, String entityNumber, String permItemId, String propKey) {
        AuthorizedOrgResult result = (AuthorizedOrgResult)SWCMServiceUtils.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getAuthorizedAdminOrgSet", (Object[])new Object[]{userId, appId, entityNumber, permItemId, propKey});
        if (result.isHasAllOrgPerm()) {
            return null;
        }
        List hasPermOrgs = result.getHasPermOrgs();
        if (hasPermOrgs != null) {
            return new HashSet<Long>(hasPermOrgs);
        }
        return new HashSet<Long>(16);
    }

    public static Set<Long> getAuthorizedAdminOrgsF7(Long userId, String appId, String entityNumber, String permItemId, String propKey) {
        AuthorizedOrgResult result = (AuthorizedOrgResult)SWCMServiceUtils.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getAuthorizedAdminOrgsF7", (Object[])new Object[]{userId, appId, entityNumber, permItemId, propKey});
        if (result.isHasAllOrgPerm()) {
            return null;
        }
        List hasPermOrgs = result.getHasPermOrgs();
        if (hasPermOrgs != null) {
            return new HashSet<Long>(hasPermOrgs);
        }
        return new HashSet<Long>(16);
    }

    public static AuthorizedOrgResult getAuthorizedAdminOrgs(String appId, String entityNumber, String permItemId, String propKey) {
        Long userId = RequestContext.get().getCurrUserId();
        return (AuthorizedOrgResult)SWCMServiceUtils.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getAuthorizedAdminOrgSet", (Object[])new Object[]{userId, appId, entityNumber, permItemId, propKey});
    }

    public static DimValueResult getDimValueResult(Long userId, String appId, String entityNumber, String permItemId, String dimNumber) {
        return (DimValueResult)SWCMServiceUtils.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getEntityDimValue", (Object[])new Object[]{userId, appId, entityNumber, permItemId, dimNumber});
    }

    public static Set<Long> getEmpgrpSetByPermItem(String appId, String entityNumber) {
        return SWCPermissionServiceHelper.getEmpgrpSetByPermItem(appId, entityNumber, "47150e89000000ac");
    }

    public static Set<Long> getEmpgrpSetByPermItem(String appId, String entityNumber, String permItemId) {
        Long userId = RequestContext.get().getCurrUserId();
        return SWCPermissionServiceHelper.getEmpgrpSetByPermItem(userId, appId, entityNumber, permItemId);
    }

    public static Set<Long> getEmpgrpSetByPermItem(Long userId, String appId, String entityNumber, String permItemId) {
        DimValueResult dimValueResult = SWCPermissionServiceHelper.getDimValueResult(userId, appId, entityNumber, permItemId, "empgroup");
        return SWCPermissionServiceHelper.getSetFromDimValue(dimValueResult);
    }

    public static Set<Long> getEmpgrpSetByPermItemAndApp(String appNumber, String appId, String entityNumber) {
        List<Long> appEmpGroupIdList = SWCPermissionServiceHelper.getEmpgroupByAppNumber(appNumber);
        if (CollectionUtils.isEmpty(appEmpGroupIdList)) {
            return null;
        }
        HashSet appEmpGroupIdSet = Sets.newHashSet(appEmpGroupIdList);
        Set<Long> empGroupSet = SWCPermissionServiceHelper.getEmpgrpSetByPermItem(appId, entityNumber, "47150e89000000ac");
        if (empGroupSet == null) {
            return appEmpGroupIdSet;
        }
        return empGroupSet.stream().filter(id -> appEmpGroupIdSet.contains(id)).collect(Collectors.toSet());
    }

    public static Set<Long> getPayrollGrpSetByPermItem(String appId, String entityNumber, String permItemId) {
        Long userId = RequestContext.get().getCurrUserId();
        DimValueResult dimValueResult = SWCPermissionServiceHelper.getDimValueResult(userId, appId, entityNumber, permItemId, "payrollgrp");
        return SWCPermissionServiceHelper.getSetFromDimValue(dimValueResult);
    }

    public static Set<Long> getPayrollSceneSetByPermItem(String appId, String entityNumber, String permItemId) {
        Long userId = RequestContext.get().getCurrUserId();
        DimValueResult dimValueResult = SWCPermissionServiceHelper.getDimValueResult(userId, appId, entityNumber, permItemId, "payrollscene");
        return SWCPermissionServiceHelper.getSetFromDimValue(dimValueResult);
    }

    public static Set<Long> getPayrollCalSetByPermItem(String appId, String entityNumber, String permItemId) {
        Long userId = RequestContext.get().getCurrUserId();
        DimValueResult dimValueResult = SWCPermissionServiceHelper.getDimValueResult(userId, appId, entityNumber, permItemId, "payrollcal");
        return SWCPermissionServiceHelper.getSetFromDimValue(dimValueResult);
    }

    public static Set<Long> getCountrySetByPermItem(String appId, String entityNumber, String permItemId) {
        Long userId = RequestContext.get().getCurrUserId();
        DimValueResult dimValueResult = SWCPermissionServiceHelper.getDimValueResult(userId, appId, entityNumber, permItemId, "country");
        return SWCPermissionServiceHelper.getSetFromDimValue(dimValueResult);
    }

    public static Set<Long> getBizItemSetByPermItem(String appId, String entityNumber, String permItemId) {
        Long userId = RequestContext.get().getCurrUserId();
        DimValueResult dimValueResult = SWCPermissionServiceHelper.getDimValueResult(userId, appId, entityNumber, permItemId, "bizitem");
        return SWCPermissionServiceHelper.getSetFromDimValue(dimValueResult);
    }

    public static Set<Long> getBizItemCategorySetByPermItem(String appId, String entityNumber, String permItemId) {
        Long userId = RequestContext.get().getCurrUserId();
        DimValueResult dimValueResult = SWCPermissionServiceHelper.getDimValueResult(userId, appId, entityNumber, permItemId, "bizitemcategory");
        return SWCPermissionServiceHelper.getSetFromDimValue(dimValueResult);
    }

    public static Set<Long> getBizItemGrpSetByPermItem(String appId, String entityNumber, String permItemId) {
        Long userId = RequestContext.get().getCurrUserId();
        DimValueResult dimValueResult = SWCPermissionServiceHelper.getDimValueResult(userId, appId, entityNumber, permItemId, "bizitemgroup");
        return SWCPermissionServiceHelper.getSetFromDimValue(dimValueResult);
    }

    @Deprecated
    public static Set<Long> getAdminOrgSetByPermItem(String appId, String entityNumber, String permItemId) {
        Long userId = RequestContext.get().getCurrUserId();
        DimValueResult dimValueResult = SWCPermissionServiceHelper.getDimValueResult(userId, appId, entityNumber, permItemId, "adminorgteam");
        return SWCPermissionServiceHelper.getSetFromDimValue(dimValueResult);
    }

    private static Set<Long> getSetFromDimValue(DimValueResult dimValueResult) {
        if (dimValueResult != null) {
            if (dimValueResult.isAll()) {
                return null;
            }
            Set dimValueIds = dimValueResult.getDimValueIds();
            if (dimValueIds == null || dimValueIds.isEmpty()) {
                return new HashSet<Long>();
            }
            return dimValueIds.stream().filter(id -> id != null).map(id -> Long.parseLong(id.trim())).collect(Collectors.toSet());
        }
        logger.error("call IHRCSBizDataPermissionService.getEntityDimValue API error!");
        return new HashSet<Long>();
    }

    public static List<Long> getEmpgroupByAppNumber(String appNumber) {
        return (List)SWCMServiceUtils.invokeHRMPService((String)"hbss", (String)"IHBSSService", (String)"getEmpgroupByAppNumber", (Object[])new Object[]{appNumber});
    }

    public static Set<Long> getAllCompanyByDpt(String appId, String entityNumber, String permItemId, String propKey) {
        Set<Long> adminOrgIds = SWCPermissionServiceHelper.getAdminOrgSetByPermItem(appId, entityNumber, permItemId, propKey);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("haos_adminorghr");
        QFilter filter = new QFilter("id", "in", adminOrgIds);
        DynamicObjectCollection dyColl = helper.queryOriginalCollection("company", new QFilter[]{filter});
        HashSet companyIds = Sets.newHashSet();
        for (DynamicObject dynamicObject : dyColl) {
            long companyId = dynamicObject.getLong("company");
            if (companyId == 0L) continue;
            companyIds.add(companyId);
        }
        return companyIds;
    }

    public static QFilter getBaseDataFilter(String entityID, Long orgID) {
        return BaseDataServiceHelper.getBaseDataFilter((String)entityID, (Long)orgID);
    }

    public static QFilter getBaseDataFilter(String entityID, List<Long> orgID, boolean isRemoveDup) {
        return BaseDataServiceHelper.getBaseDataFilter((String)entityID, orgID, (boolean)isRemoveDup);
    }

    public static Set<Long> getValidBaseDataEntityIds(Collection<DynamicObject> inputEntityDies, String orgFieldId, String refField, String entryEntity) {
        boolean isValid;
        if (inputEntityDies == null || inputEntityDies.size() == 0) {
            return new HashSet<Long>(0);
        }
        boolean isEntryEntity = HRStringUtils.isNotEmpty((String)entryEntity);
        DynamicObject entityDy = inputEntityDies.iterator().next();
        DataEntityPropertyCollection properties = entityDy.getDynamicObjectType().getProperties();
        boolean bl = isValid = properties.containsKey((Object)orgFieldId) && (!isEntryEntity || properties.containsKey((Object)entryEntity));
        if (!isValid) {
            return new HashSet<Long>(0);
        }
        Map<Long, List<DynamicObject>> inputEntityDyGroupByOrg = inputEntityDies.stream().collect(Collectors.groupingBy(inputEntityDy -> inputEntityDy.getLong(orgFieldId + ".id")));
        HashSet<Long> validBaseDataIds = new HashSet<Long>(16);
        for (Map.Entry<Long, List<DynamicObject>> inputEntityDyGroupByOrgEntry : inputEntityDyGroupByOrg.entrySet()) {
            Set<Long> subValidBaseDataIds = SWCPermissionServiceHelper.getSubValidBaseDataIds(isEntryEntity, inputEntityDyGroupByOrgEntry.getKey(), inputEntityDyGroupByOrgEntry.getValue(), refField, entryEntity);
            validBaseDataIds.addAll(subValidBaseDataIds);
        }
        return validBaseDataIds;
    }

    private static Set<Long> getSubValidBaseDataIds(boolean isEntryEntity, Long orgId, List<DynamicObject> subInputEntityDies, String refField, String entryEntity) {
        if (orgId == null || subInputEntityDies == null || subInputEntityDies.isEmpty()) {
            return new HashSet<Long>(0);
        }
        List refEntities = isEntryEntity ? subInputEntityDies.stream().flatMap(inputEntityDy -> inputEntityDy.getDynamicObjectCollection(entryEntity).stream()).filter(entityEntityDy -> entityEntityDy.getDynamicObject(refField) != null && entityEntityDy.getLong(refField + ".id") != 0L).map(tmpEntityDy -> tmpEntityDy.getDynamicObject(refField)).collect(Collectors.toList()) : subInputEntityDies.stream().filter(tmpEntityDy -> tmpEntityDy.getDynamicObject(refField) != null && tmpEntityDy.getLong(refField + ".id") != 0L).map(tmpEntityDy -> tmpEntityDy.getDynamicObject(refField)).collect(Collectors.toList());
        if (refEntities.size() == 0) {
            return new HashSet<Long>(0);
        }
        String refEntityName = ((DynamicObject)refEntities.get(0)).getDynamicObjectType().getName();
        List refEntityIds = refEntities.stream().map(refEntity -> refEntity.getLong("id")).collect(Collectors.toList());
        QFilter orgBaseDataFilter = SWCPermissionServiceHelper.getBaseDataFilter(refEntityName, orgId);
        QFilter entityFilter = new QFilter("id", "in", refEntityIds);
        entityFilter.and(orgBaseDataFilter);
        SWCDataServiceHelper helper = new SWCDataServiceHelper(refEntityName);
        DynamicObjectCollection entityDys = helper.queryOriginalCollection("id", entityFilter.toArray());
        if (entityDys == null || entityDys.size() == 0) {
            return new HashSet<Long>(0);
        }
        return entityDys.stream().map(tmpEntityDy -> tmpEntityDy.getLong("id")).collect(Collectors.toSet());
    }

    public static QFilter getOrgFilterByOrgPerm(String appId, String permEntityNumber, String permItemId, String baseDataEntity) {
        HasPermOrgResult permOrgResult = SWCPermissionServiceHelper.getPermOrgs(appId, permEntityNumber, permItemId);
        if (permOrgResult.hasAllOrgPerm()) {
            return null;
        }
        List orgIDList = permOrgResult.getHasPermOrgs();
        if (orgIDList == null) {
            return new QFilter("1", "!=", (Object)1);
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)baseDataEntity);
        String mainOrg = type.getMainOrg();
        return new QFilter(mainOrg, "in", (Object)orgIDList);
    }

    public static String getPermissionOfDataEntityOperate(String entityNumber, String opKey) {
        if (HRStringUtils.isEmpty((String)opKey)) {
            return null;
        }
        try {
            Map operateMetaMap = EntityMetadataCache.getDataEntityOperate((String)entityNumber, (String)opKey);
            String permissionItemId = null;
            if (operateMetaMap != null) {
                permissionItemId = (String)operateMetaMap.get("permission");
            }
            return permissionItemId;
        }
        catch (Exception ex) {
            logger.error("SWCPermissionServiceHelper.getPermissionOfDataEntityOperate, error info is: ", (Throwable)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("", ex.getMessage()), new Object[0]);
        }
    }

    public static List<QFilter> getAuthorizedDataRuleQFilterByOpKey(String appId, String entityNumber, String opKey) {
        String permissionItemIdOfOpKey = null;
        try {
            permissionItemIdOfOpKey = SWCPermissionServiceHelper.getPermissionOfDataEntityOperate(entityNumber, opKey);
        }
        catch (Exception ex) {
            logger.error("SWCPermissionServiceHelper.getAuthorizedDataRuleQFilterByOpKey, error info is: ", (Throwable)ex);
        }
        return SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter(RequestContext.get().getCurrUserId(), appId, entityNumber, permissionItemIdOfOpKey);
    }

    public static List<QFilter> getAuthorizedDataRuleQFilter(String appId, String entityNumber, String permItemId) {
        return SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter(RequestContext.get().getCurrUserId(), appId, entityNumber, permItemId);
    }

    public static List<QFilter> getAuthorizedDataRuleQFilter(long userId, String appId, String entityNumber, String permItemId) {
        ArrayList qFilters = Lists.newArrayListWithExpectedSize((int)10);
        if (PermissionServiceHelper.isSuperUser((long)userId)) {
            logger.info("SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter: the current user is supper user.");
            qFilters.add(new QFilter("1", "=", (Object)1));
            return qFilters;
        }
        if (!SWCPermissionServiceHelper.hasPerm(userId, appId, entityNumber, permItemId)) {
            logger.info("SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter: the current user does not have any permission.");
            return null;
        }
        QFilter qFilter = (QFilter)SWCMServiceUtils.invokeHRMPService((String)"hrcs", (String)"IHRCSDataPermissionService", (String)"getDataRule", (Object[])new Object[]{userId, appId, entityNumber, permItemId, new HashMap()});
        if (qFilter == null) {
            qFilter = new QFilter("1", "=", (Object)1);
        }
        logger.info("SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter: the filter info is [{}]", (Object)qFilter.toString());
        qFilters.add(qFilter);
        return qFilters;
    }

    public static QFilter getDataRuleForBdProp(String appId, String parentEntityNumber, String propFullKey) {
        return SWCPermissionServiceHelper.getDataRuleForBdProp(RequestContext.get().getCurrUserId(), appId, parentEntityNumber, propFullKey, "47156aff000000ac");
    }

    public static QFilter getDataRuleForBdProp(long userId, String appId, String parentEntityNumber, String propFullKey, String permItemId) {
        return (QFilter)SWCMServiceUtils.invokeHRMPService((String)"hrcs", (String)"IHRCSDataPermissionService", (String)"getDataRuleForBdProp", (Object[])new Object[]{userId, appId, parentEntityNumber, propFullKey, permItemId, new HashMap()});
    }

    public static Set<Long> getTaxUnitSetByPermItem(String appId, String entityNumber, String permItemId) {
        Long userId = RequestContext.get().getCurrUserId();
        return SWCPermissionServiceHelper.getTaxUnitSetByPermItem(userId, appId, entityNumber, permItemId);
    }

    public static Set<Long> getTaxUnitSetByPermItem(Long userId, String appId, String entityNumber, String permItemId) {
        DimValueResult dimValueResult = SWCPermissionServiceHelper.getDimValueResult(userId, appId, entityNumber, permItemId, "taxunit");
        return SWCPermissionServiceHelper.getSetFromDimValue(dimValueResult);
    }

    public static boolean checkCancelDataAndFunctionRight(IFormView iFormView, boolean fillEntityName) {
        return SWCPermissionServiceHelper.checkCancelFunctionRight(iFormView, fillEntityName, false) || SWCPermissionServiceHelper.checkCancelDataRight(iFormView, false);
    }

    public static boolean checkCancelDataAndFunctionRightWithException(IFormView iFormView, boolean fillEntityName) throws KDBizException {
        return SWCPermissionServiceHelper.checkCancelFunctionRight(iFormView, fillEntityName, true) || SWCPermissionServiceHelper.checkCancelDataRight(iFormView, true);
    }

    public static boolean checkCancelFunctionRight(IFormView iFormView, boolean fillEntityName, boolean withException) {
        FormShowParameter formShowParameter;
        if (iFormView != null && (formShowParameter = iFormView.getFormShowParameter()) != null && formShowParameter.getCancelRight() != 0) {
            String formName;
            FormConfig config = formShowParameter.getFormConfig();
            String string = formName = fillEntityName ? "\"" + config.getCaption().toString() + "\"" : "";
            if (withException) {
                throw new KDBizException(SWCErrorInfoEnum.COMMON_FUNCTION_RIGHT_CHANGED.getErrInfo(new Object[]{formName}));
            }
            iFormView.showConfirm(SWCErrorInfoEnum.COMMON_FUNCTION_RIGHT_CHANGED.getErrInfo(new Object[]{formName}), MessageBoxOptions.OK, ConfirmTypes.Default, new ConfirmCallBackListener(SWCErrorInfoEnum.COMMON_FUNCTION_RIGHT_CHANGED.getErrCode()));
            return true;
        }
        return false;
    }

    public static boolean checkCancelDataRight(IFormView iFormView, Boolean withException) {
        boolean hasDataPerm;
        boolean isCancelDataRight;
        if (iFormView == null) {
            return false;
        }
        FormShowParameter parentViewParameter = SessionManager.getCurrent().getFormShowParameter(iFormView.getFormShowParameter().getParentPageId());
        boolean bl = isCancelDataRight = parentViewParameter != null && parentViewParameter.isCancelDataRight();
        if (!isCancelDataRight && !(hasDataPerm = SWCPermissionServiceHelper.checkHasDataPerm(iFormView.getFormShowParameter()))) {
            isCancelDataRight = true;
        }
        if (isCancelDataRight) {
            iFormView.getFormShowParameter().setCancelDataRight(true);
            if (withException.booleanValue()) {
                throw new KDBizException(SWCErrorInfoEnum.COMMON_DATA_RIGHT_CHANGED.getErrInfo());
            }
            iFormView.showConfirm(SWCErrorInfoEnum.COMMON_DATA_RIGHT_CHANGED.getErrInfo(), MessageBoxOptions.OK, ConfirmTypes.Default, new ConfirmCallBackListener(SWCErrorInfoEnum.COMMON_DATA_RIGHT_CHANGED.getErrCode()));
            return isCancelDataRight;
        }
        return isCancelDataRight;
    }

    private static boolean checkHasDataPerm(FormShowParameter showParameter) {
        boolean exists;
        BillShowParameter billParam;
        String entityId;
        MainEntityType entityType;
        int dbType;
        FormConfig fc;
        String entityTypeId = SWCPermissionServiceHelper.getEntityTypeId(showParameter);
        String permItem = showParameter.getPermissionItemId();
        String appId = showParameter.getCheckRightAppId();
        long userId = RequestContext.get().getCurrUserId();
        String bizAppId = StringUtils.isBlank((CharSequence)appId) ? (StringUtils.isBlank((CharSequence)(fc = FormMetadataCache.getFormConfig((String)entityTypeId)).getBizAppNumber()) ? BizAppServiceHelp.getAppIdByFormNum((String)entityTypeId) : BizAppServiceHelp.getAppIdByAppNumber((String)fc.getBizAppNumber())) : AppMetadataCache.getAppInfo((String)appId).getId();
        Object pkId = null;
        if (showParameter instanceof BillShowParameter && (pkId = DbTypeConverter.safeConvert((int)(dbType = (entityType = EntityMetadataCache.getDataEntityType((String)(entityId = (billParam = (BillShowParameter)showParameter).getFormConfig().getEntityTypeId()))).getPrimaryKey().getDbType()), (Object)billParam.getPkId())) != null && !(exists = QueryServiceHelper.exists((String)entityTypeId, (Object)pkId))) {
            pkId = null;
        }
        boolean hasPerm = true;
        if (pkId != null) {
            QFilter[] qfilters = new QFilter[]{new QFilter("id", "=", pkId)};
            PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
            hasPerm = permissionService.matchDataRule(userId, bizAppId, entityTypeId, permItem, qfilters);
            if (!hasPerm) {
                return hasPerm;
            }
            boolean specialDataRuleDisable = Boolean.parseBoolean(System.getProperty("specialDataRuleDisable.on", "false"));
            if (specialDataRuleDisable && !(hasPerm = SWCPermissionServiceHelper.matchSpecialDataRule(permItem, entityTypeId, bizAppId, pkId, permissionService))) {
                return hasPerm;
            }
        }
        return hasPerm;
    }

    private static String getEntityTypeId(FormShowParameter showParameter) {
        String formId;
        String entityTypeId = null;
        entityTypeId = showParameter instanceof ListShowParameter ? (StringUtils.isBlank((CharSequence)(formId = ((ListShowParameter)showParameter).getBillFormId())) ? showParameter.getFormId() : FormMetadataCache.getFormConfig((String)formId).getEntityTypeId()) : (!(showParameter instanceof BillShowParameter) && !(showParameter instanceof MobileFormShowParameter) ? showParameter.getFormId() : showParameter.getFormConfig().getEntityTypeId());
        return entityTypeId;
    }

    private static boolean matchSpecialDataRule(String permItem, String entityTypeId, String bizAppId, Object pkId, PermissionService permissionService) {
        QFilter specialDataPermFilter;
        StringBuilder sbNotMatchTips = new StringBuilder();
        String operationKey = "view";
        if ("4715a0df000000ac".equals(permItem)) {
            operationKey = "modify";
        }
        if ((specialDataPermFilter = permissionService.getOperationRuleFilter(bizAppId, entityTypeId, operationKey, sbNotMatchTips)) != null) {
            ArrayList<QFilter> allFilterList = new ArrayList<QFilter>();
            allFilterList.add(specialDataPermFilter);
            allFilterList.add(new QFilter("id", "=", pkId));
            return QueryServiceHelper.exists((String)entityTypeId, (QFilter[])allFilterList.toArray(new QFilter[0]));
        }
        return true;
    }

    public static boolean checkCancelDataRight(IFormView iFormView) {
        return SWCPermissionServiceHelper.checkCancelDataRight(iFormView, Boolean.FALSE);
    }

    public static Set<Long> getStdScmSetByPermItem(String appId, String entityNumber, String permItemId) {
        Long userId = RequestContext.get().getCurrUserId();
        DimValueResult dimValueResult = SWCPermissionServiceHelper.getDimValueResult(userId, appId, entityNumber, permItemId, "stdscm");
        return SWCPermissionServiceHelper.getSetFromDimValue(dimValueResult);
    }

    public static Set<Long> getSalayStructureSetByPermItem(String appId, String entityNumber, String permItemId) {
        Long userId = RequestContext.get().getCurrUserId();
        DimValueResult dimValueResult = SWCPermissionServiceHelper.getDimValueResult(userId, appId, entityNumber, permItemId, "salaystructure");
        return SWCPermissionServiceHelper.getSetFromDimValue(dimValueResult);
    }

    public static boolean checkEntityOperatePerm(IFormView view, String appId, String entityNumber, String operateNumber) {
        String permItemId = null;
        Map entityOperate = EntityMetadataCache.getDataEntityOperate((String)entityNumber, (String)operateNumber);
        if (entityOperate == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u4f53{0}\u7684\u64cd\u4f5c{1}\u5bf9\u5e94\u7684\u5143\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"SWCPermissionServiceHelper_5", (String)"swc-hsbp-business", (Object[])new Object[]{entityNumber, operateNumber}));
        }
        permItemId = MapUtils.getString((Map)entityOperate, (Object)"permission");
        if (StringUtils.isBlank((CharSequence)permItemId)) {
            return true;
        }
        long userId = RequestContext.get().getCurrUserId();
        boolean hasPerm = SWCPermissionServiceHelper.hasPerm(userId, appId, entityNumber, permItemId);
        if (!hasPerm) {
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            String permEntityName = "";
            if (mainType != null) {
                permEntityName = mainType.getDisplayName().getLocaleValue();
            }
            Map permOperateName = MapUtils.getMap((Map)entityOperate, (Object)"name", new HashMap(0));
            String permOperateLocaleName = MapUtils.getString((Map)permOperateName, (Object)RequestContext.get().getLang().name());
            view.showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c{0}\u201d\u7684\u201c{1}\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SWCPermissionServiceHelper_4", (String)"swc-hsbp-business", (Object[])new Object[]{permEntityName, permOperateLocaleName}));
            return false;
        }
        return true;
    }

    public static Set<Long> getBizDataDimSetByPermItem(String appId, String entityNumber, String permItemId) {
        Long userId = RequestContext.get().getCurrUserId();
        DimValueResult dimValueResult = SWCPermissionServiceHelper.getDimValueResult(userId, appId, entityNumber, permItemId, "bizdatadim");
        return SWCPermissionServiceHelper.getSetFromDimValue(dimValueResult);
    }

    public static Long getCurUserHasPermOrg(String orgViewType, String appId, String entityNum, String permItemId) {
        List hasPermOrgs;
        long orgId = RequestContext.get().getOrgId();
        HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs(orgViewType, appId, entityNum, permItemId);
        if (!(permOrgs.hasAllOrgPerm() || (hasPermOrgs = permOrgs.getHasPermOrgs()) != null && !hasPermOrgs.isEmpty() && hasPermOrgs.contains(orgId))) {
            return 0L;
        }
        Long viewID = PermCommonUtil.getViewIdByNumber((String)orgViewType);
        DynamicObjectCollection orgsCol = QueryServiceHelper.query((String)"bos_org_structure", (String)"org", (QFilter[])new QFilter[]{new QFilter("view", "=", (Object)viewID)});
        for (DynamicObject orgDy : orgsCol) {
            if (orgId != orgDy.getLong("org")) continue;
            return orgId;
        }
        return 0L;
    }

    public static Set<Long> queryBaseDataUseOrgSet(String entityNumber, Long orgId, Set<Long> baseDataIdSet) {
        if (SWCStringUtils.isEmpty((String)entityNumber)) {
            return Collections.emptySet();
        }
        QFilter qFilter = baseDataIdSet == null ? new QFilter("1", "=", (Object)1) : new QFilter("id", "in", baseDataIdSet);
        DynamicObjectCollection queryBaseData = BaseDataServiceHelper.queryBaseData((String)entityNumber, (Long)orgId, (QFilter)qFilter, (String)"id");
        HashSet queryIdSet = queryBaseData.stream().map(item -> item.getLong("id")).collect(Collectors.toSet());
        return queryIdSet == null ? new HashSet(0) : queryIdSet;
    }

    public static Map<Long, Set<Long>> queryBaseDataByOrgMap(String entityNumber, Map<Long, Set<Long>> orgDataMap) {
        if (SWCStringUtils.isEmpty((String)entityNumber)) {
            return Collections.emptyMap();
        }
        HashMap<Long, Set<Long>> baseDataOrgMap = new HashMap<Long, Set<Long>>(16);
        for (Map.Entry<Long, Set<Long>> entry : orgDataMap.entrySet()) {
            Long orgId = entry.getKey();
            Set<Long> baseDataIdSet = entry.getValue();
            Set<Long> queryIdSet = SWCPermissionServiceHelper.queryBaseDataUseOrgSet(entityNumber, orgId, baseDataIdSet);
            Set tempIdSet = baseDataOrgMap.computeIfAbsent(orgId, item -> new HashSet(16));
            if (CollectionUtils.isEmpty(queryIdSet)) continue;
            tempIdSet.addAll(queryIdSet);
        }
        return baseDataOrgMap;
    }

    public static Map<Long, Set<Long>> queryBaseDataByOrgSet(String entityNumber, Set<Long> orgIdSet, Set<Long> baseDataIdSet) {
        if (SWCStringUtils.isEmpty((String)entityNumber) || CollectionUtils.isEmpty(orgIdSet)) {
            return Collections.emptyMap();
        }
        HashMap<Long, Set<Long>> baseDataOrgMap = new HashMap<Long, Set<Long>>(16);
        for (Long orgId : orgIdSet) {
            Set<Long> queryIdSet = SWCPermissionServiceHelper.queryBaseDataUseOrgSet(entityNumber, orgId, baseDataIdSet);
            Set tempIdSet = baseDataOrgMap.computeIfAbsent(orgId, item -> new HashSet(16));
            if (CollectionUtils.isEmpty(queryIdSet)) continue;
            tempIdSet.addAll(queryIdSet);
        }
        return baseDataOrgMap;
    }

    public static Set<Long> getPayrollCdmSetByPermItem(String appId, String entityNumber, String permItemId) {
        Long userId = RequestContext.get().getCurrUserId();
        DimValueResult dimValueResult = SWCPermissionServiceHelper.getDimValueResult(userId, appId, entityNumber, permItemId, "payrollcdm");
        return SWCPermissionServiceHelper.getSetFromDimValue(dimValueResult);
    }
}

