/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.tab;

import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.mvc.SessionManager;

public class UpdateTabNameHelper {
    public static void updateTabName(IFormView formView, String fieldKey) {
        String name = formView.getModel().getDataEntity().getString(fieldKey);
        UpdateTabNameHelper.updateTabNameBySuffixValue(formView, name);
    }

    public static void updateTabNameBySuffixValue(IFormView formView, String suffixValue) {
        String appId = formView.getFormShowParameter().getAppId();
        IFormView mainView = formView.getMainView();
        if (appId != null && mainView != null) {
            IFormView appView = SessionManager.getCurrent().getViewNoPlugin(formView.getFormShowParameter().getAppId() + mainView.getPageId());
            if (appView == null) {
                return;
            }
            Tab tab = (Tab)appView.getControl("_submaintab_");
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)formView.getEntityId());
            String displayName = mainEntityType.getDisplayName().getLocaleValue();
            if (!ObjectUtils.isEmpty((Object)suffixValue) && tab != null) {
                displayName = displayName + " - " + suffixValue;
                tab.updateTabName(formView.getPageId(), displayName);
                formView.sendFormAction(appView);
            }
        }
    }

    public static void updateTabNameByWholeValue(IFormView formView, String value) {
        String appId = formView.getFormShowParameter().getAppId();
        IFormView mainView = formView.getMainView();
        if (appId != null && mainView != null) {
            IFormView appView = SessionManager.getCurrent().getViewNoPlugin(formView.getFormShowParameter().getAppId() + mainView.getPageId());
            if (appView == null) {
                return;
            }
            Tab tab = (Tab)appView.getControl("_submaintab_");
            if (!ObjectUtils.isEmpty((Object)value) && tab != null) {
                tab.updateTabName(formView.getPageId(), value);
                formView.sendFormAction(appView);
            }
        }
    }
}

