/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.threadpool;

import java.util.ArrayList;
import java.util.List;
import kd.bos.unifiedthreadpool.api.PoolRejectedExecutionHandler;
import kd.bos.unifiedthreadpool.api.ThreadExecutorService;
import kd.bos.unifiedthreadpool.api.ThreadPoolFactory;
import kd.bos.unifiedthreadpool.api.ThreadPoolStrategy;
import kd.bos.unifiedthreadpool.api.ThreadPoolStrategyFactory;
import kd.bos.unifiedthreadpool.policy.AbortPolicy;
import kd.bos.unifiedthreadpool.tasktype.TaskType;
import kd.swc.hsbp.common.enums.SWCUnifiedTaskTypeEnum;

public class SWCUnifiedThreadPoolFactory {
    private static final int NUM_MINTHREAD = 50;
    private static final int NUM_MAXTHREAD = 150;
    private static final int NUM_OVERFLOWTHREAD = 20;
    public static final ThreadExecutorService SERVICE = ThreadPoolFactory.create((String)"swc", (String)"swc-threadpool", (ThreadPoolStrategy)SWCUnifiedThreadPoolFactory.getDefaultThreadPoolStrategy());

    private static ThreadPoolStrategy getDefaultThreadPoolStrategy() {
        ThreadPoolStrategy strategy = ThreadPoolStrategyFactory.create();
        int sumThreadNum = SWCUnifiedThreadPoolFactory.getSumThreadNum();
        int minThreadNum = sumThreadNum <= 50 ? sumThreadNum : 50;
        int maxThreadNum = sumThreadNum <= 150 ? sumThreadNum : 150;
        int overflowThreadNum = sumThreadNum - 150;
        overflowThreadNum = overflowThreadNum < 0 ? 0 : overflowThreadNum;
        overflowThreadNum = overflowThreadNum < 20 ? overflowThreadNum : 20;
        strategy.setMinThreadNum(minThreadNum).setMaxThreadNum(maxThreadNum).setOverflowThreadNum(overflowThreadNum).setThreadIdeMinutes(1L);
        strategy.setRejectedExecutionHandler((PoolRejectedExecutionHandler)new AbortPolicy());
        strategy.register(SWCUnifiedThreadPoolFactory.getTaskType());
        return strategy;
    }

    private static int getSumThreadNum() {
        int num = 0;
        for (SWCUnifiedTaskTypeEnum taskTypeEnum : SWCUnifiedTaskTypeEnum.values()) {
            num += taskTypeEnum.getThreadLimitedValue();
        }
        return num;
    }

    private static List<TaskType> getTaskType() {
        ArrayList<TaskType> taskTypeList = new ArrayList<TaskType>(SWCUnifiedTaskTypeEnum.values().length);
        for (SWCUnifiedTaskTypeEnum taskTypeEnum : SWCUnifiedTaskTypeEnum.values()) {
            TaskType taskType = new TaskType(taskTypeEnum.getKey(), taskTypeEnum.getPriority(), taskTypeEnum.getThreadLimitedModel(), (Object)taskTypeEnum.getThreadLimitedValue(), taskTypeEnum.getTaskQueueMaxSize());
            taskTypeList.add(taskType);
        }
        return taskTypeList;
    }

    private static void main(String[] args) {
        SERVICE.execute(() -> {}, SWCUnifiedTaskTypeEnum.SWC_COMMONASYNCTHREADPOOL.getKey(), null, null);
        SERVICE.execute(() -> {}, SWCUnifiedTaskTypeEnum.SWC_HSAS_PERSONSYNCTHREADPOOL.getKey(), null, null);
    }
}

