/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.business.util;

import java.io.IOException;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.operate.MutexHelper;
import kd.bos.mutex.DataMutex;
import kd.swc.hsbp.common.enums.ResultStatusEnum;
import kd.swc.hsbp.common.model.MutexLockInfo;
import kd.swc.hsbp.common.util.BaseResult;

public class MutexServiceHelper {
    public static BaseResult<MutexLockInfo> require(String entityName, String pkId, String opKey) {
        return MutexServiceHelper.require(entityName, pkId, opKey, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BaseResult<MutexLockInfo> require(String entityName, String pkId, String opKey, boolean isStrict) {
        StringBuilder msg = new StringBuilder();
        boolean require = MutexHelper.require((String)entityName, (Object)pkId, (String)opKey, (boolean)isStrict, (StringBuilder)msg);
        if (require) {
            BaseResult result = BaseResult.success(null);
            return result.ofMessage(msg.toString());
        }
        String groupId = MutexHelper.getMutexGroupId((String)entityName, (String)opKey);
        DataMutex dataMutex = null;
        try {
            dataMutex = DataMutex.create();
            Map mutex = dataMutex.getLockInfo(pkId, groupId, entityName);
            BaseResult result = BaseResult.fail((String)msg.toString());
            BaseResult baseResult = result.ofData((Object)new MutexLockInfo().initByMap(mutex));
            return baseResult;
        }
        finally {
            if (dataMutex != null) {
                try {
                    dataMutex.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BaseResult<MutexLockInfo> release(String entityName, String pkId, String opKey) {
        String groupId = MutexHelper.getMutexGroupId((String)entityName, (String)opKey);
        DataMutex dataMutex = null;
        try {
            String currentOwner;
            dataMutex = DataMutex.create();
            Map mutex = dataMutex.getLockInfo(pkId, groupId, entityName);
            if (null == mutex || mutex.isEmpty()) {
                BaseResult result = BaseResult.success(null);
                BaseResult baseResult = result.ofMessage("not locked").ofStatus(ResultStatusEnum.WARN.getCode());
                return baseResult;
            }
            String lockOwner = (String)mutex.get("GLOBALSESSION");
            if (!ObjectUtils.nullSafeEquals((Object)lockOwner, (Object)(currentOwner = RequestContext.get().getGlobalSessionId()))) {
                BaseResult baseResult = BaseResult.fail((String)"lock owner is not current user");
                return baseResult;
            }
            boolean release = MutexHelper.release((String)entityName, (String)opKey, (String)pkId);
            BaseResult baseResult = new BaseResult(release, (Object)new MutexLockInfo().initByMap(mutex), "");
            return baseResult;
        }
        finally {
            if (dataMutex != null) {
                try {
                    dataMutex.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BaseResult<MutexLockInfo> releaseForce(String entityName, String pkId, String opKey) {
        String groupId = MutexHelper.getMutexGroupId((String)entityName, (String)opKey);
        DataMutex dataMutex = null;
        dataMutex = DataMutex.create();
        Map mutex = dataMutex.getLockInfo(pkId, groupId, entityName);
        if (null == mutex || mutex.isEmpty()) {
            BaseResult result = BaseResult.success(null);
            BaseResult baseResult = result.ofMessage("not locked").ofStatus(ResultStatusEnum.WARN.getCode());
            return baseResult;
        }
        boolean release = MutexHelper.release((String)entityName, (String)opKey, (String)pkId);
        BaseResult baseResult = new BaseResult(release, (Object)new MutexLockInfo().initByMap(mutex), "");
        return baseResult;
        finally {
            if (dataMutex != null) {
                try {
                    dataMutex.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BaseResult<MutexLockInfo> getMutexLockInfo(String entityName, String pkId, String opKey) {
        DataMutex dataMutex = null;
        try {
            String groupId = MutexHelper.getMutexGroupId((String)entityName, (String)opKey);
            dataMutex = DataMutex.create();
            Map mutex = dataMutex.getLockInfo(pkId, groupId, entityName);
            BaseResult result = mutex == null ? BaseResult.fail((String)"") : BaseResult.success(null);
            BaseResult baseResult = result.ofData((Object)new MutexLockInfo().initByMap(mutex));
            return baseResult;
        }
        finally {
            if (dataMutex != null) {
                try {
                    dataMutex.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

