/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.addperson.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.converter.util.CollectionUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hsas.business.extpoint.calperson.IAddCalPersonExtService;
import kd.sdk.swc.hsas.common.events.calperson.AfterAddCalpersonEvent;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.enums.OnHoldStatusEnum;
import kd.swc.hsbp.common.enums.PayStateEnum;
import kd.swc.hsbp.common.enums.TaxStateEnum;
import kd.swc.hsbp.common.history.model.SWCHisBaseConstants;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.vo.SWCOperationResult;
import kd.swc.hscs.business.addperson.service.AddCalPersonExtService;
import kd.swc.hscs.business.addperson.service.ProrationGenerateService;

public class CalAddPersonService {
    public final Log log = LogFactory.getLog(CalAddPersonService.class);
    private long payrolltaskId;
    private List<Long> fileVids;
    private Boolean isExc = Boolean.FALSE;
    private Set<Long> exceptionFilevs = new HashSet<Long>(16);
    private List<Long> personhrIds = new ArrayList<Long>(500);
    private List<Long> salaryFileBoIds = new ArrayList<Long>(500);
    private List<Long> empolyeeIds = new ArrayList<Long>(500);
    private List<Long> empposorgrelIds = new ArrayList<Long>(500);
    private List<Long> manascoperecordIds = new ArrayList<Long>(500);
    private Date startDate;
    private Date endDate;
    private DynamicObject taskDy;
    private List<DynamicObject> filevObjs;
    private Map<Long, List<DynamicObject>> empposorgrelMap;
    private Map<Long, List<DynamicObject>> manascoperecordMap;
    private Map<Long, List<DynamicObject>> personMap;
    private Map<Long, List<DynamicObject>> pernontspropMap;
    private Map<Long, List<DynamicObject>> pertspropMap;
    private Map<Long, List<DynamicObject>> employeeMap;
    private Map<Long, List<DynamicObject>> empjobrelMap;
    private Map<Long, List<DynamicObject>> empentrelMap;
    private Map<Long, List<DynamicObject>> trialperiodMap;
    private Map<Long, List<DynamicObject>> perserlenMap;
    private Map<Long, String> onHoldBillMap;
    private Map<Long, String> salaryFileOnHoldStatusMap;
    private String tid;
    private List<Long> onholdFileIds = new ArrayList<Long>(10);
    private boolean islssuepayslip;

    public Boolean getExc() {
        return this.isExc;
    }

    public Set<Long> getExceptionFilevs() {
        return this.exceptionFilevs;
    }

    public void setExceptionFilevs(Set<Long> exceptionFilevs) {
        this.exceptionFilevs = exceptionFilevs;
    }

    public void setExc(Boolean exc) {
        this.isExc = exc;
    }

    public CalAddPersonService(DynamicObject task, List<Long> fileIds, Map<Long, String> onHoldBillMap, boolean islssuepayslip) {
        this.payrolltaskId = task.getLong("id");
        this.taskDy = task;
        this.fileVids = new ArrayList<Long>(fileIds);
        this.onHoldBillMap = onHoldBillMap;
        this.islssuepayslip = islssuepayslip;
    }

    public Map<String, SWCOperationResult> batchAddCalPerson() {
        this.tid = String.valueOf(Thread.currentThread().getId());
        this.queryFile();
        this.batchGetFileData();
        this.createAndSaveCalTableList();
        HashMap<String, SWCOperationResult> resultMap = new HashMap<String, SWCOperationResult>(2);
        resultMap.put("addperson", new SWCOperationResult(this.fileVids.size(), this.fileVids.size(), null));
        return resultMap;
    }

    public DynamicObjectCollection batchGetCalPerson() {
        this.tid = String.valueOf(Thread.currentThread().getId());
        this.queryFile();
        this.batchGetFileData();
        return this.getCalPersonList();
    }

    private DynamicObjectCollection getCalPersonList() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        DynamicObjectCollection objs = new DynamicObjectCollection();
        Date payrolldate = this.taskDy.getDate("payrolldate");
        Long calPeriodId = this.taskDy.getLong("period.id");
        for (int i = 0; i < this.filevObjs.size(); ++i) {
            DynamicObject newObj = helper.generateEmptyDynamicObject();
            DynamicObject filevObj = this.filevObjs.get(i);
            Long personId = filevObj.getLong("person.id");
            Long employeeId = filevObj.getLong("employee.id");
            Long jobId = this.fillFileInfo(newObj, filevObj);
            this.fillPersonInfo(newObj, personId);
            this.fillEmployeeInfo(newObj, employeeId, jobId);
            newObj.set("caltask", (Object)this.payrolltaskId);
            newObj.set("belongperiod", (Object)payrolldate);
            newObj.set("calperiod", (Object)calPeriodId);
            newObj.set("taxstatus", (Object)TaxStateEnum.UNPUSH.getCode());
            newObj.set("calstatus", (Object)CalStateEnum.UNCAL.getCode());
            newObj.set("paystatus", (Object)PayStateEnum.UNCREATE.getCode());
            newObj.set("allotstatus", (Object)"A");
            newObj.set("salarystatus", (Object)"1");
            newObj.set("bizdatagenstatus", (Object)"1");
            objs.add((Object)newObj);
        }
        if (!SWCObjectUtils.isEmpty((Object)objs)) {
            this.callExtService(objs);
            return objs;
        }
        return new DynamicObjectCollection();
    }

    private void queryFile() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryfile");
        DynamicObject[] filevObjArr = helper.query("id,number,org.id,adminorg.id,empgroup.id,empposinfo.id,managingscope.id,employee.id,person.id,boid", new QFilter[]{new QFilter("id", "in", this.fileVids)}, "boid desc");
        this.filevObjs = Arrays.asList(filevObjArr);
        for (DynamicObject fileObj : this.filevObjs) {
            this.personhrIds.add(fileObj.getLong("person.id"));
            this.empolyeeIds.add(fileObj.getLong("employee.id"));
            this.empposorgrelIds.add(fileObj.getLong("empposinfo.id"));
            this.manascoperecordIds.add(fileObj.getLong("managingscope.id"));
            this.salaryFileBoIds.add(fileObj.getLong("boid"));
        }
    }

    private void batchGetFileData() {
        this.startDate = this.taskDy.getDate("startdate");
        this.endDate = this.taskDy.getDate("enddate");
        this.startDate = SWCDateTimeUtils.getDateWithoutMinTs((Date)this.startDate);
        this.endDate = SWCDateTimeUtils.getDateWithoutMinTs((Date)this.endDate);
        this.queryPerson();
        this.queryEmployee();
        this.getEmpposorgrel();
        this.getManagingscope();
        this.getPernontsprop();
        this.getPertsprop();
        this.getEmpjobrel();
        this.getEmpentrel();
        this.getPerserlen();
        this.getTrialperiod();
        this.getSalaryFileOnHoldStatus();
    }

    public void getSalaryFileOnHoldStatus() {
        if (this.salaryFileBoIds == null || this.salaryFileBoIds.size() == 0) {
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_onholdfile");
        QFilter qFilter = new QFilter("salaryfile.id", "in", this.salaryFileBoIds);
        qFilter.and("status", "in", (Object)new String[]{String.valueOf(OnHoldStatusEnum.STATUS_RELEASE.getCode()), String.valueOf(OnHoldStatusEnum.STATUS_ONHOLD.getCode()), String.valueOf(OnHoldStatusEnum.STATUS_TOPAY.getCode()), String.valueOf(OnHoldStatusEnum.STATUS_STOPPAY.getCode())});
        DynamicObjectCollection onHoldColl = helper.queryOriginalCollection("salaryfile.id,status,startdate", new QFilter[]{qFilter}, "modifytime asc");
        if (onHoldColl == null || onHoldColl.size() == 0) {
            return;
        }
        if (this.salaryFileOnHoldStatusMap == null) {
            this.salaryFileOnHoldStatusMap = new HashMap<Long, String>(16);
        }
        for (DynamicObject onHoldObj : onHoldColl) {
            Date onHoldStartDate = onHoldObj.getDate("startdate");
            if (onHoldStartDate == null) continue;
            Long salaryFileId = onHoldObj.getLong("salaryfile.id");
            if (onHoldStartDate.getTime() > this.endDate.getTime()) {
                this.salaryFileOnHoldStatusMap.put(salaryFileId, " ");
                continue;
            }
            String onHoldStatus = onHoldObj.getString("status");
            this.salaryFileOnHoldStatusMap.put(salaryFileId, onHoldStatus);
            if (!SWCStringUtils.equals((String)onHoldStatus, (String)String.valueOf(OnHoldStatusEnum.STATUS_TOPAY.getCode()))) continue;
            this.salaryFileOnHoldStatusMap.put(salaryFileId, String.valueOf(OnHoldStatusEnum.STATUS_ONHOLD.getCode()));
        }
    }

    public void getEmpposorgrel() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_empposorgrelhr");
        QFilter qFilter = new QFilter("boid", "in", this.empposorgrelIds);
        BaseDataHisHelper.addHisVerFilter((QFilter)qFilter);
        qFilter.and(CalAddPersonService.getDateFilter(this.startDate, this.endDate));
        qFilter.and(new QFilter("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus()));
        String selectProperties = "id,boid,bsed,job.id";
        DynamicObjectCollection empPosOrgRels = helper.queryOriginalCollection(selectProperties, new QFilter[]{qFilter}, "boid,bsed");
        this.empposorgrelMap = CollectionUtils.isEmpty((Collection)empPosOrgRels) ? new HashMap<Long, List<DynamicObject>>(0) : empPosOrgRels.stream().collect(Collectors.groupingBy(empPosRogRel -> empPosRogRel.getLong("boid")));
    }

    public void getManagingscope() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_managingscope");
        QFilter qFilter = new QFilter("boid", "in", this.manascoperecordIds);
        BaseDataHisHelper.addHisVerFilter((QFilter)qFilter);
        qFilter.and(CalAddPersonService.getDateFilter(this.startDate, this.endDate));
        qFilter.and(new QFilter("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus()));
        String selectProperties = "id,boid,bsed";
        DynamicObjectCollection manascoperecords = helper.queryOriginalCollection(selectProperties, new QFilter[]{qFilter}, "boid,bsed");
        this.manascoperecordMap = CollectionUtils.isEmpty((Collection)manascoperecords) ? new HashMap<Long, List<DynamicObject>>(0) : manascoperecords.stream().collect(Collectors.groupingBy(o -> o.getLong("boid")));
    }

    public void getPernontsprop() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_pernontsprop");
        QFilter qFilter = new QFilter("person", "in", this.personhrIds);
        BaseDataHisHelper.addHisCurrFilter((QFilter)qFilter);
        String selectProperties = "id,person.id,sourcevid";
        DynamicObjectCollection pernontprops = helper.queryOriginalCollection(selectProperties, new QFilter[]{qFilter});
        this.pernontspropMap = CollectionUtils.isEmpty((Collection)pernontprops) ? new HashMap<Long, List<DynamicObject>>(0) : pernontprops.stream().collect(Collectors.groupingBy(o -> o.getLong("person.id")));
    }

    public void getPertsprop() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_pertsprop");
        QFilter qFilter = new QFilter("person", "in", this.personhrIds);
        BaseDataHisHelper.addHisVerFilter((QFilter)qFilter);
        QFilter dateFilter = CalAddPersonService.getDateFilter(this.startDate, this.endDate);
        QFilter statusFilter = new QFilter("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus());
        String selectProperties = "id,person.id";
        DynamicObjectCollection pertsprops = helper.queryOriginalCollection(selectProperties, new QFilter[]{qFilter, dateFilter, statusFilter}, "person.id,bsed");
        this.pertspropMap = CollectionUtils.isEmpty((Collection)pertsprops) ? new HashMap<Long, List<DynamicObject>>(0) : pertsprops.stream().collect(Collectors.groupingBy(o -> o.getLong("person.id")));
    }

    public void getEmpjobrel() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_empjobrel");
        QFilter qFilter = new QFilter("employee", "in", this.empolyeeIds);
        BaseDataHisHelper.addHisVerFilter((QFilter)qFilter);
        QFilter dateFilter = CalAddPersonService.getDateFilter(this.startDate, this.endDate);
        dateFilter.and(new QFilter("startdate", "<=", (Object)this.endDate));
        QFilter brledFilter = new QFilter("enddate", ">=", (Object)this.startDate);
        brledFilter.or(QFilter.isNull((String)"enddate"));
        dateFilter.and(brledFilter);
        QFilter statusFilter = new QFilter("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus());
        String selectProperties = "id,employee.id,bsed,job.id,startdate,enddate";
        DynamicObjectCollection empPosOrgRels = helper.queryOriginalCollection(selectProperties, new QFilter[]{qFilter, dateFilter, statusFilter}, "employee.id,startdate,bsed");
        this.empjobrelMap = CollectionUtils.isEmpty((Collection)empPosOrgRels) ? new HashMap<Long, List<DynamicObject>>(0) : empPosOrgRels.stream().collect(Collectors.groupingBy(o -> o.getLong("employee.id")));
    }

    public void getEmpentrel() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_empentrel");
        QFilter qFilter = new QFilter("employee", "in", this.empolyeeIds);
        BaseDataHisHelper.addHisVerFilter((QFilter)qFilter);
        QFilter dateFilter = CalAddPersonService.getDateFilter(this.startDate, this.endDate);
        QFilter statusFilter = new QFilter("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus());
        String selectProperties = "id,employee.id,bsed";
        DynamicObjectCollection objvs = helper.queryOriginalCollection(selectProperties, new QFilter[]{qFilter, dateFilter, statusFilter}, "employee.id,bsed");
        this.empentrelMap = CollectionUtils.isEmpty((Collection)objvs) ? new HashMap<Long, List<DynamicObject>>(0) : objvs.stream().collect(Collectors.groupingBy(o -> o.getLong("employee.id")));
    }

    public void getPerserlen() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_perserlen");
        QFilter qFilter = new QFilter("employee", "in", this.empolyeeIds);
        BaseDataHisHelper.addHisCurrFilter((QFilter)qFilter);
        String selectProperties = "id,employee.id,sourcevid";
        DynamicObjectCollection objvs = helper.queryOriginalCollection(selectProperties, new QFilter[]{qFilter});
        this.perserlenMap = CollectionUtils.isEmpty((Collection)objvs) ? new HashMap<Long, List<DynamicObject>>(0) : objvs.stream().collect(Collectors.groupingBy(o -> o.getLong("employee.id")));
    }

    public void getTrialperiod() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_trialperiod");
        QFilter qFilter = new QFilter("employee", "in", this.empolyeeIds);
        BaseDataHisHelper.addHisVerFilter((QFilter)qFilter);
        QFilter dateFilter = CalAddPersonService.getDateFilter(this.startDate, this.endDate);
        QFilter statusFilter = new QFilter("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus());
        String selectProperties = "id,employee.id,bsed";
        DynamicObjectCollection objvs = helper.queryOriginalCollection(selectProperties, new QFilter[]{qFilter, statusFilter, dateFilter}, "employee.id,bsed");
        this.trialperiodMap = CollectionUtils.isEmpty((Collection)objvs) ? new HashMap<Long, List<DynamicObject>>(0) : objvs.stream().collect(Collectors.groupingBy(o -> o.getLong("employee.id")));
    }

    private void queryPerson() {
        SWCDataServiceHelper personHelper = new SWCDataServiceHelper("hsas_personhr");
        String selectProperties = "id,name,boid,sourcevid";
        QFilter qFilter = new QFilter("boid", "in", this.personhrIds);
        BaseDataHisHelper.addHisCurrFilter((QFilter)qFilter);
        DynamicObjectCollection persons = personHelper.queryOriginalCollection(selectProperties, new QFilter[]{qFilter});
        this.personMap = persons.stream().collect(Collectors.groupingBy(o -> o.getLong("boid")));
    }

    private void queryEmployee() {
        SWCDataServiceHelper personHelper = new SWCDataServiceHelper("hsas_employee");
        String selectProperties = "id,boid,empnumber,bsed";
        QFilter qFilter = new QFilter("boid", "in", this.empolyeeIds);
        BaseDataHisHelper.addHisVerFilter((QFilter)qFilter);
        qFilter.and(CalAddPersonService.getDateFilter(this.startDate, this.endDate));
        qFilter.and(new QFilter("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus()));
        DynamicObjectCollection employees = personHelper.queryOriginalCollection(selectProperties, new QFilter[]{qFilter}, "boid,bsed");
        this.employeeMap = employees.stream().collect(Collectors.groupingBy(emp -> emp.getLong("boid")));
    }

    private static QFilter getDateFilter(Date startDate, Date endDate) {
        QFilter filter = new QFilter("bsed", "<=", (Object)endDate);
        QFilter brledFilter = new QFilter("bsled", ">=", (Object)startDate);
        brledFilter.or(QFilter.isNull((String)"bsled"));
        filter.and(brledFilter);
        return filter;
    }

    private void createAndSaveCalTableList() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        DynamicObjectCollection objs = new DynamicObjectCollection();
        String userId = RequestContext.get().getUserId();
        Date payrolldate = this.taskDy.getDate("payrolldate");
        Long calPeriodId = this.taskDy.getLong("period.id");
        String isHandleProration = this.taskDy.getString("ishandleproration");
        for (int i = 0; i < this.filevObjs.size(); ++i) {
            String onHoldStatus;
            DynamicObject newObj = helper.generateEmptyDynamicObject();
            DynamicObject filevObj = this.filevObjs.get(i);
            Long personId = filevObj.getLong("person.id");
            Long employeeId = filevObj.getLong("employee.id");
            Long jobId = this.fillFileInfo(newObj, filevObj);
            this.fillPersonInfo(newObj, personId);
            this.fillEmployeeInfo(newObj, employeeId, jobId);
            newObj.set("caltask", (Object)this.payrolltaskId);
            newObj.set("addfiletype", (Object)"0");
            if (this.isExc.booleanValue() || this.exceptionFilevs.contains(filevObj.getLong("boid"))) {
                newObj.set("addfiletype", (Object)"1");
            }
            newObj.set("belongperiod", (Object)payrolldate);
            newObj.set("calperiod", (Object)calPeriodId);
            newObj.set("taxstatus", (Object)TaxStateEnum.UNPUSH.getCode());
            newObj.set("calstatus", (Object)CalStateEnum.UNCAL.getCode());
            newObj.set("paystatus", (Object)PayStateEnum.UNCREATE.getCode());
            newObj.set("allotstatus", (Object)"A");
            if (this.islssuepayslip) {
                newObj.set("salarystatus", (Object)"2");
            } else {
                newObj.set("salarystatus", (Object)"1");
            }
            Long salaryFileId = filevObj.getLong("boid");
            if (this.salaryFileOnHoldStatusMap != null && this.salaryFileOnHoldStatusMap.size() > 0 && SWCStringUtils.isNotEmpty((String)(onHoldStatus = this.salaryFileOnHoldStatusMap.get(salaryFileId)))) {
                newObj.set("onholdstatus", (Object)onHoldStatus);
            }
            newObj.set("bizdatagenstatus", (Object)"1");
            objs.add((Object)newObj);
        }
        this.callExtService(objs);
        if (!SWCObjectUtils.isEmpty((Object)objs)) {
            helper.save(objs);
            if (SWCStringUtils.equals((String)isHandleProration, (String)"1")) {
                ProrationGenerateService prorationGenerateService = new ProrationGenerateService(this.taskDy, (List<DynamicObject>)objs);
                prorationGenerateService.generateProration();
            }
        }
        this.resetOnHoldBill(helper);
    }

    private void callExtService(DynamicObjectCollection objs) {
        AddCalPersonExtService addCalPersonExtService = new AddCalPersonExtService();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)addCalPersonExtService, IAddCalPersonExtService.class, (String)"kd.sdk.swc.hsas.business.extpoint.calperson.IAddCalPersonExtService#afterPackagePerson", null);
        AfterAddCalpersonEvent afterAddCalpersonEvent = new AfterAddCalpersonEvent(objs);
        afterAddCalpersonEvent.setStartDate(this.startDate);
        afterAddCalpersonEvent.setEndDate(this.endDate);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.afterPackagePerson(afterAddCalpersonEvent);
            return null;
        });
    }

    public DynamicObjectCollection createWriteInCalPersonList() {
        this.tid = String.valueOf(Thread.currentThread().getId());
        this.queryFile();
        this.batchGetFileData();
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        DynamicObjectCollection objs = new DynamicObjectCollection();
        Date payrolldate = this.taskDy.getDate("payrolldate");
        Long calPeriodId = this.taskDy.getLong("period.id");
        for (int i = 0; i < this.filevObjs.size(); ++i) {
            DynamicObject newObj = helper.generateEmptyDynamicObject();
            DynamicObject filevObj = this.filevObjs.get(i);
            Long personId = filevObj.getLong("person.id");
            Long employeeId = filevObj.getLong("employee.id");
            Long jobId = this.fillFileInfo(newObj, filevObj);
            this.fillPersonInfo(newObj, personId);
            this.fillEmployeeInfo(newObj, employeeId, jobId);
            newObj.set("caltask", (Object)this.payrolltaskId);
            newObj.set("addfiletype", (Object)"0");
            if (this.isExc.booleanValue() || this.exceptionFilevs.contains(filevObj.getLong("boid"))) {
                newObj.set("addfiletype", (Object)"1");
            }
            newObj.set("belongperiod", (Object)payrolldate);
            newObj.set("calperiod", (Object)calPeriodId);
            String taskType = this.taskDy.getString("tasktype");
            if (SWCStringUtils.equals((String)"0", (String)taskType)) {
                newObj.set("taxstatus", (Object)TaxStateEnum.UNPUSH.getCode());
                newObj.set("calstatus", (Object)CalStateEnum.ALL_CALED.getCode());
                newObj.set("paystatus", (Object)PayStateEnum.UNCREATE.getCode());
                newObj.set("allotstatus", (Object)"A");
                if (this.islssuepayslip) {
                    newObj.set("salarystatus", (Object)"2");
                } else {
                    newObj.set("salarystatus", (Object)"1");
                }
            }
            objs.add((Object)newObj);
        }
        this.callExtService(objs);
        return objs;
    }

    private void resetOnHoldBill(SWCDataServiceHelper helper) {
        if (this.onholdFileIds.size() > 0) {
            DynamicObject[] onholdbills;
            QFilter qFilter = new QFilter("salaryfile", "in", this.onholdFileIds);
            qFilter.and(new QFilter("caltask", "=", (Object)this.payrolltaskId));
            DynamicObjectCollection calpersons = helper.queryOriginalCollection("id,salaryfile.id", qFilter.toArray());
            Map<Long, Long> onholdPersonMap = calpersons.stream().collect(Collectors.toMap(o -> o.getLong("salaryfile.id"), o -> o.getLong("id"), (v1, v2) -> v1));
            SWCDataServiceHelper onholdHelper = new SWCDataServiceHelper("hsas_onholdbill");
            for (DynamicObject onholdbill : onholdbills = onholdHelper.query("id,salaryfile.id,caltableid", qFilter.toArray())) {
                long fileId = onholdbill.getLong("salaryfile.id");
                onholdbill.set("caltableid", (Object)onholdPersonMap.get(fileId));
            }
            onholdHelper.save(onholdbills);
        }
    }

    private void fillPersonInfo(DynamicObject newObj, Long personId) {
        DynamicObject pernontsprop;
        String name = null;
        Long personvId = 0L;
        Long pernontspropvId = 0L;
        Long pertspropvId = 0L;
        DynamicObject person = this.getLastDy(this.personMap.get(personId));
        if (person != null) {
            name = person.getString("name");
            personvId = person.getLong("sourcevid");
        }
        if ((pernontsprop = this.getLastDy(this.pernontspropMap.get(personId))) != null) {
            pernontspropvId = pernontsprop.getLong("sourcevid");
        }
        newObj.set("name", (Object)name);
        newObj.set("personhrv", (Object)personvId);
        newObj.set("pernontspropv", (Object)pernontspropvId);
        DynamicObject pertsprop = this.getLastDy(this.pertspropMap.get(personId));
        if (pertsprop != null) {
            pertspropvId = pertsprop.getLong("id");
        }
        newObj.set("pertspropv", (Object)pertspropvId);
    }

    private void fillEmployeeInfo(DynamicObject newObj, Long employeeId, Long jobId) {
        DynamicObject empjobrel;
        DynamicObject perserlenv;
        DynamicObject trialperiod;
        DynamicObject empentrel;
        String empnumber = null;
        Long employeevId = 0L;
        Long empentrelvId = 0L;
        Long trialperiodvId = 0L;
        Long empjobrelvId = 0L;
        Long perserlenvId = 0L;
        DynamicObject employee = this.getLastDy(this.employeeMap.get(employeeId));
        if (employee != null) {
            empnumber = employee.getString("empnumber");
            employeevId = employee.getLong("id");
        }
        if ((empentrel = this.getLastDy(this.empentrelMap.get(employeeId))) != null) {
            empentrelvId = empentrel.getLong("id");
        }
        if ((trialperiod = this.getLastDy(this.trialperiodMap.get(employeeId))) != null) {
            trialperiodvId = trialperiod.getLong("id");
        }
        if ((perserlenv = this.getLastDy(this.perserlenMap.get(employeeId))) != null) {
            perserlenvId = perserlenv.getLong("sourcevid");
        }
        if ((empjobrel = this.getLastDy(this.empjobrelMap.get(employeeId))) != null) {
            empjobrelvId = empjobrel.getLong("id");
        }
        newObj.set("empnumber", (Object)empnumber);
        newObj.set("employeev", (Object)employeevId);
        newObj.set("employee", (Object)employeeId);
        newObj.set("empentrelv", (Object)empentrelvId);
        newObj.set("trialperiodv", (Object)trialperiodvId);
        newObj.set("empjobrelv", (Object)empjobrelvId);
        newObj.set("perserlenv", (Object)perserlenvId);
    }

    private Long fillFileInfo(DynamicObject newObj, DynamicObject filevObj) {
        DynamicObject manascoperecord;
        long fileBoid = filevObj.getLong("boid");
        Long empposinfoId = filevObj.getLong("empposinfo.id");
        Long managingscopeId = filevObj.getLong("managingscope.id");
        String fileNumber = filevObj.getString("number");
        Long orgId = filevObj.getLong("org.id");
        Long adminorgId = filevObj.getLong("adminorg.id");
        Long empgroupId = filevObj.getLong("empgroup.id");
        Long empposinfovId = 0L;
        Long manascoperecordId = 0L;
        Long jobId = 0L;
        DynamicObject empposinfo = this.getLastDy(this.empposorgrelMap.get(empposinfoId));
        if (empposinfo != null) {
            empposinfovId = empposinfo.getLong("id");
            jobId = empposinfo.getLong("job.id");
        }
        if ((manascoperecord = this.getLastDy(this.manascoperecordMap.get(managingscopeId))) != null) {
            manascoperecordId = manascoperecord.getLong("id");
        }
        newObj.set("filenumber", (Object)fileNumber);
        newObj.set("salaryfilev", (Object)filevObj);
        newObj.set("salaryfile", (Object)fileBoid);
        newObj.set("org", (Object)orgId);
        newObj.set("adminorg", (Object)adminorgId);
        newObj.set("empgroup", (Object)empgroupId);
        newObj.set("empposorgrelhrv", (Object)empposinfovId);
        newObj.set("manascoperecordv", (Object)manascoperecordId);
        this.setOnHoldStatus(newObj, fileBoid);
        return jobId;
    }

    private void setOnHoldStatus(DynamicObject newObj, long fileBoid) {
        String onHoldStatus = this.onHoldBillMap.get(fileBoid);
        if (SWCStringUtils.isNotEmpty((String)onHoldStatus)) {
            int onHoldCode = Integer.parseInt(onHoldStatus);
            if (onHoldCode == OnHoldStatusEnum.STATUS_ONHOLD.getCode() || onHoldCode == OnHoldStatusEnum.STATUS_TOPAY.getCode()) {
                newObj.set("onholdstatus", (Object)"2");
            } else if (onHoldCode == OnHoldStatusEnum.STATUS_RELEASE.getCode()) {
                newObj.set("onholdstatus", (Object)"1");
            } else if (onHoldCode == OnHoldStatusEnum.STATUS_STOPPAY.getCode()) {
                newObj.set("onholdstatus", (Object)"4");
            }
            this.onholdFileIds.add(fileBoid);
        }
    }

    public DynamicObject getLastDy(List<DynamicObject> dys) {
        if (dys == null) {
            return null;
        }
        return dys.size() > 0 ? dys.get(dys.size() - 1) : null;
    }
}

