/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.attintegrate.handler;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.BizDataFailStatusEnum;
import kd.swc.hsbp.common.enums.IgnoredStateEnum;
import kd.swc.hsbp.common.enums.IntegrationProcessStateEnum;
import kd.swc.hsbp.common.enums.IntegrationStatusEnum;
import kd.swc.hsbp.common.enums.ProcessResultEnum;
import kd.swc.hsbp.common.enums.WriteBackStateEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCDbUtil;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hscs.business.attintegrate.IntegrateState;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractIntegrateHandler {
    private static final Log LOGGER = LogFactory.getLog(AbstractIntegrateHandler.class);
    protected List<Long> attFileIds;
    protected DynamicObject[] fileLogs;
    protected List<DynamicObject> detailLogCollection;
    protected List<DynamicObject> itemDetailLogCollection;
    protected Map<Long, IntegrateState> fileStateMap;
    protected Map<String, IntegrateState> fileDepEmpStateMap;
    protected Map<String, IntegrateState> fileDepEmpItemStateMap;
    protected List<Map<String, Object>> rows;
    protected Long summaryLogId;
    protected DynamicObject summaryLog;
    protected DynamicObject batchLog;
    protected String batchVersionId;
    protected List<DynamicObject> bizDataList;
    protected Long operator;
    protected Date earliestAttStartDate = null;
    protected Date lastAttStartDate = null;
    protected Date earliestAttEndDate = null;
    protected Date lastAttEndDate = null;
    protected SWCDataServiceHelper fileLogService = new SWCDataServiceHelper("hsas_attintegfilelog");
    protected SWCDataServiceHelper detailLogService = new SWCDataServiceHelper("hsas_attintegdetaillog");
    protected SWCDataServiceHelper itemDetailLogService = new SWCDataServiceHelper("hsas_attintegitemlog");
    protected SWCDataServiceHelper summaryLogService = new SWCDataServiceHelper("hsas_attintegsumlog");
    protected SWCDataServiceHelper bizDataService;
    protected static final String THIRD_LONG_TPL = "%d_%d_%d";
    protected static final String TWO_LONG_TPL = "%d_%d";

    public AbstractIntegrateHandler(DynamicObject summaryLog, DynamicObject batchLog, Long operator) {
        this.summaryLog = summaryLog;
        this.batchLog = batchLog;
        this.operator = operator;
        this.batchVersionId = summaryLog.getString("batchversionid");
        this.summaryLogId = summaryLog.getLong("id");
        int fileSize = batchLog.getInt("endindex") - batchLog.getInt("startindex") + 1;
        this.detailLogCollection = new ArrayList<DynamicObject>(fileSize);
        this.itemDetailLogCollection = new ArrayList<DynamicObject>(fileSize);
        this.fileStateMap = new HashMap<Long, IntegrateState>(fileSize);
        this.fileDepEmpStateMap = new HashMap<String, IntegrateState>(fileSize);
        this.fileDepEmpItemStateMap = new HashMap<String, IntegrateState>(fileSize);
        this.bizDataService = new SWCDataServiceHelper(this.getBizDataEntityKey());
        this.bizDataList = new ArrayList<DynamicObject>(fileSize);
    }

    public void integrate() {
        if (IntegrationStatusEnum.COMPLETE.getCode().equals(this.summaryLog.getString("integrationstatus"))) {
            return;
        }
        long startTime = System.currentTimeMillis();
        LOGGER.info("start integrate");
        if (this.init()) {
            long costTime = System.currentTimeMillis() - startTime;
            startTime = System.currentTimeMillis();
            LOGGER.info("init use time {} ms", (Object)costTime);
            if (IntegrationProcessStateEnum.PENDING.getCode().equals(this.batchLog.getString("processstate"))) {
                this.createFileLog();
                costTime = System.currentTimeMillis() - startTime;
                startTime = System.currentTimeMillis();
                LOGGER.info("createFileLog use time {} ms", (Object)costTime);
                this.pullAttRecord();
                costTime = System.currentTimeMillis() - startTime;
                startTime = System.currentTimeMillis();
                LOGGER.info("pullAttRecord use time {} ms", (Object)costTime);
                this.handleData();
                costTime = System.currentTimeMillis() - startTime;
                startTime = System.currentTimeMillis();
                LOGGER.info("handleData use time {} ms", (Object)costTime);
                this.save();
                costTime = System.currentTimeMillis() - startTime;
                startTime = System.currentTimeMillis();
                LOGGER.info("save use time {} ms", (Object)costTime);
            }
            if (WriteBackStateEnum.INCOMPLETE.getCode().equals(this.batchLog.getString("writebackstate"))) {
                this.writeBack();
                costTime = System.currentTimeMillis() - startTime;
                LOGGER.info("writeBack use time {} ms", (Object)costTime);
            }
        }
    }

    public void save() {
        try (TXHandle txHandle = TX.required();){
            try {
                String updateSql;
                this.fileLogService.save(this.fileLogs);
                this.detailLogService.save(this.detailLogCollection.toArray(new DynamicObject[0]));
                this.itemDetailLogService.save(this.itemDetailLogCollection.toArray(new DynamicObject[0]));
                this.bizDataService.save(this.bizDataList.toArray(new DynamicObject[0]));
                int count = this.fileLogService.count(new QFilter[]{new QFilter("batchversionid", "=", (Object)this.batchVersionId), new QFilter("processstate", "=", (Object)IntegrationProcessStateEnum.COMPLETE.getCode())});
                IntegrationProcessStateEnum processState = IntegrationProcessStateEnum.RUNNING;
                if (count >= this.summaryLog.getInt("filequantity")) {
                    processState = IntegrationProcessStateEnum.COMPLETE;
                }
                String sql = "update t_hsas_attintegsumlog set fintegrationquantity=fintegrationquantity+ ? ,fsuccessquantity=fsuccessquantity+ ? ,ffailquantity=ffailquantity+ ? ,fprocessstate= ?  where fid= ? ";
                int successDepEmpCount = this.sumCount(this.fileDepEmpStateMap, true);
                int failDepEmpCount = this.fileDepEmpStateMap.size() - successDepEmpCount;
                SWCDbUtil.execute((DBRoute)DBRoute.of((String)"swc"), (String)sql, (Object[])new Object[]{this.detailLogCollection.size(), successDepEmpCount, failDepEmpCount, processState.getCode(), this.summaryLogId});
                String updateBatchLogSql = "update t_hsas_attintegbatchlog set fprocessstate = '3',fmsgstate = '1' where fid = ?";
                SWCDbUtil.execute((DBRoute)DBRoute.of((String)"swc"), (String)updateBatchLogSql, (Object[])new Object[]{this.batchLog.getLong("id")});
                if (this.earliestAttStartDate != null) {
                    updateSql = "update t_hsas_attintegsumlog set fearliestattstartdate = ? where fid = ? and (fearliestattstartdate is null or fearliestattstartdate > ?)";
                    SWCDbUtil.execute((DBRoute)DBRoute.of((String)"swc"), (String)updateSql, (Object[])new Object[]{this.earliestAttStartDate, this.summaryLogId, this.earliestAttStartDate});
                }
                if (this.lastAttStartDate != null) {
                    updateSql = "update t_hsas_attintegsumlog set flastattstartdate = ? where fid = ? and (flastattstartdate is null or flastattstartdate < ?)";
                    SWCDbUtil.execute((DBRoute)DBRoute.of((String)"swc"), (String)updateSql, (Object[])new Object[]{this.lastAttStartDate, this.summaryLogId, this.lastAttStartDate});
                }
                if (this.earliestAttEndDate != null) {
                    updateSql = "update t_hsas_attintegsumlog set fearliestattenddate = ? where fid = ? and (fearliestattenddate is null or fearliestattenddate > ?)";
                    SWCDbUtil.execute((DBRoute)DBRoute.of((String)"swc"), (String)updateSql, (Object[])new Object[]{this.earliestAttEndDate, this.summaryLogId, this.earliestAttEndDate});
                }
                if (this.lastAttEndDate != null) {
                    updateSql = "update t_hsas_attintegsumlog set flastattenddate = ? where fid = ? and (flastattenddate is null or flastattenddate < ?)";
                    SWCDbUtil.execute((DBRoute)DBRoute.of((String)"swc"), (String)updateSql, (Object[])new Object[]{this.lastAttEndDate, this.summaryLogId, this.lastAttEndDate});
                }
            }
            catch (Throwable e) {
                txHandle.markRollback();
                LOGGER.error("doIntegrate transaction error", e);
                throw e;
            }
        }
    }

    public abstract boolean init();

    public abstract void handleData();

    public abstract String getBizDataEntityKey();

    protected Map<Long, Map<Long, Map<Long, Map<String, Object>>>> groupByFileIdDepEmpIdAndSumItemId(List<Map<String, Object>> rows) {
        HashMap<Long, Map<Long, Map<Long, Map<String, Object>>>> resultMap = new HashMap<Long, Map<Long, Map<Long, Map<String, Object>>>>();
        for (Map<String, Object> row : rows) {
            Long fileId = (Long)row.get("attfileid");
            Long depEmpId = (Long)row.get("depempid");
            Long attItemId = (Long)row.get("attitemid");
            Long sumItemId = (Long)row.get("id");
            Long attPeriodId = (Long)row.get("attperiodid");
            Long employeeId = (Long)row.get("employeeid");
            Object value = row.get("value");
            if (fileId == null || fileId == 0L || depEmpId == null || depEmpId == 0L || attItemId == null || attItemId == 0L || attPeriodId == null || attPeriodId == 0L || employeeId == null || employeeId == 0L || value == null) {
                LOGGER.warn(MessageFormat.format("att data error, data is -> {0}", JSON.toJSONString(row)));
            }
            Map depEmpMap = resultMap.computeIfAbsent(fileId, val -> new HashMap());
            Map itemMap = depEmpMap.computeIfAbsent(depEmpId, val -> new HashMap());
            itemMap.put(sumItemId, row);
        }
        return resultMap;
    }

    protected int sumCount(Map<String, IntegrateState> fileDepEmpStateMap, boolean checkPass) {
        int count = 0;
        for (Map.Entry<String, IntegrateState> stateEntry : fileDepEmpStateMap.entrySet()) {
            if (stateEntry.getValue().isCheckPass() != checkPass) continue;
            ++count;
        }
        return count;
    }

    protected boolean checkBigDecimalValue(IntegrateState itemState, DynamicObject attBizItem, BigDecimal value) {
        boolean checkResult;
        BigDecimal minValue = attBizItem.getBigDecimal("minvalue");
        BigDecimal maxValue = attBizItem.getBigDecimal("maxvalue");
        boolean isMinValNull = attBizItem.getBoolean("isminvalnull");
        boolean isMaxValNull = attBizItem.getBoolean("ismaxvalnull");
        if (isMinValNull && isMaxValNull) {
            checkResult = true;
        } else if (isMinValNull) {
            checkResult = maxValue.compareTo(value) >= 0;
        } else if (isMaxValNull) {
            checkResult = minValue.compareTo(value) <= 0;
        } else {
            boolean bl = checkResult = minValue.compareTo(value) <= 0 && maxValue.compareTo(value) >= 0;
        }
        if (!checkResult) {
            itemState.setCheckPass(false);
            itemState.setReasonCode(BizDataFailStatusEnum.FAILSTATUS_6003.getCode());
            return false;
        }
        int scalelimit = attBizItem.getInt("scalelimit");
        int scale = value.scale();
        if (scale > scalelimit) {
            itemState.setCheckPass(false);
            itemState.setReasonCode(BizDataFailStatusEnum.FAILSTATUS_6007.getCode());
            return false;
        }
        return true;
    }

    public void createFileLog() {
        int startIndex = this.batchLog.getInt("startindex");
        int endIndex = this.batchLog.getInt("endindex");
        LOGGER.info("createFileLog_invokeBizService_pullAttfile param -> startIndex={}; endIndex={}; batchVersionId={}", new Object[]{startIndex, endIndex, this.batchVersionId});
        HashMap<String, Object> pullRpcParam = new HashMap<String, Object>(3);
        pullRpcParam.put("version", this.batchVersionId);
        pullRpcParam.put("start", startIndex);
        pullRpcParam.put("end", endIndex);
        List attFileIds = (List)SWCMServiceUtils.invokeBizService((String)"wtc", (String)"wtis", (String)"ISalaryIntegrationService", (String)"pullAttfile", (Object[])new Object[]{pullRpcParam});
        LOGGER.info("tryPullFileIdsByRPC_invokeBizService_pullAttfile response ->{}", (Object)JSON.toJSONString((Object)attFileIds));
        if (CollectionUtils.isEmpty((Collection)attFileIds)) {
            LOGGER.error("wtc api response empty, startIndex={}; endIndex={};", (Object)startIndex, (Object)endIndex);
            return;
        }
        ArrayList<DynamicObject> fileLogList = new ArrayList<DynamicObject>(attFileIds.size());
        for (Long attFileId : attFileIds) {
            DynamicObject fileLog2 = this.fileLogService.generateEmptyDynamicObject();
            fileLogList.add(fileLog2);
            fileLog2.set("batchversionid", (Object)this.batchVersionId);
            fileLog2.set("attfileid", (Object)attFileId);
            fileLog2.set("processstate", (Object)IntegrationProcessStateEnum.COMPLETE.getCode());
            fileLog2.set("writebackstate", (Object)WriteBackStateEnum.INCOMPLETE.getCode());
            fileLog2.set("batchlog", (Object)this.batchLog.getLong("id"));
        }
        this.fileLogs = fileLogList.toArray(new DynamicObject[0]);
        this.attFileIds = Arrays.stream(this.fileLogs).map(fileLog -> fileLog.getLong("attfileid")).collect(Collectors.toList());
    }

    public void pullAttRecord() {
        long beginTime = System.currentTimeMillis();
        LOGGER.info("pullAttRecord_invokeBizService_pullAttRecord param -> batchVersionId={}; attfileid=[{}]", new Object[]{this.batchVersionId, this.attFileIds, ","});
        if (kd.bos.orm.util.CollectionUtils.isEmpty(this.attFileIds)) {
            this.rows = new ArrayList<Map<String, Object>>(0);
            return;
        }
        HashMap<String, Object> pullAttRecordParam = new HashMap<String, Object>(3);
        pullAttRecordParam.put("version", this.batchVersionId);
        pullAttRecordParam.put("successfileid", this.attFileIds);
        Map map = (Map)SWCMServiceUtils.invokeBizService((String)"wtc", (String)"wtis", (String)"ISalaryIntegrationService", (String)"pullAttRecord", (Object[])new Object[]{pullAttRecordParam});
        LOGGER.info("pullAttRecord_invokeBizService_pullAttRecord response ->{}", (Object)JSON.toJSONString((Object)map));
        long endTime = System.currentTimeMillis();
        LOGGER.info("pullAttRecord.pullAttRecord,cost time is {} s", (Object)((endTime - beginTime) / 1000L));
        List dataIndex = (List)map.get("dataindex");
        HashMap<String, Integer> dataIndexMap = new HashMap<String, Integer>(dataIndex.size());
        for (int i = 0; i < dataIndex.size(); ++i) {
            dataIndexMap.put((String)dataIndex.get(i), i);
        }
        this.rows = this.convertDataToMap(dataIndexMap, (List)map.get("data"));
    }

    private List<Map<String, Object>> convertDataToMap(Map<String, Integer> dataIndexMap, List<List> data) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(data.size());
        for (List datum : data) {
            HashMap rowMap = new HashMap(16);
            result.add(rowMap);
            for (Map.Entry<String, Integer> entry : dataIndexMap.entrySet()) {
                Integer fieldIndex = entry.getValue();
                String fieldName = entry.getKey();
                rowMap.put(fieldName, datum.get(fieldIndex));
            }
        }
        return result;
    }

    public void writeBack() {
        Object values;
        QFilter fileLogFilter = new QFilter("batchlog", "=", (Object)this.batchLog.getLong("id"));
        DynamicObject[] unWriteBackFiles = this.fileLogService.query("id,processresult,ignoredstate,writebackstate,endtime,attfileid", new QFilter[]{fileLogFilter});
        this.attFileIds = Arrays.stream(unWriteBackFiles).map(unWriteBackFile -> unWriteBackFile.getLong("attfileid")).collect(Collectors.toList());
        Map<Long, Set<Long>> ignoredDataMap = this.getIgnoredDataMap(unWriteBackFiles);
        ArrayList<Long> attFileIdOfFail = new ArrayList<Long>(unWriteBackFiles.length);
        ArrayList<Long> attFileIdOfSuccess = new ArrayList<Long>(unWriteBackFiles.length);
        ArrayList<Long> attFileIdOfIgnore = new ArrayList<Long>(unWriteBackFiles.length);
        ArrayList<Long> attFileIdOfPartSuccess = new ArrayList<Long>(unWriteBackFiles.length);
        for (DynamicObject unWriteBackFile2 : unWriteBackFiles) {
            DynamicObject[] processResult = unWriteBackFile2.getString("processresult");
            String ignoredState = unWriteBackFile2.getString("ignoredstate");
            Long attFileId = unWriteBackFile2.getLong("attfileid");
            if (StringUtils.equals((CharSequence)ProcessResultEnum.FAILURE.getCode(), (CharSequence)processResult)) {
                attFileIdOfFail.add(attFileId);
            }
            if (StringUtils.equals((CharSequence)ProcessResultEnum.SUCCESS.getCode(), (CharSequence)processResult) && StringUtils.equals((CharSequence)IgnoredStateEnum.NO.getCode(), (CharSequence)ignoredState)) {
                if (ignoredDataMap.containsKey(attFileId)) {
                    attFileIdOfPartSuccess.add(attFileId);
                } else {
                    attFileIdOfSuccess.add(attFileId);
                }
            }
            if (!StringUtils.equals((CharSequence)IgnoredStateEnum.YES.getCode(), (CharSequence)ignoredState)) continue;
            attFileIdOfIgnore.add(attFileId);
        }
        DynamicObject[] detailLogResult = this.detailLogService.query("id,writebackstate,attfile,depemp,processresult", new QFilter[]{new QFilter("attintegsumlog", "=", (Object)this.summaryLogId), new QFilter("attfile", "in", this.attFileIds)});
        HashMap<Long, List> fileToDetailMap = new HashMap<Long, List>(this.attFileIds.size());
        ArrayList<Long> detailLogIdList = new ArrayList<Long>(detailLogResult.length);
        ArrayList<Long> detailLogIdOfFail = new ArrayList<Long>(attFileIdOfFail.size() * 4);
        for (DynamicObject object : detailLogResult) {
            long detailLogId = object.getLong("id");
            detailLogIdList.add(detailLogId);
            long attFileId = object.getLong("attfile.id");
            values = fileToDetailMap.computeIfAbsent(attFileId, val -> new ArrayList());
            values.add(object);
            if (!ProcessResultEnum.FAILURE.getCode().equals(object.getString("processresult"))) continue;
            detailLogIdOfFail.add(detailLogId);
        }
        DynamicObject[] itemDetailLogResult = this.itemDetailLogService.query("id,tagnumber,attsummaryitemid,integdetailedlog,reason,state", new QFilter[]{new QFilter("integdetailedlog", "in", detailLogIdOfFail)});
        HashMap<Long, List> detailToItemDetailMap = new HashMap<Long, List>(detailLogIdList.size());
        for (DynamicObject object : itemDetailLogResult) {
            long detailLogId = object.getLong("integdetailedlog.id");
            values = detailToItemDetailMap.computeIfAbsent(detailLogId, val -> new ArrayList());
            values.add(object);
        }
        ArrayList errorInfo = new ArrayList(attFileIdOfFail.size());
        for (Long attFileId : attFileIdOfFail) {
            List detailLogList = (List)fileToDetailMap.get(attFileId);
            HashMap<String, Serializable> attFileError = new HashMap<String, Serializable>(2);
            ArrayList detail = new ArrayList();
            attFileError.put("attfileid", attFileId);
            attFileError.put("detail", detail);
            errorInfo.add(attFileError);
            for (Object detailLog : detailLogList) {
                long l = detailLog.getLong("id");
                List itemDetailLogList = (List)detailToItemDetailMap.get(l);
                if (!org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemDetailLogList)) continue;
                for (DynamicObject itemDetailLog : itemDetailLogList) {
                    HashMap<String, Object> itemDetailInfo = new HashMap<String, Object>(3);
                    detail.add(itemDetailInfo);
                    itemDetailInfo.put("id", itemDetailLog.getLong("attsummaryitemid"));
                    itemDetailInfo.put("state", itemDetailLog.getString("state"));
                    itemDetailInfo.put("reasonCode", itemDetailLog.getString("reason"));
                }
            }
        }
        ArrayList ignoredInfo = new ArrayList(attFileIdOfFail.size());
        for (Long attFileId : attFileIdOfPartSuccess) {
            HashMap<String, Serializable> attFileInfo = new HashMap<String, Serializable>(16);
            attFileInfo.put("attfileid", attFileId);
            DynamicObject[] ignoredData = (DynamicObject[])ignoredDataMap.getOrDefault(attFileId, new HashSet(0));
            ArrayList detailInfo = new ArrayList(ignoredInfo.size());
            attFileInfo.put("detail", detailInfo);
            for (Long l : ignoredData) {
                HashMap<String, Object> detail = new HashMap<String, Object>(2);
                detail.put("id", l);
                detail.put("reasonCode", BizDataFailStatusEnum.FAILSTATUS_3050.getCode());
                detailInfo.add(detail);
            }
            ignoredInfo.add(attFileInfo);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(5);
        resultMap.put("version", this.batchVersionId);
        resultMap.put("successfileid", attFileIdOfSuccess);
        resultMap.put("ignoredfileid", attFileIdOfIgnore);
        resultMap.put("errorinfo", errorInfo);
        resultMap.put("ignoredinfo", ignoredInfo);
        LOGGER.info("doWriteBack_invokeBizService_setAttRecordState param -> batchVersionId={} ; successfileSize={}; ignoredfileSize={}; errorinfoSize={};ignoredinfo={}", new Object[]{this.batchVersionId, attFileIdOfSuccess.size(), attFileIdOfIgnore.size(), errorInfo.size(), ignoredInfo.size()});
        Boolean result = (Boolean)SWCMServiceUtils.invokeBizService((String)"wtc", (String)"wtis", (String)"ISalaryIntegrationService", (String)"setAttRecordState", (Object[])new Object[]{resultMap});
        LOGGER.info("doWriteBack_invokeBizService_setAttRecordState response ->{}", (Object)result);
        if (result == null) {
            return;
        }
        Date now = new Date();
        for (DynamicObject dynamicObject : unWriteBackFiles) {
            dynamicObject.set("writebackstate", (Object)WriteBackStateEnum.COMPLETE.getCode());
            dynamicObject.set("endtime", (Object)now);
        }
        for (DynamicObject dynamicObject : detailLogResult) {
            dynamicObject.set("writebackstate", (Object)WriteBackStateEnum.COMPLETE.getCode());
        }
        Throwable throwable = null;
        try (TXHandle txHandle = TX.required();){
            String updateBatchLogSql = "update t_hsas_attintegbatchlog set fwritebackstate = '2' where fid = ?";
            boolean bl = SWCDbUtil.execute((DBRoute)DBRoute.of((String)"swc"), (String)updateBatchLogSql, (Object[])new Object[]{this.batchLog.getLong("id")});
            if (!bl) {
                return;
            }
            try {
                this.fileLogService.save(unWriteBackFiles);
                this.detailLogService.save(detailLogResult);
                String sql = "update t_hsas_attintegsumlog set fwritebackfilequantity=fwritebackfilequantity+ ?  where fid= ? and fwritebackstate = '1'";
                SWCDbUtil.execute((DBRoute)DBRoute.of((String)"swc"), (String)sql, (Object[])new Object[]{unWriteBackFiles.length, this.summaryLogId});
                DynamicObject summaryLogResult = this.summaryLogService.queryOne("id,filequantity,integrationquantity,integrationstatus,writebackstate,writebackfilequantity,createtime,endtime,timeconsume", new QFilter[]{new QFilter("id", "=", (Object)this.summaryLogId)});
                int writeBackFileQuantity = summaryLogResult.getInt("writebackfilequantity");
                if (writeBackFileQuantity >= summaryLogResult.getInt("filequantity")) {
                    summaryLogResult.set("writebackstate", (Object)WriteBackStateEnum.COMPLETE.getCode());
                    summaryLogResult.set("integrationstatus", (Object)IntegrationStatusEnum.COMPLETE.getCode());
                    summaryLogResult.set("endtime", (Object)now);
                    summaryLogResult.set("timeconsume", (Object)Math.floor(SWCDateTimeUtils.dateDiff((Date)summaryLogResult.getDate("createtime"), (Date)now) / 1000L));
                }
                this.summaryLogService.saveOne(summaryLogResult);
            }
            catch (Throwable e) {
                txHandle.markRollback();
                LOGGER.error("doWriteBack transaction error", e);
                throw e;
            }
        }
    }

    private Map<Long, Set<Long>> getIgnoredDataMap(DynamicObject[] unWriteBackFiles) {
        Set attFileIdSet = Arrays.stream(unWriteBackFiles).map(unWriteBackFile -> unWriteBackFile.getLong("attfileid")).collect(Collectors.toSet());
        QFilter detailLogFilter = new QFilter("attintegsumlog", "=", (Object)this.summaryLogId);
        detailLogFilter.and(new QFilter("attfile", "in", attFileIdSet));
        DynamicObjectCollection detailLogs = this.detailLogService.queryOriginalCollection("id,attfile.id", new QFilter[]{detailLogFilter});
        Map<Long, Long> detailLogToAttFileIdMap = detailLogs.stream().collect(Collectors.toMap(detailLog -> detailLog.getLong("id"), detailLog -> detailLog.getLong("attfile.id")));
        QFilter itemDetailLogFilter = new QFilter("integdetailedlog", "in", detailLogToAttFileIdMap.keySet());
        itemDetailLogFilter.and(new QFilter("state", "=", (Object)ProcessResultEnum.IGNORED.getCode()));
        DynamicObjectCollection itemDetailLogs = this.itemDetailLogService.queryOriginalCollection("attsummaryitemid,integdetailedlog.id", new QFilter[]{itemDetailLogFilter});
        HashMap<Long, Set<Long>> ignoredDataMap = new HashMap<Long, Set<Long>>(itemDetailLogs.size());
        for (DynamicObject itemDetail : itemDetailLogs) {
            Long detailLogId = itemDetail.getLong("integdetailedlog.id");
            Long attFileId = detailLogToAttFileIdMap.get(detailLogId);
            if (attFileId == null) continue;
            Set attDataIdSet = ignoredDataMap.computeIfAbsent(attFileId, key -> new HashSet(16));
            attDataIdSet.add(itemDetail.getLong("attsummaryitemid"));
        }
        return ignoredDataMap;
    }

    protected void setReasonToItemOfCheckPass(Map<String, IntegrateState> fileDepEmpItemStateMap, Long attFileId, Long depEmpId, Map<Long, Map<String, Object>> itemDataMap, String code) {
        for (Long sumItemId : itemDataMap.keySet()) {
            String itemKey = String.format(THIRD_LONG_TPL, attFileId, depEmpId, sumItemId);
            IntegrateState itemState = fileDepEmpItemStateMap.get(itemKey);
            if (itemState == null || !itemState.isCheckPass() || itemState.isIgnored()) continue;
            itemState.setReasonCode(code);
        }
    }

    protected void setItemState(Map<String, IntegrateState> depEmpItemStateMap, Long attFileId, Long depEmpId, Map<Long, Map<String, Object>> sumItemIdToDataMap, BizDataFailStatusEnum reasonCode, boolean checkPass) {
        for (Long sumItemId : sumItemIdToDataMap.keySet()) {
            String depEmpItemStateKey = String.format(THIRD_LONG_TPL, attFileId, depEmpId, sumItemId);
            IntegrateState fileDepEmpItemState = depEmpItemStateMap.computeIfAbsent(depEmpItemStateKey, val -> new IntegrateState());
            fileDepEmpItemState.setCheckPass(checkPass);
            if (reasonCode == null) continue;
            fileDepEmpItemState.setReasonCode(reasonCode.getCode());
        }
    }

    protected DynamicObject createItemDetailLog(long detailLogId, Map<String, Object> itemData, IntegrateState itemState, Long summaryLogId) {
        DynamicObject dynamicObject = this.itemDetailLogService.generateEmptyDynamicObject();
        dynamicObject.set("integdetailedlog", (Object)detailLogId);
        dynamicObject.set("attintegsumlog", (Object)summaryLogId);
        dynamicObject.set("attitem", itemData.get("attitemid"));
        dynamicObject.set("tagnumber", itemData.get("tagnumber"));
        dynamicObject.set("attsummaryitemid", itemData.get("id"));
        dynamicObject.set("value", itemData.get("value"));
        if (itemData.get("datastartdate") != null) {
            dynamicObject.set("attstartdate", itemData.get("datastartdate"));
        }
        if (itemData.get("dataenddate") != null) {
            dynamicObject.set("attenddate", itemData.get("dataenddate"));
        }
        dynamicObject.set("reason", (Object)itemState.getReasonCode());
        dynamicObject.set("state", (Object)(!itemState.isCheckPass() ? ProcessResultEnum.FAILURE.getCode() : (itemState.isIgnored() ? ProcessResultEnum.IGNORED.getCode() : ProcessResultEnum.SUCCESS.getCode())));
        return dynamicObject;
    }

    public Map<Long, IntegrateState> getFileStateMap() {
        return this.fileStateMap;
    }

    public void setFileStateMap(Map<Long, IntegrateState> fileStateMap) {
        this.fileStateMap = fileStateMap;
    }

    public Map<String, IntegrateState> getFileDepEmpStateMap() {
        return this.fileDepEmpStateMap;
    }

    public void setFileDepEmpStateMap(Map<String, IntegrateState> fileDepEmpStateMap) {
        this.fileDepEmpStateMap = fileDepEmpStateMap;
    }

    public Map<String, IntegrateState> getFileDepEmpItemStateMap() {
        return this.fileDepEmpItemStateMap;
    }

    public void setFileDepEmpItemStateMap(Map<String, IntegrateState> fileDepEmpItemStateMap) {
        this.fileDepEmpItemStateMap = fileDepEmpItemStateMap;
    }
}

