/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.attintegrate.handler;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCSalaryParameterServiceHelper;
import kd.swc.hsbp.common.constants.WtcInteCfgConstants;
import kd.swc.hsbp.common.enums.AttDataTypeEnum;
import kd.swc.hsbp.common.enums.BizDataFailStatusEnum;
import kd.swc.hsbp.common.enums.IgnoredStateEnum;
import kd.swc.hsbp.common.enums.IntegrationProcessStateEnum;
import kd.swc.hsbp.common.enums.ProcessResultEnum;
import kd.swc.hsbp.common.enums.WriteBackStateEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hscs.business.attintegrate.IntegrateState;
import kd.swc.hscs.business.attintegrate.handler.AbstractIntegrateHandler;

public class AttBizDataIntegrateHandler
extends AbstractIntegrateHandler {
    private static final Log LOGGER = LogFactory.getLog(AttBizDataIntegrateHandler.class);
    private SWCDataServiceHelper integMapScmService = new SWCDataServiceHelper("hsbs_attintegmapscmnew");
    private Map<Long, Map<Long, Long>> scmToItemMap;
    private Map<Long, DynamicObject> attBizItemMap;
    private String dataType;
    private static final String THIRD_LONG_TPL = "%d_%d_%d";
    private static final String TWO_LONG_TPL = "%d_%d";
    private List<Map.Entry<String, Long>> adminOrgEntryList;
    private Map<Long, DynamicObject> integrateSchemeMap;
    private SWCDataServiceHelper depEmpService = new SWCDataServiceHelper("hrpi_depemp");

    public AttBizDataIntegrateHandler(DynamicObject summaryLog, DynamicObject batchLog, Long operator) {
        super(summaryLog, batchLog, operator);
    }

    @Override
    public boolean init() {
        HashMap<String, Long> adminOrgLongNumberMap;
        this.dataType = this.summaryLog.getString("attdatatype");
        Map paramMap = SWCSalaryParameterServiceHelper.getSalaryParam((String)"wtcinte");
        Boolean enableWtcInte = (Boolean)paramMap.get("enableWtcInte");
        Integer attScheme = paramMap.getOrDefault("scheme", WtcInteCfgConstants.FIELD_SCHEME_THREE);
        List mapRuleList = (List)paramMap.get("mapRuleList");
        if (!enableWtcInte.booleanValue() || !WtcInteCfgConstants.FIELD_SCHEME_ONE.equals(attScheme)) {
            LOGGER.warn("enableWtcInte is close or scheme is not one");
            return false;
        }
        DynamicObject[] schemes = this.integMapScmService.query("id,org.id,sumentryentity.sumattitem,sumentryentity.sumattbizitem,detailentryentity.detailattitem,detailentryentity.detailattbizitem,itemscope,enable,status", new QFilter[]{new QFilter("id", "in", mapRuleList.stream().map(mapRule -> mapRule.get("attintegmapscm")).collect(Collectors.toSet()))});
        if (schemes.length == 0) {
            LOGGER.warn("hsbs_attintegmapscmnew data is empty");
            return false;
        }
        Map<Long, DynamicObject> schemeMap = Arrays.stream(schemes).collect(Collectors.toMap(scheme -> scheme.getLong("id"), scheme -> scheme));
        this.integrateSchemeMap = new HashMap<Long, DynamicObject>(schemes.length);
        HashSet<Long> unContainSubOrgIdSet = new HashSet<Long>(mapRuleList.size());
        for (Map mapRule2 : mapRuleList) {
            Object schemeIdObject = mapRule2.get("attintegmapscm");
            Long schemeId = schemeIdObject instanceof Integer ? Long.valueOf(((Integer)schemeIdObject).longValue()) : (Long)schemeIdObject;
            DynamicObject scheme2 = schemeMap.get(schemeId);
            if (scheme2 == null) continue;
            Object adminOrgIdObject = mapRule2.get("adminorghr");
            Long adminOrgId = adminOrgIdObject instanceof Integer ? Long.valueOf(((Integer)adminOrgIdObject).longValue()) : (Long)adminOrgIdObject;
            this.integrateSchemeMap.put(adminOrgId, scheme2);
            if ("1".equals(mapRule2.get("containssub"))) continue;
            unContainSubOrgIdSet.add(adminOrgId);
        }
        HRBaseServiceHelper adminOrgHelper = new HRBaseServiceHelper("haos_adminorghr");
        HashSet<Long> adminOrgIdSet = new HashSet<Long>(this.integrateSchemeMap.size());
        adminOrgIdSet.addAll(this.integrateSchemeMap.keySet());
        adminOrgIdSet.removeAll(unContainSubOrgIdSet);
        if (CollectionUtils.isEmpty(adminOrgIdSet)) {
            adminOrgLongNumberMap = new HashMap<String, Long>(0);
        } else {
            DynamicObjectCollection adminOrgs = adminOrgHelper.queryOriginalCollection("id,structlongnumber", new QFilter[]{new QFilter("id", "in", adminOrgIdSet)});
            adminOrgLongNumberMap = new HashMap(adminOrgs.size());
            for (DynamicObject adminOrg : adminOrgs) {
                adminOrgLongNumberMap.put(adminOrg.getString("structlongnumber"), adminOrg.getLong("id"));
            }
        }
        this.adminOrgEntryList = adminOrgLongNumberMap.size() > 0 ? adminOrgLongNumberMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toList()) : new ArrayList<Map.Entry<String, Long>>(0);
        HashSet attBizItemIdSet = new HashSet(16);
        this.scmToItemMap = new HashMap<Long, Map<Long, Long>>(this.integrateSchemeMap.size());
        for (DynamicObject scheme3 : this.integrateSchemeMap.values()) {
            Map itemMap = this.scmToItemMap.computeIfAbsent(scheme3.getLong("id"), key -> new HashMap(16));
            if (AttDataTypeEnum.DETAIL.getCode().equals(this.dataType)) {
                DynamicObjectCollection detailEntry = scheme3.getDynamicObjectCollection("detailentryentity");
                for (DynamicObject detailItem : detailEntry) {
                    itemMap.put(detailItem.getLong("detailattitem.id"), detailItem.getLong("detailattbizitem.id"));
                }
            } else {
                DynamicObjectCollection sumEntry = scheme3.getDynamicObjectCollection("sumentryentity");
                for (DynamicObject sumItem : sumEntry) {
                    itemMap.put(sumItem.getLong("sumattitem.id"), sumItem.getLong("sumattbizitem.id"));
                }
            }
            attBizItemIdSet.addAll(itemMap.values());
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_attbizitem");
        QFilter filter = new QFilter("id", "in", attBizItemIdSet);
        filter.and("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)"1");
        DynamicObjectCollection attBizItems = helper.queryOriginalCollection("id,name,scalelimit,minvalue,isminvalnull,maxvalue,ismaxvalnull", new QFilter[]{filter});
        this.attBizItemMap = attBizItems.stream().collect(Collectors.toMap(attBizItem -> attBizItem.getLong("id"), attBizItem -> attBizItem));
        return true;
    }

    @Override
    public void handleData() {
        long startTime = System.currentTimeMillis();
        LOGGER.info("start handleData");
        HashSet<Long> depEmpIdSet = new HashSet<Long>(this.rows.size());
        HashSet<String> tagNumberSet = new HashSet<String>(this.rows.size());
        for (Map row : this.rows) {
            tagNumberSet.add((String)row.get("tagnumber"));
            depEmpIdSet.add((Long)row.get("depempid"));
        }
        Map<Long, Map<Long, Map<Long, Map<String, Object>>>> dataMap = this.groupByFileIdDepEmpIdAndSumItemId(this.rows);
        Map<Long, DynamicObject> fileLogMap = Arrays.stream(this.fileLogs).collect(Collectors.toMap(fileLog -> fileLog.getLong("attfileid"), Function.identity()));
        DynamicObjectCollection depEmps = this.depEmpService.queryOriginalCollection("id,adminorg.id,employee.empnumber", new QFilter[]{new QFilter("id", "in", depEmpIdSet)});
        Set adminOrgIdSet = depEmps.stream().map(depEmp -> depEmp.getLong("adminorg.id")).collect(Collectors.toSet());
        HRBaseServiceHelper adminOrgHelper = new HRBaseServiceHelper("haos_adminorghr");
        DynamicObjectCollection adminOrgs = adminOrgHelper.queryOriginalCollection("id,structlongnumber", new QFilter[]{new QFilter("id", "in", adminOrgIdSet)});
        Map<Long, String> adminorgToLongNumberMap = adminOrgs.stream().collect(Collectors.toMap(adminOrg -> adminOrg.getLong("id"), adminOrg -> adminOrg.getString("structlongnumber")));
        Map<Long, DynamicObject> depEmpMap = depEmps.stream().collect(Collectors.toMap(depEmp -> depEmp.getLong("id"), depEmp -> depEmp));
        DynamicObjectCollection oldAttBizDatas = this.bizDataService.queryOriginalCollection("id,batchnumber,identifynumber", new QFilter[]{new QFilter("identifynumber", "in", tagNumberSet)});
        Map<String, DynamicObject> oldAttBizDataMap = oldAttBizDatas.stream().collect(Collectors.toMap(oldAttBizData -> oldAttBizData.getString("identifynumber"), oldAttBizData -> oldAttBizData));
        long costTime = System.currentTimeMillis() - startTime;
        startTime = System.currentTimeMillis();
        LOGGER.info("collectData use time {} ms", (Object)costTime);
        HashMap<String, DynamicObject> newAttBizDataMap = new HashMap<String, DynamicObject>(this.rows.size());
        HashMap<String, String> uniqueCodeToBizDataKeyMap = new HashMap<String, String>(this.rows.size());
        for (Long attFileId : this.attFileIds) {
            Map<Long, Map<Long, Map<String, Object>>> depEmpIdAndSumItemIdToDataMap = dataMap.get(attFileId);
            if (depEmpIdAndSumItemIdToDataMap == null || depEmpIdAndSumItemIdToDataMap.size() == 0) {
                LOGGER.warn(MessageFormat.format("attitem data error,attFileId={0}", attFileId));
                continue;
            }
            this.checkIntegrateData(attFileId, depEmpIdAndSumItemIdToDataMap, this.fileStateMap, this.fileDepEmpItemStateMap, depEmpMap, adminorgToLongNumberMap, oldAttBizDataMap, uniqueCodeToBizDataKeyMap, newAttBizDataMap);
        }
        costTime = System.currentTimeMillis() - startTime;
        startTime = System.currentTimeMillis();
        LOGGER.info("checkAllData use time {} ms", (Object)costTime);
        this.batchCreateIntegrateLog(this.attFileIds, fileLogMap, dataMap, depEmpMap, adminorgToLongNumberMap, this.detailLogCollection, this.itemDetailLogCollection);
        costTime = System.currentTimeMillis() - startTime;
        LOGGER.info("createAllIntegrateLog use time {} ms", (Object)costTime);
        LOGGER.info("fileStateMap: {}", (Object)JSON.toJSONString((Object)this.fileStateMap));
        LOGGER.info("fileDepEmpStateMap: {}", (Object)JSON.toJSONString((Object)this.fileDepEmpStateMap));
        LOGGER.info("fileDepEmpItemStateMap: {}", (Object)JSON.toJSONString((Object)this.fileDepEmpItemStateMap));
    }

    @Override
    public String getBizDataEntityKey() {
        return AttDataTypeEnum.DETAIL.getCode().equals(this.summaryLog.getString("attdatatype")) ? "hsas_attbizdatadetail" : "hsas_attbizdatasummary";
    }

    private void batchCreateIntegrateLog(List<Long> attFileIdOfProcessing, Map<Long, DynamicObject> fileLogMap, Map<Long, Map<Long, Map<Long, Map<String, Object>>>> dataMap, Map<Long, DynamicObject> depEmpMap, Map<Long, String> adminorgToLongNumberMap, List<DynamicObject> detailLogCollection, List<DynamicObject> itemDetailLogCollection) {
        for (Long attFileId : attFileIdOfProcessing) {
            IntegrateState attFileState = (IntegrateState)this.fileStateMap.get(attFileId);
            if (attFileState == null) continue;
            this.createIntegrateLog(attFileId, attFileState, fileLogMap, dataMap, depEmpMap, adminorgToLongNumberMap, detailLogCollection, itemDetailLogCollection);
        }
    }

    private void createIntegrateLog(Long attFileId, IntegrateState attFileState, Map<Long, DynamicObject> fileLogMap, Map<Long, Map<Long, Map<Long, Map<String, Object>>>> dataMap, Map<Long, DynamicObject> depEmpMap, Map<Long, String> adminorgToLongNumberMap, List<DynamicObject> detailLogCollection, List<DynamicObject> itemDetailLogCollection) {
        DynamicObject fileLogObj = fileLogMap.get(attFileId);
        fileLogObj.set("ignoredstate", (Object)(attFileState.isIgnored() ? IgnoredStateEnum.YES.getCode() : IgnoredStateEnum.NO.getCode()));
        fileLogObj.set("processresult", (Object)(attFileState.isCheckPass() ? ProcessResultEnum.SUCCESS.getCode() : ProcessResultEnum.FAILURE.getCode()));
        Map<Long, Map<Long, Map<String, Object>>> depEmpIdAndItemIdToDataMap = dataMap.get(attFileId);
        long[] detailLogIds = DBServiceHelper.genLongIds((String)"hsas_attintegdetaillog", (int)depEmpIdAndItemIdToDataMap.size());
        int detailLogIdIndex = 0;
        for (Map.Entry<Long, Map<Long, Map<String, Object>>> depEmpEntry : depEmpIdAndItemIdToDataMap.entrySet()) {
            Long schemeId;
            Long depEmpId = depEmpEntry.getKey();
            Map<Long, Map<String, Object>> itemDataMap = depEmpEntry.getValue();
            DynamicObject depEmp = depEmpMap.get(depEmpId);
            DynamicObject scheme = this.integrateSchemeMap.get(depEmp.getLong("adminorg.id"));
            IntegrateState depEmpState = (IntegrateState)this.fileDepEmpStateMap.get(String.format(TWO_LONG_TPL, attFileId, depEmpId));
            if (!depEmpState.isCheckPass()) {
                this.setReasonToItemOfCheckPass(this.fileDepEmpItemStateMap, attFileId, depEmpId, itemDataMap, BizDataFailStatusEnum.FAILSTATUS_3060.getCode());
            }
            if (scheme == null) {
                scheme = this.findParentOrgSchemeByLongNumber(adminorgToLongNumberMap.get(depEmp.getLong("adminorg.id")));
            }
            if (scheme == null) {
                schemeId = 0L;
                LOGGER.info("current file depemp has no scm,depEmpId={}", (Object)depEmpId);
            } else {
                schemeId = scheme.getLong("id");
            }
            long detailLogId = detailLogIds[detailLogIdIndex++];
            DynamicObject detailLog = this.createDetailLog(detailLogId, this.summaryLog.getLong("id"), attFileId, depEmpId, schemeId, IntegrationProcessStateEnum.COMPLETE.getCode(), WriteBackStateEnum.INCOMPLETE.getCode(), depEmpState);
            detailLogCollection.add(detailLog);
            for (Map.Entry<Long, Map<String, Object>> itemEntry : itemDataMap.entrySet()) {
                Long sumAttItemId = itemEntry.getKey();
                Map<String, Object> itemData = itemEntry.getValue();
                String depEmpItemStateKey = String.format(THIRD_LONG_TPL, attFileId, depEmpId, sumAttItemId);
                IntegrateState itemState = (IntegrateState)this.fileDepEmpItemStateMap.get(depEmpItemStateKey);
                if (attFileState.isCheckPass() && !itemState.isIgnored()) continue;
                DynamicObject itemDetailLog = this.createItemDetailLog(detailLogId, itemData, itemState, this.summaryLog.getLong("id"));
                itemDetailLogCollection.add(itemDetailLog);
            }
        }
    }

    private void checkIntegrateData(Long attFileId, Map<Long, Map<Long, Map<String, Object>>> depEmpIdAndSumItemIdToDataMap, Map<Long, IntegrateState> fileStateMap, Map<String, IntegrateState> fileDepEmpItemStateMap, Map<Long, DynamicObject> depEmpMap, Map<Long, String> adminorgToLongNumberMap, Map<String, DynamicObject> oldAttBizDataMap, Map<String, String> uniqueCodeToBizDataKeyMap, Map<String, DynamicObject> newAttBizDataMap) {
        HashSet<Long> effectiveDepEmpIdSet = new HashSet<Long>(depEmpIdAndSumItemIdToDataMap.size());
        HashMap<Long, Long> effectiveAttItemToAttBizItemMap = new HashMap<Long, Long>(depEmpIdAndSumItemIdToDataMap.size());
        HashSet<Date> effectiveAttStartDateSet = new HashSet<Date>(depEmpIdAndSumItemIdToDataMap.size());
        HashSet<Date> effectiveAttEndDateSet = new HashSet<Date>(depEmpIdAndSumItemIdToDataMap.size());
        IntegrateState attFileState = fileStateMap.computeIfAbsent(attFileId, val -> new IntegrateState());
        int curFileDepEmpIgnoredSize = 0;
        ArrayList<DynamicObject> newAttBizDataList = new ArrayList<DynamicObject>(10);
        for (Map.Entry<Long, Map<Long, Map<String, Object>>> entry : depEmpIdAndSumItemIdToDataMap.entrySet()) {
            long startTime = System.currentTimeMillis();
            Long depEmpId = entry.getKey();
            LOGGER.info("checkData for {}", (Object)depEmpId);
            String fileDepEmpItemStateKey = String.format(TWO_LONG_TPL, attFileId, depEmpId);
            IntegrateState fileDepEmpState = this.fileDepEmpStateMap.computeIfAbsent(fileDepEmpItemStateKey, val -> new IntegrateState());
            Map<Long, Map<String, Object>> sumItemIdToDataMap = entry.getValue();
            this.setItemState(fileDepEmpItemStateMap, attFileId, depEmpId, sumItemIdToDataMap, null, true);
            DynamicObject depEmp = depEmpMap.get(depEmpId);
            if (depEmp == null) {
                this.setItemState(fileDepEmpItemStateMap, attFileId, depEmpId, sumItemIdToDataMap, BizDataFailStatusEnum.FAILSTATUS_6001, false);
                attFileState.setCheckPass(false);
                continue;
            }
            DynamicObject scheme = this.integrateSchemeMap.get(depEmp.getLong("adminorg.id"));
            if (scheme == null) {
                scheme = this.findParentOrgSchemeByLongNumber(adminorgToLongNumberMap.get(depEmp.getLong("adminorg.id")));
            }
            if (scheme == null) {
                this.setItemState(fileDepEmpItemStateMap, attFileId, depEmpId, sumItemIdToDataMap, BizDataFailStatusEnum.FAILSTATUS_6012, false);
                attFileState.setCheckPass(false);
                continue;
            }
            if (AttDataTypeEnum.SUM.getCode().equals(this.dataType)) {
                if (scheme.getString("itemscope").equals("1")) {
                    this.setItemState(fileDepEmpItemStateMap, attFileId, depEmpId, sumItemIdToDataMap, BizDataFailStatusEnum.FAILSTATUS_6004, false);
                    attFileState.setCheckPass(false);
                    continue;
                }
            } else if (scheme.getString("itemscope").equals("0")) {
                this.setItemState(fileDepEmpItemStateMap, attFileId, depEmpId, sumItemIdToDataMap, BizDataFailStatusEnum.FAILSTATUS_6005, false);
                attFileState.setCheckPass(false);
                continue;
            }
            if (!"C".equals(scheme.getString("status")) || !"1".equals(scheme.getString("enable"))) {
                this.setItemState(fileDepEmpItemStateMap, attFileId, depEmpId, sumItemIdToDataMap, BizDataFailStatusEnum.FAILSTATUS_6006, false);
                attFileState.setCheckPass(false);
                continue;
            }
            int curDepEmpIgnoredItemSize = this.checkItemData(newAttBizDataList, sumItemIdToDataMap, attFileId, depEmpId, fileDepEmpItemStateMap, oldAttBizDataMap, uniqueCodeToBizDataKeyMap, newAttBizDataMap, scheme, attFileState, fileDepEmpState, depEmp, effectiveAttItemToAttBizItemMap, effectiveAttStartDateSet, effectiveAttEndDateSet);
            effectiveDepEmpIdSet.add(depEmpId);
            if (curDepEmpIgnoredItemSize == sumItemIdToDataMap.size()) {
                fileDepEmpState.setIgnored(true);
                ++curFileDepEmpIgnoredSize;
            }
            long costTime = System.currentTimeMillis() - startTime;
            LOGGER.info("checkData for {} use time {} ms", (Object)depEmpId, (Object)costTime);
        }
        if (CollectionUtils.isNotEmpty(effectiveDepEmpIdSet) && effectiveAttItemToAttBizItemMap.size() > 0) {
            this.checkOverlap(depEmpIdAndSumItemIdToDataMap, effectiveDepEmpIdSet, effectiveAttItemToAttBizItemMap, effectiveAttStartDateSet, effectiveAttEndDateSet, attFileId, attFileState, fileDepEmpItemStateMap);
        }
        if (curFileDepEmpIgnoredSize == depEmpIdAndSumItemIdToDataMap.size()) {
            attFileState.setIgnored(true);
        }
        if (!attFileState.isCheckPass()) {
            this.setDepEmpState(attFileId, depEmpIdAndSumItemIdToDataMap.keySet(), false);
        } else if (CollectionUtils.isNotEmpty(newAttBizDataList)) {
            this.bizDataList.addAll(newAttBizDataList);
        }
    }

    private int checkItemData(List<DynamicObject> newAttBizDataList, Map<Long, Map<String, Object>> sumItemIdToDataMap, Long attFileId, Long depEmpId, Map<String, IntegrateState> fileDepEmpItemStateMap, Map<String, DynamicObject> oldAttBizDataMap, Map<String, String> uniqueCodeToBizDataKeyMap, Map<String, DynamicObject> newAttBizDataMap, DynamicObject scheme, IntegrateState attFileState, IntegrateState fileDepEmpState, DynamicObject depEmp, Map<Long, Long> effectiveAttItemToAttBizItemMap, Set<Date> effectiveAttStartDateSet, Set<Date> effectiveAttEndDateSet) {
        int curDepEmpIgnoredItemSize = 0;
        for (Map.Entry<Long, Map<String, Object>> itemEntry : sumItemIdToDataMap.entrySet()) {
            Long sumItemId = itemEntry.getKey();
            Map<String, Object> itemData = itemEntry.getValue();
            String tagNumber = (String)itemData.get("tagnumber");
            Long attItemId = (Long)itemData.get("attitemid");
            DynamicObject oldAttBizData = oldAttBizDataMap.get(tagNumber);
            IntegrateState itemState = fileDepEmpItemStateMap.computeIfAbsent(String.format(THIRD_LONG_TPL, attFileId, depEmpId, sumItemId), val -> new IntegrateState());
            if (oldAttBizData != null) {
                itemState.setCheckPass(false);
                itemState.setReasonCode(BizDataFailStatusEnum.FAILSTATUS_1010.getCode());
                attFileState.setCheckPass(false);
                continue;
            }
            Map<Long, Long> itemMap = this.scmToItemMap.get(scheme.getLong("id"));
            Long attBizItemId = itemMap.get(attItemId);
            if (attBizItemId == null) {
                itemState.setIgnored(true);
                itemState.setReasonCode(BizDataFailStatusEnum.FAILSTATUS_3050.getCode());
                ++curDepEmpIgnoredItemSize;
                continue;
            }
            DynamicObject attBizItem = this.attBizItemMap.get(attBizItemId);
            if (attBizItem == null) {
                itemState.setCheckPass(false);
                fileDepEmpState.setCheckPass(false);
                attFileState.setCheckPass(false);
                itemState.setReasonCode(BizDataFailStatusEnum.FAILSTATUS_6002.getCode());
                ++curDepEmpIgnoredItemSize;
                continue;
            }
            if (!this.checkBigDecimalValue(itemState, attBizItem, (BigDecimal)itemData.get("value"))) {
                fileDepEmpState.setCheckPass(false);
                attFileState.setCheckPass(false);
                continue;
            }
            String bizDataKey = String.format(THIRD_LONG_TPL, attFileId, depEmpId, sumItemId);
            DynamicObject newAttBizData = this.createAttBizData(depEmp, attBizItemId, itemData, attFileId);
            uniqueCodeToBizDataKeyMap.put(newAttBizData.getString("bizuniquecode"), bizDataKey);
            DynamicObject duplicateObj = newAttBizDataMap.putIfAbsent(bizDataKey, newAttBizData);
            if (duplicateObj != null) {
                LOGGER.error(MessageFormat.format("attbizdata is error , key is {0}", bizDataKey));
                continue;
            }
            newAttBizDataList.add(newAttBizData);
            effectiveAttItemToAttBizItemMap.put(attItemId, attBizItemId);
            effectiveAttStartDateSet.add(new Date((Long)itemData.get("datastartdate")));
            effectiveAttEndDateSet.add(new Date((Long)itemData.get("dataenddate")));
        }
        return curDepEmpIgnoredItemSize;
    }

    private void checkOverlap(Map<Long, Map<Long, Map<String, Object>>> depEmpIdAndSumItemIdToDataMap, Set<Long> effectiveDepEmpIdSet, Map<Long, Long> effectiveAttItemToAttBizItemMap, Set<Date> effectiveAttStartDateSet, Set<Date> effectiveAttEndDateSet, Long attFileId, IntegrateState attFileState, Map<String, IntegrateState> fileDepEmpItemStateMap) {
        HashSet<Long> effectiveAttItemIdSet = new HashSet<Long>(effectiveAttItemToAttBizItemMap.size());
        effectiveAttItemIdSet.addAll(effectiveAttItemToAttBizItemMap.values());
        Map<String, String> existAttBizDataInfoMap = this.getExistAttBizDataInfo(effectiveDepEmpIdSet, effectiveAttItemIdSet, effectiveAttStartDateSet, effectiveAttEndDateSet);
        HashSet<String> currentAttBizDataInfoSet = new HashSet<String>(depEmpIdAndSumItemIdToDataMap.size());
        for (Long depEmpId : effectiveDepEmpIdSet) {
            Map<Long, Map<String, Object>> dataMap = depEmpIdAndSumItemIdToDataMap.get(depEmpId);
            if (dataMap == null || dataMap.size() == 0) continue;
            for (Map.Entry<Long, Map<String, Object>> itemDataEntry : dataMap.entrySet()) {
                Date attEndDate;
                Map<String, Object> itemData = itemDataEntry.getValue();
                Long attItemId = (Long)itemData.get("attitemid");
                if (!effectiveAttItemToAttBizItemMap.containsKey(attItemId)) continue;
                Date attStartDate = new Date((Long)itemData.get("datastartdate"));
                String attBizDataKey = this.getAttBizDataKey(attStartDate, attEndDate = new Date((Long)itemData.get("dataenddate")), depEmpId, effectiveAttItemToAttBizItemMap.get(attItemId));
                if (existAttBizDataInfoMap.containsKey(attBizDataKey) || currentAttBizDataInfoSet.contains(attBizDataKey)) {
                    attFileState.setCheckPass(false);
                    IntegrateState fileDepEmpState = (IntegrateState)this.fileDepEmpStateMap.get(String.format(TWO_LONG_TPL, attFileId, depEmpId));
                    fileDepEmpState.setCheckPass(false);
                    String depEmpItemStateKey = String.format(THIRD_LONG_TPL, attFileId, depEmpId, itemDataEntry.getKey());
                    IntegrateState itemState = fileDepEmpItemStateMap.get(depEmpItemStateKey);
                    itemState.setCheckPass(false);
                    itemState.setReasonCode(BizDataFailStatusEnum.FAILSTATUS_6014.getCode());
                    continue;
                }
                currentAttBizDataInfoSet.add(attBizDataKey);
            }
        }
    }

    private DynamicObject findParentOrgSchemeByLongNumber(String longNumber) {
        for (int index = this.adminOrgEntryList.size() - 1; index >= 0; --index) {
            Map.Entry<String, Long> entry = this.adminOrgEntryList.get(index);
            if (!longNumber.startsWith(entry.getKey())) continue;
            return this.integrateSchemeMap.get(entry.getValue());
        }
        return null;
    }

    private DynamicObject createAttBizData(DynamicObject depEmp, Long attBizItemId, Map<String, Object> itemData, Long attFileId) {
        DynamicObject newAttBizData = this.bizDataService.generateEmptyDynamicObject();
        newAttBizData.set("batchnumber", (Object)this.batchVersionId);
        newAttBizData.set("bizuniquecode", (Object)((String)itemData.get("tagnumber") + Long.toHexString(attBizItemId)));
        newAttBizData.set("identifynumber", itemData.get("tagnumber"));
        newAttBizData.set("employee", itemData.get("employeeid"));
        newAttBizData.set("depemp", itemData.get("depempid"));
        newAttBizData.set("person", itemData.get("personid"));
        newAttBizData.set("adminorg", (Object)depEmp.getLong("adminorg.id"));
        newAttBizData.set("attbizitem", (Object)attBizItemId);
        newAttBizData.set("decimalvalue", itemData.get("value"));
        newAttBizData.set("amountvalue", (Object)0L);
        newAttBizData.set("textvalue", (Object)((BigDecimal)itemData.get("value")).toPlainString());
        Date attStartDate = new Date((Long)itemData.get("datastartdate"));
        Date attEndDate = new Date((Long)itemData.get("dataenddate"));
        newAttBizData.set("attstartdate", (Object)attStartDate);
        newAttBizData.set("attenddate", (Object)attEndDate);
        newAttBizData.set("empnumber", (Object)depEmp.getString("employee.empnumber"));
        if (this.earliestAttStartDate == null || this.earliestAttStartDate.after(attStartDate)) {
            this.earliestAttStartDate = attStartDate;
        }
        if (this.lastAttStartDate == null || this.lastAttStartDate.before(attStartDate)) {
            this.lastAttStartDate = attStartDate;
        }
        if (this.earliestAttEndDate == null || this.earliestAttEndDate.after(attEndDate)) {
            this.earliestAttEndDate = attEndDate;
        }
        if (this.lastAttEndDate == null || this.lastAttEndDate.before(attEndDate)) {
            this.lastAttEndDate = attEndDate;
        }
        newAttBizData.set("datasource", (Object)"0");
        newAttBizData.set("srcsystem", (Object)"0");
        newAttBizData.set("groupid", (Object)String.valueOf(attFileId));
        newAttBizData.set("creator", (Object)this.operator);
        newAttBizData.set("modifier", (Object)this.operator);
        newAttBizData.set("createtime", (Object)new Date());
        newAttBizData.set("modifytime", (Object)new Date());
        newAttBizData.set("billstatus", (Object)"C");
        newAttBizData.set("auditstatus", (Object)"C");
        return newAttBizData;
    }

    private void setDepEmpState(Long attFileId, Set<Long> depEmpIdSet, boolean isCheckPass) {
        for (Long depEmpId : depEmpIdSet) {
            String fileDepEmpStateKey = String.format(TWO_LONG_TPL, attFileId, depEmpId);
            IntegrateState depEmpState = (IntegrateState)this.fileDepEmpStateMap.get(fileDepEmpStateKey);
            if (depEmpState == null) {
                LOGGER.warn("depEmpStateMap data error");
                return;
            }
            depEmpState.setCheckPass(isCheckPass);
        }
    }

    private DynamicObject createDetailLog(long detailLogId, Long summaryLogId, Long attFileId, Long depEmpId, Long scmId, String processState, String writeBackState, IntegrateState depEmpState) {
        DynamicObject dynamicObject = this.detailLogService.generateEmptyDynamicObject();
        dynamicObject.set("id", (Object)detailLogId);
        dynamicObject.set("attintegsumlog", (Object)summaryLogId);
        dynamicObject.set("attfile", (Object)attFileId);
        dynamicObject.set("depemp", (Object)depEmpId);
        dynamicObject.set("attintegmapscmnew", (Object)scmId);
        dynamicObject.set("processstate", (Object)processState);
        dynamicObject.set("writebackstate", (Object)writeBackState);
        dynamicObject.set("ignoredstate", (Object)(depEmpState.isIgnored() ? IgnoredStateEnum.YES.getCode() : IgnoredStateEnum.NO.getCode()));
        dynamicObject.set("processresult", (Object)(depEmpState.isCheckPass() ? ProcessResultEnum.SUCCESS.getCode() : ProcessResultEnum.FAILURE.getCode()));
        return dynamicObject;
    }

    protected Map<String, String> getExistAttBizDataInfo(Set<Long> depEmpIdSet, Set<Long> attBizItemIdSet, Set<Date> attStartDateSet, Set<Date> attEndDateSet) {
        Date earliestStartDate = null;
        Date lastStartDate = null;
        Date earliestEndDate = null;
        Date lastEndDate = null;
        for (Date attStartDate : attStartDateSet) {
            if (earliestStartDate == null || earliestStartDate.after(attStartDate)) {
                earliestStartDate = attStartDate;
            }
            if (lastStartDate != null && !lastStartDate.before(attStartDate)) continue;
            lastStartDate = attStartDate;
        }
        for (Date attEndDate : attEndDateSet) {
            if (earliestEndDate == null || earliestEndDate.after(attEndDate)) {
                earliestEndDate = attEndDate;
            }
            if (lastEndDate != null && !lastEndDate.before(attEndDate)) continue;
            lastEndDate = attEndDate;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper(this.getBizDataEntityKey());
        QFilter filter = new QFilter("depemp", "in", depEmpIdSet);
        filter.and(new QFilter("attbizitem", "in", attBizItemIdSet));
        filter.and(new QFilter("attstartdate", ">=", (Object)earliestStartDate));
        filter.and(new QFilter("attstartdate", "<=", (Object)lastStartDate));
        filter.and(new QFilter("attenddate", ">=", (Object)earliestStartDate));
        filter.and(new QFilter("attenddate", "<=", (Object)lastEndDate));
        filter.and(new QFilter("auditstatus", "!=", (Object)"F"));
        DynamicObjectCollection attBizDatas = helper.queryOriginalCollection("depemp.id,attbizitem.id,attstartdate,attenddate,identifynumber", new QFilter[]{filter});
        if (kd.bos.orm.util.CollectionUtils.isEmpty((Collection)attBizDatas)) {
            return new HashMap<String, String>(16);
        }
        HashMap<String, String> attBizDataKeyMap = new HashMap<String, String>(attBizDatas.size() * 2);
        for (DynamicObject attBizData : attBizDatas) {
            String attBizDataKey = this.getAttBizDataKey(attBizData.getDate("attstartdate"), attBizData.getDate("attenddate"), attBizData.getLong("depemp.id"), attBizData.getLong("attbizitem.id"));
            attBizDataKeyMap.put(attBizDataKey, attBizData.getString("identifynumber"));
        }
        return attBizDataKeyMap;
    }

    protected String getAttBizDataKey(Date attStartDate, Date attEndDate, Long depEmpId, Long attBizItemId) {
        if (attStartDate == null || attEndDate == null || depEmpId == null || attBizItemId == null) {
            return "";
        }
        StringBuilder keyBuilder = new StringBuilder();
        try {
            attStartDate = SWCDateTimeUtils.formatDateToDate((Date)attStartDate, (String)"yyyy-MM-dd");
            attEndDate = SWCDateTimeUtils.formatDateToDate((Date)attEndDate, (String)"yyyy-MM-dd");
        }
        catch (Exception exception) {
            LOGGER.error("format date error", (Throwable)exception);
        }
        keyBuilder.append(SWCDateTimeUtils.format((Date)attStartDate, (String)"yyyy-MM-dd"));
        keyBuilder.append('_');
        keyBuilder.append(SWCDateTimeUtils.format((Date)attEndDate, (String)"yyyy-MM-dd"));
        keyBuilder.append('_');
        keyBuilder.append(depEmpId);
        keyBuilder.append('_');
        keyBuilder.append(attBizItemId);
        return keyBuilder.toString();
    }

    public Map<Long, Map<Long, Long>> getScmToItemMap() {
        return this.scmToItemMap;
    }

    public void setScmToItemMap(Map<Long, Map<Long, Long>> scmToItemMap) {
        this.scmToItemMap = scmToItemMap;
    }

    public Map<Long, DynamicObject> getAttBizItemMap() {
        return this.attBizItemMap;
    }

    public void setAttBizItemMap(Map<Long, DynamicObject> attBizItemMap) {
        this.attBizItemMap = attBizItemMap;
    }

    public Map<Long, DynamicObject> getIntegrateSchemeMap() {
        return this.integrateSchemeMap;
    }

    public void setIntegrateSchemeMap(Map<Long, DynamicObject> integrateSchemeMap) {
        this.integrateSchemeMap = integrateSchemeMap;
    }
}

