/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.bizdata;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.encrypt.Encrypters;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.BizDataFailStatusEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.MapUtils;

public class BizDataServiceHelper {
    public final Log log = LogFactory.getLog(BizDataServiceHelper.class);

    public Map<Long, DynamicObject> getBizItemProp(List<Map<String, Object>> dataList) {
        HashSet<Long> bizItemPropIdSet = new HashSet<Long>(16);
        for (Map<String, Object> dataMap : dataList) {
            List propDataList = (List)dataMap.get("propdatalist");
            if (propDataList == null || propDataList.size() == 0) continue;
            for (Map propDataMap : propDataList) {
                Long propId = MapUtils.getLong((Map)propDataMap, (Object)"bizitempropid");
                if (propId == null) continue;
                bizItemPropIdSet.add(propId);
            }
        }
        if (bizItemPropIdSet.size() == 0) {
            return new HashMap<Long, DynamicObject>(16);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_bizitemprop");
        String field = "id,name,number,datatype.id,datatype.storagetype,datalength,scalelimit,isminvalnull,minvalue,ismaxvalnull,maxvalue,earliestdate,lastdate";
        QFilter filter = new QFilter("id", "in", bizItemPropIdSet);
        filter.and("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        DynamicObjectCollection propColl = helper.queryOriginalCollection(field, new QFilter[]{filter});
        if (propColl == null || propColl.size() == 0) {
            return new HashMap<Long, DynamicObject>(16);
        }
        HashMap<Long, DynamicObject> retMap = new HashMap<Long, DynamicObject>(propColl.size());
        for (DynamicObject propObj : propColl) {
            retMap.put(propObj.getLong("id"), propObj);
        }
        return retMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> validateDataValue(List<Map<String, Object>> params, Map<Long, DynamicObject> bizItemPropMap) {
        this.log.info("validateDataValue params is :{}", (Object)String.valueOf(JSON.toJSON(params)));
        HashSet<Long> bizItemIdSet = new HashSet<Long>(16);
        HashSet<Long> usedCurrencySet = new HashSet<Long>(16);
        for (Map<String, Object> param : params) {
            Long bizItemId = MapUtils.getLong(param, (Object)"bizitemid");
            bizItemIdSet.add(bizItemId);
            Long usedCurrencyId = MapUtils.getLong(param, (Object)"currencyid");
            usedCurrencySet.add(usedCurrencyId);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_bizitem");
        String selectField = "id, datatype,datatype.id, datalength, minvalue, isminvalnull, maxvalue, ismaxvalnull, earliestdate, lastdate, scalelimit, currency,bizitempropentry.bizitemprop";
        QFilter filter = new QFilter("id", "in", bizItemIdSet);
        filter.and("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)"1");
        filter.and(new QFilter("classification", "!=", (Object)"1"));
        DynamicObject[] bizItemColl = helper.query(selectField, new QFilter[]{filter});
        HashMap<Long, DynamicObject> bizItemMap = new HashMap<Long, DynamicObject>(bizItemColl.length);
        for (DynamicObject dynamicObject : bizItemColl) {
            bizItemMap.put(dynamicObject.getLong("id"), dynamicObject);
        }
        helper.setEntityName("bd_currency");
        String selectFields = "id,amtprecision";
        DynamicObject[] currencyColl = helper.queryOriginalArray(selectFields, new QFilter[]{new QFilter("id", "in", usedCurrencySet)});
        HashMap<Long, DynamicObject> useCurrencyMap = new HashMap<Long, DynamicObject>(currencyColl.length);
        for (DynamicObject currency : currencyColl) {
            useCurrencyMap.put(currency.getLong("id"), currency);
        }
        ArrayList arrayList = new ArrayList(params.size());
        HashMap<String, Object> resultMap = null;
        for (Map<String, Object> param : params) {
            Map<String, Object> retMap;
            List propDataList;
            boolean checkResult;
            List propErrorInfo;
            String errorMsg;
            String errorCode;
            DynamicObject bizItemObj;
            block65: {
                String dataValue;
                long dataTypeId;
                block67: {
                    Long currencyId;
                    block66: {
                        block64: {
                            String bizDataCode = MapUtils.getString(param, (Object)"bizdatacode");
                            Long bizItemId = MapUtils.getLong(param, (Object)"bizitemid");
                            resultMap = new HashMap<String, Object>(4);
                            resultMap.put("bizdatacode", bizDataCode);
                            resultMap.put("bizitemid", bizItemId);
                            resultMap.put("status", 1);
                            resultMap.put("errorcode", null);
                            bizItemObj = (DynamicObject)bizItemMap.get(bizItemId);
                            if (SWCObjectUtils.isEmpty((Object)bizItemObj)) {
                                resultMap.put("status", 0);
                                resultMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1021.getCode());
                                resultMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1021.getDesc());
                                arrayList.add(resultMap);
                                continue;
                            }
                            dataTypeId = bizItemObj.getLong("datatype.id");
                            String value = MapUtils.getString(param, (Object)"value");
                            errorCode = null;
                            errorMsg = null;
                            propErrorInfo = null;
                            checkResult = true;
                            resultMap = new HashMap(4);
                            resultMap.put("bizdatacode", bizDataCode);
                            resultMap.put("bizitemid", bizItemId);
                            resultMap.put("status", 1);
                            resultMap.put("errorcode", null);
                            dataValue = value;
                            if (null != param.get("isencrypted") && MapUtils.getBoolean(param, (Object)"isencrypted").booleanValue()) {
                                try {
                                    dataValue = Encrypters.decode((String)value);
                                }
                                catch (Exception e) {
                                    resultMap.put("status", 0);
                                    resultMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1091.getCode());
                                    resultMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1091.getDesc());
                                    arrayList.add(resultMap);
                                    continue;
                                }
                            }
                            if (dataTypeId != 1030L) break block64;
                            currencyId = MapUtils.getLong(param, (Object)"currencyid");
                            if (currencyId != null) {
                                errorCode = BizDataFailStatusEnum.FAILSTATUS_1088.getCode();
                                errorMsg = BizDataFailStatusEnum.FAILSTATUS_1088.getDesc();
                                checkResult = false;
                            }
                            if (checkResult) {
                                int dataLength = bizItemObj.getInt("datalength");
                                if (dataValue.length() > dataLength) {
                                    errorCode = BizDataFailStatusEnum.FAILSTATUS_1090.getCode();
                                    errorMsg = BizDataFailStatusEnum.FAILSTATUS_1090.getDesc();
                                    checkResult = false;
                                }
                            }
                            break block65;
                        }
                        if (dataTypeId != 1010L) break block66;
                        currencyId = MapUtils.getLong(param, (Object)"currencyid");
                        if (currencyId != null) {
                            errorCode = BizDataFailStatusEnum.FAILSTATUS_1088.getCode();
                            errorMsg = BizDataFailStatusEnum.FAILSTATUS_1088.getDesc();
                            checkResult = false;
                        }
                        if (checkResult) {
                            BigDecimal decimalValue = null;
                            boolean flag = true;
                            try {
                                decimalValue = new BigDecimal(dataValue);
                            }
                            catch (Exception e) {
                                flag = false;
                            }
                            finally {
                                if (flag) {
                                    checkResult = this.checkNumScaleLimit(bizItemObj, dataValue);
                                    if (checkResult) {
                                        checkResult = this.checkMaxAndMinValue(bizItemObj, decimalValue);
                                        if (!checkResult) {
                                            errorCode = BizDataFailStatusEnum.FAILSTATUS_1092.getCode();
                                            errorMsg = BizDataFailStatusEnum.FAILSTATUS_1092.getDesc();
                                        }
                                    } else {
                                        errorCode = BizDataFailStatusEnum.FAILSTATUS_1096.getCode();
                                        errorMsg = BizDataFailStatusEnum.FAILSTATUS_1096.getDesc();
                                    }
                                } else {
                                    errorCode = BizDataFailStatusEnum.FAILSTATUS_1091.getCode();
                                    errorMsg = BizDataFailStatusEnum.FAILSTATUS_1091.getDesc();
                                    checkResult = false;
                                }
                            }
                        }
                        break block65;
                    }
                    if (dataTypeId != 1050L) break block67;
                    currencyId = MapUtils.getLong(param, (Object)"currencyid");
                    if (currencyId != null) {
                        errorCode = BizDataFailStatusEnum.FAILSTATUS_1088.getCode();
                        errorMsg = BizDataFailStatusEnum.FAILSTATUS_1088.getDesc();
                        checkResult = false;
                    }
                    if (checkResult) {
                        Date dateValue = null;
                        boolean flag = true;
                        try {
                            if (!SWCDateTimeUtils.validDateEffecitive((String)dataValue)) {
                                flag = false;
                            }
                            dateValue = SWCDateTimeUtils.parseDate((String)dataValue, (String)"yyyy-MM-dd");
                        }
                        catch (ParseException e) {
                            flag = false;
                        }
                        finally {
                            if (!flag) {
                                checkResult = false;
                                errorCode = BizDataFailStatusEnum.FAILSTATUS_1091.getCode();
                                errorMsg = BizDataFailStatusEnum.FAILSTATUS_1091.getDesc();
                            } else {
                                checkResult = this.checkDateEarlistAndLastValue(bizItemObj, dateValue);
                                if (!checkResult) {
                                    errorCode = BizDataFailStatusEnum.FAILSTATUS_1093.getCode();
                                    errorMsg = BizDataFailStatusEnum.FAILSTATUS_1093.getDesc();
                                }
                            }
                        }
                    }
                    break block65;
                }
                if (dataTypeId == 1020L) {
                    block62: {
                        HashMap<Long, DynamicObject> currencyMap;
                        DynamicObjectCollection currencys;
                        BigDecimal decimalValue = null;
                        boolean flag = true;
                        try {
                            decimalValue = new BigDecimal(dataValue);
                            if (!flag) break block62;
                        }
                        catch (Exception e) {
                            block63: {
                                try {
                                    flag = false;
                                    if (!flag) break block63;
                                }
                                catch (Throwable throwable) {
                                    if (flag) {
                                        Long usedCurrencyId = MapUtils.getLong(param, (Object)"currencyid");
                                        checkResult = this.checkCurrencyMustInput(usedCurrencyId);
                                        if (!checkResult) {
                                            errorCode = BizDataFailStatusEnum.FAILSTATUS_1094.getCode();
                                            errorMsg = BizDataFailStatusEnum.FAILSTATUS_1094.getDesc();
                                        } else {
                                            DynamicObjectCollection currencys2 = bizItemObj.getDynamicObjectCollection("currency");
                                            HashMap<Long, DynamicObject> currencyMap2 = new HashMap<Long, DynamicObject>(currencys2.size());
                                            for (DynamicObject currencyObj : currencys2) {
                                                currencyMap2.put(currencyObj.getDynamicObject("fbasedataid").getLong("id"), currencyObj);
                                            }
                                            checkResult = this.checkCurrencyRange(usedCurrencyId, currencyMap2);
                                            if (!checkResult) {
                                                errorCode = BizDataFailStatusEnum.FAILSTATUS_1095.getCode();
                                                errorMsg = BizDataFailStatusEnum.FAILSTATUS_1095.getDesc();
                                            } else if (!(checkResult = this.checkCurrencyPrecision(dataValue, checkResult, usedCurrencyId, useCurrencyMap))) {
                                                errorCode = BizDataFailStatusEnum.FAILSTATUS_1097.getCode();
                                                errorMsg = BizDataFailStatusEnum.FAILSTATUS_1097.getDesc();
                                            }
                                        }
                                    } else {
                                        errorCode = BizDataFailStatusEnum.FAILSTATUS_1091.getCode();
                                        errorMsg = BizDataFailStatusEnum.FAILSTATUS_1091.getDesc();
                                        checkResult = false;
                                    }
                                    throw throwable;
                                }
                                Long usedCurrencyId = MapUtils.getLong(param, (Object)"currencyid");
                                checkResult = this.checkCurrencyMustInput(usedCurrencyId);
                                if (!checkResult) {
                                    errorCode = BizDataFailStatusEnum.FAILSTATUS_1094.getCode();
                                    errorMsg = BizDataFailStatusEnum.FAILSTATUS_1094.getDesc();
                                } else {
                                    currencys = bizItemObj.getDynamicObjectCollection("currency");
                                    currencyMap = new HashMap(currencys.size());
                                    for (DynamicObject currencyObj : currencys) {
                                        currencyMap.put(currencyObj.getDynamicObject("fbasedataid").getLong("id"), currencyObj);
                                    }
                                    checkResult = this.checkCurrencyRange(usedCurrencyId, currencyMap);
                                    if (!checkResult) {
                                        errorCode = BizDataFailStatusEnum.FAILSTATUS_1095.getCode();
                                        errorMsg = BizDataFailStatusEnum.FAILSTATUS_1095.getDesc();
                                    } else if (!(checkResult = this.checkCurrencyPrecision(dataValue, checkResult, usedCurrencyId, useCurrencyMap))) {
                                        errorCode = BizDataFailStatusEnum.FAILSTATUS_1097.getCode();
                                        errorMsg = BizDataFailStatusEnum.FAILSTATUS_1097.getDesc();
                                    }
                                }
                            }
                            errorCode = BizDataFailStatusEnum.FAILSTATUS_1091.getCode();
                            errorMsg = BizDataFailStatusEnum.FAILSTATUS_1091.getDesc();
                            checkResult = false;
                        }
                        Long usedCurrencyId = MapUtils.getLong(param, (Object)"currencyid");
                        checkResult = this.checkCurrencyMustInput(usedCurrencyId);
                        if (!checkResult) {
                            errorCode = BizDataFailStatusEnum.FAILSTATUS_1094.getCode();
                            errorMsg = BizDataFailStatusEnum.FAILSTATUS_1094.getDesc();
                        } else {
                            currencys = bizItemObj.getDynamicObjectCollection("currency");
                            currencyMap = new HashMap<Long, DynamicObject>(currencys.size());
                            for (DynamicObject currencyObj : currencys) {
                                currencyMap.put(currencyObj.getDynamicObject("fbasedataid").getLong("id"), currencyObj);
                            }
                            checkResult = this.checkCurrencyRange(usedCurrencyId, currencyMap);
                            if (!checkResult) {
                                errorCode = BizDataFailStatusEnum.FAILSTATUS_1095.getCode();
                                errorMsg = BizDataFailStatusEnum.FAILSTATUS_1095.getDesc();
                            } else if (!(checkResult = this.checkCurrencyPrecision(dataValue, checkResult, usedCurrencyId, useCurrencyMap))) {
                                errorCode = BizDataFailStatusEnum.FAILSTATUS_1097.getCode();
                                errorMsg = BizDataFailStatusEnum.FAILSTATUS_1097.getDesc();
                            }
                        }
                        break block65;
                    }
                    errorCode = BizDataFailStatusEnum.FAILSTATUS_1091.getCode();
                    errorMsg = BizDataFailStatusEnum.FAILSTATUS_1091.getDesc();
                    checkResult = false;
                }
            }
            if (checkResult && (propDataList = (List)param.get("propdatalist")) != null && propDataList.size() > 0 && !(checkResult = ((Boolean)(retMap = this.checkPropDataValue(propDataList, bizItemObj, bizItemPropMap)).get("checkResult")).booleanValue())) {
                errorCode = (String)retMap.get("errorCode");
                errorMsg = (String)retMap.get("errorMsg");
                propErrorInfo = (List)retMap.get("propErrorInfo");
            }
            if (!checkResult) {
                resultMap.put("status", 0);
                resultMap.put("errorcode", errorCode);
                resultMap.put("errormsg", errorMsg);
                if (propErrorInfo != null && propErrorInfo.size() > 0) {
                    resultMap.put("propErrorInfo", propErrorInfo);
                }
            }
            arrayList.add(resultMap);
        }
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        result.put("success", Boolean.TRUE);
        result.put("message", null);
        result.put("result", arrayList);
        this.log.info("validateDataValue result is :{}", (Object)String.valueOf(JSON.toJSON(result)));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> checkPropDataValue(List<Map<String, Object>> propDataList, DynamicObject bizItemObj, Map<Long, DynamicObject> bizItemPropMap) {
        DynamicObject bizItemPropObj;
        Long bizitempropid;
        HashMap<String, Object> retMap = new HashMap<String, Object>(2);
        retMap.put("checkResult", Boolean.TRUE);
        DynamicObjectCollection entryColl = bizItemObj.getDynamicObjectCollection("bizitempropentry");
        if (entryColl == null || entryColl.size() == 0) {
            return retMap;
        }
        HashSet<Long> entryPoroIdSet = new HashSet<Long>(entryColl.size());
        for (Object entryObj : entryColl) {
            DynamicObject dynamicObject = entryObj.getDynamicObject("bizitemprop");
            if (SWCObjectUtils.isEmpty((Object)dynamicObject)) continue;
            entryPoroIdSet.add(dynamicObject.getLong("id"));
        }
        ArrayList propErrorList = new ArrayList(propDataList.size());
        for (Map map : propDataList) {
            HashMap<String, Object> propErrorMap;
            Long bizitempropid2 = (Long)map.get("bizitempropid");
            DynamicObject bizItemPropObj3 = bizItemPropMap.get(bizitempropid2);
            if (SWCObjectUtils.isEmpty((Object)bizItemPropObj3)) {
                propErrorMap = new HashMap<String, Object>(16);
                propErrorMap.put("bizitempropid", bizitempropid2);
                propErrorList.add(propErrorMap);
                continue;
            }
            if (entryPoroIdSet.contains(bizitempropid2)) continue;
            propErrorMap = new HashMap(16);
            propErrorMap.put("bizitempropid", bizitempropid2);
            propErrorMap.put("bizitempropname", bizItemPropObj3.getString("name"));
            propErrorMap.put("bizitempropnumber", bizItemPropObj3.getString("number"));
            propErrorList.add(propErrorMap);
        }
        if (propErrorList.size() > 0) {
            retMap.put("checkResult", Boolean.FALSE);
            retMap.put("errorCode", BizDataFailStatusEnum.FAILSTATUS_1102.getCode());
            retMap.put("errorMsg", BizDataFailStatusEnum.FAILSTATUS_1102.getDesc());
            retMap.put("propErrorInfo", propErrorList);
            return retMap;
        }
        HashSet<Long> bizItemPropIdSet = new HashSet<Long>(propDataList.size());
        for (Map<String, Object> propDataMap : propDataList) {
            bizitempropid = (Long)propDataMap.get("bizitempropid");
            bizItemPropObj = bizItemPropMap.get(bizitempropid);
            if (bizItemPropIdSet.contains(bizitempropid)) {
                HashMap<String, Object> propErrorMap = new HashMap<String, Object>(16);
                propErrorMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1085.getCode());
                propErrorMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1085.getDesc());
                propErrorMap.put("bizitempropid", bizitempropid);
                propErrorMap.put("bizitempropname", bizItemPropObj.getString("name"));
                propErrorMap.put("bizitempropnumber", bizItemPropObj.getString("number"));
                propErrorList.add(propErrorMap);
                break;
            }
            bizItemPropIdSet.add(bizitempropid);
        }
        if (propErrorList.size() > 0) {
            retMap.put("checkResult", Boolean.FALSE);
            retMap.put("errorCode", BizDataFailStatusEnum.FAILSTATUS_1098.getCode());
            retMap.put("errorMsg", BizDataFailStatusEnum.FAILSTATUS_1098.getDesc());
            retMap.put("propErrorInfo", propErrorList);
            return retMap;
        }
        for (Map<String, Object> propDataMap : propDataList) {
            block30: {
                HashMap<String, Object> propErrorMap;
                block31: {
                    bizitempropid = (Long)propDataMap.get("bizitempropid");
                    bizItemPropObj = bizItemPropMap.get(bizitempropid);
                    long dataTypeId = bizItemPropObj.getLong("datatype.id");
                    String propValue = MapUtils.getString(propDataMap, (Object)"propvalue");
                    if (dataTypeId == 1030L) {
                        int dataLength = bizItemPropObj.getInt("datalength");
                        if (propValue.length() <= dataLength) continue;
                        HashMap<String, Object> propErrorMap2 = new HashMap<String, Object>(16);
                        propErrorMap2.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1090.getCode());
                        propErrorMap2.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1090.getDesc());
                        propErrorMap2.put("bizitempropid", bizitempropid);
                        propErrorMap2.put("bizitempropname", bizItemPropObj.getString("name"));
                        propErrorMap2.put("bizitempropnumber", bizItemPropObj.getString("number"));
                        propErrorList.add(propErrorMap2);
                        continue;
                    }
                    if (dataTypeId == 1050L) {
                        Date dateValue;
                        block29: {
                            HashMap<String, Object> propErrorMap3;
                            dateValue = null;
                            boolean flag = true;
                            try {
                                if (!SWCDateTimeUtils.validDateEffecitive((String)propValue)) {
                                    flag = false;
                                } else {
                                    dateValue = SWCDateTimeUtils.parseDate((String)propValue, (String)"yyyy-MM-dd");
                                }
                                if (flag) break block29;
                                propErrorMap3 = new HashMap<String, Object>(16);
                                propErrorMap3.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1091.getCode());
                            }
                            catch (ParseException e) {
                                flag = false;
                                continue;
                            }
                            finally {
                                if (!flag) {
                                    HashMap<String, Object> propErrorMap4 = new HashMap<String, Object>(16);
                                    propErrorMap4.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1091.getCode());
                                    propErrorMap4.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1091.getDesc());
                                    propErrorMap4.put("bizitempropid", bizitempropid);
                                    propErrorMap4.put("bizitempropname", bizItemPropObj.getString("name"));
                                    propErrorMap4.put("bizitempropnumber", bizItemPropObj.getString("number"));
                                    propErrorList.add(propErrorMap4);
                                    continue;
                                }
                                boolean checkResult = this.checkDateEarlistAndLastValue(bizItemPropObj, dateValue);
                                if (checkResult) continue;
                                propErrorMap = new HashMap<String, Object>(16);
                                propErrorMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1093.getCode());
                                propErrorMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1093.getDesc());
                                propErrorMap.put("bizitempropid", bizitempropid);
                                propErrorMap.put("bizitempropname", bizItemPropObj.getString("name"));
                                propErrorMap.put("bizitempropnumber", bizItemPropObj.getString("number"));
                                propErrorList.add(propErrorMap);
                                continue;
                            }
                            propErrorMap3.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1091.getDesc());
                            propErrorMap3.put("bizitempropid", bizitempropid);
                            propErrorMap3.put("bizitempropname", bizItemPropObj.getString("name"));
                            propErrorMap3.put("bizitempropnumber", bizItemPropObj.getString("number"));
                            propErrorList.add(propErrorMap3);
                            continue;
                        }
                        boolean checkResult = this.checkDateEarlistAndLastValue(bizItemPropObj, dateValue);
                        if (checkResult) continue;
                        propErrorMap = new HashMap(16);
                        propErrorMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1093.getCode());
                        propErrorMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1093.getDesc());
                        propErrorMap.put("bizitempropid", bizitempropid);
                        propErrorMap.put("bizitempropname", bizItemPropObj.getString("name"));
                        propErrorMap.put("bizitempropnumber", bizItemPropObj.getString("number"));
                        propErrorList.add(propErrorMap);
                        continue;
                    }
                    if (dataTypeId != 1010L) continue;
                    BigDecimal decimalValue = null;
                    boolean flag = true;
                    try {
                        decimalValue = new BigDecimal(propValue);
                        if (!flag) break block30;
                        boolean checkResult = this.checkNumScaleLimit(bizItemPropObj, propValue);
                        if (!checkResult) break block31;
                        checkResult = this.checkMaxAndMinValue(bizItemPropObj, decimalValue);
                        if (checkResult) continue;
                        propErrorMap = new HashMap(16);
                        propErrorMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1092.getCode());
                    }
                    catch (Exception e) {
                        block32: {
                            block33: {
                                try {
                                    flag = false;
                                    if (!flag) break block32;
                                    boolean checkResult = this.checkNumScaleLimit(bizItemPropObj, propValue);
                                    if (!checkResult) break block33;
                                    checkResult = this.checkMaxAndMinValue(bizItemPropObj, decimalValue);
                                    if (checkResult) continue;
                                    propErrorMap = new HashMap(16);
                                    propErrorMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1092.getCode());
                                }
                                catch (Throwable throwable) {
                                    if (flag) {
                                        boolean checkResult = this.checkNumScaleLimit(bizItemPropObj, propValue);
                                        if (checkResult) {
                                            checkResult = this.checkMaxAndMinValue(bizItemPropObj, decimalValue);
                                            if (!checkResult) {
                                                HashMap<String, Object> propErrorMap5 = new HashMap<String, Object>(16);
                                                propErrorMap5.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1092.getCode());
                                                propErrorMap5.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1092.getDesc());
                                                propErrorMap5.put("bizitempropid", bizitempropid);
                                                propErrorMap5.put("bizitempropname", bizItemPropObj.getString("name"));
                                                propErrorMap5.put("bizitempropnumber", bizItemPropObj.getString("number"));
                                                propErrorList.add(propErrorMap5);
                                            }
                                        } else {
                                            HashMap<String, Object> propErrorMap6 = new HashMap<String, Object>(16);
                                            propErrorMap6.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1096.getCode());
                                            propErrorMap6.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1096.getDesc());
                                            propErrorMap6.put("bizitempropid", bizitempropid);
                                            propErrorMap6.put("bizitempropname", bizItemPropObj.getString("name"));
                                            propErrorMap6.put("bizitempropnumber", bizItemPropObj.getString("number"));
                                            propErrorList.add(propErrorMap6);
                                        }
                                    } else {
                                        HashMap<String, Object> propErrorMap7 = new HashMap<String, Object>(16);
                                        propErrorMap7.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1091.getCode());
                                        propErrorMap7.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1091.getDesc());
                                        propErrorMap7.put("bizitempropid", bizitempropid);
                                        propErrorMap7.put("bizitempropname", bizItemPropObj.getString("name"));
                                        propErrorMap7.put("bizitempropnumber", bizItemPropObj.getString("number"));
                                        propErrorList.add(propErrorMap7);
                                    }
                                    throw throwable;
                                }
                                propErrorMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1092.getDesc());
                                propErrorMap.put("bizitempropid", bizitempropid);
                                propErrorMap.put("bizitempropname", bizItemPropObj.getString("name"));
                                propErrorMap.put("bizitempropnumber", bizItemPropObj.getString("number"));
                                propErrorList.add(propErrorMap);
                                continue;
                            }
                            propErrorMap = new HashMap(16);
                            propErrorMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1096.getCode());
                            propErrorMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1096.getDesc());
                            propErrorMap.put("bizitempropid", bizitempropid);
                            propErrorMap.put("bizitempropname", bizItemPropObj.getString("name"));
                            propErrorMap.put("bizitempropnumber", bizItemPropObj.getString("number"));
                            propErrorList.add(propErrorMap);
                            continue;
                        }
                        HashMap<String, Object> propErrorMap8 = new HashMap<String, Object>(16);
                        propErrorMap8.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1091.getCode());
                        propErrorMap8.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1091.getDesc());
                        propErrorMap8.put("bizitempropid", bizitempropid);
                        propErrorMap8.put("bizitempropname", bizItemPropObj.getString("name"));
                        propErrorMap8.put("bizitempropnumber", bizItemPropObj.getString("number"));
                        propErrorList.add(propErrorMap8);
                        continue;
                    }
                    propErrorMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1092.getDesc());
                    propErrorMap.put("bizitempropid", bizitempropid);
                    propErrorMap.put("bizitempropname", bizItemPropObj.getString("name"));
                    propErrorMap.put("bizitempropnumber", bizItemPropObj.getString("number"));
                    propErrorList.add(propErrorMap);
                    continue;
                }
                propErrorMap = new HashMap(16);
                propErrorMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1096.getCode());
                propErrorMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1096.getDesc());
                propErrorMap.put("bizitempropid", bizitempropid);
                propErrorMap.put("bizitempropname", bizItemPropObj.getString("name"));
                propErrorMap.put("bizitempropnumber", bizItemPropObj.getString("number"));
                propErrorList.add(propErrorMap);
                continue;
            }
            HashMap<String, Object> propErrorMap = new HashMap<String, Object>(16);
            propErrorMap.put("errorcode", BizDataFailStatusEnum.FAILSTATUS_1091.getCode());
            propErrorMap.put("errormsg", BizDataFailStatusEnum.FAILSTATUS_1091.getDesc());
            propErrorMap.put("bizitempropid", bizitempropid);
            propErrorMap.put("bizitempropname", bizItemPropObj.getString("name"));
            propErrorMap.put("bizitempropnumber", bizItemPropObj.getString("number"));
            propErrorList.add(propErrorMap);
        }
        if (propErrorList.size() > 0) {
            retMap.put("checkResult", Boolean.FALSE);
            retMap.put("errorCode", BizDataFailStatusEnum.FAILSTATUS_1098.getCode());
            retMap.put("errorMsg", BizDataFailStatusEnum.FAILSTATUS_1098.getDesc());
            retMap.put("propErrorInfo", propErrorList);
        }
        return retMap;
    }

    private boolean checkNumScaleLimit(DynamicObject bizItemObj, String value) {
        boolean checkResult = true;
        int indexOf = value.indexOf(46);
        int precision = 0;
        if (indexOf > 0) {
            precision = value.substring(indexOf + 1, value.length()).length();
        }
        String scaleLimit = bizItemObj.getString("scalelimit");
        int scale = 10;
        if (!SWCStringUtils.isEmpty((String)scaleLimit)) {
            scale = Integer.parseInt(scaleLimit);
        }
        if (scale < precision) {
            checkResult = false;
        }
        return checkResult;
    }

    private boolean checkMaxAndMinValue(DynamicObject bizItemObj, BigDecimal decimalValue) {
        BigDecimal minValue = bizItemObj.getBigDecimal("minvalue");
        BigDecimal maxValue = bizItemObj.getBigDecimal("maxvalue");
        Boolean isMinValNull = bizItemObj.getBoolean("isminvalnull");
        boolean isMaxValNull = bizItemObj.getBoolean("ismaxvalnull");
        boolean checkResult = isMinValNull != false && isMaxValNull ? true : (isMinValNull != false ? maxValue.compareTo(decimalValue) >= 0 : (isMaxValNull ? minValue.compareTo(decimalValue) <= 0 : minValue.compareTo(decimalValue) <= 0 && maxValue.compareTo(decimalValue) >= 0));
        return checkResult;
    }

    private boolean checkDateEarlistAndLastValue(DynamicObject bizItemObj, Date dateValue) {
        Date earliestDate = bizItemObj.getDate("earliestdate");
        Date lastDate = bizItemObj.getDate("lastdate");
        boolean checkResult = earliestDate == null && lastDate == null ? true : (earliestDate == null ? !lastDate.before(dateValue) : (lastDate == null ? !earliestDate.after(dateValue) : !lastDate.before(dateValue) && !earliestDate.after(dateValue)));
        return checkResult;
    }

    private boolean checkCurrencyMustInput(Long usedCurrencyId) {
        boolean checkResult = true;
        if (SWCObjectUtils.isEmpty((Object)usedCurrencyId)) {
            checkResult = false;
        }
        return checkResult;
    }

    private boolean checkCurrencyRange(Long usedCurrencyId, Map<Long, DynamicObject> currencyMap) {
        boolean isMatch;
        boolean checkResult = true;
        if (currencyMap.size() > 0 && !(isMatch = currencyMap.containsKey(usedCurrencyId))) {
            checkResult = false;
        }
        return checkResult;
    }

    private boolean checkCurrencyPrecision(String value, boolean checkResult, Long usedCurrencyId, Map<Long, DynamicObject> useCurrencyMap) {
        int amtPrecision = 10;
        DynamicObject useCurrency = useCurrencyMap.get(usedCurrencyId);
        if (SWCObjectUtils.isEmpty((Object)useCurrency)) {
            return checkResult;
        }
        amtPrecision = useCurrency.getInt("amtprecision");
        int indexOf = value.indexOf(46);
        int precision = 0;
        if (indexOf > 0) {
            precision = value.substring(indexOf + 1, value.length()).length();
        }
        if (amtPrecision < precision) {
            checkResult = false;
        }
        return checkResult;
    }
}

