/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cal.check;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.CalStatusEnum;
import kd.swc.hsbp.common.enums.FailureTypeEnum;
import kd.swc.hscs.business.cal.rollback.helper.TaxPushHelper;

public class AccCheckService {
    private static final Log log = LogFactory.getLog(AccCheckService.class);
    private Long calTaskId;
    private Long recordId;

    public AccCheckService(Long calTaskId, Long recordId) {
        this.calTaskId = calTaskId;
        this.recordId = recordId;
    }

    public DynamicObject[] checkAccForCancelCal(DynamicObject[] allCalPersonArr, DynamicObjectCollection calDetailList) {
        log.info("checkAccForCancelCal start,recordId = {}", (Object)this.recordId);
        if (allCalPersonArr == null || allCalPersonArr.length == 0) {
            return new DynamicObject[0];
        }
        Map<Long, DynamicObject> calPersonMap = Arrays.asList(allCalPersonArr).stream().collect(Collectors.toMap(obj -> obj.getLong("id"), obj -> obj));
        List<Long> calPersonIdList = calPersonMap.keySet().stream().collect(Collectors.toList());
        Map<Long, String> errorMap = this.checkAccIndexIsMax(calPersonIdList, "cancelcal");
        if (errorMap.size() == 0) {
            return allCalPersonArr;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"hsas_caldetail");
        DynamicObject calPerson = null;
        for (Map.Entry<Long, String> entry : errorMap.entrySet()) {
            calPerson = calPersonMap.remove(entry.getKey());
            calDetailList.add((Object)TaxPushHelper.createCalDetail(type, calPerson, entry.getValue(), this.recordId, FailureTypeEnum.CHECK_FAIL.getCode(), CalStatusEnum.FAIL.getCode()));
        }
        DynamicObject[] newCalPersonArray = new DynamicObject[calPersonMap.size()];
        calPersonMap.values().toArray(newCalPersonArray);
        log.info("checkAccForCancelCal end,recordId = {}", (Object)this.recordId);
        return newCalPersonArray;
    }

    public Map<Long, String> checkAccForCal(List<Long> calPersonIdList) {
        return this.checkAccIndexIsMax(calPersonIdList, "cal");
    }

    private Map<Long, String> checkAccIndexIsMax(List<Long> calPersonIdList, String type) {
        log.info("checkAccIndexIsMax start,recordId = {}", (Object)this.recordId);
        HashMap<Long, String> errorMap = new HashMap<Long, String>(16);
        log.info("getAccDetailsData start,recordId = {}", (Object)this.recordId);
        DynamicObjectCollection accDetailsList = this.getAccDetailsData(calPersonIdList);
        log.info("getAccDetailsData end,recordId = {}", (Object)this.recordId);
        if (accDetailsList.size() == 0) {
            return errorMap;
        }
        String calErrorMsg = ResManager.loadKDString((String)"\u53ea\u80fd\u91cd\u65b0\u8ba1\u7b97\u4e0a\u6b21\u8ba1\u7b97\u7684\u85aa\u8d44\u6838\u7b97\u4efb\u52a1{0}\u3002", (String)"AccCheckService_1", (String)"swc-hscs-business", (Object[])new Object[0]);
        String cancelCalMsg = ResManager.loadKDString((String)"\u8bf7\u6309\u8ba1\u7b97\u7684\u5012\u5e8f\u56de\u6eda\uff0c\u4e0a\u6b21\u8ba1\u7b97\u7684\u6838\u7b97\u4efb\u52a1\u4e3a{0}\u3002", (String)"AccCheckService_0", (String)"swc-hscs-business", (Object[])new Object[0]);
        List<Long> accResultIdList = accDetailsList.stream().map(obj -> obj.getLong("accresult.id")).collect(Collectors.toList());
        log.info("getMaxIndexAccMap start,recordId = {}", (Object)this.recordId);
        Map<Long, DynamicObject> maxIndexAccMap = this.getMaxIndexAccMap(accResultIdList);
        log.info("getMaxIndexAccMap end,recordId = {}", (Object)this.recordId);
        Map<Long, Map<Long, DynamicObject>> accDetailMap = this.getAccDetailMap(accDetailsList);
        DynamicObject tempAcc = null;
        block0: for (Map.Entry<Long, Map<Long, DynamicObject>> entry : accDetailMap.entrySet()) {
            for (Map.Entry<Long, DynamicObject> accEntry : entry.getValue().entrySet()) {
                tempAcc = maxIndexAccMap.get(accEntry.getKey());
                if (tempAcc == null || tempAcc.getInt("index") <= accEntry.getValue().getInt("index") || tempAcc.getLong("caltask.id") == accEntry.getValue().getLong("caltask.id")) continue;
                if ("cal".equals(type)) {
                    errorMap.put(entry.getKey(), MessageFormat.format(calErrorMsg, tempAcc.getString("caltask.name")));
                    continue block0;
                }
                errorMap.put(entry.getKey(), MessageFormat.format(cancelCalMsg, tempAcc.getString("caltask.name")));
                continue block0;
            }
        }
        log.info("checkAccIndexIsMax end,recordId = {}", (Object)this.recordId);
        return errorMap;
    }

    private Map<Long, Map<Long, DynamicObject>> getAccDetailMap(DynamicObjectCollection accDetailsList) {
        HashMap<Long, Map<Long, DynamicObject>> accDetailMap = new HashMap<Long, Map<Long, DynamicObject>>(16);
        Map tempMap = null;
        for (DynamicObject obj : accDetailsList) {
            tempMap = accDetailMap.getOrDefault(obj.getLong("calpersonid"), new HashMap(16));
            tempMap.put(obj.getLong("accresult.id"), obj);
            accDetailMap.put(obj.getLong("calpersonid"), tempMap);
        }
        return accDetailMap;
    }

    private Map<Long, DynamicObject> getMaxIndexAccMap(List<Long> accResultIdList) {
        DynamicObjectCollection list = this.getMaxIndexAccDetailsData(accResultIdList);
        HashMap<Long, DynamicObject> maxIndexAccMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject obj : list) {
            if (maxIndexAccMap.containsKey(obj.getLong("accresult.id"))) continue;
            maxIndexAccMap.put(obj.getLong("accresult.id"), obj);
        }
        return maxIndexAccMap;
    }

    private DynamicObjectCollection getMaxIndexAccDetailsData(List<Long> accResultIdList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_accdetails");
        QFilter qFilter = new QFilter("accresult", "in", accResultIdList);
        qFilter.and("caltask", "!=", (Object)this.calTaskId);
        qFilter.and("index", ">", (Object)1);
        String fields = "id,caltask.id,caltask.name,accresult.id,index";
        return helper.queryOriginalCollection(fields, new QFilter[]{qFilter}, "accresult.id asc,index desc");
    }

    private DynamicObjectCollection getAccDetailsData(List<Long> calPersonIdList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_accdetails");
        QFilter qFilter = new QFilter("caltask", "=", (Object)this.calTaskId);
        qFilter.and("calpersonid", "in", calPersonIdList);
        String fields = "id,caltask.id,caltask.name,accresult.id,calpersonid,index";
        return helper.queryOriginalCollection(fields, new QFilter[]{qFilter});
    }
}

