/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cal.custfunc;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.swc.hscs.business.cal.utils.CalUtils;
import kd.swc.hscs.common.constants.TaxRateConstants;

public class OneTimeBonusCalForYearService {
    private static final int OUTPUTRESULTTYPE_ZERO = 0;
    private static final int OUTPUTRESULTTYPE_ONE = 1;
    private static final int OUTPUTRESULTTYPE_TWO = 2;
    private static final int OUTPUTRESULTTYPE_THREE = 3;

    public BigDecimal oneTimeBonusCalForYear(BigDecimal allSalary, BigDecimal oneTimeBonus, BigDecimal adjustType, BigDecimal adjustmentRange, BigDecimal outPutResultType) {
        BigDecimal tempTaxBandValue;
        this.checkParams(allSalary, oneTimeBonus, adjustType, adjustmentRange, outPutResultType);
        BigDecimal totalValue = allSalary.add(oneTimeBonus);
        Map<Integer, Map<String, BigDecimal>> taxRateMap = CalUtils.getTaxRateMap();
        BigDecimal oriTaxValue = this.getOriginalTaxValue(allSalary, oneTimeBonus, taxRateMap);
        if (adjustType == null) {
            adjustType = BigDecimal.ZERO;
        }
        if (adjustmentRange != null && adjustmentRange.compareTo(BigDecimal.ZERO) == 0) {
            adjustmentRange = null;
        }
        int resultType = 0;
        if (outPutResultType != null) {
            resultType = outPutResultType.intValue();
        }
        if (totalValue.compareTo(BigDecimal.ZERO) < 0) {
            if (resultType == 0) {
                return BigDecimal.ZERO;
            }
            if (resultType == 1) {
                return oneTimeBonus;
            }
            if (resultType == 2) {
                return BigDecimal.ZERO;
            }
            if (resultType == 3) {
                return oriTaxValue;
            }
        }
        Map<String, BigDecimal> rateInfoMap = null;
        BigDecimal minTaxBandValue = null;
        BigDecimal minTaxValue = null;
        BigDecimal minAdjustValue = null;
        BigDecimal minSalaryValue = null;
        BigDecimal minBonusValue = null;
        for (int taxBand = 0; taxBand < 8 && totalValue.compareTo(tempTaxBandValue = (rateInfoMap = taxRateMap.get(taxBand)).get("taxBandValue")) >= 0; ++taxBand) {
            BigDecimal tempValue = tempTaxBandValue.subtract(oneTimeBonus);
            if (tempValue.compareTo(BigDecimal.ZERO) > 0) {
                if (adjustType.compareTo(BigDecimal.ONE) != 0) break;
                if (adjustmentRange != null) {
                    tempValue = tempValue.min(adjustmentRange);
                }
            }
            BigDecimal tempBonuxValue = oneTimeBonus.add(tempValue);
            BigDecimal tempSalaryValue = totalValue.subtract(tempBonuxValue);
            BigDecimal tempTaxValue = this.getOriginalTaxValue(tempSalaryValue, tempBonuxValue, taxRateMap);
            if (minTaxValue != null && tempTaxValue.compareTo(minTaxValue) >= 0) continue;
            minTaxValue = tempTaxValue;
            minBonusValue = tempBonuxValue;
            minSalaryValue = tempSalaryValue;
            minAdjustValue = tempValue;
            minTaxBandValue = tempTaxBandValue;
        }
        BigDecimal result = null;
        if (minTaxValue == null || oriTaxValue.compareTo(minTaxValue) < 0) {
            switch (resultType) {
                case 0: {
                    result = oneTimeBonus;
                    break;
                }
                case 1: {
                    result = BigDecimal.ZERO;
                    break;
                }
                case 2: {
                    result = oriTaxValue;
                    break;
                }
                case 3: {
                    result = BigDecimal.ZERO;
                    break;
                }
            }
            return result;
        }
        if (minSalaryValue == null) {
            minSalaryValue = BigDecimal.ZERO;
        }
        minSalaryValue = minSalaryValue.max(minTaxBandValue);
        minBonusValue = totalValue.subtract(minSalaryValue);
        minAdjustValue = oneTimeBonus.subtract(minBonusValue);
        switch (resultType) {
            case 0: {
                result = minBonusValue;
                break;
            }
            case 1: {
                result = minAdjustValue;
                break;
            }
            case 2: {
                result = minTaxValue;
                break;
            }
            case 3: {
                result = oriTaxValue.subtract(minTaxValue);
                break;
            }
        }
        return result;
    }

    private BigDecimal getOriginalTaxValue(BigDecimal allSalary, BigDecimal oneTimeBonus, Map<Integer, Map<String, BigDecimal>> taxRateMap) {
        BigDecimal salaryTaxValue = this.salaryTaxCal(allSalary, taxRateMap);
        BigDecimal oneTimeBonusValue = this.oneTimeBonusCal(oneTimeBonus, taxRateMap);
        return salaryTaxValue.add(oneTimeBonusValue);
    }

    private BigDecimal oneTimeBonusCal(BigDecimal oneTimeBonus, Map<Integer, Map<String, BigDecimal>> taxRateMap) {
        Map<String, BigDecimal> rateInfoMap = this.getRateInfoMap(oneTimeBonus, taxRateMap);
        BigDecimal result = oneTimeBonus.multiply(rateInfoMap.get("taxRate")).subtract(rateInfoMap.get("bonusDeduct"));
        return result;
    }

    private BigDecimal salaryTaxCal(BigDecimal allSalary, Map<Integer, Map<String, BigDecimal>> taxRateMap) {
        Map<String, BigDecimal> rateInfoMap = this.getRateInfoMap(allSalary, taxRateMap);
        BigDecimal result = allSalary.multiply(rateInfoMap.get("taxRate")).subtract(rateInfoMap.get("salaryDeduct"));
        return result;
    }

    private void checkParams(BigDecimal allSalary, BigDecimal oneTimeBonus, BigDecimal adjustType, BigDecimal adjustmentRange, BigDecimal outPutResultType) {
        if (allSalary == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u51fd\u6570\u201c\u5168\u5e74\u4e00\u6b21\u6027\u5956\u91d1\u7a0e\u4f18\u6d4b\u7b97\u201d\u8ba1\u7b97\u5931\u8d25\uff1a\u5165\u53c2\u201c\u7efc\u5408\u6240\u5f97\u5e94\u7eb3\u7a0e\u6240\u5f97\u989d\u201d\u503c\u4e3a\u7a7a\u3002", (String)"OneTimeBonusCalForYearService_0", (String)"swc-hscs-business", (Object[])new Object[0]));
        }
        if (oneTimeBonus == null || BigDecimal.ZERO.compareTo(oneTimeBonus) > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u51fd\u6570\u201c\u5168\u5e74\u4e00\u6b21\u6027\u5956\u91d1\u7a0e\u4f18\u6d4b\u7b97\u201d\u8ba1\u7b97\u5931\u8d25\uff1a\u5165\u53c2\u201c\u5de5\u8d44\u53ef\u8c03\u8303\u56f4\u201d\u503c\u4e3a\u8d1f\u3002", (String)"OneTimeBonusCalForYearService_1", (String)"swc-hscs-business", (Object[])new Object[0]));
        }
        if (adjustType != null && adjustType.compareTo(BigDecimal.ZERO) != 0 && adjustType.compareTo(BigDecimal.ONE) != 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u51fd\u6570\u201c\u5168\u5e74\u4e00\u6b21\u6027\u5956\u91d1\u7a0e\u4f18\u6d4b\u7b97\u201d\u8ba1\u7b97\u5931\u8d25\uff1a\u5165\u53c2\u201c\u7a0e\u4f18\u8c03\u6574\u6a21\u5f0f\u201d\u503c\u4e0d\u5339\u914d\u3002", (String)"OneTimeBonusCalForYearService_2", (String)"swc-hscs-business", (Object[])new Object[0]));
        }
        if (adjustmentRange != null && adjustmentRange.compareTo(BigDecimal.ZERO) < 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u51fd\u6570\u201c\u5168\u5e74\u4e00\u6b21\u6027\u5956\u91d1\u7a0e\u4f18\u6d4b\u7b97\u201d\u8ba1\u7b97\u5931\u8d25\uff1a\u5165\u53c2\u201c\u5de5\u8d44\u53ef\u8c03\u8303\u56f4\u201d\u503c\u4e3a\u8d1f\u3002", (String)"OneTimeBonusCalForYearService_3", (String)"swc-hscs-business", (Object[])new Object[0]));
        }
        if (outPutResultType != null && outPutResultType.compareTo(BigDecimal.ZERO) != 0 && outPutResultType.compareTo(BigDecimal.ONE) != 0 && outPutResultType.compareTo(new BigDecimal("2")) != 0 && outPutResultType.compareTo(new BigDecimal("3")) != 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u51fd\u6570\u201c\u5168\u5e74\u4e00\u6b21\u6027\u5956\u91d1\u7a0e\u4f18\u6d4b\u7b97\u201d\u8ba1\u7b97\u5931\u8d25\uff1a\u5165\u53c2\u201c\u8f93\u51fa\u7ed3\u679c\u201d\u503c\u4e0d\u5339\u914d\u3002", (String)"OneTimeBonusCalForYearService_4", (String)"swc-hscs-business", (Object[])new Object[0]));
        }
    }

    private Map<String, BigDecimal> getRateInfoMap(BigDecimal value, Map<Integer, Map<String, BigDecimal>> taxRateMap) {
        Map<Object, Object> rateInfoMap = new HashMap(3);
        if (value.compareTo(BigDecimal.ZERO) > 0 && value.compareTo(new BigDecimal("36000")) <= 0) {
            rateInfoMap = taxRateMap.get(TaxRateConstants.TAX_BAND_ONE);
        } else if (value.compareTo(new BigDecimal("36000")) > 0 && value.compareTo(new BigDecimal("144000")) <= 0) {
            rateInfoMap = taxRateMap.get(TaxRateConstants.TAX_BAND_TWO);
        } else if (value.compareTo(new BigDecimal("144000")) > 0 && value.compareTo(new BigDecimal("300000")) <= 0) {
            rateInfoMap = taxRateMap.get(TaxRateConstants.TAX_BAND_THREE);
        } else if (value.compareTo(new BigDecimal("300000")) > 0 && value.compareTo(new BigDecimal("420000")) <= 0) {
            rateInfoMap = taxRateMap.get(TaxRateConstants.TAX_BAND_FOUR);
        } else if (value.compareTo(new BigDecimal("420000")) > 0 && value.compareTo(new BigDecimal("660000")) <= 0) {
            rateInfoMap = taxRateMap.get(TaxRateConstants.TAX_BAND_FIVE);
        } else if (value.compareTo(new BigDecimal("660000")) > 0 && value.compareTo(new BigDecimal("960000")) <= 0) {
            rateInfoMap = taxRateMap.get(TaxRateConstants.TAX_BAND_SIX);
        } else if (value.compareTo(new BigDecimal("960000")) > 0) {
            rateInfoMap = taxRateMap.get(TaxRateConstants.TAX_BAND_SEVEN);
        } else {
            rateInfoMap = new HashMap(4);
            rateInfoMap.put("taxRate", BigDecimal.ZERO);
            rateInfoMap.put("salaryDeduct", BigDecimal.ZERO);
            rateInfoMap.put("bonusDeduct", BigDecimal.ZERO);
        }
        return rateInfoMap;
    }
}

