/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cal.custfunc;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.FunctionErrorCodeEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import org.apache.commons.collections.MapUtils;
import org.jetbrains.annotations.NotNull;

public class PayDaysService {
    public static final String ENTITY_WORKINGPLAN = "working_plan";
    public static final String DAYTYPE_WEEKDAY = "1";
    public static final String DAYTYPE_RESTDAY = "2";
    public static final String DAYTYPE_HOLIDAY = "3";

    public BigDecimal getPayDaysByWorkingPlanNumber(Long calRecordId, String workingPlanNumber, Date date1, Date date2) throws Exception {
        String funcType = "getPayDays";
        return this.getPayDaysByWorkingPlanNumber(calRecordId, workingPlanNumber, date1, date2, true, false, true, funcType);
    }

    public BigDecimal getPayDaysByWorkingPlanNumber(Long calRecordId, String workingPlanNumber, Date date1, Date date2, Boolean countWeekday, Boolean countRestday, Boolean countHoliday, String funcType) throws Exception {
        if (StringUtils.isBlank((String)workingPlanNumber)) {
            String msg = "getPayDays".equals(funcType) ? FunctionErrorCodeEnum.FUNCTION_100051.getDesc() : FunctionErrorCodeEnum.FUNCTION_100059.getDesc();
            throw new Exception(msg);
        }
        if (date1 == null) {
            String msg = "getPayDays".equals(funcType) ? FunctionErrorCodeEnum.FUNCTION_100049.getDesc() : FunctionErrorCodeEnum.FUNCTION_100057.getDesc();
            throw new Exception(msg);
        }
        if (date2 == null) {
            String msg = "getPayDays".equals(funcType) ? FunctionErrorCodeEnum.FUNCTION_100050.getDesc() : FunctionErrorCodeEnum.FUNCTION_100058.getDesc();
            throw new Exception(msg);
        }
        Date startDate = (date1 = SWCDateTimeUtils.getDateWithoutMinTs((Date)date1)).compareTo(date2 = SWCDateTimeUtils.getDateWithoutMinTs((Date)date2)) < 0 ? date1 : date2;
        Date endDate = date1.compareTo(date2) < 0 ? date2 : date1;
        String key = String.format(Locale.ROOT, "getPayDays_%d_%s_%s_%s", calRecordId, workingPlanNumber, SWCDateTimeUtils.formatDate((Date)startDate), SWCDateTimeUtils.formatDate((Date)endDate));
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "hscs_salarycalcache_%d", calRecordId));
        BigDecimal payDaysCache = (BigDecimal)appCache.get(key, BigDecimal.class);
        if (payDaysCache != null) {
            return payDaysCache;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper(ENTITY_WORKINGPLAN);
        QFilter filter = new QFilter("number", "=", (Object)workingPlanNumber);
        DynamicObject workingPlan = helper.queryOne("id", new QFilter[]{filter});
        if (workingPlan == null) {
            String msg = "getPayDays".equals(funcType) ? FunctionErrorCodeEnum.FUNCTION_100052.getDesc() : FunctionErrorCodeEnum.FUNCTION_100060.getDesc();
            throw new Exception(msg);
        }
        Long workingPlanId = workingPlan.getLong("id");
        Map<String, String> workingPlanDataWithDay = this.getWorkingPlanDataWithDay(calRecordId, workingPlanId, startDate, endDate);
        BigDecimal payDays = this.getPayDays(startDate, endDate, workingPlanDataWithDay, countWeekday, countRestday, countHoliday, funcType);
        appCache.put(key, (Object)payDays);
        return payDays;
    }

    @NotNull
    private BigDecimal getPayDays(Date startDate, Date endDate, Map<String, String> workingPlanDataWithDay, Boolean countWeekday, Boolean countRestday, Boolean countHoliday, String funcType) throws Exception {
        Date tDate = startDate;
        BigDecimal payDays = BigDecimal.ZERO;
        while (tDate.compareTo(endDate) <= 0) {
            String type = workingPlanDataWithDay.get(SWCDateTimeUtils.formatDate((Date)tDate));
            if (type == null) {
                String msg = "getPayDays".equals(funcType) ? FunctionErrorCodeEnum.FUNCTION_100053.getDesc() : FunctionErrorCodeEnum.FUNCTION_100061.getDesc();
                throw new Exception(msg);
            }
            if (countWeekday.booleanValue() && DAYTYPE_WEEKDAY.equals(type)) {
                payDays = payDays.add(BigDecimal.ONE);
            } else if (countRestday.booleanValue() && DAYTYPE_RESTDAY.equals(type)) {
                payDays = payDays.add(BigDecimal.ONE);
            } else if (countHoliday.booleanValue() && DAYTYPE_HOLIDAY.equals(type)) {
                payDays = payDays.add(BigDecimal.ONE);
            }
            tDate = SWCDateTimeUtils.addDay((Date)tDate, (long)1L);
        }
        return payDays;
    }

    private Map<String, String> getWorkingPlanDataWithDay(Long calRecordId, Long workingPlanId, Date startDate, Date endDate) throws ParseException {
        String key = String.format(Locale.ROOT, "workingPlanDataWithDay_%d_%d", calRecordId, workingPlanId);
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "hscs_salarycalcache_%d", calRecordId));
        Map workingPlanCache = (Map)appCache.get(key, Map.class);
        if (workingPlanCache != null) {
            Date startDateCache = SWCDateTimeUtils.parseDate((String)MapUtils.getString((Map)workingPlanCache, (Object)"startDate"));
            Date endDateCache = SWCDateTimeUtils.parseDate((String)MapUtils.getString((Map)workingPlanCache, (Object)"endDate"));
            if (startDateCache.compareTo(startDate) <= 0 && endDateCache.compareTo(endDate) >= 0) {
                return MapUtils.getMap((Map)workingPlanCache, (Object)"data");
            }
            startDate = startDateCache.compareTo(startDate) < 0 ? startDateCache : startDate;
            endDate = endDateCache.compareTo(endDate) > 0 ? endDateCache : endDate;
        }
        Map workingPlanData = (Map)SWCMServiceUtils.invokeHRMPService((String)"hrcs", (String)"IHRCSCalendarService", (String)"getCalendarDataWithDay", (Object[])new Object[]{workingPlanId, startDate, endDate});
        WorkingPlan workingPlan = new WorkingPlan();
        workingPlan.setStartDate(SWCDateTimeUtils.formatDate((Date)startDate));
        workingPlan.setEndDate(SWCDateTimeUtils.formatDate((Date)endDate));
        workingPlan.setData(workingPlanData);
        appCache.put(key, (Object)workingPlan);
        return workingPlanData;
    }

    static class WorkingPlan {
        private String startDate;
        private String endDate;
        private Map<String, String> data;

        WorkingPlan() {
        }

        public String getStartDate() {
            return this.startDate;
        }

        public void setStartDate(String startDate) {
            this.startDate = startDate;
        }

        public String getEndDate() {
            return this.endDate;
        }

        public void setEndDate(String endDate) {
            this.endDate = endDate;
        }

        public Map<String, String> getData() {
            return this.data;
        }

        public void setData(Map<String, String> data) {
            this.data = data;
        }
    }
}

