/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cal.datagrade.calculation;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.business.datagrade.enums.DataGradeValueTypeEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hscs.business.cal.datagrade.utils.DataGradeMatchFailUtil;

public class MatchPreciseHelper {
    private static final Log log = LogFactory.getLog(MatchPreciseHelper.class);

    public static Map<String, Object> matchPreciseCal(Map<String, Object> params) {
        List conditionIds = (List)params.get("conditionIds");
        if (SWCObjectUtils.isEmpty((Object)conditionIds)) {
            return null;
        }
        Map conditionMap = (Map)params.get("conditionMap");
        if (SWCObjectUtils.isEmpty((Object)conditionMap)) {
            return null;
        }
        String failPolicy = (String)params.get("failpolice");
        List resultDatas = (List)params.get("resultDatas");
        if (SWCObjectUtils.isEmpty((Object)resultDatas)) {
            return null;
        }
        HashMap<String, Object> retMap = new HashMap<String, Object>(16);
        retMap.put("result", "success");
        Map matchSourceMap = (Map)params.get("matchSourceMap");
        ArrayList<String> conditions = new ArrayList<String>(10);
        for (String conditionId : conditionIds) {
            Object value = conditionMap.get(conditionId);
            String[] split = conditionId.split("-");
            conditions.add(MatchPreciseHelper.assembleSingleConditionValue(split, value));
        }
        String targetConditionValueStr = String.join((CharSequence)"#", conditions);
        Map matchRetMap = (Map)matchSourceMap.get(targetConditionValueStr);
        if (matchRetMap != null) {
            retMap.putAll(matchRetMap);
        } else {
            DataGradeMatchFailUtil.matchFailAction(retMap, failPolicy, resultDatas);
        }
        return retMap;
    }

    private static String assembleSingleConditionValue(String[] split, Object value) {
        String dataType = split[1];
        try {
            if (SWCStringUtils.equals((String)dataType, (String)DataGradeValueTypeEnum.AMOUNT.getDesc()) || SWCStringUtils.equals((String)dataType, (String)DataGradeValueTypeEnum.DECIMAL.getDesc())) {
                return ((BigDecimal)value).stripTrailingZeros().toPlainString();
            }
            if (SWCStringUtils.equals((String)dataType, (String)DataGradeValueTypeEnum.DATE.getDesc())) {
                return SWCDateTimeUtils.format((Date)((Date)value), (String)"yyyy-MM-dd");
            }
            return (String)value;
        }
        catch (Exception exception) {
            log.error("assembleSingleConditionValue_error", (Throwable)exception);
            return "";
        }
    }
}

