/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cal.fetchdata;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.exchangerate.ExchangeRateInfo;
import kd.swc.hsbp.business.exchangerate.helper.ExchangeRateHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.BizConsumeMethodEnum;
import kd.swc.hsbp.common.enums.CalResultItemEnum;
import kd.swc.hsbp.common.enums.DataTypeEnum;
import kd.swc.hsbp.common.enums.FailureTypeEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCDateUtils;
import kd.swc.hsbp.common.util.SWCDbUtil;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hscs.business.cal.service.BizDataService;
import kd.swc.hscs.business.cal.utils.CalReportUtils;
import kd.swc.hscs.business.cal.utils.CalUtils;
import kd.swc.hscs.common.vo.CalParamCacheInfo;
import kd.swc.hscs.common.vo.CalParamVO;
import kd.swc.hscs.common.vo.CalRecordVO;
import kd.swc.hscs.common.vo.CalResultItem;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.jetbrains.annotations.NotNull;

public class FetchBizItemDataService {
    private static final Log logger = LogFactory.getLog(FetchBizItemDataService.class);
    private static final String BIZDATA_CALPERIOD_IDS_KEY = "bizDataAndCalPeriodIds";
    private static final String BIZDATA_CALTASK_IDS_KEY = "bizDataAndCalTaskIds";
    DBRoute dbRoute = new DBRoute("swc");
    public static final String ATTITEMTYPE_SUMMARY = "1";
    public static final String ATTITEMTYPE_DETAIL = "0";
    private static final Integer INDEX_ZERO = 0;
    private static final Integer INDEX_ONE = 1;
    public static final String AMOUNT = "amount";
    private List<Long> calPersonIdList;
    private CalParamVO calParam;
    private Map<Long, Map<String, List<String>>> bsItemProrateRangeQueryMap;
    private Map<String, ExchangeRateInfo> exrateCacheMap;
    private Map<Long, Map<String, Object>> itemResultParamMap;
    private Map<Long, Map<String, Map<String, Object>>> itemSectionResultParamMap;
    private Set<Long> nonRecurBizDataIdSet;
    private Set<Long> recurBizDataIdSet;
    private Set<Long> attBizDataSummaryIdSet;
    private Set<Long> attBizDataDetailIdSet;
    private boolean isOnlyCal;
    private String traceId;
    private boolean isNoCountBizData;
    private boolean isNoCountAtt;

    public FetchBizItemDataService(List<Long> calPersonIdList, CalParamVO calParam, Map<Long, Map<String, List<String>>> bsItemProrateRangeQueryMap, Map<String, ExchangeRateInfo> exrateCacheMap, Map<Long, Map<String, Object>> itemResultParamMap, Map<Long, Map<String, Map<String, Object>>> itemSectionResultParamMap, boolean isOnlyCal) {
        this.calPersonIdList = calPersonIdList;
        this.calParam = calParam;
        this.bsItemProrateRangeQueryMap = bsItemProrateRangeQueryMap;
        this.exrateCacheMap = exrateCacheMap;
        this.itemResultParamMap = itemResultParamMap;
        this.itemSectionResultParamMap = itemSectionResultParamMap;
        this.nonRecurBizDataIdSet = new HashSet<Long>();
        this.recurBizDataIdSet = new HashSet<Long>();
        this.attBizDataSummaryIdSet = new HashSet<Long>();
        this.attBizDataDetailIdSet = new HashSet<Long>();
        this.traceId = RequestContext.get().getTraceId();
        this.isOnlyCal = isOnlyCal;
        this.isNoCountBizData = calParam.getCalParamMap().isNoCountBizData();
        this.isNoCountAtt = calParam.getCalParamMap().isNoCountAtt();
    }

    public void handleBsItemData(Map<Long, Long> salaryFileMap, Map<Long, Map<String, Map<String, CalResultItem>>> calResultDataMap, DynamicObjectCollection calPersonData, List<CalRecordVO> fetchBsDataFailList, Set<Long> failCalPersonSet) throws Exception {
        ArrayList<Long> attBizDataIdList;
        HashMap<Long, Map<String, List<DynamicObject>>> attBsItemDataMap;
        DynamicObjectCollection attBsItemDataColl;
        QFilter[] qFilters;
        Map<Long, Map<String, List<String>>> bizDataRelMap;
        HashMap<Long, Map<String, List<DynamicObject>>> bsItemDataMap;
        DynamicObjectCollection bsItemDataColl;
        QFilter[] qFilters2;
        logger.info("handleBsItemData begin,calBatchId={}", (Object)this.calParam.getCalBatchId());
        if (CalUtils.isTerminationCal(Long.valueOf(this.calParam.getRecordId()))) {
            return;
        }
        CalParamCacheInfo calParamMap = this.calParam.getCalParamMap();
        Map bsDataMap = calParamMap.getBsMap();
        if (null == bsDataMap) {
            return;
        }
        ArrayList<Long> recurBizItemList = new ArrayList<Long>(10);
        ArrayList<Long> nonrecurBizItemList = new ArrayList<Long>(10);
        ArrayList<Long> attBizItemSummaryList = new ArrayList<Long>(10);
        ArrayList<Long> attBizItemDetailList = new ArrayList<Long>(10);
        List bsIdForFileList = (List)bsDataMap.get("2");
        CalUtils.printLog("bsIdForFileList =>", bsIdForFileList);
        DynamicObjectCollection bizItemColl = this.getBizItemInfo(bsIdForFileList);
        HashMap<String, DynamicObject> bizItemInfoMap = new HashMap<String, DynamicObject>(bizItemColl.size());
        for (DynamicObject bizItem : bizItemColl) {
            bizItemInfoMap.put(bizItem.getString("uniquecode"), bizItem);
            Long bizItemId = bizItem.getLong("id");
            String classification = bizItem.getString("classification");
            if (ATTITEMTYPE_SUMMARY.equals(classification)) {
                String attItemType = bizItem.getString("attitemtype");
                if (ATTITEMTYPE_SUMMARY.equals(attItemType)) {
                    attBizItemSummaryList.add(bizItemId);
                    continue;
                }
                attBizItemDetailList.add(bizItemId);
                continue;
            }
            if (bizItem.getBoolean("cycle")) {
                recurBizItemList.add(bizItemId);
                continue;
            }
            nonrecurBizItemList.add(bizItemId);
        }
        String calType = this.calParam.getCalType();
        if (!SWCStringUtils.equals((String)calType, (String)"afterTaxCal") && !this.isOnlyCal) {
            Date calPayRollDate = calParamMap.getPayrolldate();
            this.dealCalBizDataRel(this.calParam.getCalTaskId(), calPayRollDate, this.calPersonIdList);
            List splitPersonList = SWCListUtils.split(this.calPersonIdList, (int)1000);
            for (List personList : splitPersonList) {
                this.dealAttCalBizDataRel(this.calParam.getCalTaskId(), personList);
            }
        }
        Set<Long> salaryFileIdSet = salaryFileMap.keySet();
        SWCDataServiceHelper bizDataHelper = new SWCDataServiceHelper("hsas_recurbizdata");
        if (recurBizItemList.size() > 0) {
            qFilters2 = this.getBizDataQFilter(calParamMap, salaryFileIdSet, recurBizItemList, true);
            bsItemDataColl = this.getRecBsItemData(bizDataHelper, qFilters2);
            bsItemDataMap = new HashMap<Long, Map<String, List<DynamicObject>>>(16);
            ArrayList<Long> recurBizDataIdList = new ArrayList<Long>(10);
            if (bsItemDataColl.size() > 0) {
                this.buildBsItemDataMap(bsItemDataColl, bsItemDataMap, salaryFileMap, recurBizDataIdList);
                bizDataRelMap = this.getBizDataAndCalTaskRelMap(recurBizDataIdList, true);
                this.dealBsPeriodProrateData(bsItemDataMap, bizDataRelMap, calResultDataMap, bizDataHelper, true, bizItemInfoMap);
            }
        }
        if (nonrecurBizItemList.size() > 0) {
            bizDataHelper.setEntityName("hsas_nonrecurbizdata");
            qFilters2 = this.getBizDataQFilter(calParamMap, salaryFileIdSet, nonrecurBizItemList, false);
            bsItemDataColl = this.getBsItemDataList(bizDataHelper, qFilters2);
            bsItemDataMap = new HashMap(16);
            ArrayList<Long> nonRecurBizDataIdList = new ArrayList<Long>(10);
            if (bsItemDataColl.size() > 0) {
                this.buildBsItemDataMap(bsItemDataColl, bsItemDataMap, salaryFileMap, nonRecurBizDataIdList);
                bizDataRelMap = this.getBizDataAndCalTaskRelMap(nonRecurBizDataIdList, false);
                this.dealBsPeriodProrateData(bsItemDataMap, bizDataRelMap, calResultDataMap, bizDataHelper, false, bizItemInfoMap);
            }
        }
        Map calTaskMap = calParamMap.getCalTaskMap();
        String attStartDateStr = MapUtils.getString((Map)calTaskMap, (Object)"attstartdate");
        String attEndDateStr = MapUtils.getString((Map)calTaskMap, (Object)"attenddate");
        if (StringUtils.isBlank((CharSequence)attStartDateStr) || StringUtils.isBlank((CharSequence)attEndDateStr)) {
            return;
        }
        Map<Long, Long> personIdAndCalPersonMap = calPersonData.stream().collect(Collectors.toMap(obj -> obj.getLong("personhrv.boid"), obj -> obj.getLong("id")));
        Set<Long> personIdSet = personIdAndCalPersonMap.keySet();
        this.checkAttStartAndEndDate(fetchBsDataFailList, failCalPersonSet, calTaskMap, attStartDateStr, attEndDateStr);
        Map<Long, Long> calPersonAndSalaryFileMap = calPersonData.stream().collect(Collectors.toMap(obj -> obj.getLong("id"), obj -> obj.getLong("salaryfile.id")));
        if (attBizItemSummaryList.size() > 0) {
            bizDataHelper.setEntityName("hsas_attbizdatasummary");
            qFilters = this.getAttBizDataQFilter(attStartDateStr, attEndDateStr, personIdSet, attBizItemSummaryList);
            attBsItemDataColl = this.getAttBsItemDataList(bizDataHelper, qFilters);
            attBsItemDataMap = new HashMap<Long, Map<String, List<DynamicObject>>>(16);
            attBizDataIdList = new ArrayList<Long>(10);
            if (attBsItemDataColl.size() > 0) {
                this.buildAttBsItemDataMap(attBsItemDataColl, attBsItemDataMap, attBizDataIdList, personIdAndCalPersonMap);
                this.dealAttBsPeriodProrateData(attBsItemDataMap, calResultDataMap, bizItemInfoMap, calPersonAndSalaryFileMap, fetchBsDataFailList, failCalPersonSet);
            }
        }
        if (attBizItemDetailList.size() > 0) {
            bizDataHelper.setEntityName("hsas_attbizdatadetail");
            qFilters = this.getAttBizDataQFilter(attStartDateStr, attEndDateStr, personIdSet, attBizItemDetailList);
            attBsItemDataColl = this.getAttBsItemDataList(bizDataHelper, qFilters);
            attBsItemDataMap = new HashMap(16);
            attBizDataIdList = new ArrayList(10);
            if (attBsItemDataColl.size() > 0) {
                this.buildAttBsItemDataMap(attBsItemDataColl, attBsItemDataMap, attBizDataIdList, personIdAndCalPersonMap);
                this.dealAttBsPeriodProrateData(attBsItemDataMap, calResultDataMap, bizItemInfoMap, calPersonAndSalaryFileMap, fetchBsDataFailList, failCalPersonSet);
            }
        }
        logger.info("handleBsItemData end,calBatchId= {}", (Object)this.calParam.getCalBatchId());
    }

    private void checkAttStartAndEndDate(List<CalRecordVO> fetchBsDataFailList, Set<Long> failCalPersonSet, Map<String, Object> calTaskMap, String attStartDateStr, String attEndDateStr) throws ParseException {
        for (Long personId : this.calPersonIdList) {
            Map<String, List<String>> itemDateRangeMap = this.bsItemProrateRangeQueryMap.get(personId);
            if (null == itemDateRangeMap) continue;
            Date attStartDate = SWCDateTimeUtils.parseDate((String)attStartDateStr);
            Date attEndDate = SWCDateTimeUtils.parseDate((String)attEndDateStr);
            String startDateStr = MapUtils.getString(calTaskMap, (Object)"startdate");
            Date startDate = SWCDateTimeUtils.parseDate((String)startDateStr);
            String endDateStr = MapUtils.getString(calTaskMap, (Object)"enddate");
            Date endDate = SWCDateTimeUtils.parseDate((String)endDateStr);
            if (startDate.compareTo(attStartDate) == 0 && endDate.compareTo(attEndDate) == 0 || failCalPersonSet.contains(personId)) continue;
            logger.info("proration fetchData fail,  The start and end dates of attendance and salary are not equal!");
            String msg = ResManager.loadKDString((String)"\u8be5\u85aa\u916c\u9879\u76ee\u9700\u8981\u5f15\u7528\u5206\u6bb5\u7684\u8003\u52e4\u6570\u636e\uff0c\u4f46\u7531\u4e8e\u8003\u52e4\u8d77\u6b62\u65e5\u671f\u4e0e\u85aa\u8d44\u8d77\u6b62\u65e5\u671f\u4e0d\u4e00\u81f4\uff0c\u53d6\u6570\u5931\u8d25\u3002\u5efa\u8bae\u8c03\u6574\u5206\u6bb5\u8ba1\u7b97\u65b9\u6848\u3002", (String)"FetchBizItemDataService_2", (String)"swc-hscs-business", (Object[])new Object[0]);
            String errorElement = CalReportUtils.getErrorElement(FailureTypeEnum.FETCHDATA_FAIL.getCode(), null);
            CalRecordVO calRecord = CalUtils.getCalRecordObj(personId, msg, FailureTypeEnum.FETCHDATA_FAIL.getCode(), errorElement);
            fetchBsDataFailList.add(calRecord);
            failCalPersonSet.add(personId);
        }
    }

    private void dealCalBizDataRel(String calTaskIdStr, Date calPayRollDate, List<Long> calPersonIdList) {
        Long calTaskId = Long.valueOf(calTaskIdStr);
        this.dealCalRecurBizDataRel(calTaskId, calPersonIdList);
        this.dealCalNonRecurBizDataRel(calTaskId, calPayRollDate, calPersonIdList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealCalNonRecurBizDataRel(Long calTaskId, Date calPayRollDate, List<Long> calPersonIdList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calnonbizdatarel");
        QFilter filter = new QFilter("caltask.id", "=", (Object)calTaskId);
        filter.and("payrolldate", "=", (Object)calPayRollDate);
        filter.and("calpersonid", "in", calPersonIdList);
        DynamicObjectCollection bizDataRelColl = helper.queryOriginalCollection("bizdataid", new QFilter[]{filter});
        SWCDataServiceHelper noCntHelper = new SWCDataServiceHelper("hsas_noncalbsnocntrel");
        DynamicObjectCollection notCntBizDataRelList = noCntHelper.queryOriginalCollection("bizdataid", new QFilter[]{filter});
        if (bizDataRelColl.size() == 0 && notCntBizDataRelList.size() == 0) {
            return;
        }
        Set<Long> nonRecurBizDataIdSet = bizDataRelColl.stream().map(obj -> obj.getLong("bizdataid")).collect(Collectors.toSet());
        Set<Long> nonRecBizDataNoCntIdSet = notCntBizDataRelList.stream().map(obj -> obj.getLong("bizdataid")).collect(Collectors.toSet());
        try (TXHandle txHandle = TX.requiresNew();){
            helper.deleteByFilter(new QFilter[]{filter});
            noCntHelper.deleteByFilter(new QFilter[]{filter});
            HashMap<Long, Integer> cacheNonRecurBizDataUseCountMap = new HashMap<Long, Integer>(16);
            this.handleNonRecBizDataUseCount(helper, nonRecurBizDataIdSet, cacheNonRecurBizDataUseCountMap);
            HashMap<Long, Integer> nonRecBizDataNoCntUseCountMap = new HashMap<Long, Integer>(16);
            this.handleNonRecBizDataNoCntUseCount(noCntHelper, nonRecBizDataNoCntIdSet, nonRecBizDataNoCntUseCountMap);
            nonRecurBizDataIdSet.addAll(nonRecBizDataNoCntIdSet);
            HashSet<Long> bizDataRecordIdSet = new HashSet<Long>(16);
            SWCDataServiceHelper bizDataHelper = new SWCDataServiceHelper("hsas_nonrecurbizdata");
            QFilter bizNonRecurDataFilter = new QFilter("id", "in", nonRecurBizDataIdSet);
            DynamicObject[] nonRecurBizData = bizDataHelper.query("id,usagecount,modifytime,nocounttimes,bizdatarecord", new QFilter[]{bizNonRecurDataFilter}, null);
            this.resetNonRecurBizDataCount(cacheNonRecurBizDataUseCountMap, nonRecBizDataNoCntUseCountMap, bizDataRecordIdSet, nonRecurBizData);
            if (nonRecurBizData != null && nonRecurBizData.length > 0) {
                bizDataHelper.update(nonRecurBizData);
            }
            BizDataService bizDataService = new BizDataService();
            bizDataService.updateBizDataRecordUseCount(bizDataRecordIdSet);
            if (CalUtils.isTerminationCal(Long.valueOf(this.calParam.getRecordId()))) {
                txHandle.markRollback();
            }
        }
    }

    private void resetNonRecurBizDataCount(Map<Long, Integer> cacheNonRecurBizDataUseCountMap, Map<Long, Integer> nonRecBizDataNoCntUseCountMap, Set<Long> bizDataRecordIdSet, DynamicObject[] nonRecurBizData) {
        if (nonRecurBizData == null || nonRecurBizData.length == 0) {
            return;
        }
        Date date = new Date();
        for (DynamicObject obj : nonRecurBizData) {
            Integer noCountTimes;
            Long bizDataId = obj.getLong("id");
            Integer cacheUseCount = cacheNonRecurBizDataUseCountMap.get(bizDataId);
            if (cacheUseCount != null) {
                obj.set("usagecount", (Object)cacheUseCount);
            }
            if ((noCountTimes = nonRecBizDataNoCntUseCountMap.get(bizDataId)) != null) {
                obj.set("nocounttimes", (Object)noCountTimes);
            }
            obj.set("modifytime", (Object)date);
            long bizDataRecordId = obj.getLong("bizdatarecord");
            if (bizDataRecordId == 0L) continue;
            bizDataRecordIdSet.add(bizDataRecordId);
        }
    }

    private void handleNonRecBizDataUseCount(SWCDataServiceHelper helper, Set<Long> nonRecurBizDataIdSet, Map<Long, Integer> cacheNonRecurBizDataUseCountMap) {
        if (nonRecurBizDataIdSet.size() == 0) {
            return;
        }
        DynamicObjectCollection calNonRecurBizDataRel = helper.queryOriginalCollection("bizdataid", new QFilter[]{new QFilter("bizdataid", "in", nonRecurBizDataIdSet)});
        for (DynamicObject calBizData : calNonRecurBizDataRel) {
            Long bizDataId = calBizData.getLong("bizdataid");
            Integer useCount = cacheNonRecurBizDataUseCountMap.get(bizDataId);
            if (useCount == null) {
                cacheNonRecurBizDataUseCountMap.put(bizDataId, 1);
                continue;
            }
            cacheNonRecurBizDataUseCountMap.put(bizDataId, useCount + 1);
        }
        for (Long bizDataId : nonRecurBizDataIdSet) {
            Integer useCount = cacheNonRecurBizDataUseCountMap.get(bizDataId);
            if (useCount != null) continue;
            cacheNonRecurBizDataUseCountMap.put(bizDataId, 0);
        }
    }

    private void handleNonRecBizDataNoCntUseCount(SWCDataServiceHelper helper, Set<Long> nonRecBizDataNoCntIdSet, Map<Long, Integer> nonRecBizDataNoCntUseCountMap) {
        if (nonRecBizDataNoCntIdSet.size() == 0) {
            return;
        }
        DynamicObjectCollection calNonRecurBizDataRel = helper.queryOriginalCollection("bizdataid", new QFilter[]{new QFilter("bizdataid", "in", nonRecBizDataNoCntIdSet)});
        for (DynamicObject calBizData : calNonRecurBizDataRel) {
            Long bizDataId = calBizData.getLong("bizdataid");
            Integer useCount = nonRecBizDataNoCntUseCountMap.get(bizDataId);
            if (useCount == null) {
                nonRecBizDataNoCntUseCountMap.put(bizDataId, 1);
                continue;
            }
            nonRecBizDataNoCntUseCountMap.put(bizDataId, useCount + 1);
        }
        for (Long bizDataId : nonRecBizDataNoCntIdSet) {
            Integer useCount = nonRecBizDataNoCntUseCountMap.get(bizDataId);
            if (useCount != null) continue;
            nonRecBizDataNoCntUseCountMap.put(bizDataId, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealCalRecurBizDataRel(Long calTaskId, List<Long> calPersonIdList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calbizdatarel");
        QFilter filter = new QFilter("caltask.id", "=", (Object)calTaskId);
        filter.and("calpersonid", "in", calPersonIdList);
        DynamicObjectCollection bizDataRelColl = helper.queryOriginalCollection("bizdataid", new QFilter[]{filter});
        SWCDataServiceHelper noCntHelper = new SWCDataServiceHelper("hsas_calbsnocntrel");
        DynamicObjectCollection notCntBizDataRelList = noCntHelper.queryOriginalCollection("bizdataid", new QFilter[]{filter});
        if (bizDataRelColl.size() == 0 && notCntBizDataRelList.size() == 0) {
            return;
        }
        Set<Long> recurBizDataIdSet = bizDataRelColl.stream().map(obj -> obj.getLong("bizdataid")).collect(Collectors.toSet());
        Set<Long> notCntRecBizDataIdSet = notCntBizDataRelList.stream().map(obj -> obj.getLong("bizdataid")).collect(Collectors.toSet());
        try (TXHandle txHandle = TX.requiresNew();){
            helper.deleteByFilter(new QFilter[]{filter});
            noCntHelper.deleteByFilter(new QFilter[]{filter});
            HashMap<Long, Integer> cacheRecurBizDataUseCount = new HashMap<Long, Integer>(16);
            this.handleRecBizDataRelCount(helper, recurBizDataIdSet, cacheRecurBizDataUseCount);
            HashMap<Long, Integer> recurBizDataNoCntUseCount = new HashMap<Long, Integer>(16);
            this.handleRecBizDataNoCntRelCount(noCntHelper, notCntRecBizDataIdSet, recurBizDataNoCntUseCount);
            recurBizDataIdSet.addAll(notCntRecBizDataIdSet);
            QFilter bizRecurDataFilter = new QFilter("id", "in", recurBizDataIdSet);
            SWCDataServiceHelper bizDataHelper = new SWCDataServiceHelper("hsas_recurbizdata");
            DynamicObject[] recurBizData = bizDataHelper.query("id,usagecount,nocounttimes,modifytime", new QFilter[]{bizRecurDataFilter});
            Date date = new Date();
            if (recurBizData != null && recurBizData.length > 0) {
                for (DynamicObject obj2 : recurBizData) {
                    Integer noCountTimes;
                    Long bizDataId = obj2.getLong("id");
                    Integer cacheUseCount = (Integer)cacheRecurBizDataUseCount.get(bizDataId);
                    if (cacheUseCount != null) {
                        obj2.set("usagecount", (Object)cacheUseCount);
                    }
                    if ((noCountTimes = (Integer)recurBizDataNoCntUseCount.get(bizDataId)) != null) {
                        obj2.set("nocounttimes", (Object)noCountTimes);
                    }
                    obj2.set("modifytime", (Object)date);
                }
                bizDataHelper.update(recurBizData);
            }
            if (CalUtils.isTerminationCal(Long.valueOf(this.calParam.getRecordId()))) {
                txHandle.markRollback();
            }
        }
    }

    private void handleRecBizDataNoCntRelCount(SWCDataServiceHelper helper, Set<Long> notCntRecBizDataIdSet, Map<Long, Integer> recurBizDataNoCntUseCount) {
        if (notCntRecBizDataIdSet.size() == 0) {
            return;
        }
        DynamicObjectCollection calRecurBizDataRel = helper.queryOriginalCollection("bizdataid", new QFilter[]{new QFilter("bizdataid", "in", notCntRecBizDataIdSet)});
        for (DynamicObject calBizData : calRecurBizDataRel) {
            Long bizDataId = calBizData.getLong("bizdataid");
            Integer useCount = recurBizDataNoCntUseCount.get(bizDataId);
            if (useCount == null) {
                recurBizDataNoCntUseCount.put(bizDataId, 1);
                continue;
            }
            recurBizDataNoCntUseCount.put(bizDataId, useCount + 1);
        }
        for (Long bizDataId : notCntRecBizDataIdSet) {
            Integer useCount = recurBizDataNoCntUseCount.get(bizDataId);
            if (useCount != null) continue;
            recurBizDataNoCntUseCount.put(bizDataId, 0);
        }
    }

    private void handleRecBizDataRelCount(SWCDataServiceHelper helper, Set<Long> recurBizDataIdSet, Map<Long, Integer> cacheRecurBizDataUseCount) {
        if (recurBizDataIdSet.size() == 0) {
            return;
        }
        DynamicObjectCollection calRecurBizDataRel = helper.queryOriginalCollection("bizdataid", new QFilter[]{new QFilter("bizdataid", "in", recurBizDataIdSet)});
        for (DynamicObject calBizData : calRecurBizDataRel) {
            Long bizDataId = calBizData.getLong("bizdataid");
            Integer useCount = cacheRecurBizDataUseCount.get(bizDataId);
            if (useCount == null) {
                cacheRecurBizDataUseCount.put(bizDataId, 1);
                continue;
            }
            cacheRecurBizDataUseCount.put(bizDataId, useCount + 1);
        }
        for (Long bizDataId : recurBizDataIdSet) {
            Integer useCount = cacheRecurBizDataUseCount.get(bizDataId);
            if (useCount != null) continue;
            cacheRecurBizDataUseCount.put(bizDataId, 0);
        }
    }

    private void dealAttCalBizDataRel(String calTaskIdStr, List<Long> calPersonIdList) throws ParseException {
        Long calTaskId = Long.valueOf(calTaskIdStr);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calattbizdatarel");
        SWCDataServiceHelper bizDataHelper = new SWCDataServiceHelper("hsas_attbizdatasummary");
        this.dealAttCalBizDataRel(calTaskId, calPersonIdList, helper, bizDataHelper, "usagecount");
        helper.setEntityName("hsas_calattnocntrel");
        this.dealAttCalBizDataRel(calTaskId, calPersonIdList, helper, bizDataHelper, "nocounttimes");
        bizDataHelper.setEntityName("hsas_attbizdatadetail");
        helper.setEntityName("hsas_calattbsdetailrel");
        this.dealAttCalBizDataRel(calTaskId, calPersonIdList, helper, bizDataHelper, "usagecount");
        helper.setEntityName("hsas_calattdetnocntrel");
        this.dealAttCalBizDataRel(calTaskId, calPersonIdList, helper, bizDataHelper, "nocounttimes");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealAttCalBizDataRel(Long calTaskId, List<Long> calPersonIdList, SWCDataServiceHelper helper, SWCDataServiceHelper bizDataHelper, String updateField) throws ParseException {
        DynamicObjectCollection attBizDataRelColl;
        String attEndDateStr;
        CalParamCacheInfo calParamCacheInfo = this.calParam.getCalParamMap();
        Map calTaskMap = calParamCacheInfo.getCalTaskMap();
        String attStartDateStr = MapUtils.getString((Map)calTaskMap, (Object)"attstartdate");
        Date attStartDate = null;
        Date attEndDate = null;
        if (!SWCStringUtils.isEmpty((String)attStartDateStr)) {
            attStartDate = SWCDateTimeUtils.parseDate((String)attStartDateStr);
        }
        if (!SWCStringUtils.isEmpty((String)(attEndDateStr = MapUtils.getString((Map)calTaskMap, (Object)"attenddate")))) {
            attEndDate = SWCDateTimeUtils.parseDate((String)attEndDateStr);
        }
        QFilter filter = new QFilter("caltask.id", "=", (Object)calTaskId);
        filter.and("calpersonid", "in", calPersonIdList);
        if (attStartDate != null && attEndDate != null) {
            filter.and("attstartdate", ">=", (Object)attStartDate);
            filter.and("attstartdate", "<=", (Object)attEndDate);
            filter.and("attenddate", ">=", (Object)attStartDate);
            filter.and("attenddate", "<=", (Object)attEndDate);
        }
        if ((attBizDataRelColl = helper.queryOriginalCollection("attbizdataid, caltask.id", new QFilter[]{filter})) == null || attBizDataRelColl.size() == 0) {
            return;
        }
        Set attBizDataIdSet = attBizDataRelColl.stream().map(attBizData -> attBizData.getLong("attbizdataid")).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(attBizDataIdSet)) {
            return;
        }
        QFilter attBizDataFilter = new QFilter("id", "in", attBizDataIdSet);
        DynamicObject[] attBizDataColl = bizDataHelper.query("id, usagecount, nocounttimes, modifytime", new QFilter[]{attBizDataFilter});
        if (SWCObjectUtils.isEmpty((Object)attBizDataColl)) {
            return;
        }
        Date date = new Date();
        for (DynamicObject obj : attBizDataColl) {
            int updateFieldValue = obj.getInt(updateField);
            if (updateFieldValue <= 0) continue;
            obj.set(updateField, (Object)(updateFieldValue - 1));
            obj.set("modifytime", (Object)date);
        }
        try (TXHandle txHandle = TX.requiresNew();){
            helper.deleteByFilter(new QFilter[]{filter});
            bizDataHelper.update(attBizDataColl);
        }
    }

    @NotNull
    private Map<Long, Map<String, List<String>>> getBizDataAndCalTaskRelMap(List<Long> allBizDataIdList, boolean isRec) {
        HashMap<Long, Map<String, List<String>>> bizDataRelMap = new HashMap<Long, Map<String, List<String>>>(16);
        List splitBizDataIdList = SWCListUtils.split(allBizDataIdList, (int)1000000);
        for (List bizDataIdList : splitBizDataIdList) {
            this.addBizDataToMap(bizDataIdList, bizDataRelMap, isRec);
        }
        return bizDataRelMap;
    }

    private void dealBsPeriodProrateData(Map<Long, Map<String, List<DynamicObject>>> bsItemDataMap, Map<Long, Map<String, List<String>>> bizDataRelMap, Map<Long, Map<String, Map<String, CalResultItem>>> calResultDataMap, SWCDataServiceHelper bizDataHelper, boolean isRecur, Map<String, DynamicObject> bizItemInfoMap) throws Exception {
        if (bsItemDataMap.size() == 0) {
            logger.info("bsItemDataMap is empty,traceId= {}", (Object)this.traceId);
            return;
        }
        CalParamCacheInfo calParamCacheInfo = this.calParam.getCalParamMap();
        String dateRangeStr = CalUtils.getDataRange(calParamCacheInfo.getStartDate(), calParamCacheInfo.getEndDate());
        String[] dateRange = dateRangeStr.split("@");
        Map bsItemMap = null;
        HashSet<Long> allBsDataIdSet = new HashSet<Long>(16);
        DynamicObjectCollection calBizDataRelList = new DynamicObjectCollection();
        HashMap<String, DynamicObject> calBizDataRelMap = new HashMap<String, DynamicObject>(16);
        DynamicObject bizItemInfo = null;
        for (Map.Entry<Long, Map<String, List<DynamicObject>>> itemEntry : bsItemDataMap.entrySet()) {
            Long calPersonId = itemEntry.getKey();
            bsItemMap = this.itemResultParamMap.getOrDefault(calPersonId, new HashMap(16));
            this.itemResultParamMap.put(calPersonId, bsItemMap);
            Map bizResultDateDataMap = calResultDataMap.getOrDefault(calPersonId, new HashMap(16));
            Map bizResultDataMap = bizResultDateDataMap.getOrDefault(dateRangeStr, new HashMap(16));
            for (Map.Entry<String, List<DynamicObject>> entry : itemEntry.getValue().entrySet()) {
                bizItemInfo = bizItemInfoMap.get(entry.getKey());
                this.setBizItemData(dateRange, bsItemMap, allBsDataIdSet, entry, bizDataRelMap, bizResultDataMap, calPersonId, calBizDataRelMap, false, bizItemInfo);
                this.handleBsItemProrationData(entry, bizDataRelMap, calPersonId, allBsDataIdSet, bizResultDateDataMap, calBizDataRelMap, bizItemInfo);
            }
            bizResultDateDataMap.put(dateRangeStr, bizResultDataMap);
            calResultDataMap.put(calPersonId, bizResultDateDataMap);
        }
        calBizDataRelMap.values().forEach(obj -> calBizDataRelList.add(obj));
        Set<Long> calPersonIdSet = bsItemDataMap.keySet();
        this.updateBizDataUsageCount(allBsDataIdSet, calBizDataRelList, calPersonIdSet, isRecur);
    }

    private void dealAttBsPeriodProrateData(Map<Long, Map<String, List<DynamicObject>>> bsItemDataMap, Map<Long, Map<String, Map<String, CalResultItem>>> calResultDataMap, Map<String, DynamicObject> bizItemInfoMap, Map<Long, Long> calPersonAndSalaryFileMap, List<CalRecordVO> fetchBsDataFailList, Set<Long> failCalPersonSet) throws Exception {
        if (bsItemDataMap.size() == 0) {
            logger.info("bsItemDataMap is empty,traceId= {}", (Object)this.traceId);
            return;
        }
        CalParamCacheInfo calParamCacheInfo = this.calParam.getCalParamMap();
        Map calTaskMap = calParamCacheInfo.getCalTaskMap();
        String attStartDateStr = MapUtils.getString((Map)calTaskMap, (Object)"attstartdate");
        Date attStartDate = SWCDateTimeUtils.parseDate((String)attStartDateStr);
        String attEndDateStr = MapUtils.getString((Map)calTaskMap, (Object)"attenddate");
        Date attEndDate = SWCDateTimeUtils.parseDate((String)attEndDateStr);
        String startDateStr = MapUtils.getString((Map)calTaskMap, (Object)"startdate");
        Date startDate = SWCDateTimeUtils.parseDate((String)startDateStr);
        String endDateStr = MapUtils.getString((Map)calTaskMap, (Object)"enddate");
        Date endDate = SWCDateTimeUtils.parseDate((String)endDateStr);
        String dateRangeStr = CalUtils.getDataRange(startDate, endDate);
        String[] dateRange = dateRangeStr.split("@");
        Map bsItemMap = null;
        HashSet<Long> allBsDataIdSet = new HashSet<Long>(16);
        HashMap<String, DynamicObject> calBizDataRelMap = new HashMap<String, DynamicObject>(16);
        DynamicObject bizItemInfo = null;
        for (Map.Entry<Long, Map<String, List<DynamicObject>>> itemEntry : bsItemDataMap.entrySet()) {
            Long calPersonId = itemEntry.getKey();
            if (failCalPersonSet.contains(calPersonId)) continue;
            bsItemMap = this.itemResultParamMap.getOrDefault(calPersonId, new HashMap(16));
            this.itemResultParamMap.put(calPersonId, bsItemMap);
            Map bizResultDateDataMap = calResultDataMap.getOrDefault(calPersonId, new HashMap(16));
            Map bizResultDataMap = bizResultDateDataMap.getOrDefault(dateRangeStr, new HashMap(16));
            for (Map.Entry<String, List<DynamicObject>> entry : itemEntry.getValue().entrySet()) {
                bizItemInfo = bizItemInfoMap.get(entry.getKey());
                logger.info("start unproration fetchData!");
                this.setAttBizItemData(dateRange, bsItemMap, allBsDataIdSet, entry, bizResultDataMap, calPersonId, calBizDataRelMap, bizItemInfo, calPersonAndSalaryFileMap, fetchBsDataFailList, failCalPersonSet, false, attStartDate, attEndDate);
                logger.info("end unproration fetchData!");
                Map<String, List<String>> itemDateRangeMap = this.bsItemProrateRangeQueryMap.get(calPersonId);
                if (itemDateRangeMap != null && itemDateRangeMap.get(entry.getKey()) != null) {
                    logger.info("start proration fetchData,itemDateRangeMap is :{}", itemDateRangeMap);
                    this.handleAttBsItemProrationData(entry, calPersonId, allBsDataIdSet, bizResultDateDataMap, calBizDataRelMap, bizItemInfo, calPersonAndSalaryFileMap, fetchBsDataFailList, failCalPersonSet);
                }
                logger.info("end proration fetchData!");
            }
            bizResultDateDataMap.put(dateRangeStr, bizResultDataMap);
            calResultDataMap.put(calPersonId, bizResultDateDataMap);
        }
        DynamicObjectCollection calAttBizDataRelSummaryList = new DynamicObjectCollection();
        DynamicObjectCollection calAttBizDataRelDetailList = new DynamicObjectCollection();
        for (DynamicObject obj : calBizDataRelMap.values()) {
            String attItemType = obj.getString("attitemtype");
            long calPersonId = obj.getLong("calpersonid");
            if (failCalPersonSet.contains(calPersonId)) continue;
            if (ATTITEMTYPE_DETAIL.equals(attItemType)) {
                calAttBizDataRelDetailList.add((Object)obj);
                continue;
            }
            calAttBizDataRelSummaryList.add((Object)obj);
        }
        Set<Long> calPersonIdSet = bsItemDataMap.keySet();
        if (calAttBizDataRelSummaryList.size() > 0) {
            this.updateAttBizDataUsageCount(calAttBizDataRelSummaryList, calPersonIdSet, attStartDate, attEndDate, ATTITEMTYPE_SUMMARY);
        }
        if (calAttBizDataRelDetailList.size() > 0) {
            this.updateAttBizDataUsageCount(calAttBizDataRelDetailList, calPersonIdSet, attStartDate, attEndDate, ATTITEMTYPE_DETAIL);
        }
    }

    private void handleBsItemProrationData(Map.Entry<String, List<DynamicObject>> entry, Map<Long, Map<String, List<String>>> bizDataRelMap, Long calPersonId, Set<Long> allBsDataIdSet, Map<String, Map<String, CalResultItem>> bizResultDateDataMap, Map<String, DynamicObject> calBizDataRelMap, DynamicObject bizItemInfo) throws ParseException {
        Map<String, List<String>> itemDateRangeMap = this.bsItemProrateRangeQueryMap.get(calPersonId);
        if (itemDateRangeMap == null || itemDateRangeMap.get(entry.getKey()) == null) {
            return;
        }
        Map itemSectionResultMap = this.itemSectionResultParamMap.getOrDefault(calPersonId, new HashMap(16));
        Map bsItemMap = null;
        List<String> dateRangeList = itemDateRangeMap.get(entry.getKey());
        if (SWCListUtils.isEmpty(dateRangeList)) {
            return;
        }
        String[] dateRangeArray = null;
        for (String dateRange : dateRangeList) {
            Map bizResultDataMap = bizResultDateDataMap.getOrDefault(dateRange, new HashMap(16));
            bsItemMap = itemSectionResultMap.getOrDefault(dateRange, new HashMap(16));
            dateRangeArray = dateRange.split("@");
            this.setBizItemData(dateRangeArray, bsItemMap, allBsDataIdSet, entry, bizDataRelMap, bizResultDataMap, calPersonId, calBizDataRelMap, true, bizItemInfo);
            bizResultDateDataMap.put(dateRange, bizResultDataMap);
            itemSectionResultMap.put(dateRange, bsItemMap);
        }
        this.itemSectionResultParamMap.put(calPersonId, itemSectionResultMap);
    }

    private void handleAttBsItemProrationData(Map.Entry<String, List<DynamicObject>> entry, Long calPersonId, Set<Long> allBsDataIdSet, Map<String, Map<String, CalResultItem>> bizResultDateDataMap, Map<String, DynamicObject> calBizDataRelMap, DynamicObject bizItemInfo, Map<Long, Long> calPersonAndSalaryFileMap, List<CalRecordVO> fetchBsDataFailList, Set<Long> failCalPersonSet) throws ParseException {
        Map<String, List<String>> itemDateRangeMap = this.bsItemProrateRangeQueryMap.get(calPersonId);
        if (itemDateRangeMap == null || itemDateRangeMap.get(entry.getKey()) == null) {
            return;
        }
        Map itemSectionResultMap = this.itemSectionResultParamMap.getOrDefault(calPersonId, new HashMap(16));
        Map bsItemMap = null;
        List<String> dateRangeList = itemDateRangeMap.get(entry.getKey());
        if (SWCListUtils.isEmpty(dateRangeList)) {
            return;
        }
        String[] dateRangeArray = null;
        for (String dateRange : dateRangeList) {
            Map bizResultDataMap = bizResultDateDataMap.getOrDefault(dateRange, new HashMap(16));
            bsItemMap = itemSectionResultMap.getOrDefault(dateRange, new HashMap(16));
            dateRangeArray = dateRange.split("@");
            this.setAttBizItemData(dateRangeArray, bsItemMap, allBsDataIdSet, entry, bizResultDataMap, calPersonId, calBizDataRelMap, bizItemInfo, calPersonAndSalaryFileMap, fetchBsDataFailList, failCalPersonSet, true, null, null);
            bizResultDateDataMap.put(dateRange, bizResultDataMap);
            itemSectionResultMap.put(dateRange, bsItemMap);
        }
        this.itemSectionResultParamMap.put(calPersonId, itemSectionResultMap);
    }

    @NotNull
    private QFilter[] getBizDataQFilter(CalParamCacheInfo calParamMap, Set<Long> salaryFileIdSet, List<Long> bizItemIdList, boolean isRecur) throws ParseException {
        Date startDate = SWCDateTimeUtils.formatDateToDate((Date)calParamMap.getStartDate(), (String)"yyyy-MM-dd");
        Date endDate = SWCDateTimeUtils.formatDateToDate((Date)calParamMap.getEndDate(), (String)"yyyy-MM-dd");
        QFilter qFilter = new QFilter("auditstatus", "=", (Object)"C");
        qFilter.and("bsed", "<=", (Object)endDate);
        if (!isRecur) {
            qFilter.and("bsed", ">=", (Object)startDate);
        }
        QFilter expiryDateFilter = new QFilter("bsled", ">=", (Object)startDate);
        expiryDateFilter.or("bsled", "is null", null);
        qFilter.and(expiryDateFilter);
        QFilter salaryFileFilter = new QFilter("salaryfile.id", "in", salaryFileIdSet);
        salaryFileFilter.and(new QFilter("bizitem.id", "in", bizItemIdList));
        return new QFilter[]{qFilter, salaryFileFilter};
    }

    private QFilter[] getAttBizDataQFilter(String attStartDateStr, String attEndDateStr, Set<Long> personIdSet, List<Long> attBizItemList) throws ParseException {
        Date attStartDate = SWCDateTimeUtils.parseDate((String)attStartDateStr, (String)"yyyy-MM-dd");
        Date attEndDate = SWCDateTimeUtils.parseDate((String)attEndDateStr, (String)"yyyy-MM-dd");
        QFilter qFilter = new QFilter("attbizitem.id", "in", attBizItemList);
        qFilter.and("attstartdate", ">=", (Object)attStartDate);
        qFilter.and("attstartdate", "<=", (Object)attEndDate);
        qFilter.and("attenddate", ">=", (Object)attStartDate);
        qFilter.and("attenddate", "<=", (Object)attEndDate);
        qFilter.and("auditstatus", "=", (Object)"C");
        qFilter.and("person.id", "in", personIdSet);
        return new QFilter[]{qFilter};
    }

    private void setBizItemData(String[] dateRange, Map<String, Object> bsItemMap, Set<Long> bsDataIdSet, Map.Entry<String, List<DynamicObject>> entry, Map<Long, Map<String, List<String>>> bizDataRelMap, Map<String, CalResultItem> bizResultDataMap, Long calPersonId, Map<String, DynamicObject> calBizDataRelMap, boolean isSection, DynamicObject bizItemInfo) throws ParseException {
        CalParamCacheInfo calParamInfo = this.calParam.getCalParamMap();
        Map bsDataMap = calParamInfo.getBsMap();
        Map bsDataTypeMap = (Map)bsDataMap.get("bsDataTypeKey");
        String bsUniqueCode = entry.getKey();
        List<DynamicObject> bizDataList = entry.getValue();
        Map calTaskMap = calParamInfo.getCalTaskMap();
        long calTaskCalfrequencyId = MapUtils.getLong((Map)calTaskMap, (Object)"calfrequencyId");
        int calTaskCoefficient = MapUtils.getInteger((Map)calTaskMap, (Object)"coefficient");
        Date startDate = SWCDateTimeUtils.parseDate((String)dateRange[INDEX_ZERO], (String)"yyyy-MM-dd");
        Date endDate = SWCDateTimeUtils.parseDate((String)dateRange[INDEX_ONE], (String)"yyyy-MM-dd");
        Date bsed = null;
        Date bsled = null;
        String consumeMethod = bizItemInfo.getString("consumemethod");
        Long bizItemId = bizItemInfo.getLong("id");
        Boolean cycle = bizItemInfo.getBoolean("cycle");
        Boolean oneoffConsume = bizItemInfo.getBoolean("oneoffconsume");
        String dataType = bizItemInfo.getString("datatype.storagetype");
        ArrayList<DynamicObject> needDealObjList = new ArrayList<DynamicObject>(10);
        for (DynamicObject bizDataObj : bizDataList) {
            Long bizDataId;
            Map<String, List<String>> calTaskPeriodMap;
            bsed = SWCDateTimeUtils.formatDateToDate((Date)bizDataObj.getDate("bsed"), (String)"yyyy-MM-dd");
            bsled = bizDataObj.getDate("bsled") == null ? null : SWCDateTimeUtils.formatDateToDate((Date)bizDataObj.getDate("bsled"), (String)"yyyy-MM-dd");
            int usagecount = bizDataObj.getInt("usagecount");
            long frequencyId = bizDataObj.getLong("frequency.id");
            BigDecimal bizDataCoefficient = bizDataObj.getBigDecimal("frequency.coefficient");
            if (oneoffConsume.booleanValue() && !this.isOnlyCal && (calTaskPeriodMap = bizDataRelMap.get(bizDataId = Long.valueOf(bizDataObj.getLong("id")))) != null) {
                List<String> calPeriodIds = calTaskPeriodMap.get(BIZDATA_CALPERIOD_IDS_KEY);
                List<String> calTaskIds = calTaskPeriodMap.get(BIZDATA_CALTASK_IDS_KEY);
                if (!SWCObjectUtils.isEmpty(calTaskPeriodMap) && !SWCObjectUtils.isEmpty(calTaskIds) && !calTaskIds.contains(this.calParam.getCalTaskId()) && this.checkBizDataRel(usagecount, cycle, calPeriodIds, calTaskMap)) continue;
            }
            if (bsed.after(endDate)) continue;
            if (cycle.booleanValue()) {
                if (bsled != null && bsled.before(startDate)) {
                    logger.info("recur bizitem (bsed <= endDate and bsled >= startDate) is false, continue now ");
                    continue;
                }
            } else if (!(isSection && this.isNewOrEarst(consumeMethod) || !bsed.before(startDate))) {
                logger.info("nonrecur bizitem (startDate <= bsed <= endDate ) is false, continue now ");
                continue;
            }
            String dateTypeStr = (String)bsDataTypeMap.get(bizDataObj.getString("bizitem.uniquecode"));
            DataTypeEnum dataTypeEnum = DataTypeEnum.getDataType((String)dateTypeStr);
            if (frequencyId != 0L && frequencyId != calTaskCalfrequencyId && DataTypeEnum.DATE != dataTypeEnum && DataTypeEnum.STRING != dataTypeEnum && !isSection) {
                BigDecimal value = bizDataObj.getString("datavalue") == null ? BigDecimal.ZERO : new BigDecimal(bizDataObj.getString("datavalue"));
                bizDataObj.set("datavalue", (Object)value.multiply(bizDataCoefficient).divide(new BigDecimal(calTaskCoefficient), CalUtils.getSystemDefaultScal(), 4));
            }
            needDealObjList.add(bizDataObj);
            bsDataIdSet.add(bizDataObj.getLong("id"));
            Date payRollDate = calParamInfo.getPayrolldate();
            this.getCalBizDataRelData(calBizDataRelMap, calPersonId, bizDataObj, calTaskMap, cycle, bizItemId, payRollDate);
        }
        if (needDealObjList.size() > 0) {
            CalResultItem param = this.getFormulaItemParamVO(CalResultItemEnum.BIZITEM, bizItemId, ATTITEMTYPE_DETAIL, dataType, startDate, endDate);
            param.setItemType("hsbs_bizitem");
            param.setCalPersonId(calPersonId);
            bizResultDataMap.put(bsUniqueCode, param);
            this.addConsumeItemData(calTaskMap, bsDataTypeMap, bsItemMap, needDealObjList, param, bsDataMap, bizItemInfo, calBizDataRelMap);
        }
    }

    private void setAttBizItemData(String[] dateRange, Map<String, Object> bsItemMap, Set<Long> bsDataIdSet, Map.Entry<String, List<DynamicObject>> entry, Map<String, CalResultItem> bizResultDataMap, Long calPersonId, Map<String, DynamicObject> calBizDataRelMap, DynamicObject bizItemInfo, Map<Long, Long> calPersonAndSalaryFileMap, List<CalRecordVO> fetchBsDataFailList, Set<Long> failCalPersonSet, boolean handleProration, Date attStartDate, Date attEndDate) throws ParseException {
        CalParamCacheInfo calParamInfo = this.calParam.getCalParamMap();
        Map bsDataMap = calParamInfo.getBsMap();
        Map bsDataTypeMap = (Map)bsDataMap.get("bsDataTypeKey");
        String bsUniqueCode = entry.getKey();
        List<DynamicObject> bizDataList = entry.getValue();
        Map calTaskMap = calParamInfo.getCalTaskMap();
        Date startDate = SWCDateTimeUtils.parseDate((String)dateRange[INDEX_ZERO], (String)"yyyy-MM-dd");
        Date endDate = SWCDateTimeUtils.parseDate((String)dateRange[INDEX_ONE], (String)"yyyy-MM-dd");
        Long bizItemId = bizItemInfo.getLong("id");
        String dataType = bizItemInfo.getString("datatype.storagetype");
        ArrayList<DynamicObject> needDealObjList = new ArrayList<DynamicObject>(10);
        Date attBizDataStartDate = null;
        Date attBizDataEndDate = null;
        for (DynamicObject bizDataObj : bizDataList) {
            attBizDataStartDate = SWCDateTimeUtils.formatDateToDate((Date)bizDataObj.getDate("attstartdate"), (String)"yyyy-MM-dd");
            attBizDataEndDate = SWCDateTimeUtils.formatDateToDate((Date)bizDataObj.getDate("attenddate"), (String)"yyyy-MM-dd");
            if (handleProration && (startDate.after(attBizDataStartDate) || attBizDataEndDate.after(endDate))) continue;
            bsDataIdSet.add(bizDataObj.getLong("id"));
            needDealObjList.add(bizDataObj);
            this.generateCalAttBizDataRelData(calBizDataRelMap, calPersonId, bizDataObj, calTaskMap, bizItemInfo, calPersonAndSalaryFileMap);
        }
        if (needDealObjList.size() > 0) {
            Date itemStartDate = handleProration ? startDate : attStartDate;
            Date itemEndDate = handleProration ? endDate : attEndDate;
            CalResultItem param = this.getFormulaItemParamVO(CalResultItemEnum.BIZITEM, bizItemId, ATTITEMTYPE_DETAIL, dataType, itemStartDate, itemEndDate);
            param.setItemType("hsbs_attbizitem");
            param.setCalPersonId(calPersonId);
            bizResultDataMap.put(bsUniqueCode, param);
            this.addConsumeAttItemData(calTaskMap, bsDataTypeMap, bsItemMap, needDealObjList, param, bizItemInfo, calPersonId, fetchBsDataFailList, failCalPersonSet, calBizDataRelMap);
        }
    }

    private boolean isNewOrEarst(String consumeMethod) {
        return BizConsumeMethodEnum.NEWEST.getCode().equals(consumeMethod) || BizConsumeMethodEnum.EARLIEST.getCode().equals(consumeMethod);
    }

    private CalResultItem getFormulaItemParamVO(CalResultItemEnum itemEnum, Long itemId, String prorateType, String dataShowType, Date startDate, Date endDate) {
        CalResultItem param = new CalResultItem(itemEnum);
        param.setItemId(itemId);
        param.setProrateType(prorateType);
        param.setDataShowType(dataShowType);
        param.setStartDate(startDate);
        param.setEndDate(endDate);
        param.setOriAmountValue(BigDecimal.ZERO);
        param.setOriCurrencyId(Long.valueOf(0L));
        param.setExRateType(Boolean.FALSE);
        param.setExRateValue(BigDecimal.ZERO);
        return param;
    }

    private void addConsumeItemData(Map<String, Object> calTaskMap, Map<String, String> bsDataTypeMap, Map<String, Object> bsItemMap, List<DynamicObject> needDealObjList, CalResultItem param, Map<String, Object> bsDataMap, DynamicObject bizItemInfo, Map<String, DynamicObject> calBizDataRelMap) throws ParseException {
        Object value = null;
        String bsUniqueCode = bizItemInfo.getString("uniquecode");
        String consumeMethod = bizItemInfo.getString("consumemethod");
        Boolean cycle = bizItemInfo.getBoolean("cycle");
        if (BizConsumeMethodEnum.AVE.getCode().equals(consumeMethod)) {
            value = this.getBsDataAveOrSumValue(needDealObjList, bsDataTypeMap, BizConsumeMethodEnum.AVE.getCode(), calTaskMap, param, calBizDataRelMap);
        } else if (BizConsumeMethodEnum.SUM.getCode().equals(consumeMethod)) {
            value = this.getBsDataAveOrSumValue(needDealObjList, bsDataTypeMap, BizConsumeMethodEnum.SUM.getCode(), calTaskMap, param, calBizDataRelMap);
        } else if (BizConsumeMethodEnum.EARLIEST.getCode().equals(consumeMethod)) {
            value = this.getEarliestValue(bsDataTypeMap, needDealObjList, calTaskMap, param, calBizDataRelMap);
        } else if (BizConsumeMethodEnum.NEWEST.getCode().equals(consumeMethod)) {
            DynamicObject data = this.getNewestValue(needDealObjList);
            if (data == null) {
                return;
            }
            String dateKey = param.getCalPersonId() + "@" + data.getLong("id") + param.getItemId();
            DynamicObject relObj = calBizDataRelMap.get(dateKey);
            if (relObj != null) {
                relObj.set("actualcomsume", (Object)ATTITEMTYPE_SUMMARY);
            }
            value = data.getString("datavalue");
            String dateTypeStr = bsDataTypeMap.get(bsUniqueCode);
            DataTypeEnum dataType = DataTypeEnum.getDataType((String)dateTypeStr);
            if (AMOUNT.equalsIgnoreCase(dateTypeStr)) {
                this.setFormulaItemAmount(data, calTaskMap, new BigDecimal((String)value), param);
                value = this.getExrateData(calTaskMap, data);
            }
            if (DataTypeEnum.DATE == dataType) {
                value = SWCDateTimeUtils.parseDate((String)((String)value), (String)"yyyy-MM-dd");
            }
            if (cycle.booleanValue()) {
                this.addBsItemPropValue(data, bsDataMap, bsUniqueCode, bsItemMap);
            }
        } else if (BizConsumeMethodEnum.MAX.getCode().equals(consumeMethod)) {
            value = this.getMaxValue(needDealObjList, bsDataTypeMap, calTaskMap, param, calBizDataRelMap);
        } else if (BizConsumeMethodEnum.MIN.getCode().equals(consumeMethod)) {
            value = this.getMinValue(needDealObjList, bsDataTypeMap, calTaskMap, param, calBizDataRelMap);
        } else {
            needDealObjList.forEach(obj -> bsItemMap.put(bsUniqueCode, obj.getString("datavalue")));
            return;
        }
        bsItemMap.put(bsUniqueCode, value);
    }

    private void addConsumeAttItemData(Map<String, Object> calTaskMap, Map<String, String> bsDataTypeMap, Map<String, Object> bsItemMap, List<DynamicObject> needDealObjList, CalResultItem param, DynamicObject bizItemInfo, Long calPersonId, List<CalRecordVO> fetchBsDataFailList, Set<Long> failCalPersonSet, Map<String, DynamicObject> calBizDataRelMap) throws ParseException {
        Object value = null;
        String bsUniqueCode = bizItemInfo.getString("uniquecode");
        String consumeMethod = bizItemInfo.getString("consumemethod");
        if (BizConsumeMethodEnum.AVE.getCode().equals(consumeMethod)) {
            value = this.getAttBsDataAveOrSumValue(needDealObjList, bsDataTypeMap, BizConsumeMethodEnum.AVE.getCode(), calTaskMap, param, calBizDataRelMap);
        } else if (BizConsumeMethodEnum.SUM.getCode().equals(consumeMethod)) {
            value = this.getAttBsDataAveOrSumValue(needDealObjList, bsDataTypeMap, BizConsumeMethodEnum.SUM.getCode(), calTaskMap, param, calBizDataRelMap);
        } else if (BizConsumeMethodEnum.EARLIEST.getCode().equals(consumeMethod)) {
            Map<String, Object> attEarliestValue = this.getAttEarliestValue(needDealObjList);
            boolean isSuccess = (Boolean)attEarliestValue.get("isFetchDataSuccess");
            if (!isSuccess) {
                if (failCalPersonSet.contains(calPersonId)) {
                    return;
                }
                String msg = ResManager.loadKDString((String)"\u8003\u52e4\u4e1a\u52a1\u9879\u76ee\u201c{0}\u201d\u7684\u8ba1\u7b97\u53d6\u503c\u65b9\u5f0f\u4e3a\u201c\u6700\u65e9\u201d\uff0c\u4f46\u7531\u4e8e\u5b58\u5728\u591a\u6761\u76f8\u540c\u8003\u52e4\u5f00\u59cb\u65e5\u671f\u7684\u6570\u636e\uff0c\u53d6\u6570\u5931\u8d25\u3002", (String)"FetchBizItemDataService_1", (String)"swc-hscs-business", (Object[])new Object[]{bizItemInfo.getString("name")});
                String errorElement = CalReportUtils.getErrorElement(FailureTypeEnum.FETCHDATA_FAIL.getCode(), null);
                CalRecordVO calRecord = CalUtils.getCalRecordObj(calPersonId, msg, FailureTypeEnum.FETCHDATA_FAIL.getCode(), errorElement);
                fetchBsDataFailList.add(calRecord);
                failCalPersonSet.add(calPersonId);
                return;
            }
            Object earliestItem = attEarliestValue.get("earliestItem");
            if (earliestItem == null) {
                return;
            }
            DynamicObject data = (DynamicObject)earliestItem;
            String dateKey = param.getCalPersonId() + "@" + data.getLong("id") + param.getItemId();
            DynamicObject relObj = calBizDataRelMap.get(dateKey);
            if (relObj != null) {
                relObj.set("actualcomsume", (Object)ATTITEMTYPE_SUMMARY);
            }
            value = data.getString("textvalue");
            String dateTypeStr = bsDataTypeMap.get(bsUniqueCode);
            DataTypeEnum dataType = DataTypeEnum.getDataType((String)dateTypeStr);
            if (AMOUNT.equalsIgnoreCase(dateTypeStr)) {
                this.setFormulaItemAmount(data, calTaskMap, new BigDecimal((String)value), param);
                value = this.getAttExrateData(calTaskMap, data);
            }
            if (DataTypeEnum.DATE == dataType) {
                value = SWCDateTimeUtils.parseDate((String)((String)value), (String)"yyyy-MM-dd");
            }
        } else if (BizConsumeMethodEnum.NEWEST.getCode().equals(consumeMethod)) {
            Map<String, Object> attNewestValue = this.getAttNewestValue(needDealObjList);
            boolean isSuccess = (Boolean)attNewestValue.get("isSuccess");
            if (!isSuccess) {
                if (failCalPersonSet.contains(calPersonId)) {
                    return;
                }
                String msg = ResManager.loadKDString((String)"\u8003\u52e4\u4e1a\u52a1\u9879\u76ee\u201c{0}\u201d\u7684\u8ba1\u7b97\u53d6\u503c\u65b9\u5f0f\u4e3a\u201c\u6700\u65b0\u201d\uff0c\u4f46\u7531\u4e8e\u5b58\u5728\u591a\u6761\u76f8\u540c\u8003\u52e4\u7ed3\u675f\u65e5\u671f\u7684\u6570\u636e\uff0c\u53d6\u6570\u5931\u8d25\u3002", (String)"FetchBizItemDataService_0", (String)"swc-hscs-business", (Object[])new Object[]{bizItemInfo.getString("name")});
                String errorElement = CalReportUtils.getErrorElement(FailureTypeEnum.FETCHDATA_FAIL.getCode(), null);
                CalRecordVO calRecord = CalUtils.getCalRecordObj(calPersonId, msg, FailureTypeEnum.FETCHDATA_FAIL.getCode(), errorElement);
                fetchBsDataFailList.add(calRecord);
                failCalPersonSet.add(calPersonId);
                return;
            }
            Object newestItem = attNewestValue.get("newestItem");
            if (newestItem == null) {
                return;
            }
            DynamicObject data = (DynamicObject)newestItem;
            String dateKey = param.getCalPersonId() + "@" + data.getLong("id") + param.getItemId();
            DynamicObject relObj = calBizDataRelMap.get(dateKey);
            if (relObj != null) {
                relObj.set("actualcomsume", (Object)ATTITEMTYPE_SUMMARY);
            }
            value = data.getString("textvalue");
            String dateTypeStr = bsDataTypeMap.get(bsUniqueCode);
            DataTypeEnum dataType = DataTypeEnum.getDataType((String)dateTypeStr);
            if (AMOUNT.equalsIgnoreCase(dateTypeStr)) {
                this.setFormulaItemAmount(data, calTaskMap, new BigDecimal((String)value), param);
                value = this.getAttExrateData(calTaskMap, data);
            }
            if (DataTypeEnum.DATE == dataType) {
                value = SWCDateTimeUtils.parseDate((String)((String)value), (String)"yyyy-MM-dd");
            }
        } else if (BizConsumeMethodEnum.MAX.getCode().equals(consumeMethod)) {
            value = this.getAttMaxValue(needDealObjList, bsDataTypeMap, calTaskMap, param, calBizDataRelMap);
        } else if (BizConsumeMethodEnum.MIN.getCode().equals(consumeMethod)) {
            value = this.getAttMinValue(needDealObjList, bsDataTypeMap, calTaskMap, param, calBizDataRelMap);
        } else {
            needDealObjList.forEach(obj -> bsItemMap.put(bsUniqueCode, obj.getString("textvalue")));
            return;
        }
        bsItemMap.put(bsUniqueCode, value);
    }

    private void addBsItemPropValue(DynamicObject data, Map<String, Object> bsDataMap, String bsUniqueCode, Map<String, Object> bsItemMap) throws ParseException {
        Map bsItemPropRelMap = (Map)bsDataMap.get("bsItemPropRelMap");
        DynamicObjectCollection entryList = data.getDynamicObjectCollection("recurbizpropentry");
        if (bsItemPropRelMap == null || bsItemPropRelMap.size() == 0 || entryList == null || entryList.size() == 0) {
            return;
        }
        List propList = (List)bsItemPropRelMap.get(bsUniqueCode);
        if (SWCListUtils.isEmpty((List)propList)) {
            return;
        }
        Map bsItemPropDataTypeMap = (Map)bsDataMap.get("bsItemPropDataTypeMap");
        Map<String, String> propValueMap = entryList.stream().collect(Collectors.toMap(obj -> obj.getString("bizitemprop.propuniquecode"), obj -> obj.getString("propdatavalue"), (k1, k2) -> k1));
        Object value = null;
        for (String propCode : propList) {
            String propValue = propValueMap.get(propCode);
            if (SWCStringUtils.isEmpty((String)propValue)) continue;
            long dataTypeId = Long.parseLong((String)bsItemPropDataTypeMap.get(propCode));
            value = DataTypeEnum.NUMBERIC.getDbId() == dataTypeId ? new BigDecimal(propValue) : (DataTypeEnum.DATE.getDbId() == dataTypeId ? SWCDateTimeUtils.parseDate((String)propValue, (String)"yyyy-MM-dd") : propValue);
            bsItemMap.put(bsUniqueCode + "_@_" + propCode, value);
        }
    }

    private Object getMinValue(List<DynamicObject> needDealObjList, Map<String, String> bsDataTypeMap, Map<String, Object> calTaskMap, CalResultItem param, Map<String, DynamicObject> calBizDataRelMap) throws ParseException {
        String dateKey;
        DynamicObject relObj;
        BigDecimal minValue = null;
        DynamicObject minItem = null;
        String dateTypeStr = "";
        for (DynamicObject item : needDealObjList) {
            dateTypeStr = bsDataTypeMap.get(item.getString("bizitem.uniquecode"));
            DataTypeEnum dataType = DataTypeEnum.getDataType((String)dateTypeStr);
            if (DataTypeEnum.DATE == dataType || DataTypeEnum.STRING == dataType) {
                return null;
            }
            Object value = item.getString("datavalue");
            if (AMOUNT.equalsIgnoreCase(dateTypeStr)) {
                BigDecimal itemValue = this.getExrateData(calTaskMap, item);
                value = itemValue;
            }
            if (SWCObjectUtils.isEmpty((Object)value)) continue;
            BigDecimal tmpValue = new BigDecimal(value.toString());
            if (minValue == null) {
                minValue = tmpValue;
                minItem = item;
                continue;
            }
            if (minValue.compareTo(tmpValue) <= 0) continue;
            minValue = tmpValue;
            minItem = item;
        }
        assert (minItem != null);
        if (AMOUNT.equalsIgnoreCase(dateTypeStr)) {
            BigDecimal itemValue;
            this.setFormulaItemAmount(minItem, calTaskMap, param);
            minValue = itemValue = this.getExrateData(calTaskMap, minItem);
        }
        if ((relObj = calBizDataRelMap.get(dateKey = param.getCalPersonId() + "@" + minItem.getLong("id") + param.getItemId())) != null) {
            relObj.set("actualcomsume", (Object)ATTITEMTYPE_SUMMARY);
        }
        return minValue;
    }

    private Object getAttMinValue(List<DynamicObject> needDealObjList, Map<String, String> bsDataTypeMap, Map<String, Object> calTaskMap, CalResultItem param, Map<String, DynamicObject> calBizDataRelMap) throws ParseException {
        String dateKey;
        DynamicObject relObj;
        BigDecimal minValue = null;
        DynamicObject minItem = null;
        String dateTypeStr = "";
        for (DynamicObject item : needDealObjList) {
            dateTypeStr = bsDataTypeMap.get(item.getString("attbizitem.uniquecode"));
            DataTypeEnum dataType = DataTypeEnum.getDataType((String)dateTypeStr);
            if (DataTypeEnum.DATE == dataType || DataTypeEnum.STRING == dataType) {
                return null;
            }
            Object value = item.getString("textvalue");
            if (AMOUNT.equalsIgnoreCase(dateTypeStr)) {
                BigDecimal itemValue = this.getAttExrateData(calTaskMap, item);
                value = itemValue;
            }
            if (SWCObjectUtils.isEmpty((Object)value)) continue;
            BigDecimal tmpValue = new BigDecimal(value.toString());
            if (minValue == null) {
                minValue = tmpValue;
                minItem = item;
                continue;
            }
            if (minValue.compareTo(tmpValue) <= 0) continue;
            minValue = tmpValue;
            minItem = item;
        }
        assert (minItem != null);
        if (AMOUNT.equalsIgnoreCase(dateTypeStr)) {
            BigDecimal itemValue;
            this.setAttFormulaItemAmount(minItem, calTaskMap, param);
            minValue = itemValue = this.getAttExrateData(calTaskMap, minItem);
        }
        if ((relObj = calBizDataRelMap.get(dateKey = param.getCalPersonId() + "@" + minItem.getLong("id") + param.getItemId())) != null) {
            relObj.set("actualcomsume", (Object)ATTITEMTYPE_SUMMARY);
        }
        return minValue;
    }

    private Object getMaxValue(List<DynamicObject> needDealObjList, Map<String, String> bsDataTypeMap, Map<String, Object> calTaskMap, CalResultItem param, Map<String, DynamicObject> calBizDataRelMap) throws ParseException {
        String dateKey;
        DynamicObject relObj;
        BigDecimal maxValue = null;
        DynamicObject maxItem = null;
        String dateTypeStr = "";
        for (DynamicObject item : needDealObjList) {
            DataTypeEnum dataType = DataTypeEnum.getDataType((String)bsDataTypeMap.get(item.getString("bizitem.uniquecode")));
            if (DataTypeEnum.DATE == dataType || DataTypeEnum.STRING == dataType) {
                return null;
            }
            dateTypeStr = bsDataTypeMap.get(item.getString("bizitem.uniquecode"));
            Object value = item.getString("datavalue");
            if (AMOUNT.equalsIgnoreCase(dateTypeStr)) {
                BigDecimal itemValue = this.getExrateData(calTaskMap, item);
                value = itemValue;
            }
            if (SWCObjectUtils.isEmpty((Object)value)) continue;
            BigDecimal tmpValue = new BigDecimal(value.toString());
            if (maxValue == null) {
                maxValue = tmpValue;
                maxItem = item;
                continue;
            }
            if (maxValue.compareTo(tmpValue) >= 0) continue;
            maxValue = tmpValue;
            maxItem = item;
        }
        assert (maxItem != null);
        if (AMOUNT.equalsIgnoreCase(dateTypeStr)) {
            BigDecimal itemValue;
            this.setFormulaItemAmount(maxItem, calTaskMap, param);
            maxValue = itemValue = this.getExrateData(calTaskMap, maxItem);
        }
        if ((relObj = calBizDataRelMap.get(dateKey = param.getCalPersonId() + "@" + maxItem.getLong("id") + param.getItemId())) != null) {
            relObj.set("actualcomsume", (Object)ATTITEMTYPE_SUMMARY);
        }
        return maxValue;
    }

    private Object getAttMaxValue(List<DynamicObject> needDealObjList, Map<String, String> bsDataTypeMap, Map<String, Object> calTaskMap, CalResultItem param, Map<String, DynamicObject> calBizDataRelMap) throws ParseException {
        String dateKey;
        DynamicObject relObj;
        BigDecimal maxValue = null;
        DynamicObject maxItem = null;
        String dateTypeStr = "";
        for (DynamicObject item : needDealObjList) {
            DataTypeEnum dataType = DataTypeEnum.getDataType((String)bsDataTypeMap.get(item.getString("attbizitem.uniquecode")));
            if (DataTypeEnum.DATE == dataType || DataTypeEnum.STRING == dataType) {
                return null;
            }
            dateTypeStr = bsDataTypeMap.get(item.getString("attbizitem.uniquecode"));
            Object value = item.getString("textvalue");
            if (AMOUNT.equalsIgnoreCase(dateTypeStr)) {
                BigDecimal itemValue = this.getAttExrateData(calTaskMap, item);
                value = itemValue;
            }
            if (SWCObjectUtils.isEmpty((Object)value)) continue;
            BigDecimal tmpValue = new BigDecimal(value.toString());
            if (maxValue == null) {
                maxValue = tmpValue;
                maxItem = item;
                continue;
            }
            if (maxValue.compareTo(tmpValue) >= 0) continue;
            maxValue = tmpValue;
            maxItem = item;
        }
        assert (maxItem != null);
        if (AMOUNT.equalsIgnoreCase(dateTypeStr)) {
            BigDecimal itemValue;
            this.setAttFormulaItemAmount(maxItem, calTaskMap, param);
            maxValue = itemValue = this.getAttExrateData(calTaskMap, maxItem);
        }
        if ((relObj = calBizDataRelMap.get(dateKey = param.getCalPersonId() + "@" + maxItem.getLong("id") + param.getItemId())) != null) {
            relObj.set("actualcomsume", (Object)ATTITEMTYPE_SUMMARY);
        }
        return maxValue;
    }

    private DynamicObject getNewestValue(List<DynamicObject> needDealObjList) {
        Long newestTime = null;
        Date newBsedDate = null;
        DynamicObject newestItem = null;
        for (DynamicObject item : needDealObjList) {
            Date bsed = item.getDate("bsed");
            Date createDate = item.getDate("createtime");
            if (newBsedDate == null) {
                newBsedDate = bsed;
                newestTime = createDate.getTime();
                newestItem = item;
                continue;
            }
            if (SWCDateUtils.before((Date)newBsedDate, (Date)bsed)) {
                newBsedDate = bsed;
                newestTime = createDate.getTime();
                newestItem = item;
                continue;
            }
            if (!SWCDateUtils.isEqual((Date)newBsedDate, (Date)bsed) || newestTime >= createDate.getTime()) continue;
            newBsedDate = bsed;
            newestTime = createDate.getTime();
            newestItem = item;
        }
        return newestItem;
    }

    private Map<String, Object> getAttNewestValue(List<DynamicObject> needDealObjList) {
        Date newBsedDate = null;
        DynamicObject tmpItem = null;
        boolean isSuccess = true;
        for (DynamicObject item : needDealObjList) {
            Date attEndDate = item.getDate("attenddate");
            if (newBsedDate == null) {
                newBsedDate = attEndDate;
                tmpItem = item;
                continue;
            }
            if (newBsedDate.compareTo(attEndDate) < 0) {
                newBsedDate = attEndDate;
                tmpItem = item;
                continue;
            }
            if (newBsedDate.compareTo(attEndDate) != 0) continue;
            tmpItem = null;
            isSuccess = false;
            break;
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        resultMap.put("isSuccess", isSuccess);
        resultMap.put("newestItem", tmpItem);
        return resultMap;
    }

    private Object getEarliestValue(Map<String, String> bsDataTypeMap, List<DynamicObject> needDealObjList, Map<String, Object> calTaskMap, CalResultItem param, Map<String, DynamicObject> calBizDataRelMap) throws ParseException {
        Long earliestTime = null;
        DynamicObject earliestItem = null;
        Date earliestBsedDate = null;
        for (DynamicObject item : needDealObjList) {
            Date bsed = item.getDate("bsed");
            Date createDate = item.getDate("createtime");
            if (earliestBsedDate == null) {
                earliestBsedDate = bsed;
                earliestTime = createDate.getTime();
                earliestItem = item;
                continue;
            }
            if (SWCDateUtils.after((Date)earliestBsedDate, (Date)bsed)) {
                earliestBsedDate = bsed;
                earliestTime = createDate.getTime();
                earliestItem = item;
                continue;
            }
            if (!SWCDateUtils.isEqual((Date)earliestBsedDate, (Date)bsed) || earliestTime <= createDate.getTime()) continue;
            earliestBsedDate = bsed;
            earliestTime = createDate.getTime();
            earliestItem = item;
        }
        assert (earliestItem != null);
        String dateKey = param.getCalPersonId() + "@" + earliestItem.getLong("id") + param.getItemId();
        DynamicObject relObj = calBizDataRelMap.get(dateKey);
        if (relObj != null) {
            relObj.set("actualcomsume", (Object)ATTITEMTYPE_SUMMARY);
        }
        Object earliestValue = earliestItem.getString("datavalue");
        String dateTypeStr = bsDataTypeMap.get(earliestItem.getString("bizitem.uniquecode"));
        DataTypeEnum dataType = DataTypeEnum.getDataType((String)dateTypeStr);
        if (AMOUNT.equalsIgnoreCase(dateTypeStr)) {
            this.setFormulaItemAmount(earliestItem, calTaskMap, new BigDecimal((String)earliestValue), param);
            BigDecimal itemValue = this.getExrateData(calTaskMap, earliestItem);
            earliestValue = itemValue;
        }
        if (DataTypeEnum.DATE == dataType) {
            return SWCDateTimeUtils.parseDate((String)earliestValue, (String)"yyyy-MM-dd");
        }
        return earliestValue;
    }

    private Map<String, Object> getAttEarliestValue(List<DynamicObject> needDealObjList) {
        Date earliestBsedDate = null;
        DynamicObject earliestItem = null;
        boolean flag = true;
        for (DynamicObject item : needDealObjList) {
            Date attStartDate = item.getDate("attstartdate");
            if (earliestBsedDate == null) {
                earliestBsedDate = attStartDate;
                earliestItem = item;
                continue;
            }
            if (earliestBsedDate.compareTo(attStartDate) > 0) {
                earliestBsedDate = attStartDate;
                earliestItem = item;
                continue;
            }
            if (earliestBsedDate.compareTo(attStartDate) != 0) continue;
            earliestItem = null;
            flag = false;
            break;
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        resultMap.put("isFetchDataSuccess", flag);
        resultMap.put("earliestItem", earliestItem);
        return resultMap;
    }

    private BigDecimal getBsDataAveOrSumValue(List<DynamicObject> needDealObjList, Map<String, String> bsDataTypeMap, String consumeMethod, Map<String, Object> calTaskMap, CalResultItem param, Map<String, DynamicObject> calBizDataRelMap) throws ParseException {
        BigDecimal sumValue = BigDecimal.ZERO;
        BigDecimal orgSumValue = BigDecimal.ZERO;
        String dataKey = null;
        DynamicObject relObj = null;
        for (DynamicObject item : needDealObjList) {
            BigDecimal value;
            String dateTypeStr = bsDataTypeMap.get(item.getString("bizitem.uniquecode"));
            DataTypeEnum dataType = DataTypeEnum.getDataType((String)dateTypeStr);
            if (DataTypeEnum.DATE == dataType || DataTypeEnum.STRING == dataType) {
                return null;
            }
            BigDecimal bigDecimal = value = item.getString("datavalue") == null ? BigDecimal.ZERO : new BigDecimal(item.getString("datavalue"));
            if (AMOUNT.equalsIgnoreCase(dateTypeStr)) {
                BigDecimal itemValue;
                orgSumValue = orgSumValue.add(value);
                this.setFormulaItemAmount(item, calTaskMap, orgSumValue, param);
                value = itemValue = this.getExrateData(calTaskMap, item);
            }
            sumValue = sumValue.add(value);
            dataKey = param.getCalPersonId() + "@" + item.getLong("id") + param.getItemId();
            relObj = calBizDataRelMap.get(dataKey);
            if (relObj == null) continue;
            relObj.set("actualcomsume", (Object)ATTITEMTYPE_SUMMARY);
        }
        if (!BizConsumeMethodEnum.SUM.getCode().equals(consumeMethod)) {
            param.setOriAmountValue(orgSumValue.divide(new BigDecimal(needDealObjList.size()), CalUtils.getSystemDefaultScal(), 4));
        }
        if (BizConsumeMethodEnum.SUM.getCode().equals(consumeMethod)) {
            return sumValue;
        }
        return sumValue.divide(new BigDecimal(needDealObjList.size()), CalUtils.getSystemDefaultScal(), 4);
    }

    private BigDecimal getAttBsDataAveOrSumValue(List<DynamicObject> needDealObjList, Map<String, String> bsDataTypeMap, String consumeMethod, Map<String, Object> calTaskMap, CalResultItem param, Map<String, DynamicObject> calBizDataRelMap) throws ParseException {
        BigDecimal sumValue = BigDecimal.ZERO;
        BigDecimal orgSumValue = BigDecimal.ZERO;
        String dataKey = null;
        DynamicObject relObj = null;
        for (DynamicObject item : needDealObjList) {
            BigDecimal value;
            String dateTypeStr = bsDataTypeMap.get(item.getString("attbizitem.uniquecode"));
            DataTypeEnum dataType = DataTypeEnum.getDataType((String)dateTypeStr);
            if (DataTypeEnum.DATE == dataType || DataTypeEnum.STRING == dataType) {
                return null;
            }
            BigDecimal bigDecimal = value = item.getString("textvalue") == null ? BigDecimal.ZERO : new BigDecimal(item.getString("textvalue"));
            if (AMOUNT.equalsIgnoreCase(dateTypeStr)) {
                BigDecimal itemValue;
                orgSumValue = orgSumValue.add(value);
                this.setFormulaItemAmount(item, calTaskMap, orgSumValue, param);
                value = itemValue = this.getAttExrateData(calTaskMap, item);
            }
            sumValue = sumValue.add(value);
            dataKey = param.getCalPersonId() + "@" + item.getLong("id") + param.getItemId();
            relObj = calBizDataRelMap.get(dataKey);
            if (relObj == null) continue;
            relObj.set("actualcomsume", (Object)ATTITEMTYPE_SUMMARY);
        }
        if (!BizConsumeMethodEnum.SUM.getCode().equals(consumeMethod)) {
            param.setOriAmountValue(orgSumValue.divide(new BigDecimal(needDealObjList.size()), CalUtils.getSystemDefaultScal(), 4));
        }
        if (BizConsumeMethodEnum.SUM.getCode().equals(consumeMethod)) {
            return sumValue;
        }
        return sumValue.divide(new BigDecimal(needDealObjList.size()), CalUtils.getSystemDefaultScal(), 4);
    }

    private void setFormulaItemAmount(DynamicObject item, Map<String, Object> calTaskMap, CalResultItem itemParam) throws ParseException {
        String value = item.getString("datavalue");
        BigDecimal itemValue = new BigDecimal(value);
        this.setFormulaItemAmount(item, calTaskMap, itemValue, itemParam);
    }

    private void setAttFormulaItemAmount(DynamicObject item, Map<String, Object> calTaskMap, CalResultItem itemParam) throws ParseException {
        String value = item.getString("textvalue");
        BigDecimal itemValue = new BigDecimal(value);
        this.setFormulaItemAmount(item, calTaskMap, itemValue, itemParam);
    }

    private void setFormulaItemAmount(DynamicObject item, Map<String, Object> calTaskMap, BigDecimal itemValue, CalResultItem itemParam) throws ParseException {
        Long orgCurrencyId = item.getLong("currency.id");
        Long calCurrencyId = MapUtils.getLong(calTaskMap, (Object)"calCurrencyId");
        String key = calCurrencyId + "@" + orgCurrencyId;
        ExchangeRateInfo info = this.exrateCacheMap.get(key);
        if (null == info) {
            Long exratetableId = MapUtils.getLong(calTaskMap, (Object)"exratetableId");
            Date exratedate = SWCDateTimeUtils.parseDate((String)((String)calTaskMap.get("exratedate")), (String)"yyyy-MM-dd");
            info = ExchangeRateHelper.getExchangeRateInfo((Long)orgCurrencyId, (Long)calCurrencyId, (Long)exratetableId, (Date)exratedate);
            this.exrateCacheMap.put(key, info);
        }
        itemParam.setOriCurrencyId(orgCurrencyId);
        itemParam.setOriAmountValue(itemValue);
        if (null != info) {
            itemParam.setExRateType(info.getQuoteType());
            itemParam.setExRateValue(info.getExchangeRate());
        }
    }

    private BigDecimal getExrateData(Map<String, Object> calTaskMap, DynamicObject item) throws ParseException {
        String value = item.getString("datavalue");
        Long orgCurrencyId = item.getLong("currency.id");
        Long calCurrencyId = MapUtils.getLong(calTaskMap, (Object)"calCurrencyId");
        Long exratetableId = MapUtils.getLong(calTaskMap, (Object)"exratetableId");
        BigDecimal itemValue = new BigDecimal(value);
        if (orgCurrencyId != null && !orgCurrencyId.equals(calCurrencyId)) {
            Date exratedate = SWCDateTimeUtils.parseDate((String)((String)calTaskMap.get("exratedate")), (String)"yyyy-MM-dd");
            String key = calCurrencyId + "@" + orgCurrencyId;
            ExchangeRateInfo info = this.exrateCacheMap.get(key);
            if (null == info) {
                info = ExchangeRateHelper.getExchangeRateInfo((Long)orgCurrencyId, (Long)calCurrencyId, (Long)exratetableId, (Date)exratedate);
                if (null != info) {
                    this.exrateCacheMap.put(key, info);
                } else {
                    logger.error("getExrate null,orgCurrencyId={},calCurrencyId={},bsItemUniqueCode={}", new Object[]{orgCurrencyId, calCurrencyId, item.getString("bizitem.uniquecode")});
                }
            }
            if (null != info) {
                itemValue = info.getQuoteType() != false ? itemValue.divide(info.getExchangeRate(), CalUtils.getSystemDefaultScal(), 4) : itemValue.multiply(info.getExchangeRate());
            }
        }
        return itemValue;
    }

    private BigDecimal getAttExrateData(Map<String, Object> calTaskMap, DynamicObject item) throws ParseException {
        String value = item.getString("textvalue");
        Long orgCurrencyId = item.getLong("currency.id");
        Long calCurrencyId = MapUtils.getLong(calTaskMap, (Object)"calCurrencyId");
        Long exratetableId = MapUtils.getLong(calTaskMap, (Object)"exratetableId");
        BigDecimal itemValue = new BigDecimal(value);
        if (orgCurrencyId != null && !orgCurrencyId.equals(calCurrencyId)) {
            Date exratedate = SWCDateTimeUtils.parseDate((String)((String)calTaskMap.get("exratedate")), (String)"yyyy-MM-dd");
            String key = calCurrencyId + "@" + orgCurrencyId;
            ExchangeRateInfo info = this.exrateCacheMap.get(key);
            if (null == info) {
                info = ExchangeRateHelper.getExchangeRateInfo((Long)orgCurrencyId, (Long)calCurrencyId, (Long)exratetableId, (Date)exratedate);
                if (null != info) {
                    this.exrateCacheMap.put(key, info);
                } else {
                    logger.error("getExrate null,orgCurrencyId={},calCurrencyId={},bsItemUniqueCode={}", new Object[]{orgCurrencyId, calCurrencyId, item.getString("attbizitem.uniquecode")});
                }
            }
            if (null != info) {
                itemValue = info.getQuoteType() != false ? itemValue.divide(info.getExchangeRate(), CalUtils.getSystemDefaultScal(), 4) : itemValue.multiply(info.getExchangeRate());
            }
        }
        return itemValue;
    }

    private void getCalBizDataRelData(Map<String, DynamicObject> calBizDataRelMap, Long calPersonId, DynamicObject bizDataObj, Map<String, Object> calTaskMap, Boolean cycle, Long bizItemId, Date payRollDate) {
        MainEntityType type = null;
        type = !cycle.booleanValue() ? (this.isNoCountBizData ? EntityMetadataCache.getDataEntityType((String)"hsas_noncalbsnocntrel") : EntityMetadataCache.getDataEntityType((String)"hsas_calnonbizdatarel")) : (this.isNoCountBizData ? EntityMetadataCache.getDataEntityType((String)"hsas_calbsnocntrel") : EntityMetadataCache.getDataEntityType((String)"hsas_calbizdatarel"));
        Date currentDate = new Date();
        long userId = RequestContext.get().getCurrUserId();
        Long bizDataId = bizDataObj.getLong("id");
        String key = calPersonId + "@" + bizDataId + bizItemId;
        if (calBizDataRelMap.containsKey(key)) {
            return;
        }
        DynamicObject calBizDataRel = (DynamicObject)type.createInstance();
        Long calTaskId = Long.valueOf(this.calParam.getCalTaskId());
        calBizDataRel.set("bizdataid", (Object)bizDataId);
        calBizDataRel.set("caltask", (Object)calTaskId);
        calBizDataRel.set("calpersonid", (Object)calPersonId);
        calBizDataRel.set("actualcomsume", (Object)"2");
        calBizDataRel.set("creator", (Object)userId);
        calBizDataRel.set("createtime", (Object)currentDate);
        calBizDataRel.set("modifier", (Object)userId);
        calBizDataRel.set("modifytime", (Object)currentDate);
        calBizDataRel.set("bizitem", (Object)bizItemId);
        if (!this.isNoCountBizData) {
            calBizDataRel.set("calperiod", (Object)MapUtils.getString(calTaskMap, (Object)"period"));
            calBizDataRel.set("caltasknumber", (Object)MapUtils.getString(calTaskMap, (Object)"number"));
        }
        if (!cycle.booleanValue()) {
            calBizDataRel.set("payrolldate", (Object)payRollDate);
        } else {
            calBizDataRel.set("isrecur", (Object)ATTITEMTYPE_SUMMARY);
        }
        calBizDataRelMap.put(key, calBizDataRel);
    }

    private void generateCalAttBizDataRelData(Map<String, DynamicObject> calBizDataRelMap, Long calPersonId, DynamicObject bizDataObj, Map<String, Object> calTaskMap, DynamicObject bizItem, Map<Long, Long> calPersonAndSalaryFileMap) {
        MainEntityType type = null;
        String attItemType = bizItem.getString("attitemtype");
        Long bizItemId = bizItem.getLong("id");
        type = ATTITEMTYPE_DETAIL.equals(attItemType) ? (this.isNoCountAtt ? EntityMetadataCache.getDataEntityType((String)"hsas_calattdetnocntrel") : EntityMetadataCache.getDataEntityType((String)"hsas_calattbsdetailrel")) : (this.isNoCountAtt ? EntityMetadataCache.getDataEntityType((String)"hsas_calattnocntrel") : EntityMetadataCache.getDataEntityType((String)"hsas_calattbizdatarel"));
        Date currentDate = new Date();
        long userId = RequestContext.get().getCurrUserId();
        Long bizDataId = bizDataObj.getLong("id");
        String key = calPersonId + "@" + bizDataId + bizItemId;
        if (calBizDataRelMap.containsKey(key)) {
            return;
        }
        DynamicObject calBizDataRel = (DynamicObject)type.createInstance();
        Long calTaskId = Long.valueOf(this.calParam.getCalTaskId());
        calBizDataRel.set("attbizdataid", (Object)bizDataId);
        calBizDataRel.set("caltask", (Object)calTaskId);
        calBizDataRel.set("salaryfile", (Object)calPersonAndSalaryFileMap.get(calPersonId));
        calBizDataRel.set("calpersonid", (Object)calPersonId);
        calBizDataRel.set("calperiod", (Object)MapUtils.getString(calTaskMap, (Object)"period"));
        calBizDataRel.set("attbizitem", (Object)bizItemId);
        calBizDataRel.set("attitemtype", (Object)attItemType);
        calBizDataRel.set("creator", (Object)userId);
        calBizDataRel.set("createtime", (Object)currentDate);
        calBizDataRel.set("modifier", (Object)userId);
        calBizDataRel.set("modifytime", (Object)currentDate);
        calBizDataRel.set("attstartdate", (Object)bizDataObj.getDate("attstartdate"));
        calBizDataRel.set("attenddate", (Object)bizDataObj.getDate("attenddate"));
        calBizDataRel.set("actualcomsume", (Object)"2");
        calBizDataRelMap.put(key, calBizDataRel);
    }

    private DynamicObjectCollection getBizItemInfo(List<Long> bsIdForFileList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_bizitem");
        QFilter qFilter = new QFilter("id", "in", bsIdForFileList);
        return helper.queryOriginalCollection("id, name, cycle,uniquecode,oneoffconsume,consumemethod,datatype.storagetype,datatype.id, classification, attitemtype", new QFilter[]{qFilter});
    }

    private DynamicObjectCollection getBsItemDataList(SWCDataServiceHelper bizDataHelper, QFilter[] qFilters) {
        logger.info("getBsItemDataList begin,traceId= {}", (Object)this.traceId);
        String fields = "id, salaryfile.id, bsed, bsled, datavalue, bizitem, bizitem.id, bizitem.uniquecode, calperiod.id, calperiod.periodtypeid, createtime, currency.id, usagecount, frequency.id, frequency.coefficient ";
        DynamicObjectCollection result = bizDataHelper.queryOriginalCollection(fields, qFilters, "modifytime desc");
        logger.info("getBsItemDataList end,traceId={}", (Object)this.traceId);
        return result;
    }

    private DynamicObjectCollection getAttBsItemDataList(SWCDataServiceHelper bizDataHelper, QFilter[] qFilters) {
        logger.info("getBsItemDataList begin,traceId= {}", (Object)this.traceId);
        String fields = "id, attstartdate, attenddate, textvalue, attbizitem, attbizitem.id, attbizitem.uniquecode, createtime, currency.id, usagecount, person.id";
        DynamicObjectCollection result = bizDataHelper.queryOriginalCollection(fields, qFilters);
        logger.info("getBsItemDataList end,traceId={}", (Object)this.traceId);
        return result;
    }

    private DynamicObjectCollection getRecBsItemData(SWCDataServiceHelper bizDataHelper, QFilter[] qFilters) {
        logger.info("getRecBsItemData begin,traceId={}", (Object)this.traceId);
        String fields = "id, salaryfile.id, bsed, bsled, datavalue, bizitem, bizitem.id, bizitem.uniquecode, calperiod.id, calperiod.periodtypeid, createtime, currency, usagecount, frequency.id, frequency.coefficient,bizitemprop,propdatavalue ";
        DynamicObject[] result = bizDataHelper.query(fields, qFilters, "modifytime desc");
        logger.info("getRecBsItemData end,traceId={}", (Object)this.traceId);
        DynamicObjectCollection list = new DynamicObjectCollection();
        for (DynamicObject obj : result) {
            list.add((Object)obj);
        }
        return list;
    }

    private void addBizDataToMap(List<Long> bizDataIds, Map<Long, Map<String, List<String>>> bizDataRelMap, boolean isRec) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calbizdatarel");
        if (!isRec) {
            helper = new SWCDataServiceHelper("hsas_calnonbizdatarel");
        }
        String selectFields = "id,bizdataid,caltask.id,calperiod.id";
        QFilter filter = new QFilter("bizdataid", "in", bizDataIds);
        DynamicObjectCollection coll = helper.queryOriginalCollection(selectFields, new QFilter[]{filter});
        Map calTaskPeriodMap = null;
        for (DynamicObject obj : coll) {
            Long bizDataId = obj.getLong("bizdataid");
            calTaskPeriodMap = bizDataRelMap.getOrDefault(bizDataId, new HashMap(16));
            List calTaskIds = calTaskPeriodMap.getOrDefault(BIZDATA_CALTASK_IDS_KEY, new ArrayList());
            List calperiodIds = calTaskPeriodMap.getOrDefault(BIZDATA_CALPERIOD_IDS_KEY, new ArrayList());
            calTaskIds.add(obj.getString("caltask.id"));
            calperiodIds.add(obj.getString("calperiod.id"));
            calTaskPeriodMap.put(BIZDATA_CALTASK_IDS_KEY, calTaskIds);
            calTaskPeriodMap.put(BIZDATA_CALPERIOD_IDS_KEY, calperiodIds);
            bizDataRelMap.put(bizDataId, calTaskPeriodMap);
        }
    }

    private void buildBsItemDataMap(DynamicObjectCollection bsItemDataList, Map<Long, Map<String, List<DynamicObject>>> bsItemDataMap, Map<Long, Long> salaryFileMap, List<Long> bizDataIds) {
        Long calPersonId = null;
        Map itemMap = null;
        List bsDataList = null;
        for (DynamicObject item : bsItemDataList) {
            bizDataIds.add(item.getLong("id"));
            calPersonId = salaryFileMap.get(item.getLong("salaryfile.id"));
            if (null == calPersonId) continue;
            itemMap = bsItemDataMap.getOrDefault(calPersonId, new HashMap(16));
            bsDataList = itemMap.getOrDefault(item.getString("bizitem.uniquecode"), new ArrayList());
            bsDataList.add(item);
            itemMap.put(item.getString("bizitem.uniquecode"), bsDataList);
            bsItemDataMap.put(calPersonId, itemMap);
        }
    }

    private void buildAttBsItemDataMap(DynamicObjectCollection bsItemDataList, Map<Long, Map<String, List<DynamicObject>>> attBsItemDataMap, List<Long> bizDataIds, Map<Long, Long> personIdAndCalPersonMap) {
        Long calPersonId = null;
        Map itemMap = null;
        List bsDataList = null;
        for (DynamicObject item : bsItemDataList) {
            Long attBizDataId = item.getLong("id");
            Long personId = item.getLong("person.id");
            bizDataIds.add(attBizDataId);
            calPersonId = personIdAndCalPersonMap.get(personId);
            if (null == calPersonId) continue;
            itemMap = attBsItemDataMap.getOrDefault(calPersonId, new HashMap(16));
            bsDataList = itemMap.getOrDefault(item.getString("attbizitem.uniquecode"), new ArrayList());
            bsDataList.add(item);
            itemMap.put(item.getString("attbizitem.uniquecode"), bsDataList);
            attBsItemDataMap.put(calPersonId, itemMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBizDataUsageCount(Set<Long> bsDataIdSet, DynamicObjectCollection calBizDataRelList, Set<Long> calPersonIdSet, boolean isRecur) {
        QFilter recordFilter;
        DynamicObject[] calBizDataRel;
        logger.info("updateBizDataUsageCount start,calBatchId = {},isRecur = {}", (Object)this.calParam.getCalBatchId(), (Object)isRecur);
        if (this.isOnlyCal || CalUtils.isTerminationCal(Long.valueOf(this.calParam.getRecordId()))) {
            return;
        }
        HashMap<Long, Integer> cacheBizDataUseCount = new HashMap<Long, Integer>(16);
        HashMap<Long, HashSet<Long>> cacheBizDataCalTaskId = new HashMap<Long, HashSet<Long>>(16);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calbizdatarel");
        if (this.isNoCountBizData) {
            helper.setEntityName("hsas_calbsnocntrel");
        }
        if (!isRecur) {
            if (this.isNoCountBizData) {
                helper.setEntityName("hsas_noncalbsnocntrel");
            } else {
                helper.setEntityName("hsas_calnonbizdatarel");
            }
        }
        for (DynamicObject calBizData : calBizDataRel = helper.query("bizdataid,caltask.id", new QFilter[]{new QFilter("bizdataid", "in", bsDataIdSet)})) {
            Long bizDataId = calBizData.getLong("bizdataid");
            Integer useCount = (Integer)cacheBizDataUseCount.get(bizDataId);
            if (useCount == null) {
                cacheBizDataUseCount.put(bizDataId, 1);
            } else {
                cacheBizDataUseCount.put(bizDataId, useCount + 1);
            }
            HashSet<Long> calTaskIdSet = (HashSet<Long>)cacheBizDataCalTaskId.get(bizDataId);
            if (calTaskIdSet == null) {
                calTaskIdSet = new HashSet<Long>(16);
                cacheBizDataCalTaskId.put(bizDataId, calTaskIdSet);
            }
            calTaskIdSet.add(calBizData.getLong("caltask.id"));
        }
        HashSet<Long> needUpdateBizdataIdSet = new HashSet<Long>(cacheBizDataUseCount.size());
        if (calBizDataRelList != null && calBizDataRelList.size() > 0) {
            for (DynamicObject calBizDataRelObj : calBizDataRelList) {
                Integer useCount;
                long relBizDataId = calBizDataRelObj.getLong("bizdataid");
                long relCalTaskId = calBizDataRelObj.getLong("caltask");
                if (relCalTaskId == 0L) continue;
                HashSet<Long> calTaskIdSet = (HashSet<Long>)cacheBizDataCalTaskId.get(relBizDataId);
                if (calTaskIdSet == null) {
                    calTaskIdSet = new HashSet<Long>(16);
                    calTaskIdSet.add(relCalTaskId);
                    cacheBizDataCalTaskId.put(relBizDataId, calTaskIdSet);
                    needUpdateBizdataIdSet.add(relBizDataId);
                    useCount = (Integer)cacheBizDataUseCount.get(relBizDataId);
                    if (useCount == null) {
                        cacheBizDataUseCount.put(relBizDataId, 1);
                        continue;
                    }
                    cacheBizDataUseCount.put(relBizDataId, useCount + 1);
                    continue;
                }
                if (!calTaskIdSet.add(relCalTaskId)) continue;
                cacheBizDataCalTaskId.put(relBizDataId, calTaskIdSet);
                needUpdateBizdataIdSet.add(relBizDataId);
                useCount = (Integer)cacheBizDataUseCount.get(relBizDataId);
                if (useCount == null) {
                    cacheBizDataUseCount.put(relBizDataId, 1);
                    continue;
                }
                cacheBizDataUseCount.put(relBizDataId, useCount + 1);
            }
        }
        QFilter filter = new QFilter("id", "in", bsDataIdSet);
        DynamicObject[] bizDataArr = null;
        SWCDataServiceHelper bizDataHelper = null;
        if (isRecur) {
            bizDataHelper = new SWCDataServiceHelper("hsas_recurbizdata");
            bizDataArr = bizDataHelper.query("id,usagecount,nocounttimes,modifytime", new QFilter[]{filter});
        } else {
            bizDataHelper = new SWCDataServiceHelper("hsas_nonrecurbizdata");
            bizDataArr = bizDataHelper.query("id,usagecount,nocounttimes,modifytime,bizdatarecord", new QFilter[]{filter});
        }
        if ("afterTaxCal".equals(this.calParam.getCalType())) {
            if (isRecur) {
                this.recurBizDataIdSet.addAll(needUpdateBizdataIdSet);
            } else {
                this.nonRecurBizDataIdSet.addAll(needUpdateBizdataIdSet);
            }
        }
        Date date = new Date();
        String updateField = "usagecount";
        if (this.isNoCountBizData) {
            updateField = "nocounttimes";
        }
        HashMap<Long, Map<String, Integer>> bizDataRecordUseCountMap = new HashMap<Long, Map<String, Integer>>(16);
        Map<String, Integer> recordCountMap = null;
        int oldUsageCount = 0;
        int noCountTimes = 0;
        for (DynamicObject dynamicObject : bizDataArr) {
            Integer existUseCount;
            Long bizDataId = dynamicObject.getLong("id");
            oldUsageCount = dynamicObject.getInt("usagecount");
            noCountTimes = dynamicObject.getInt("nocounttimes");
            Integer cacheUseCount = (Integer)cacheBizDataUseCount.get(bizDataId);
            if (cacheUseCount != null && cacheUseCount > 0) {
                dynamicObject.set(updateField, (Object)cacheUseCount);
            } else {
                dynamicObject.set(updateField, (Object)1);
            }
            dynamicObject.set("modifytime", (Object)date);
            if (isRecur) continue;
            long bizDataRecordId = dynamicObject.getLong("bizdatarecord");
            recordCountMap = (HashMap)bizDataRecordUseCountMap.get(bizDataRecordId);
            if (recordCountMap == null) {
                recordCountMap = new HashMap(2);
                bizDataRecordUseCountMap.put(bizDataRecordId, recordCountMap);
            }
            if ((existUseCount = (Integer)recordCountMap.get("usagecount")) == null) {
                existUseCount = 0;
            }
            existUseCount = existUseCount + dynamicObject.getInt("usagecount") - oldUsageCount;
            recordCountMap.put("usagecount", existUseCount);
            Integer existNoCount = (Integer)recordCountMap.get("nocounttimes");
            if (existNoCount == null) {
                existNoCount = 0;
            }
            existNoCount = existNoCount + dynamicObject.getInt("nocounttimes") - noCountTimes;
            recordCountMap.put("nocounttimes", existNoCount);
        }
        SWCDataServiceHelper bizDataRecordHelper = new SWCDataServiceHelper("hsas_bizdatarecord");
        DynamicObject[] bizDataRecordArray = null;
        if (bizDataRecordUseCountMap.size() > 0 && (bizDataRecordArray = bizDataRecordHelper.query("id,usagecount,nocounttimes,modifytime", new QFilter[]{recordFilter = new QFilter("id", "in", bizDataRecordUseCountMap.keySet())})) != null && bizDataRecordArray.length > 0) {
            for (DynamicObject recordObj : bizDataRecordArray) {
                recordCountMap = (Map)bizDataRecordUseCountMap.get(recordObj.getLong("id"));
                if (recordCountMap == null) continue;
                int useCount = recordObj.getInt("usagecount") + (Integer)recordCountMap.get("usagecount");
                int noCount = recordObj.getInt("nocounttimes") + (Integer)recordCountMap.get("nocounttimes");
                recordObj.set("usagecount", (Object)useCount);
                recordObj.set("nocounttimes", (Object)noCount);
                recordObj.set("modifytime", (Object)date);
            }
        }
        logger.info("start update bizdatarel and usagecount!");
        try (TXHandle txHandle = TX.requiresNew();){
            if (bizDataArr.length > 0) {
                bizDataHelper.update(bizDataArr);
            }
            if (bizDataRecordArray != null && bizDataRecordArray.length > 0) {
                bizDataRecordHelper.update(bizDataRecordArray);
            }
            if (calBizDataRelList != null && calBizDataRelList.size() > 0) {
                QFilter qFilter = new QFilter("calpersonid", "in", calPersonIdSet);
                qFilter.and("bizdataid", "in", bsDataIdSet);
                helper.deleteByFilter(new QFilter[]{qFilter});
                helper.save(calBizDataRelList);
            }
            if (CalUtils.isTerminationCal(Long.valueOf(this.calParam.getRecordId()))) {
                txHandle.markRollback();
            }
        }
        logger.info("updateBizDataUsageCount end,calBatchId = {}", (Object)this.calParam.getCalBatchId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAttBizDataUsageCount(DynamicObjectCollection calBizDataRelList, Set<Long> calPersonIdSet, Date attStartDate, Date attEndDate, String attItemType) {
        ArrayList<Map<String, Object>> excuteSQLList;
        List<Long> attBizDataUpdateList;
        List splitList;
        SWCDataServiceHelper helper;
        if (this.isOnlyCal) {
            return;
        }
        if (CalUtils.isTerminationCal(Long.valueOf(this.calParam.getRecordId()))) {
            return;
        }
        if (SWCObjectUtils.isEmpty((Object)calBizDataRelList)) {
            return;
        }
        Set<Long> attBizDataUpdateSet = calBizDataRelList.stream().map(obj -> obj.getLong("attbizdataid")).collect(Collectors.toSet());
        if (SWCObjectUtils.isEmpty(attBizDataUpdateSet)) {
            return;
        }
        if ("afterTaxCal".equals(this.calParam.getCalType())) {
            if (ATTITEMTYPE_DETAIL.equals(attItemType)) {
                this.attBizDataDetailIdSet.addAll(attBizDataUpdateSet);
            } else {
                this.attBizDataSummaryIdSet.addAll(attBizDataUpdateSet);
            }
        }
        if ((helper = this.getHelperAndGenUpList(attStartDate, attEndDate, attItemType, splitList = SWCListUtils.split(attBizDataUpdateList = Arrays.asList(attBizDataUpdateSet.toArray(new Long[0])), (int)1000), excuteSQLList = new ArrayList<Map<String, Object>>(splitList.size()))) == null) {
            return;
        }
        logger.error("start update attbizdatarel and usagecount!");
        try (TXHandle txHandle = TX.requiresNew();){
            if (excuteSQLList.size() > 0) {
                for (Map map : excuteSQLList) {
                    String sql = (String)map.get("sql");
                    List params = (List)map.get("params");
                    ArrayList updateParamList = Lists.newArrayListWithExpectedSize((int)1);
                    updateParamList.add(params.toArray());
                    SWCDbUtil.executeBatch((DBRoute)this.dbRoute, (String)sql, (List)updateParamList);
                }
            }
            if (calBizDataRelList != null && calBizDataRelList.size() > 0) {
                QFilter delFilter = new QFilter("calpersonid", "in", calPersonIdSet);
                delFilter.and("attbizdataid", "in", attBizDataUpdateSet);
                helper.deleteByFilter(new QFilter[]{delFilter});
                helper.save(calBizDataRelList);
            }
            if (CalUtils.isTerminationCal(Long.valueOf(this.calParam.getRecordId()))) {
                txHandle.markRollback();
            }
        }
    }

    private SWCDataServiceHelper getHelperAndGenUpList(Date attStartDate, Date attEndDate, String attItemType, List<List<Long>> splitList, List<Map<String, Object>> excuteSQLList) {
        SWCDataServiceHelper helper = null;
        for (List<Long> attBizDataIdList : splitList) {
            String sql = "";
            if (ATTITEMTYPE_DETAIL.equals(attItemType)) {
                if (this.isNoCountAtt) {
                    helper = new SWCDataServiceHelper("hsas_calattdetnocntrel");
                    sql = "UPDATE T_HSAS_ATTBSDETAIL SET FNOCOUNTTIMES = FNOCOUNTTIMES+1 WHERE FID in " + FetchBizItemDataService.getFidHolder(attBizDataIdList.size()) + " AND FATTSTARTDATE >= ? AND FATTSTARTDATE <= ? AND FATTENDDATE >= ?  AND FATTENDDATE <= ?;";
                } else {
                    helper = new SWCDataServiceHelper("hsas_calattbsdetailrel");
                    sql = "UPDATE T_HSAS_ATTBSDETAIL SET FUSAGECOUNT = FUSAGECOUNT+1 WHERE FID in " + FetchBizItemDataService.getFidHolder(attBizDataIdList.size()) + " AND FATTSTARTDATE >= ? AND FATTSTARTDATE <= ? AND FATTENDDATE >= ?  AND FATTENDDATE <= ?;";
                }
            } else if (this.isNoCountAtt) {
                helper = new SWCDataServiceHelper("hsas_calattnocntrel");
                sql = "UPDATE T_HSAS_ATTBIZDATA SET FNOCOUNTTIMES = FNOCOUNTTIMES+1 WHERE FID in " + FetchBizItemDataService.getFidHolder(attBizDataIdList.size()) + " AND FATTSTARTDATE >= ? AND FATTSTARTDATE <= ? AND FATTENDDATE >= ?  AND FATTENDDATE <= ?;";
            } else {
                helper = new SWCDataServiceHelper("hsas_calattbizdatarel");
                sql = "UPDATE T_HSAS_ATTBIZDATA SET FUSAGECOUNT = FUSAGECOUNT+1 WHERE FID in " + FetchBizItemDataService.getFidHolder(attBizDataIdList.size()) + " AND FATTSTARTDATE >= ? AND FATTSTARTDATE <= ? AND FATTENDDATE >= ?  AND FATTENDDATE <= ?;";
            }
            ArrayList<Comparable<Long>> sqlParam = new ArrayList<Comparable<Long>>(attBizDataIdList.size() + 4);
            for (Long attBizDataId : attBizDataIdList) {
                sqlParam.add(attBizDataId);
            }
            sqlParam.add(attStartDate);
            sqlParam.add(attEndDate);
            sqlParam.add(attStartDate);
            sqlParam.add(attEndDate);
            HashMap<String, Object> updateParamMap = new HashMap<String, Object>(2);
            updateParamMap.put("sql", sql);
            updateParamMap.put("params", sqlParam);
            excuteSQLList.add(updateParamMap);
        }
        return helper;
    }

    private boolean checkBizDataRel(int usagecount, Boolean cycle, List<String> calPeriodIds, Map<String, Object> calTaskMap) {
        if (cycle.booleanValue()) {
            String calTaskPeriodId = MapUtils.getString(calTaskMap, (Object)"period");
            if (SWCObjectUtils.isEmpty(calPeriodIds)) {
                return false;
            }
            if (calPeriodIds.contains(calTaskPeriodId)) {
                return true;
            }
        } else if (usagecount > 0) {
            return true;
        }
        return false;
    }

    public Set<Long> getNonRecurBizDataIdSet() {
        return this.nonRecurBizDataIdSet;
    }

    public Set<Long> getRecurBizDataIdSet() {
        return this.recurBizDataIdSet;
    }

    public Set<Long> getAttBizDataSummaryIdSet() {
        return this.attBizDataSummaryIdSet;
    }

    public Set<Long> getAttBizDataDetailIdSet() {
        return this.attBizDataDetailIdSet;
    }

    public static String getFidHolder(int size) {
        StringJoiner sj = new StringJoiner(",", "(", ")");
        for (int i = 0; i < size; ++i) {
            sj.add("?");
        }
        return sj.toString();
    }
}

