/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cal.fetchdata;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hscs.business.extpoint.IFetchResultCoverDataExtService;
import kd.sdk.swc.hscs.common.events.FetchResultCoverEvent;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.DataTypeEnum;
import kd.swc.hscs.business.cal.fetchdata.FetchResultCoverDataExtService;
import kd.swc.hscs.business.cal.utils.CalUtils;
import kd.swc.hscs.common.vo.CalParamCacheInfo;
import kd.swc.hscs.common.vo.CalParamVO;

public class FetchCalResultCoverDataService {
    private static final Log logger = LogFactory.getLog(FetchCalResultCoverDataService.class);
    private List<Long> calPersonIdList;
    private CalParamVO calParam;
    private Map<Long, Map<String, Map<String, Object>>> slItemSectionResultMap;
    private Map<Long, Map<String, Object>> slItemResultMap;

    public FetchCalResultCoverDataService(List<Long> calPersonIdList, CalParamVO calParam, Map<Long, Map<String, Object>> slItemResultMap, Map<Long, Map<String, Map<String, Object>>> slItemSectionResultMap) {
        this.calPersonIdList = calPersonIdList;
        this.calParam = calParam;
        this.slItemResultMap = slItemResultMap;
        this.slItemSectionResultMap = slItemSectionResultMap;
    }

    public void fetchCalResultCoverData() {
        logger.info("fetchCalResultCoverData begin,calBatchId = {}", (Object)this.calParam.getCalBatchId());
        if (CalUtils.isTerminationCal(Long.valueOf(this.calParam.getRecordId()))) {
            return;
        }
        CalParamCacheInfo calParamCacheInfo = this.calParam.getCalParamMap();
        List<Long> salaryItemIdList = calParamCacheInfo.getCalRuleItemIdList().stream().map(obj -> Long.valueOf(obj)).collect(Collectors.toList());
        this.handleCoverData(salaryItemIdList);
        this.handleProrationCoverData(salaryItemIdList);
        this.invokeFetchCalResultCoverData(salaryItemIdList);
        logger.info("fetchCalResultCoverData end,calBatchId = {}", (Object)this.calParam.getCalBatchId());
    }

    private void invokeFetchCalResultCoverData(List<Long> salaryItemIdList) {
        logger.info("invokeFetchCalResultCoverData start");
        FetchResultCoverEvent event = new FetchResultCoverEvent(Long.parseLong(this.calParam.getCalTaskId()), this.calPersonIdList, salaryItemIdList, this.slItemResultMap, this.slItemSectionResultMap);
        FetchResultCoverDataExtService fetchResultCoverDataExtService = new FetchResultCoverDataExtService();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)fetchResultCoverDataExtService, IFetchResultCoverDataExtService.class, (String)"kd.sdk.swc.hscs.business.extpoint.IFetchResultCoverDataExtService#fetchCalResultCoverData", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.fetchCalResultCoverData(event);
            return null;
        });
        logger.info("invokeFetchCalResultCoverData end");
    }

    private void handleProrationCoverData(List<Long> salaryItemIdList) {
        if (!"1".equals(this.calParam.getCalParamMap().getProrationCal())) {
            return;
        }
        logger.info("handleProrationCoverData begin,calBatchId = {}", (Object)this.calParam.getCalBatchId());
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_proratecoverdata");
        QFilter filter = new QFilter("calperson", "in", this.calPersonIdList);
        filter.and("salaryitem.id", "in", salaryItemIdList);
        String fields = "calperson,salaryitem.uniquecode,salaryitem.datatype.id,covervalue,startdate,enddate";
        DynamicObjectCollection data = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        if (data.size() == 0) {
            return;
        }
        Map itemSectionMap = null;
        Map dataRangeMap = null;
        for (DynamicObject obj : data) {
            itemSectionMap = this.slItemSectionResultMap.getOrDefault(obj.getLong("calperson"), new HashMap(16));
            dataRangeMap = itemSectionMap.getOrDefault(obj.getString("salaryitem.uniquecode"), new HashMap(16));
            String dataRange = CalUtils.getDataRange(obj.getDate("startdate"), obj.getDate("enddate"));
            dataRangeMap.put(dataRange, obj.getBigDecimal("covervalue"));
            itemSectionMap.put(obj.getString("salaryitem.uniquecode"), dataRangeMap);
            this.slItemSectionResultMap.put(obj.getLong("calperson"), itemSectionMap);
        }
        logger.info("handleProrationCoverData end,calBatchId = {}", (Object)this.calParam.getCalBatchId());
    }

    private void handleCoverData(List<Long> salaryItemIdList) {
        logger.info("handleCoverData begin,calBatchId = {}", (Object)this.calParam.getCalBatchId());
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calresultcoverdata");
        QFilter filter = new QFilter("calperson", "in", this.calPersonIdList);
        filter.and("salaryitem.id", "in", salaryItemIdList);
        String fields = "calperson,salaryitem.uniquecode,salaryitem.datatype.id,numvalue,datevalue,textvalue,calamountvalue";
        DynamicObjectCollection coverDataList = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        if (coverDataList.size() == 0) {
            return;
        }
        Map itemResultMap = null;
        for (DynamicObject coverData : coverDataList) {
            itemResultMap = this.slItemResultMap.getOrDefault(coverData.getLong("calperson"), new HashMap(16));
            itemResultMap.put(coverData.getString("salaryitem.uniquecode"), this.getItemValueByDataType(coverData));
            this.slItemResultMap.put(coverData.getLong("calperson"), itemResultMap);
        }
        logger.info("handleCoverData end,calBatchId = {}", (Object)this.calParam.getCalBatchId());
    }

    private Object getItemValueByDataType(DynamicObject obj) {
        long dataType = obj.getLong("salaryitem.datatype.id");
        Object value = DataTypeEnum.NUMBERIC.getDbId() == dataType ? obj.getBigDecimal("numvalue") : (DataTypeEnum.AMOUNT.getDbId() == dataType ? obj.getBigDecimal("calamountvalue") : (DataTypeEnum.STRING.getDbId() == dataType ? obj.getString("textvalue") : (DataTypeEnum.DATE.getDbId() == dataType ? obj.getDate("datevalue") : null)));
        return value;
    }

    public Map<Long, Map<String, Map<String, Object>>> getSlItemSectionResultMap() {
        return this.slItemSectionResultMap;
    }

    public Map<Long, Map<String, Object>> getSlItemResultMap() {
        return this.slItemResultMap;
    }
}

