/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cal.fetchdata;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.exchangerate.ExchangeRateInfo;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.CalResultItemEnum;
import kd.swc.hsbp.common.enums.DataTypeEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hscs.business.cal.fetchdata.FetchBizItemDataService;
import kd.swc.hscs.business.cal.fetchdata.FetchCalResultCoverDataService;
import kd.swc.hscs.business.cal.fetchdata.helper.DataReaderCalHelper;
import kd.swc.hscs.business.cal.helper.SalaryCalServiceHelper;
import kd.swc.hscs.business.cal.insurance.InsuranceHelper;
import kd.swc.hscs.business.cal.service.AccService;
import kd.swc.hscs.business.cal.utils.CalUtils;
import kd.swc.hscs.common.vo.CalParamCacheInfo;
import kd.swc.hscs.common.vo.CalParamVO;
import kd.swc.hscs.common.vo.CalRecordVO;
import kd.swc.hscs.common.vo.CalResultItem;
import kd.swc.hscs.common.vo.acc.AccDetailsVO;
import kd.swc.hscs.common.vo.fetch.CalFetchConfigInfo;
import kd.swc.hscs.common.vo.fetch.CalResultMatchItemInfo;
import kd.swc.hscs.common.vo.fetch.FetchFieldInfo;

public class FormulaFecthData {
    private static final Log logger = LogFactory.getLog(FormulaFecthData.class);
    public static final String AMOUNT = "amount";
    private List<Long> calPersonIdList;
    private CalParamVO calParam;
    private Map<Long, Map<String, List<String>>> ftItemProrateRangeQueryMap;
    private Map<Long, Map<String, List<String>>> bsItemProrateRangeQueryMap;
    private String traceId;
    private Map<String, ExchangeRateInfo> exrateCacheMap;
    private Map<Long, Map<String, Map<String, Object>>> slItemSectionResultMap;
    private Map<Long, Map<String, Object>> slItemResultMap;
    private Map<Long, Map<String, Object>> itemResultParamMap;
    private Map<Long, Map<String, Map<String, Object>>> itemSectionResultParamMap;
    private Map<Long, Map<String, Map<String, CalResultItem>>> calResultDataMap;
    private Map<Long, Long> insuranceCalpersonMap;
    private boolean isOnlyCal;
    private Map<String, Object> fetchConsumeTimeMap;

    public FormulaFecthData(List<Long> calPersonIdList, CalParamVO calParam, Map<Long, Map<String, List<String>>> ftItemProrateRangeQueryMap, Map<Long, Map<String, List<String>>> bsItemProrateRangeQueryMap, boolean isOnlyCal) {
        this.calPersonIdList = calPersonIdList;
        this.calParam = calParam;
        this.traceId = RequestContext.get().getTraceId();
        this.exrateCacheMap = new HashMap<String, ExchangeRateInfo>(16);
        this.bsItemProrateRangeQueryMap = bsItemProrateRangeQueryMap;
        this.ftItemProrateRangeQueryMap = ftItemProrateRangeQueryMap;
        this.slItemSectionResultMap = new HashMap<Long, Map<String, Map<String, Object>>>();
        this.slItemResultMap = new HashMap<Long, Map<String, Object>>();
        this.itemResultParamMap = new HashMap<Long, Map<String, Object>>();
        this.itemSectionResultParamMap = new HashMap<Long, Map<String, Map<String, Object>>>();
        this.calResultDataMap = new HashMap<Long, Map<String, Map<String, CalResultItem>>>();
        this.isOnlyCal = isOnlyCal;
        this.fetchConsumeTimeMap = new HashMap<String, Object>();
    }

    public Map<String, Object> getCalItemData() throws Exception {
        logger.info("getCalItemData begin,calBatchId={},traceId={}", (Object)this.calParam.getCalBatchId(), (Object)this.traceId);
        if (CalUtils.isTerminationCal(Long.valueOf(this.calParam.getRecordId()))) {
            return new HashMap<String, Object>(0);
        }
        CalParamCacheInfo calParamInfo = this.calParam.getCalParamMap();
        List slUniqueCodeList = calParamInfo.getSlUniqueCodeList();
        DynamicObjectCollection calPersonData = this.getCalPersonRelationData(this.calPersonIdList, Long.valueOf(this.calParam.getCalTaskId()));
        Map<Long, Long> salaryFileMap = calPersonData.stream().collect(Collectors.toMap(obj -> obj.getLong("salaryfile.id"), obj -> obj.getLong("id")));
        long stepOneTime = System.currentTimeMillis();
        this.fetchSalaryItemResultValue(slUniqueCodeList, calPersonData);
        long stepTwoTime = System.currentTimeMillis();
        this.addConsumeTime("insuranceItem", stepOneTime, stepTwoTime, null);
        logger.info("fetchCalResultCoverData start");
        FetchCalResultCoverDataService coverDataService = new FetchCalResultCoverDataService(this.calPersonIdList, this.calParam, this.slItemResultMap, this.slItemSectionResultMap);
        coverDataService.fetchCalResultCoverData();
        logger.info("fetchCalResultCoverData end");
        long stepThreeTime = System.currentTimeMillis();
        this.addConsumeTime("resultCover", stepTwoTime, stepThreeTime, null);
        HashMap<Long, Map<String, Object>> allFetchItemDataMap = new HashMap<Long, Map<String, Object>>(16);
        HashMap<String, Object> taskFetchItemDataMap = new HashMap<String, Object>(16);
        this.handleFtItemData(allFetchItemDataMap, taskFetchItemDataMap);
        long stepFourTime = System.currentTimeMillis();
        this.addConsumeTime("ftItem", stepThreeTime, stepFourTime, null);
        AccService accService = new AccService(this.traceId, this.exrateCacheMap, this.isOnlyCal);
        logger.info("instanceAcc start");
        Map<Long, Map<String, AccDetailsVO>> allAccDetailsMap = accService.instanceAcc(calParamInfo, calPersonData, this.itemResultParamMap, Long.valueOf(this.calParam.getCalTaskId()), Long.valueOf(this.calParam.getRecordId()));
        logger.info("instanceAcc end");
        long stepFiveTime = System.currentTimeMillis();
        this.addConsumeTime("acc", stepFourTime, stepFiveTime, null);
        Map<Long, Map<String, Object>> spItemCalResultMap = this.handleSpItemResult(calPersonData);
        FetchBizItemDataService bizItemDataService = new FetchBizItemDataService(this.calPersonIdList, this.calParam, this.bsItemProrateRangeQueryMap, this.exrateCacheMap, this.itemResultParamMap, this.itemSectionResultParamMap, this.isOnlyCal);
        logger.info("handleBsItemData start");
        ArrayList<CalRecordVO> fetchBsDataFailList = new ArrayList<CalRecordVO>(10);
        HashSet<Long> failCalPersonSet = new HashSet<Long>(16);
        bizItemDataService.handleBsItemData(salaryFileMap, this.calResultDataMap, calPersonData, fetchBsDataFailList, failCalPersonSet);
        long stepSixTime = System.currentTimeMillis();
        this.addConsumeTime("bsItem", stepFiveTime, stepSixTime, null);
        ArrayList successCalPersonList = new ArrayList(this.calPersonIdList.size());
        this.calPersonIdList.forEach(obj -> {
            if (!failCalPersonSet.contains(obj)) {
                successCalPersonList.add(obj);
            }
        });
        logger.info("handleBsItemData fetchBsDataFailList is\uff1a{}", fetchBsDataFailList);
        logger.info("handleBsItemData failCalPersonSet is\uff1a{}", failCalPersonSet);
        logger.info("handleBsItemData end");
        HashMap<String, Object> itemData = new HashMap<String, Object>(16);
        itemData.put("slItemResultMap", this.slItemResultMap);
        itemData.put("slItemSectionResultMap", this.slItemSectionResultMap);
        itemData.put("itemResultParamMap", this.itemResultParamMap);
        itemData.put("itemSectionResultParamMap", this.itemSectionResultParamMap);
        itemData.put("allAccDetailsDataMap", allAccDetailsMap);
        itemData.put("fetchItemDataMap", allFetchItemDataMap);
        itemData.put("spItemCalResultMap", spItemCalResultMap);
        itemData.put("calResultDataMap", this.calResultDataMap);
        itemData.put("recurBizDataIdSet", bizItemDataService.getRecurBizDataIdSet());
        itemData.put("nonRecurBizDataIdSet", bizItemDataService.getNonRecurBizDataIdSet());
        itemData.put("attBizDataSummaryIdSet", bizItemDataService.getAttBizDataSummaryIdSet());
        itemData.put("attBizDataDetailIdSet", bizItemDataService.getAttBizDataDetailIdSet());
        itemData.put("fetchAttBizDataFailList", fetchBsDataFailList);
        itemData.put("successCalPersonList", successCalPersonList);
        itemData.put("insurancedataCalpersonMap", this.insuranceCalpersonMap);
        logger.info("getCalItemData end,calBatchId={},traceId= {}", (Object)this.calParam.getCalBatchId(), (Object)this.traceId);
        return itemData;
    }

    private void addConsumeTime(String fetchType, long startTime, long endTime, String fetchConfigNumber) {
        long resultTime = endTime - startTime;
        if ("ftItemConfig".equals(fetchType)) {
            HashMap<String, Long> fetchConfigMap = (HashMap<String, Long>)this.fetchConsumeTimeMap.get(fetchType);
            if (fetchConfigMap == null) {
                fetchConfigMap = new HashMap<String, Long>(16);
                this.fetchConsumeTimeMap.put(fetchType, fetchConfigMap);
            }
            fetchConfigMap.put(fetchConfigNumber, resultTime);
        } else {
            this.fetchConsumeTimeMap.put(fetchType, resultTime);
        }
    }

    private void handleFtItemData(Map<Long, Map<String, Object>> allFetchItemDataMap, Map<String, Object> taskFetchItemDataMap) throws ParseException {
        logger.info("handleFtItemData begin,calBatchId={},traceId={},time={}", new Object[]{this.calParam.getCalBatchId(), this.traceId, System.currentTimeMillis()});
        if (CalUtils.isTerminationCal(Long.valueOf(this.calParam.getRecordId()))) {
            return;
        }
        CalParamCacheInfo calParamInfo = this.calParam.getCalParamMap();
        Map fetchItemDataTypeMap = calParamInfo.getFetchItemDataTypeMap();
        List calFetchConfigList = calParamInfo.getCalFetchConfigList();
        Map fetchItemCodeIdMap = calParamInfo.getFetchItemCodeIdMap();
        List fetchItemCodeList = calParamInfo.getFetchItemCodeList();
        if (fetchItemCodeIdMap == null || fetchItemCodeIdMap.size() == 0) {
            logger.info("fetchItemCodeIdMap is empty");
            return;
        }
        HashSet<String> fetchItemCodeSet = new HashSet<String>(fetchItemCodeList);
        if (SWCListUtils.isEmpty((List)calFetchConfigList)) {
            logger.info("calFetchConfigList is empty");
            return;
        }
        String calTaskDateRange = CalUtils.getDataRange(calParamInfo.getStartDate(), calParamInfo.getEndDate());
        Map<Long, CalFetchConfigInfo> fetchConfigMap = calFetchConfigList.stream().collect(Collectors.toMap(CalFetchConfigInfo::getConfigId, single -> single, (o1, o2) -> o2));
        String calConfigPath = calParamInfo.getCalConfigPath();
        logger.info("calConfigPath:{}", (Object)calConfigPath);
        List<String> fetchConfigIdList = Arrays.asList(calConfigPath.split("#"));
        DataReaderCalHelper dataReaderCalHelper = new DataReaderCalHelper();
        for (int i = 0; i < fetchConfigIdList.size(); ++i) {
            String configId = fetchConfigIdList.get(fetchConfigIdList.size() - 1 - i);
            CalFetchConfigInfo fetchConfigInfo = fetchConfigMap.get(Long.valueOf(configId));
            if (fetchConfigInfo == null) {
                logger.info("fetchConfigInfo is null,id:{}", (Object)configId);
                continue;
            }
            logger.info("ftItemFetchData start, configId:{},fetchConfigNumber:{},type:{}", new Object[]{configId, fetchConfigInfo.getFetchNumber(), fetchConfigInfo.getSelectType()});
            long startTime = System.currentTimeMillis();
            String selectType = fetchConfigInfo.getSelectType();
            if (SWCStringUtils.equals((String)selectType, (String)"0")) {
                dataReaderCalHelper.selectFetchConfigData(fetchItemCodeSet, fetchConfigInfo, this.calPersonIdList, Long.valueOf(this.calParam.getCalTaskId()), allFetchItemDataMap, null, taskFetchItemDataMap, this.itemResultParamMap, this.itemSectionResultParamMap, false, calTaskDateRange, this.ftItemProrateRangeQueryMap);
            }
            if (SWCStringUtils.equals((String)selectType, (String)"1")) {
                Map calTaskMap = calParamInfo.getCalTaskMap();
                dataReaderCalHelper.selectHisResultFetchData(fetchItemCodeSet, taskFetchItemDataMap, Long.valueOf(this.calParam.getCalTaskId()), fetchConfigInfo, calTaskMap, this.exrateCacheMap, allFetchItemDataMap, this.calPersonIdList, this.itemResultParamMap, this.itemSectionResultParamMap);
            }
            if (SWCStringUtils.equals((String)selectType, (String)"2")) {
                dataReaderCalHelper.selectCustFetchConfigData(fetchItemCodeSet, fetchConfigInfo, this.calPersonIdList, Long.valueOf(this.calParam.getCalTaskId()), allFetchItemDataMap, taskFetchItemDataMap, this.itemResultParamMap);
            }
            this.putDataToSectionResultMap(fetchConfigInfo);
            logger.info("ftItemFetchData end, configId:{},fetchConfigNumber:{},type:{}", new Object[]{configId, fetchConfigInfo.getFetchNumber(), fetchConfigInfo.getSelectType()});
            long endTime = System.currentTimeMillis();
            this.addConsumeTime("ftItemConfig", startTime, endTime, fetchConfigInfo.getFetchNumber());
        }
        this.dealFetchItemResult(fetchItemDataTypeMap, fetchItemCodeIdMap);
        logger.info("handleFtItemData end,calBatchId={},traceId={},time={}", new Object[]{this.calParam.getCalBatchId(), this.traceId, System.currentTimeMillis()});
    }

    private void putDataToSectionResultMap(CalFetchConfigInfo fetchConfigInfo) {
        if (fetchConfigInfo.isProration()) {
            return;
        }
        logger.info("putDataToSectionResultMap start,fetchNumber = {}", (Object)fetchConfigInfo.getFetchNumber());
        Map<String, List<String>> ftItemProrationMap = null;
        Map itemSectionResultMap = null;
        Map<String, Object> itemResultMap = null;
        for (Long calPersonId : this.calPersonIdList) {
            ftItemProrationMap = this.ftItemProrateRangeQueryMap.get(calPersonId);
            if (ftItemProrationMap == null || ftItemProrationMap.size() == 0 || (itemResultMap = this.itemResultParamMap.get(calPersonId)) == null || itemResultMap.size() == 0) continue;
            itemSectionResultMap = this.itemSectionResultParamMap.getOrDefault(calPersonId, new HashMap(16));
            if (SWCStringUtils.equals((String)fetchConfigInfo.getSelectType(), (String)"1")) {
                this.addItemSectionResultForHisResult(fetchConfigInfo, ftItemProrationMap, itemSectionResultMap, itemResultMap);
            } else {
                this.addItemSectionResultForFetchConfig(fetchConfigInfo, ftItemProrationMap, itemSectionResultMap, itemResultMap);
            }
            this.itemSectionResultParamMap.put(calPersonId, itemSectionResultMap);
        }
        logger.info("putDataToSectionResultMap end,fetchNumber = {}", (Object)fetchConfigInfo.getFetchNumber());
    }

    private void addItemSectionResultForHisResult(CalFetchConfigInfo fetchConfigInfo, Map<String, List<String>> ftItemProrationMap, Map<String, Map<String, Object>> itemSectionResultMap, Map<String, Object> itemResultMap) {
        List<String> dateRangeList = null;
        for (CalResultMatchItemInfo field : fetchConfigInfo.getResultMatchItemInfo()) {
            Object value;
            String fetchItemCode = field.getMatchFetchItemCode();
            dateRangeList = ftItemProrationMap.get(fetchItemCode);
            if (SWCListUtils.isEmpty(dateRangeList) || (value = itemResultMap.get(fetchItemCode)) == null) continue;
            Map tempItemMap = null;
            for (String dateRange : dateRangeList) {
                tempItemMap = itemSectionResultMap.getOrDefault(dateRange, new HashMap(16));
                tempItemMap.put(fetchItemCode, value);
                itemSectionResultMap.put(dateRange, tempItemMap);
            }
        }
    }

    private void addItemSectionResultForFetchConfig(CalFetchConfigInfo fetchConfigInfo, Map<String, List<String>> ftItemProrationMap, Map<String, Map<String, Object>> itemSectionResultMap, Map<String, Object> itemResultMap) {
        List<String> dateRangeList = null;
        for (FetchFieldInfo field : fetchConfigInfo.getFieldInfoList()) {
            Object value;
            String fetchItemCode = field.getFetchItemCode();
            dateRangeList = ftItemProrationMap.get(fetchItemCode);
            if (SWCListUtils.isEmpty(dateRangeList) || (value = itemResultMap.get(fetchItemCode)) == null) continue;
            Map tempItemMap = null;
            for (String dateRange : dateRangeList) {
                tempItemMap = itemSectionResultMap.getOrDefault(dateRange, new HashMap(16));
                tempItemMap.put(fetchItemCode, value);
                itemSectionResultMap.put(dateRange, tempItemMap);
            }
        }
    }

    private void dealFetchItemResult(Map<String, String> fetchItemDataTypeMap, Map<String, Long> fetchItemCodeIdMap) throws ParseException {
        CalParamCacheInfo calParamCacheInfo = this.calParam.getCalParamMap();
        Date startDate = calParamCacheInfo.getStartDate();
        Date endDate = calParamCacheInfo.getEndDate();
        Map ftItemDateRangeDataMap = null;
        Map ftItemDataMap = null;
        String dateRange = CalUtils.getDataRange(calParamCacheInfo.getStartDate(), calParamCacheInfo.getEndDate());
        for (Map.Entry<Long, Map<String, Object>> entry : this.itemResultParamMap.entrySet()) {
            ftItemDateRangeDataMap = this.calResultDataMap.getOrDefault(entry.getKey(), new HashMap(16));
            ftItemDataMap = ftItemDateRangeDataMap.getOrDefault(dateRange, new HashMap(16));
            for (String string : entry.getValue().keySet()) {
                String fieldType = fetchItemDataTypeMap.get(string);
                CalResultItem param = this.getFormulaItemParamVO(CalResultItemEnum.SYSITEM, fetchItemCodeIdMap.get(string), "0", fieldType, startDate, endDate);
                ftItemDataMap.put(string, param);
            }
            ftItemDateRangeDataMap.put(dateRange, ftItemDataMap);
            this.calResultDataMap.put(entry.getKey(), ftItemDateRangeDataMap);
        }
        for (Map.Entry<Long, Map<String, Object>> entry : this.itemSectionResultParamMap.entrySet()) {
            ftItemDateRangeDataMap = this.calResultDataMap.getOrDefault(entry.getKey(), new HashMap(16));
            for (Map.Entry entry2 : entry.getValue().entrySet()) {
                ftItemDataMap = ftItemDateRangeDataMap.getOrDefault(entry2.getKey(), new HashMap(16));
                String[] dateRangeArr = ((String)entry2.getKey()).split("@");
                startDate = SWCDateTimeUtils.parseDate((String)dateRangeArr[0], (String)"yyyy-MM-dd");
                endDate = SWCDateTimeUtils.parseDate((String)dateRangeArr[1], (String)"yyyy-MM-dd");
                for (Map.Entry itemEntry : ((Map)entry2.getValue()).entrySet()) {
                    String fieldType = fetchItemDataTypeMap.get(itemEntry.getKey());
                    CalResultItem param = this.getFormulaItemParamVO(CalResultItemEnum.SYSITEM, fetchItemCodeIdMap.get(itemEntry.getKey()), "1", fieldType, startDate, endDate);
                    ftItemDataMap.put(itemEntry.getKey(), param);
                }
                ftItemDateRangeDataMap.put(entry2.getKey(), ftItemDataMap);
            }
            this.calResultDataMap.put(entry.getKey(), ftItemDateRangeDataMap);
        }
    }

    private CalResultItem getFormulaItemParamVO(CalResultItemEnum itemEnum, Long itemId, String prorateType, String dataShowType, Date startDate, Date endDate) {
        CalResultItem param = new CalResultItem(itemEnum);
        param.setItemId(itemId);
        param.setProrateType(prorateType);
        param.setDataShowType(dataShowType);
        param.setStartDate(startDate);
        param.setEndDate(endDate);
        param.setOriAmountValue(BigDecimal.ZERO);
        param.setOriCurrencyId(Long.valueOf(0L));
        param.setExRateType(Boolean.FALSE);
        param.setExRateValue(BigDecimal.ZERO);
        return param;
    }

    private DynamicObjectCollection getCalPersonRelationData(List<Long> calPersonIds, Long calTaskId) {
        SWCDataServiceHelper calTableHelper = new SWCDataServiceHelper("hsas_calperson");
        QFilter filter = new QFilter("id", "in", calPersonIds);
        filter.and(new QFilter("caltask", "=", (Object)calTaskId));
        String selectProperties = "id,caltask.id,salaryfile.id,employee.id,salaryfile.employee.id,calresultid,personhrv.id,personhrv.personindexid,personhrv.boid";
        return calTableHelper.queryOriginalCollection(selectProperties, new QFilter[]{filter});
    }

    private void fetchSalaryItemResultValue(List<String> slUniqueCodeList, DynamicObjectCollection calPersonList) {
        logger.info("fetchSalaryItemResultValue begin,calBatchId={},traceId={}", (Object)this.calParam.getCalBatchId(), (Object)this.traceId);
        if (CalUtils.isTerminationCal(Long.valueOf(this.calParam.getRecordId()))) {
            return;
        }
        Long calTaskId = Long.valueOf(this.calParam.getCalTaskId());
        Map insuranceItemMap = this.calParam.getCalParamMap().getInsuranceItemMap();
        if (!"afterTaxCal".equals(this.calParam.getCalType())) {
            Date payrolldate = this.calParam.getCalParamMap().getPayrolldate();
            InsuranceHelper.rollbackInsuranceData(this.calPersonIdList, payrolldate);
            if (insuranceItemMap.size() > 0) {
                Map<Long, HashSet<Long>> fileItemMap;
                Map uniqueCodeMap = this.calParam.getUniqueCodeMap();
                List<Long> salaryFileIdList = calPersonList.stream().map(obj -> obj.getLong("salaryfile.id")).collect(Collectors.toList());
                try {
                    fileItemMap = SalaryCalServiceHelper.getFileSalaryItemMap(this.calParam.getCalParamMap(), salaryFileIdList);
                }
                catch (Throwable ex) {
                    logger.error(ex);
                    throw new KDBizException(ex, new ErrorCode("", ex.getMessage()), new Object[0]);
                }
                this.insuranceCalpersonMap = InsuranceHelper.fetchInsuranceData(calPersonList, insuranceItemMap, this.slItemResultMap, payrolldate, calTaskId, uniqueCodeMap, fileItemMap);
            }
        }
        if (!"afterTaxCal".equals(this.calParam.getCalType())) {
            return;
        }
        List<Long> calResultIdList = calPersonList.stream().map(person -> person.getLong("calresultid")).collect(Collectors.toList());
        this.assemblePreTaxPersonResult(slUniqueCodeList, calResultIdList, calTaskId);
        logger.info("fetchSalaryItemResultValue end,calBatchId={},traceId={}", (Object)this.calParam.getCalBatchId(), (Object)this.traceId);
    }

    private void assemblePreTaxPersonResult(List<String> slUniqueCodeList, List<Long> calResultIdList, Long calTaskId) {
        if (SWCListUtils.isEmpty(slUniqueCodeList)) {
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_caltable");
        QFilter filter = new QFilter("id", "in", calResultIdList);
        filter.and("hsas_caltableentry.salaryitem.uniquecode", "in", slUniqueCodeList);
        filter.and("caltask.id", "=", (Object)calTaskId);
        String calTableFields = "id,calpersonid,hsas_caltableentry.salaryitem.uniquecode,hsas_caltableentry.salaryitem.datatype.id,hsas_caltableentry.calamountvalue,hsas_caltableentry.textvalue,hsas_caltableentry.numvalue,hsas_caltableentry.datevalue,hsas_caltableentry.slprorationindex,hsas_caltableentry.slstartdate,hsas_caltableentry.slenddate";
        DynamicObjectCollection calTableList = helper.queryOriginalCollection(calTableFields, new QFilter[]{filter});
        Map itemResultMap = null;
        Map itemSectionMap = null;
        Map dataRangeMap = null;
        for (DynamicObject calTable : calTableList) {
            if (0 == calTable.getInt("hsas_caltableentry.slprorationindex")) {
                itemResultMap = this.slItemResultMap.getOrDefault(calTable.getLong("calpersonid"), new HashMap(16));
                itemResultMap.put(calTable.getString("hsas_caltableentry.salaryitem.uniquecode"), this.getSalaryItemValue(calTable));
                this.slItemResultMap.put(calTable.getLong("calpersonid"), itemResultMap);
                continue;
            }
            itemSectionMap = this.slItemSectionResultMap.getOrDefault(calTable.getLong("calpersonid"), new HashMap(16));
            dataRangeMap = itemSectionMap.getOrDefault(calTable.getString("hsas_caltableentry.salaryitem.uniquecode"), new HashMap(16));
            String dataRange = CalUtils.getDataRange(calTable.getDate("hsas_caltableentry.slstartdate"), calTable.getDate("hsas_caltableentry.slenddate"));
            dataRangeMap.put(dataRange, this.getSalaryItemValue(calTable));
            itemSectionMap.put(calTable.getString("hsas_caltableentry.salaryitem.uniquecode"), dataRangeMap);
            this.slItemSectionResultMap.put(calTable.getLong("calpersonid"), itemSectionMap);
        }
    }

    private Object getSalaryItemValue(DynamicObject obj) {
        long dataType = obj.getLong("hsas_caltableentry.salaryitem.datatype.id");
        Object value = 1010L == dataType ? obj.getBigDecimal("hsas_caltableentry.numvalue") : (1020L == dataType ? obj.getBigDecimal("hsas_caltableentry.calamountvalue") : (1030L == dataType ? obj.getString("hsas_caltableentry.textvalue") : (1050L == dataType ? obj.getDate("hsas_caltableentry.datevalue") : null)));
        return value;
    }

    private Map<Long, Map<String, Object>> handleSpItemResult(DynamicObjectCollection calPersonData) {
        logger.info("handleSpItemResult start");
        HashMap<Long, Map<String, Object>> spItemCalResultMap = new HashMap<Long, Map<String, Object>>(16);
        CalParamCacheInfo calParamCacheInfo = this.calParam.getCalParamMap();
        List spUniqueCodeList = calParamCacheInfo.getSpUniqueCodeList();
        if (!"afterTaxCal".equals(this.calParam.getCalType()) || SWCListUtils.isEmpty((List)spUniqueCodeList)) {
            return spItemCalResultMap;
        }
        Map<Long, Long> calResultRelMap = calPersonData.stream().collect(Collectors.toMap(obj -> obj.getLong("calresultid"), obj -> obj.getLong("id"), (k1, k2) -> k1));
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_caltable");
        QFilter filter = new QFilter("id", "in", calResultRelMap.keySet());
        filter.and("caltask.id", "=", (Object)Long.parseLong(this.calParam.getCalTaskId()));
        filter.and("hsas_calspentry.supportitem.uniquecode", "in", (Object)spUniqueCodeList);
        String fields = "id,hsas_calspentry.supportitem.uniquecode,hsas_calspentry.supportitem.datatype.id,hsas_calspentry.sptextvalue,hsas_calspentry.spnumvalue,hsas_calspentry.spdatevalue";
        DynamicObjectCollection result = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        HashMap<String, Object> tempMap = null;
        for (DynamicObject obj2 : result) {
            Long calPersonId = calResultRelMap.get(obj2.getLong("id"));
            if (calPersonId == null) continue;
            tempMap = (HashMap<String, Object>)spItemCalResultMap.get(calPersonId);
            if (tempMap == null) {
                tempMap = new HashMap<String, Object>(16);
                spItemCalResultMap.put(calPersonId, tempMap);
            }
            tempMap.put(obj2.getString("hsas_calspentry.supportitem.uniquecode"), this.getItemValue(obj2));
        }
        logger.info("handleSpItemResult end");
        return spItemCalResultMap;
    }

    private Object getItemValue(DynamicObject obj) {
        long dataTypeId = obj.getLong("hsas_calspentry.supportitem.datatype.id");
        if (DataTypeEnum.NUMBERIC.getDbId() == dataTypeId) {
            return obj.getBigDecimal("hsas_calspentry.spnumvalue");
        }
        if (DataTypeEnum.DATE.getDbId() == dataTypeId) {
            return obj.getDate("hsas_calspentry.spdatevalue");
        }
        return obj.getString("hsas_calspentry.sptextvalue");
    }

    public Map<String, Object> getFetchConsumeTimeMap() {
        return this.fetchConsumeTimeMap;
    }
}

