/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cal.fetchdata.custfetch;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.swc.hscs.service.api.ICustFetchService;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;

public class FetchAssignLevelOrgServiceImpl
implements ICustFetchService {
    private static final Log logger = LogFactory.getLog(FetchAssignLevelOrgServiceImpl.class);
    private static final String SOURCEORGNUMBER = "sourceOrgNumber";
    private static final String BSED = "bsed";
    private static final String LEVEL = "level";
    private static final String CALPERSONID = "calPersonId";
    private static final String TARGETORGNUMBER = "targetOrgNumber";
    private static final String TARGETORGNAME = "targetOrgName";
    private static final String FIEEDCHAR = "org";

    public Map<Long, Map<String, Object>> fetchDataCalPerson(List<Long> calPersonIdList, Map<Long, Map<String, Object>> paramsMap) {
        logger.info("fetchDataCalPerson start,paramsMap = {}", (Object)paramsMap.toString());
        Map<String, List<Map<String, Object>>> orgInfoMap = this.getOrgInfoMap(paramsMap);
        HashMap<Long, Map<String, Object>> result = new HashMap<Long, Map<String, Object>>(calPersonIdList.size());
        for (Map.Entry<String, List<Map<String, Object>>> entry : orgInfoMap.entrySet()) {
            this.handleOrgLevel(entry.getValue(), result);
        }
        logger.info("fetchDataCalPerson end");
        return result;
    }

    private void handleOrgLevel(List<Map<String, Object>> paramsList, Map<Long, Map<String, Object>> result) {
        Map<String, Object> paramMap = paramsList.get(0);
        List orgNumberList = paramsList.stream().map(obj -> (String)obj.get(SOURCEORGNUMBER)).collect(Collectors.toList());
        BigDecimal level = paramMap.get(LEVEL) == null ? BigDecimal.ZERO : (BigDecimal)paramMap.get(LEVEL);
        Date bsed = (Date)paramMap.get(BSED);
        Map responese = null;
        logger.info("queryAssignLevelOrgInfoById start");
        try {
            responese = (Map)SWCMServiceUtils.invokeHRMPService((String)"haos", (String)"IHAOSBatchAdminOrgInfoQueryService", (String)"queryAssignLevelOrgInfoById", (Object[])new Object[]{null, orgNumberList, level.intValue(), bsed});
        }
        catch (Exception ex) {
            logger.error("IHAOSBatchAdminOrgInfoQueryService.queryAssignLevelOrgInfoById error.", (Throwable)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("", ResManager.loadKDString((String)"\u67e5\u8be2\u6307\u5b9a\u5c42\u7ea7\u7ec4\u7ec7\u63a5\u53e3\u8c03\u7528\u5931\u8d25\u3002", (String)"FetchAssignLevelOrgServiceImpl_0", (String)"swc-hscs-business", (Object[])new Object[0])), new Object[0]);
        }
        logger.info("queryAssignLevelOrgInfoById end");
        if (responese == null) {
            logger.error("queryAssignLevelOrgInfoById result is null");
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7684\u67e5\u8be2\u6307\u5b9a\u5c42\u7ea7\u7ec4\u7ec7\u63a5\u53e3\u8fd4\u56de\u503c\u4e3a\u7a7a\u3002", (String)"FetchAssignLevelOrgServiceImpl_1", (String)"swc-hscs-business", (Object[])new Object[0]));
        }
        logger.info("responese ==> {}", (Object)responese.toString());
        Long calPersonId = null;
        String orgNumber = null;
        Map targetOrgMap = null;
        Map<String, Object> tempResultMap = null;
        for (Map<String, Object> param : paramsList) {
            calPersonId = (Long)param.get(CALPERSONID);
            tempResultMap = result.get(calPersonId);
            if (tempResultMap == null) {
                tempResultMap = new HashMap<String, Object>(2);
                result.put(calPersonId, tempResultMap);
            }
            if ((targetOrgMap = (Map)responese.get(orgNumber = (String)param.get(SOURCEORGNUMBER))) == null) continue;
            tempResultMap.put(TARGETORGNAME, targetOrgMap.get("name") == null ? "" : targetOrgMap.get("name").toString());
            tempResultMap.put(TARGETORGNUMBER, targetOrgMap.get("number"));
        }
    }

    private Map<String, List<Map<String, Object>>> getOrgInfoMap(Map<Long, Map<String, Object>> paramsMap) {
        HashMap<String, List<Map<String, Object>>> orgInfoMap = new HashMap<String, List<Map<String, Object>>>(paramsMap.size());
        Map<String, Object> tempMap = null;
        ArrayList<Map<String, Object>> tempList = null;
        for (Map.Entry<Long, Map<String, Object>> entry : paramsMap.entrySet()) {
            String key;
            tempMap = entry.getValue();
            tempMap.put(CALPERSONID, entry.getKey());
            BigDecimal level = tempMap.get(LEVEL) == null ? BigDecimal.ZERO : (BigDecimal)tempMap.get(LEVEL);
            Date bsed = (Date)tempMap.get(BSED);
            String bsedStr = "";
            if (bsed != null) {
                bsedStr = SWCDateTimeUtils.format((Date)bsed, (String)"yyyy-MM-dd");
            }
            if ((tempList = (ArrayList<Map<String, Object>>)orgInfoMap.get(key = "org_" + level.intValue() + '_' + bsedStr)) == null) {
                tempList = new ArrayList<Map<String, Object>>(10);
                orgInfoMap.put(key, tempList);
            }
            tempList.add(tempMap);
        }
        return orgInfoMap;
    }

    public Map<String, Object> fetchDataCalTask(Long calTaskId, Map<String, Object> paramsMap) {
        return null;
    }
}

