/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hscs.business.cal.fetchdata.custfetch;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.sdk.swc.hscs.service.api.ICustFetchService;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class PayDaysServiceImplDemo
implements ICustFetchService {
    public static final String DAYTYPE_WEEKDAY = "1";
    public static final String DAYTYPE_HOLIDAY = "3";

    public Map<Long, Map<String, Object>> fetchDataCalPerson(List<Long> calPersonIdList, Map<Long, Map<String, Object>> paramsMap) {
        HashMap<Long, Map<String, Object>> result = new HashMap<Long, Map<String, Object>>(calPersonIdList.size());
        List<ParamVO> paramList = this.getParamVOList(paramsMap);
        Set workingPlanNumberSet = paramsMap.values().stream().map(obj -> (String)obj.get("workingPlanNumber")).collect(Collectors.toSet());
        SWCDataServiceHelper helper = new SWCDataServiceHelper("working_plan");
        QFilter filter = new QFilter("number", "in", workingPlanNumberSet);
        DynamicObjectCollection workingPlanList = helper.queryOriginalCollection("id,number", new QFilter[]{filter});
        Map<String, Long> workPlanMap = workingPlanList.stream().collect(Collectors.toMap(obj -> obj.getString("number"), obj -> obj.getLong("id"), (key1, key2) -> key1));
        Map<String, List<ParamVO>> batchParamMap = paramList.stream().collect(Collectors.groupingBy(obj -> obj.getWorkPlanNumber() + obj.getStartDate() + obj.getEndDate()));
        for (Map.Entry<String, List<ParamVO>> entry : batchParamMap.entrySet()) {
            this.dealWorkingPlanDataWithDay(entry.getValue(), workPlanMap, result);
        }
        return result;
    }

    private void dealWorkingPlanDataWithDay(List<ParamVO> paramList, Map<String, Long> workPlanMap, Map<Long, Map<String, Object>> result) {
        ParamVO param = paramList.get(0);
        Long workingPlanId = workPlanMap.get(param.getWorkPlanNumber());
        if (workingPlanId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u901a\u8fc7\u5de5\u4f5c\u65e5\u5386\u7f16\u7801\u672a\u67e5\u8be2\u51fa\u5bf9\u5e94\u7684\u6570\u636e\u3002", (String)"PeriodInfoAndPayDaysServiceImpl_0", (String)"swc-hscs-business", (Object[])new Object[0]));
        }
        Date startDate = null;
        Date endDate = null;
        try {
            startDate = SWCDateTimeUtils.parseDate((String)param.getStartDate(), (String)"yyyy-MM-dd");
            endDate = SWCDateTimeUtils.parseDate((String)param.getEndDate(), (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u65e5\u671f\u8f6c\u6362\u5931\u8d25", (String)"PeriodInfoAndPayDaysServiceImpl_1", (String)"swc-hscs-business", (Object[])new Object[0])), new Object[0]);
        }
        Map workingPlanData = (Map)SWCMServiceUtils.invokeHRMPService((String)"hrcs", (String)"IHRCSCalendarService", (String)"getCalendarDataWithDay", (Object[])new Object[]{workingPlanId, startDate, endDate});
        BigDecimal payDays = this.getPayDays(startDate, endDate, workingPlanData);
        Map tempMap = null;
        for (ParamVO obj : paramList) {
            tempMap = result.getOrDefault(obj.getCalPersonId(), new HashMap(1));
            tempMap.put("payDays", payDays);
            result.put(obj.getCalPersonId(), tempMap);
        }
    }

    private BigDecimal getPayDays(Date startDate, Date endDate, Map<String, String> workingPlanDataWithDay) {
        Date tDate = startDate;
        BigDecimal payDays = BigDecimal.ZERO;
        while (tDate.compareTo(endDate) <= 0) {
            String type = workingPlanDataWithDay.get(SWCDateTimeUtils.formatDate((Date)tDate));
            if (type == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u65e5\u5386\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u67e5\u8be2\u533a\u95f4\u662f\u5426\u5b58\u5728\u6709\u6548\u7684\u516c\u5171\u65e5\u5386\u3002", (String)"PeriodInfoAndPayDaysServiceImpl_2", (String)"swc-hscs-business", (Object[])new Object[0]));
            }
            if (DAYTYPE_WEEKDAY.equals(type) || DAYTYPE_HOLIDAY.equals(type)) {
                payDays = payDays.add(BigDecimal.ONE);
            }
            tDate = SWCDateTimeUtils.addDay((Date)tDate, (long)1L);
        }
        return payDays;
    }

    private List<ParamVO> getParamVOList(Map<Long, Map<String, Object>> paramsMap) {
        ArrayList<ParamVO> paramList = new ArrayList<ParamVO>(paramsMap.size());
        ParamVO param = null;
        Date startDate = null;
        Date endDate = null;
        String workingPlanNumber = null;
        for (Map.Entry<Long, Map<String, Object>> entry : paramsMap.entrySet()) {
            param = new ParamVO();
            param.setCalPersonId(entry.getKey());
            workingPlanNumber = (String)entry.getValue().get("workingPlanNumber");
            if (SWCStringUtils.isEmpty((String)workingPlanNumber)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u540d\u5355[{0}]\u7684\u5de5\u4f5c\u65e5\u5386\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"PeriodInfoAndPayDaysServiceImpl_3", (String)"swc-hscs-business", (Object[])new Object[]{entry.getKey()}));
            }
            param.setWorkPlanNumber(workingPlanNumber);
            startDate = (Date)entry.getValue().get("startDate");
            endDate = (Date)entry.getValue().get("endDate");
            if (startDate == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u540d\u5355[{0}]\u7684\u5f00\u59cb\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"PeriodInfoAndPayDaysServiceImpl_4", (String)"swc-hscs-business", (Object[])new Object[]{entry.getKey()}));
            }
            param.setStartDate(SWCDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd"));
            if (endDate == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u540d\u5355[{0}]\u7684\u7ed3\u675f\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"PeriodInfoAndPayDaysServiceImpl_5", (String)"swc-hscs-business", (Object[])new Object[]{entry.getKey()}));
            }
            param.setEndDate(SWCDateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd"));
            paramList.add(param);
        }
        return paramList;
    }

    public Map<String, Object> fetchDataCalTask(Long calTaskId, Map<String, Object> paramsMap) {
        return null;
    }

    static class ParamVO {
        private String startDate;
        private String endDate;
        private String workPlanNumber;
        private Long calPersonId;

        ParamVO() {
        }

        public String getStartDate() {
            return this.startDate;
        }

        public void setStartDate(String startDate) {
            this.startDate = startDate;
        }

        public String getEndDate() {
            return this.endDate;
        }

        public void setEndDate(String endDate) {
            this.endDate = endDate;
        }

        public String getWorkPlanNumber() {
            return this.workPlanNumber;
        }

        public void setWorkPlanNumber(String workPlanNumber) {
            this.workPlanNumber = workPlanNumber;
        }

        public Long getCalPersonId() {
            return this.calPersonId;
        }

        public void setCalPersonId(Long calPersonId) {
            this.calPersonId = calPersonId;
        }
    }
}

